package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.observ.value.TextValue;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class TextValueService
{
	private static final Logger logger = Logger.getLogger(TextValueService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TEXTVALUE')")
	public TextValue create(TextValue textValue) throws DatabaseException
	{
		logger.debug("creating TextValue");
		db.add(textValue);
		return textValue;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TEXTVALUE')")
	public TextValue read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving TextValue");
		return db.findById(TextValue.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TEXTVALUE')")
	public void update(TextValue textValue) throws DatabaseException
	{
		logger.debug("updating TextValue");
		db.update(textValue);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TEXTVALUE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting TextValue");
		TextValue textValue = db.findById(TextValue.class, id);
		return db.remove(textValue) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TEXTVALUE')")
	public Iterable<TextValue> readAll() throws DatabaseException
	{
		logger.debug("retrieving all TextValue instances");
		return db.find(TextValue.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TEXTVALUE')")
	public EntityPager<TextValue> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all TextValue instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(TextValue.class, queryRules.toArray(new QueryRule[0]));
		List<TextValue> textValueCollection = db.find(TextValue.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<TextValue>(start, num, count, textValueCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TEXTVALUE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("TextValue");
	}
}