
/* File:        org.molgenis.omx/model/ObservedValue.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

import java.util.LinkedHashSet;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * ObservedValue: 
				Generic storage of values as part of one observation event. Values are atomatic observations,
				e.g., length (feature) of individual 1 (valueset.target) = 179cm (value).
				Values can also be qualified by some characteristic,
				e.g., QTL p-value (feature) between phenotype 'leaf count'
				(characteristic) and marker 'PVV4' (valueset.target) = 0.1^10+3 (value).
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "ObservedValue"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
public class ObservedValue extends org.molgenis.data.support.AbstractEntity implements org.molgenis.data.Entity, org.molgenis.omx.core.Autoid
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "ObservedValue";
    
	// fieldname constants
	public final static String ID = "id";
	public final static String OBSERVATIONSET = "ObservationSet";
	public final static String FEATURE = "Feature";
	public final static String VALUE = "Value";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//automatically generated internal id, only for internal use.[type=int]
    @javax.persistence.Id @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)

    @javax.persistence.Column(name="id", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="id")
	
	private Integer id =  null;

	//Reference to the observation. For example a particular patient visit or the application of a microarray or the calculation of a QTL model[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ObservationSet", nullable=false)  
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.observ.ObservationSet observationSet = null;

	//References the ObservableFeature that this observation was made on. For example 'probe123'.[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Feature", nullable=false)  
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.observ.ObservableFeature feature = null;

	//The value observed[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Value")  
	
				

	private org.molgenis.omx.observ.value.Value value = null;

	//constructors
	public ObservedValue()
	{
	}
	
	//getters and setters
	/**
	 * Get the automatically generated internal id, only for internal use..
	 * @return id.
	 */
	public Integer getId()
	{
		return this.id;
	}
	
	
	/**
	 * Set the automatically generated internal id, only for internal use..
	 * @param id
	 */
	public void setId( Integer id)
	{
		this.id = id;
	}

	

	/**
	 * Get the Reference to the observation. For example a particular patient visit or the application of a microarray or the calculation of a QTL model.
	 * @return observationSet.
	 */
	public org.molgenis.omx.observ.ObservationSet getObservationSet()
	{
		return this.observationSet;
	}	
	
	/**
	 * Set the Reference to the observation. For example a particular patient visit or the application of a microarray or the calculation of a QTL model.
	 * @param observationSet
	 */
	public void setObservationSet( org.molgenis.omx.observ.ObservationSet observationSet)
	{
		
		this.observationSet = observationSet;
	}

	

	/**
	 * Get the References the ObservableFeature that this observation was made on. For example 'probe123'..
	 * @return feature.
	 */
	public org.molgenis.omx.observ.ObservableFeature getFeature()
	{
		return this.feature;
	}	
	
	/**
	 * Set the References the ObservableFeature that this observation was made on. For example 'probe123'..
	 * @param feature
	 */
	public void setFeature( org.molgenis.omx.observ.ObservableFeature feature)
	{
		
		this.feature = feature;
	}

	

	/**
	 * Get the The value observed.
	 * @return value.
	 */
	public org.molgenis.omx.observ.value.Value getValue()
	{
		return this.value;
	}	
	
	/**
	 * Set the The value observed.
	 * @param value
	 */
	public void setValue( org.molgenis.omx.observ.value.Value value)
	{
		
		this.value = value;
	}

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("observationset"))
			return getObservationSet();
		if (name.equals("feature"))
			return getFeature();
		if (name.equals("value"))
			return getValue();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("observedvalue_id") != null) this.setId(entity.getInt("observedvalue_id"));
		else if( entity.getInt("ObservedValue_id") != null) this.setId(entity.getInt("ObservedValue_id"));
		//set ObservationSet
		// query formal name, else lowercase name
		if( entity.get("ObservationSet") != null) { 
			this.setObservationSet((org.molgenis.omx.observ.ObservationSet)entity.get("ObservationSet"));				
		}
		else if( entity.get("observationset") != null) { 
			this.setObservationSet((org.molgenis.omx.observ.ObservationSet)entity.get("observationset"));				
		}
		else if( entity.get("ObservedValue_ObservationSet") != null) { 
			this.setObservationSet((org.molgenis.omx.observ.ObservationSet)entity.get("ObservedValue_ObservationSet"));				
		}
		else if( entity.get("observedvalue_observationset") != null) { 
			this.setObservationSet((org.molgenis.omx.observ.ObservationSet)entity.get("ObservedValue_ObservationSet"));				
		}
		//set Feature
		// query formal name, else lowercase name
		if( entity.get("Feature") != null) { 
			this.setFeature((org.molgenis.omx.observ.ObservableFeature)entity.get("Feature"));				
		}
		else if( entity.get("feature") != null) { 
			this.setFeature((org.molgenis.omx.observ.ObservableFeature)entity.get("feature"));				
		}
		else if( entity.get("ObservedValue_Feature") != null) { 
			this.setFeature((org.molgenis.omx.observ.ObservableFeature)entity.get("ObservedValue_Feature"));				
		}
		else if( entity.get("observedvalue_feature") != null) { 
			this.setFeature((org.molgenis.omx.observ.ObservableFeature)entity.get("ObservedValue_Feature"));				
		}
		//set Value
		// query formal name, else lowercase name
		if( entity.get("Value") != null) { 
			this.setValue((org.molgenis.omx.observ.value.Value)entity.get("Value"));				
		}
		else if( entity.get("value") != null) { 
			this.setValue((org.molgenis.omx.observ.value.Value)entity.get("value"));				
		}
		else if( entity.get("ObservedValue_Value") != null) { 
			this.setValue((org.molgenis.omx.observ.value.Value)entity.get("ObservedValue_Value"));				
		}
		else if( entity.get("observedvalue_value") != null) { 
			this.setValue((org.molgenis.omx.observ.value.Value)entity.get("ObservedValue_Value"));				
		}
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("ObservedValue(");
		sb.append("id='" + getId()+"' ");	
		sb.append("observationSet='" + getObservationSet()+"' ");	
		sb.append("feature='" + getFeature()+"' ");	
		sb.append("value='" + getValue()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new ObservedValueMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("id");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		set(new MapEntity(attributeName, value), false);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = 1;
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new ObservedValueMetaData();
	}
}
