
/* File:        org.molgenis.omx/model/OntologyTerm.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ.target;

import java.util.LinkedHashSet;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * OntologyTerm: 
				OntologyTerm defines a single entry (term) from an
				ontology or a controlled vocabulary (defined by Ontology). The
				identifier is the ontology term is unique. E.g. 'NCI:Antigen Gene'.
				Other data entities can reference to this OntologyTerm to harmonize
				naming of concepts. If no suitable ontology term exists then one can
				define new terms locally (in which case there is no formal accession
				for the term limiting its use for cross-Investigation queries).
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "OntologyTerm", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "ontology", "termAccession" } ) }
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
public class OntologyTerm extends org.molgenis.omx.observ.Characteristic implements org.molgenis.data.Entity
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "OntologyTerm";
    
	// fieldname constants
	public final static String ONTOLOGY = "ontology";
	public final static String TERMACCESSION = "termAccession";
	public final static String DEFINITION = "definition";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//(Optional) The source ontology or controlled vocabulary list that ontology terms have been obtained from.[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ontology")  
	
				

	private org.molgenis.omx.observ.target.Ontology ontology = null;

	//(Optional) The accession number assigned to the ontology term in its source ontology. If empty it is assumed to be a locally defined term.[type=string]

	@javax.persistence.Column(name="termAccession", length=255)
	@javax.xml.bind.annotation.XmlElement(name="termAccession")
	
				

	private String termAccession =  null;

	//(Optional) The definition of the term.[type=string]

	@javax.persistence.Column(name="definition", length=255)
	@javax.xml.bind.annotation.XmlElement(name="definition")
	
				

	private String definition =  null;

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public OntologyTerm()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the (Optional) The source ontology or controlled vocabulary list that ontology terms have been obtained from..
	 * @return ontology.
	 */
	public org.molgenis.omx.observ.target.Ontology getOntology()
	{
		return this.ontology;
	}	
	
	/**
	 * Set the (Optional) The source ontology or controlled vocabulary list that ontology terms have been obtained from..
	 * @param ontology
	 */
	public void setOntology( org.molgenis.omx.observ.target.Ontology ontology)
	{
		
		this.ontology = ontology;
	}

	

	/**
	 * Get the (Optional) The accession number assigned to the ontology term in its source ontology. If empty it is assumed to be a locally defined term..
	 * @return termAccession.
	 */
	public String getTermAccession()
	{
		return this.termAccession;
	}	
	
	/**
	 * Set the (Optional) The accession number assigned to the ontology term in its source ontology. If empty it is assumed to be a locally defined term..
	 * @param termAccession
	 */
	public void setTermAccession( String termAccession)
	{
		
		this.termAccession = termAccession;
	}

	

	/**
	 * Get the (Optional) The definition of the term..
	 * @return definition.
	 */
	public String getDefinition()
	{
		return this.definition;
	}	
	
	/**
	 * Set the (Optional) The definition of the term..
	 * @param definition
	 */
	public void setDefinition( String definition)
	{
		
		this.definition = definition;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("ontology"))
			return getOntology();
		if (name.equals("termaccession"))
			return getTermAccession();
		if (name.equals("definition"))
			return getDefinition();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("ontologyterm_id") != null) this.setId(entity.getInt("ontologyterm_id"));
		else if( entity.getInt("OntologyTerm_id") != null) this.setId(entity.getInt("OntologyTerm_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("ontologyterm_identifier") != null) this.setIdentifier(entity.getString("ontologyterm_identifier"));
		else if( entity.getString("OntologyTerm_Identifier") != null) this.setIdentifier(entity.getString("OntologyTerm_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("ontologyterm_name") != null) this.setName(entity.getString("ontologyterm_name"));
		else if( entity.getString("OntologyTerm_Name") != null) this.setName(entity.getString("OntologyTerm_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("ontologyterm___type") != null) this.set__Type(entity.getString("ontologyterm___type"));
		else if( entity.getString("OntologyTerm___Type") != null) this.set__Type(entity.getString("OntologyTerm___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("ontologyterm_description") != null) this.setDescription(entity.getString("ontologyterm_description"));
		else if( entity.getString("OntologyTerm_description") != null) this.setDescription(entity.getString("OntologyTerm_description"));
		//set Ontology
		// query formal name, else lowercase name
		if( entity.get("ontology") != null) { 
			this.setOntology((org.molgenis.omx.observ.target.Ontology)entity.get("ontology"));				
		}
		else if( entity.get("ontology") != null) { 
			this.setOntology((org.molgenis.omx.observ.target.Ontology)entity.get("ontology"));				
		}
		else if( entity.get("OntologyTerm_ontology") != null) { 
			this.setOntology((org.molgenis.omx.observ.target.Ontology)entity.get("OntologyTerm_ontology"));				
		}
		else if( entity.get("ontologyterm_ontology") != null) { 
			this.setOntology((org.molgenis.omx.observ.target.Ontology)entity.get("OntologyTerm_ontology"));				
		}
		//set TermAccession
		// query formal name, else lowercase name
		if(entity.getString("termaccession") != null) this.setTermAccession(entity.getString("termaccession"));
		else if(entity.getString("termAccession") != null) this.setTermAccession(entity.getString("termAccession"));
		else if(strict) this.setTermAccession(entity.getString("termaccession")); // setting null is not an option due to function overloading
		if( entity.getString("ontologyterm_termaccession") != null) this.setTermAccession(entity.getString("ontologyterm_termaccession"));
		else if( entity.getString("OntologyTerm_termAccession") != null) this.setTermAccession(entity.getString("OntologyTerm_termAccession"));
		//set Definition
		// query formal name, else lowercase name
		if(entity.getString("definition") != null) this.setDefinition(entity.getString("definition"));
		else if(entity.getString("definition") != null) this.setDefinition(entity.getString("definition"));
		else if(strict) this.setDefinition(entity.getString("definition")); // setting null is not an option due to function overloading
		if( entity.getString("ontologyterm_definition") != null) this.setDefinition(entity.getString("ontologyterm_definition"));
		else if( entity.getString("OntologyTerm_definition") != null) this.setDefinition(entity.getString("OntologyTerm_definition"));
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("OntologyTerm(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("ontology='" + getOntology()+"' ");	
		sb.append("termAccession='" + getTermAccession()+"' ");	
		sb.append("definition='" + getDefinition()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	
	//6
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="definitions"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.observ.ObservableFeature> definitionsObservableFeatureCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.ObservableFeature> getDefinitionsObservableFeatureCollection()
	{
		if(definitionsObservableFeatureCollection == null) definitionsObservableFeatureCollection = new java.util.ArrayList<org.molgenis.omx.observ.ObservableFeature>(); 
        return definitionsObservableFeatureCollection;
	}


    public void setDefinitionsObservableFeatureCollection(java.util.Collection<org.molgenis.omx.observ.ObservableFeature> collection)
    {
		if(definitionsObservableFeatureCollection == null) definitionsObservableFeatureCollection = new java.util.ArrayList<org.molgenis.omx.observ.ObservableFeature>();
    	definitionsObservableFeatureCollection.addAll(collection);
    }	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new OntologyTermMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		set(new MapEntity(attributeName, value), false);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		OntologyTerm other = (OntologyTerm) obj;
		if (ontology == null)
		{
			if (other.ontology != null) return false;
		}
		else if (!ontology.equals(other.ontology)) return false;
		if (termAccession == null)
		{
			if (other.termAccession != null) return false;
		}
		else if (!termAccession.equals(other.termAccession)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((ontology == null) ? 0 : ontology.hashCode());
		result = prime * result + ((termAccession == null) ? 0 : termAccession.hashCode());
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new OntologyTermMetaData();
	}
}
