
/* File:        org.molgenis.omx/model/DataSet.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

import java.util.LinkedHashSet;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * DataSet: Container for one or more observations that are measured
				using the same protocol and by the same performer(s). The data set
				may be a file (having the same identifier) but in most cases it is a
				data table consisting of rows (Observation).
				This entity replaces
				ProtocolApplication.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "DataSet"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class DataSet extends org.molgenis.omx.observ.Characteristic implements org.molgenis.data.Entity
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "DataSet";
    
	// fieldname constants
	public final static String PROTOCOLUSED = "ProtocolUsed";
	public final static String STARTTIME = "startTime";
	public final static String ENDTIME = "endTime";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//Reference to the protocol that is being used (if available)[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProtocolUsed", nullable=false)  
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.observ.Protocol protocolUsed = null;

	//time when the protocol started.[type=datetime]

    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
	@javax.persistence.Column(name="startTime", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="startTime")
	
				

	@javax.validation.constraints.NotNull
	private java.util.Date startTime =  new java.sql.Date(new java.util.Date().getTime());

	//(Optional) time when the protocol ended.[type=datetime]

    @javax.persistence.Temporal(javax.persistence.TemporalType.TIMESTAMP)
	@javax.persistence.Column(name="endTime")
	@javax.xml.bind.annotation.XmlElement(name="endTime")
	
				

	private java.util.Date endTime =  new java.sql.Date(new java.util.Date().getTime());

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public DataSet()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the Reference to the protocol that is being used (if available).
	 * @return protocolUsed.
	 */
	public org.molgenis.omx.observ.Protocol getProtocolUsed()
	{
		return this.protocolUsed;
	}	
	
	/**
	 * Set the Reference to the protocol that is being used (if available).
	 * @param protocolUsed
	 */
	public void setProtocolUsed( org.molgenis.omx.observ.Protocol protocolUsed)
	{
		
		this.protocolUsed = protocolUsed;
	}

	

	/**
	 * Get the time when the protocol started..
	 * @return startTime.
	 */
	public java.util.Date getStartTime()
	{
		return this.startTime;
	}	
	
	/**
	 * Set the time when the protocol started..
	 * @param startTime
	 */
	public void setStartTime( java.util.Date startTime)
	{
		
		this.startTime = startTime;
	}

	

	/**
	 * Get the (Optional) time when the protocol ended..
	 * @return endTime.
	 */
	public java.util.Date getEndTime()
	{
		return this.endTime;
	}	
	
	/**
	 * Set the (Optional) time when the protocol ended..
	 * @param endTime
	 */
	public void setEndTime( java.util.Date endTime)
	{
		
		this.endTime = endTime;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("protocolused"))
			return getProtocolUsed();
		if (name.equals("starttime"))
			return getStartTime();
		if (name.equals("endtime"))
			return getEndTime();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("dataset_id") != null) this.setId(entity.getInt("dataset_id"));
		else if( entity.getInt("DataSet_id") != null) this.setId(entity.getInt("DataSet_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("dataset_identifier") != null) this.setIdentifier(entity.getString("dataset_identifier"));
		else if( entity.getString("DataSet_Identifier") != null) this.setIdentifier(entity.getString("DataSet_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("dataset_name") != null) this.setName(entity.getString("dataset_name"));
		else if( entity.getString("DataSet_Name") != null) this.setName(entity.getString("DataSet_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("dataset___type") != null) this.set__Type(entity.getString("dataset___type"));
		else if( entity.getString("DataSet___Type") != null) this.set__Type(entity.getString("DataSet___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("dataset_description") != null) this.setDescription(entity.getString("dataset_description"));
		else if( entity.getString("DataSet_description") != null) this.setDescription(entity.getString("DataSet_description"));
		//set ProtocolUsed
		// query formal name, else lowercase name
		if( entity.get("ProtocolUsed") != null) { 
			this.setProtocolUsed((org.molgenis.omx.observ.Protocol)entity.get("ProtocolUsed"));				
		}
		else if( entity.get("protocolused") != null) { 
			this.setProtocolUsed((org.molgenis.omx.observ.Protocol)entity.get("protocolused"));				
		}
		else if( entity.get("DataSet_ProtocolUsed") != null) { 
			this.setProtocolUsed((org.molgenis.omx.observ.Protocol)entity.get("DataSet_ProtocolUsed"));				
		}
		else if( entity.get("dataset_protocolused") != null) { 
			this.setProtocolUsed((org.molgenis.omx.observ.Protocol)entity.get("DataSet_ProtocolUsed"));				
		}
		//set StartTime
		// query formal name, else lowercase name
		if(entity.getTimestamp("starttime") != null) this.setStartTime(entity.getTimestamp("starttime"));
		else if(entity.getTimestamp("startTime") != null) this.setStartTime(entity.getTimestamp("startTime"));
		else if(strict) this.setStartTime(entity.getTimestamp("starttime")); // setting null is not an option due to function overloading
		if( entity.getTimestamp("dataset_starttime") != null) this.setStartTime(entity.getTimestamp("dataset_starttime"));
		else if( entity.getTimestamp("DataSet_startTime") != null) this.setStartTime(entity.getTimestamp("DataSet_startTime"));
		//set EndTime
		// query formal name, else lowercase name
		if(entity.getTimestamp("endtime") != null) this.setEndTime(entity.getTimestamp("endtime"));
		else if(entity.getTimestamp("endTime") != null) this.setEndTime(entity.getTimestamp("endTime"));
		else if(strict) this.setEndTime(entity.getTimestamp("endtime")); // setting null is not an option due to function overloading
		if( entity.getTimestamp("dataset_endtime") != null) this.setEndTime(entity.getTimestamp("dataset_endtime"));
		else if( entity.getTimestamp("DataSet_endTime") != null) this.setEndTime(entity.getTimestamp("DataSet_endTime"));
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("DataSet(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("protocolUsed='" + getProtocolUsed()+"' ");	
		sb.append("startTime='" + (getStartTime() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy, HH:mm:ss", java.util.Locale.US).format(getStartTime()))+"' ");
		sb.append("endTime='" + (getEndTime() == null ? "" : new java.text.SimpleDateFormat("MMMM d, yyyy, HH:mm:ss", java.util.Locale.US).format(getEndTime()))+"'");
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new DataSetMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		set(new MapEntity(attributeName, value), false);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new DataSetMetaData();
	}
}
