
/* File:        org.molgenis.omx/model/Panel.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ.target;

import java.util.LinkedHashSet;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * Panel: The Panel class defines groups of individuals based on
				cohort design, case/controls, families, etc. For instance:
				'LifeLines
				cohort', 'middle aged man', 'recombinant mouse inbred Line
				dba x b6'
				or 'Smith family'. A Panel can act as a single
				ObservationTarget.
				For example: average height (Measurement) in the
				LifeLines cohort
				(Panel) is 174cm (ObservedValue). The Panel class
				maps to XGAP:Strain and PaGE:Panel
				classes. In METABASE this is
				assumed there is one panel per study.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "Panel"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class Panel extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.data.Entity
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "Panel";
    
	// fieldname constants
	public final static String PANELTYPE = "PanelType";
	public final static String NUMBEROFINDIVIDUALS = "NumberOfIndividuals";
	public final static String SPECIES = "Species";
	public final static String INDIVIDUALS = "Individuals";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//Indicate the type of Panel (example: Sample panel, AssayedPanel, Natural=wild type, Parental=parents of a cross, F1=First generation of cross, RCC=Recombinant congenic, CSS=chromosome substitution)[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="PanelType")  
	
				

	private org.molgenis.omx.observ.target.OntologyTerm panelType = null;

	//[type=int]

	@javax.persistence.Column(name="NumberOfIndividuals", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="numberOfIndividuals")
	
				

	@javax.validation.constraints.NotNull
	private Integer numberOfIndividuals =  null;

	//The species this panel is an instance of/part of/extracted from.[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Species")  
	
				

	private org.molgenis.omx.observ.target.Species species = null;

	//The list of individuals in this panel[type=mref]

	@javax.persistence.OrderColumn 	
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Individuals", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Panel_Individuals", 
			joinColumns=@javax.persistence.JoinColumn(name="Panel"), inverseJoinColumns=@javax.persistence.JoinColumn(name="Individuals"))
	
				

	private java.util.List<org.molgenis.omx.observ.target.Individual> individuals = new java.util.ArrayList<org.molgenis.omx.observ.target.Individual>();

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public Panel()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the Indicate the type of Panel (example: Sample panel, AssayedPanel, Natural=wild type, Parental=parents of a cross, F1=First generation of cross, RCC=Recombinant congenic, CSS=chromosome substitution).
	 * @return panelType.
	 */
	public org.molgenis.omx.observ.target.OntologyTerm getPanelType()
	{
		return this.panelType;
	}	
	
	/**
	 * Set the Indicate the type of Panel (example: Sample panel, AssayedPanel, Natural=wild type, Parental=parents of a cross, F1=First generation of cross, RCC=Recombinant congenic, CSS=chromosome substitution).
	 * @param panelType
	 */
	public void setPanelType( org.molgenis.omx.observ.target.OntologyTerm panelType)
	{
		
		this.panelType = panelType;
	}

	

	/**
	 * Get the .
	 * @return numberOfIndividuals.
	 */
	public Integer getNumberOfIndividuals()
	{
		return this.numberOfIndividuals;
	}	
	
	/**
	 * Set the .
	 * @param numberOfIndividuals
	 */
	public void setNumberOfIndividuals( Integer numberOfIndividuals)
	{
		
		this.numberOfIndividuals = numberOfIndividuals;
	}

	

	/**
	 * Get the The species this panel is an instance of/part of/extracted from..
	 * @return species.
	 */
	public org.molgenis.omx.observ.target.Species getSpecies()
	{
		return this.species;
	}	
	
	/**
	 * Set the The species this panel is an instance of/part of/extracted from..
	 * @param species
	 */
	public void setSpecies( org.molgenis.omx.observ.target.Species species)
	{
		
		this.species = species;
	}

	

	/**
	 * Get the The list of individuals in this panel.
	 * @return individuals.
	 */
	public java.util.List<org.molgenis.omx.observ.target.Individual> getIndividuals()
	{
		return this.individuals;
	}	
	
	/**
	 * Set the The list of individuals in this panel.
	 * @param individuals
	 */
	public void setIndividuals( java.util.List<org.molgenis.omx.observ.target.Individual> individuals)
	{
		
		this.individuals = individuals;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("paneltype"))
			return getPanelType();
		if (name.equals("numberofindividuals"))
			return getNumberOfIndividuals();
		if (name.equals("species"))
			return getSpecies();
		if (name.equals("individuals"))
			return getIndividuals();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("panel_id") != null) this.setId(entity.getInt("panel_id"));
		else if( entity.getInt("Panel_id") != null) this.setId(entity.getInt("Panel_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("panel_identifier") != null) this.setIdentifier(entity.getString("panel_identifier"));
		else if( entity.getString("Panel_Identifier") != null) this.setIdentifier(entity.getString("Panel_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("panel_name") != null) this.setName(entity.getString("panel_name"));
		else if( entity.getString("Panel_Name") != null) this.setName(entity.getString("Panel_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("panel___type") != null) this.set__Type(entity.getString("panel___type"));
		else if( entity.getString("Panel___Type") != null) this.set__Type(entity.getString("Panel___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("panel_description") != null) this.setDescription(entity.getString("panel_description"));
		else if( entity.getString("Panel_description") != null) this.setDescription(entity.getString("Panel_description"));
		//set PanelType
		// query formal name, else lowercase name
		if( entity.get("PanelType") != null) { 
			this.setPanelType((org.molgenis.omx.observ.target.OntologyTerm)entity.get("PanelType"));				
		}
		else if( entity.get("paneltype") != null) { 
			this.setPanelType((org.molgenis.omx.observ.target.OntologyTerm)entity.get("paneltype"));				
		}
		else if( entity.get("Panel_PanelType") != null) { 
			this.setPanelType((org.molgenis.omx.observ.target.OntologyTerm)entity.get("Panel_PanelType"));				
		}
		else if( entity.get("panel_paneltype") != null) { 
			this.setPanelType((org.molgenis.omx.observ.target.OntologyTerm)entity.get("Panel_PanelType"));				
		}
		//set NumberOfIndividuals
		// query formal name, else lowercase name
		if(entity.getInt("numberofindividuals") != null) this.setNumberOfIndividuals(entity.getInt("numberofindividuals"));
		else if(entity.getInt("NumberOfIndividuals") != null) this.setNumberOfIndividuals(entity.getInt("NumberOfIndividuals"));
		else if(strict) this.setNumberOfIndividuals(entity.getInt("numberofindividuals")); // setting null is not an option due to function overloading
		if( entity.getInt("panel_numberofindividuals") != null) this.setNumberOfIndividuals(entity.getInt("panel_numberofindividuals"));
		else if( entity.getInt("Panel_NumberOfIndividuals") != null) this.setNumberOfIndividuals(entity.getInt("Panel_NumberOfIndividuals"));
		//set Species
		// query formal name, else lowercase name
		if( entity.get("Species") != null) { 
			this.setSpecies((org.molgenis.omx.observ.target.Species)entity.get("Species"));				
		}
		else if( entity.get("species") != null) { 
			this.setSpecies((org.molgenis.omx.observ.target.Species)entity.get("species"));				
		}
		else if( entity.get("Panel_Species") != null) { 
			this.setSpecies((org.molgenis.omx.observ.target.Species)entity.get("Panel_Species"));				
		}
		else if( entity.get("panel_species") != null) { 
			this.setSpecies((org.molgenis.omx.observ.target.Species)entity.get("Panel_Species"));				
		}
		//set Individuals
		if( entity.get("Individuals") != null || entity.get("individuals") != null ) 
		{
			Object mrefs = entity.get("Individuals");
			if(mrefs == null) mrefs = entity.get("individuals");
			if(entity.get("panel_individuals")!= null) mrefs = entity.get("panel_individuals");
			else if(entity.get("Panel_Individuals")!= null) mrefs = entity.get("Panel_Individuals");									
			this.setIndividuals((java.util.List<org.molgenis.omx.observ.target.Individual>) mrefs );
		}				
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("Panel(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("panelType='" + getPanelType()+"' ");	
		sb.append("numberOfIndividuals='" + getNumberOfIndividuals()+"' ");	
		sb.append("species='" + getSpecies()+"' ");	
		sb.append("individuals='" + getIndividuals()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new PanelMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		set(new MapEntity(attributeName, value), false);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new PanelMetaData();
	}
}
