
/* File:        org.molgenis.omx/model/Characteristic.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

import java.util.LinkedHashSet;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * Characteristic:  Characteristics are yes-no statements about things in
				the world. These can be used as part of an observation, as parameter
				of ObservableFeature ('measuredCharacteristic'). For example: 'What
				is allele of [Marker]', here the [Marker] is a characteristic. Also,
				Characteristics can be used as target of observation. Typical
				examples are 'Individual' or 'Panel'. But also 'Marker' can be an
				Target when asked the question 'QTL p-value for [phenotype]': here
				both target and feature are characteristic, for example 'leave
				count'
				(phenotype characteristic) and 'PVV4' (marker characteristic).
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "Characteristic", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "Identifier" } ) }
)

@javax.persistence.Inheritance(strategy=javax.persistence.InheritanceType.JOINED)
@javax.persistence.DiscriminatorColumn(name="DType", discriminatorType=javax.persistence.DiscriminatorType.STRING)
@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class Characteristic extends org.molgenis.data.support.AbstractEntity implements org.molgenis.data.Entity, org.molgenis.omx.core.Identifiable
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "Characteristic";
    
	// fieldname constants
	public final static String ID = "id";
	public final static String IDENTIFIER = "Identifier";
	public final static String NAME = "Name";
	public final static String __TYPE = "__Type";
	public final static String DESCRIPTION = "description";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//automatically generated internal id, only for internal use.[type=int]
    @javax.persistence.Id @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)

    @javax.persistence.Column(name="id", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="id")
	
	private Integer id =  null;

	//user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234[type=string]

	@javax.persistence.Column(name="Identifier", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="identifier")
	
				

	@javax.validation.constraints.NotNull
	private String identifier =  null;

	//human readible name, not necessary unique.[type=string]

	@javax.persistence.Column(name="Name", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="name")
	
				

	@javax.validation.constraints.NotNull
	private String name =  null;

	//Subtypes have to be set to allow searching[type=enum]

	@javax.persistence.Column(name="DType", nullable=false)            
	@javax.xml.bind.annotation.XmlElement(name="__Type")
	
				

	@javax.validation.constraints.NotNull
	private String __Type =  null;
	@javax.persistence.Transient
	private String __Type_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> __Type_options;
	
	static {
		__Type_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		__Type_options.add(new org.molgenis.util.ValueLabel("Characteristic","Characteristic"));
		__Type_options.add(new org.molgenis.util.ValueLabel("Individual","Individual"));
		__Type_options.add(new org.molgenis.util.ValueLabel("Panel","Panel"));
		__Type_options.add(new org.molgenis.util.ValueLabel("ObservationTarget","ObservationTarget"));
		__Type_options.add(new org.molgenis.util.ValueLabel("ObservableFeature","ObservableFeature"));
		__Type_options.add(new org.molgenis.util.ValueLabel("Category","Category"));
		__Type_options.add(new org.molgenis.util.ValueLabel("Protocol","Protocol"));
		__Type_options.add(new org.molgenis.util.ValueLabel("DataSet","DataSet"));
		__Type_options.add(new org.molgenis.util.ValueLabel("Species","Species"));
		__Type_options.add(new org.molgenis.util.ValueLabel("Accession","Accession"));
		__Type_options.add(new org.molgenis.util.ValueLabel("PersonRole","PersonRole"));
		__Type_options.add(new org.molgenis.util.ValueLabel("OntologyTerm","OntologyTerm"));
		__Type_options.add(new org.molgenis.util.ValueLabel("Institute","Institute"));
		__Type_options.add(new org.molgenis.util.ValueLabel("Person","Person"));
	}

	//(Optional) Rudimentary meta data about the observable feature. Use of ontology       terms references to establish unambigious descriptions is recommended[type=text]

	@javax.persistence.Lob
	@javax.persistence.Column(name="description")
	
				

	private String description =  null;

	//constructors
	public Characteristic()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the automatically generated internal id, only for internal use..
	 * @return id.
	 */
	public Integer getId()
	{
		return this.id;
	}
	
	
	/**
	 * Set the automatically generated internal id, only for internal use..
	 * @param id
	 */
	public void setId( Integer id)
	{
		this.id = id;
	}

	

	/**
	 * Get the user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234.
	 * @return identifier.
	 */
	public String getIdentifier()
	{
		return this.identifier;
	}	
	
	/**
	 * Set the user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234.
	 * @param identifier
	 */
	public void setIdentifier( String identifier)
	{
		
		this.identifier = identifier;
	}

	

	/**
	 * Get the human readible name, not necessary unique..
	 * @return name.
	 */
	public String getName()
	{
		return this.name;
	}	
	
	/**
	 * Set the human readible name, not necessary unique..
	 * @param name
	 */
	public void setName( String name)
	{
		
		this.name = name;
	}

	

	/**
	 * Get the Subtypes have to be set to allow searching.
	 * @return __Type.
	 */
	public String get__Type()
	{
		return this.__Type;
	}	
	
	/**
	 * Set the Subtypes have to be set to allow searching.
	 * @param __Type
	 */
	public void set__Type( String __Type)
	{
		
		this.__Type = __Type;
	}

	
	/**
	 * Get tha label for enum __Type.
	 */
	public String get__TypeLabel()
	{
		return this.__Type_label;
	}
	/**
	 * __Type is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> get__TypeOptions()
	{
		return __Type_options;
	}	
	

	/**
	 * Get the (Optional) Rudimentary meta data about the observable feature. Use of ontology       terms references to establish unambigious descriptions is recommended.
	 * @return description.
	 */
	public String getDescription()
	{
		return this.description;
	}	
	
	/**
	 * Set the (Optional) Rudimentary meta data about the observable feature. Use of ontology       terms references to establish unambigious descriptions is recommended.
	 * @param description
	 */
	public void setDescription( String description)
	{
		
		this.description = description;
	}

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("characteristic_id") != null) this.setId(entity.getInt("characteristic_id"));
		else if( entity.getInt("Characteristic_id") != null) this.setId(entity.getInt("Characteristic_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("characteristic_identifier") != null) this.setIdentifier(entity.getString("characteristic_identifier"));
		else if( entity.getString("Characteristic_Identifier") != null) this.setIdentifier(entity.getString("Characteristic_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("characteristic_name") != null) this.setName(entity.getString("characteristic_name"));
		else if( entity.getString("Characteristic_Name") != null) this.setName(entity.getString("Characteristic_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("characteristic___type") != null) this.set__Type(entity.getString("characteristic___type"));
		else if( entity.getString("Characteristic___Type") != null) this.set__Type(entity.getString("Characteristic___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("characteristic_description") != null) this.setDescription(entity.getString("characteristic_description"));
		else if( entity.getString("Characteristic_description") != null) this.setDescription(entity.getString("Characteristic_description"));
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("Characteristic(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	
	//3
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="value"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.observ.value.MrefValue> valueMrefValueCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.value.MrefValue> getValueMrefValueCollection()
	{
		if(valueMrefValueCollection == null) valueMrefValueCollection = new java.util.ArrayList<org.molgenis.omx.observ.value.MrefValue>(); 
        return valueMrefValueCollection;
	}


    public void setValueMrefValueCollection(java.util.Collection<org.molgenis.omx.observ.value.MrefValue> collection)
    {
		if(valueMrefValueCollection == null) valueMrefValueCollection = new java.util.ArrayList<org.molgenis.omx.observ.value.MrefValue>();
    	valueMrefValueCollection.addAll(collection);
    }	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new CharacteristicMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		set(new MapEntity(attributeName, value), false);
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		Characteristic other = (Characteristic) obj;
		if (identifier == null)
		{
			if (other.identifier != null) return false;
		}
		else if (!identifier.equals(other.identifier)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ((identifier == null) ? 0 : identifier.hashCode());
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new CharacteristicMetaData();
	}
}
