
/* File:        org.molgenis.omx/model/Ontology.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ.target;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * Ontology:  Ontology defines a reference to an ontology or
				controlled vocabulary from which well-defined and stable (ontology)
				terms can be obtained. Each Ontology should have a unique identifer,
				for instance: Gene Ontology, Mammalian Phenotype, Human Phenotype
				Ontology, Unified Medical Language System, Medical Subject Headings,
				etc. Also a abbreviation is required, for instance: GO, MP, HPO,
				UMLS, MeSH, etc. Use of existing ontologies/vocabularies is
				recommended to harmonize phenotypic feature and value descriptions.
				But one can also create a 'local' Ontology. The Ontology class maps
				to FuGE::Ontology, MAGE-TAB::TermSourceREF.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "Ontology", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "Identifier" } ) }
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class Ontology extends org.molgenis.data.support.AbstractEntity implements org.molgenis.data.Entity, org.molgenis.omx.core.Identifiable
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "Ontology";
    
	// fieldname constants
	public final static String ID = "id";
	public final static String IDENTIFIER = "Identifier";
	public final static String NAME = "Name";
	public final static String ONTOLOGYACCESSION = "ontologyAccession";
	public final static String ONTOLOGYURI = "ontologyURI";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//automatically generated internal id, only for internal use.[type=int]
    @javax.persistence.Id @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)

    @javax.persistence.Column(name="id", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="id")
	
	private Integer id =  null;

	//user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234[type=string]

	@javax.persistence.Column(name="Identifier", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="identifier")
	
				

	@javax.validation.constraints.NotNull
	private String identifier =  null;

	//human readible name, not necessary unique.[type=string]

	@javax.persistence.Column(name="Name", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="name")
	
				

	@javax.validation.constraints.NotNull
	private String name =  null;

	//A accession that uniquely identifies the ontology (typically an acronym). E.g. GO, MeSH, HPO.[type=string]

	@javax.persistence.Column(name="ontologyAccession", length=255)
	@javax.xml.bind.annotation.XmlElement(name="ontologyAccession")
	
				

	private String ontologyAccession =  null;

	//(Optional) A URI that references the location of the ontology.[type=hyperlink]

	@javax.persistence.Column(name="ontologyURI")
	@javax.xml.bind.annotation.XmlElement(name="ontologyURI")
	
				

	private String ontologyURI =  null;

	//constructors
	public Ontology()
	{
	}
	
	//getters and setters
	/**
	 * Get the automatically generated internal id, only for internal use..
	 * @return id.
	 */
	public Integer getId()
	{
		return this.id;
	}
	
	
	/**
	 * Set the automatically generated internal id, only for internal use..
	 * @param id
	 */
	public void setId( Integer id)
	{
		this.id = id;
	}

	

	/**
	 * Get the user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234.
	 * @return identifier.
	 */
	public String getIdentifier()
	{
		return this.identifier;
	}	
	
	/**
	 * Set the user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234.
	 * @param identifier
	 */
	public void setIdentifier( String identifier)
	{
		
		this.identifier = identifier;
	}

	

	/**
	 * Get the human readible name, not necessary unique..
	 * @return name.
	 */
	public String getName()
	{
		return this.name;
	}	
	
	/**
	 * Set the human readible name, not necessary unique..
	 * @param name
	 */
	public void setName( String name)
	{
		
		this.name = name;
	}

	

	/**
	 * Get the A accession that uniquely identifies the ontology (typically an acronym). E.g. GO, MeSH, HPO..
	 * @return ontologyAccession.
	 */
	public String getOntologyAccession()
	{
		return this.ontologyAccession;
	}	
	
	/**
	 * Set the A accession that uniquely identifies the ontology (typically an acronym). E.g. GO, MeSH, HPO..
	 * @param ontologyAccession
	 */
	public void setOntologyAccession( String ontologyAccession)
	{
		
		this.ontologyAccession = ontologyAccession;
	}

	

	/**
	 * Get the (Optional) A URI that references the location of the ontology..
	 * @return ontologyURI.
	 */
	public String getOntologyURI()
	{
		return this.ontologyURI;
	}	
	
	/**
	 * Set the (Optional) A URI that references the location of the ontology..
	 * @param ontologyURI
	 */
	public void setOntologyURI( String ontologyURI)
	{
		
		this.ontologyURI = ontologyURI;
	}

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("ontologyaccession"))
			return getOntologyAccession();
		if (name.equals("ontologyuri"))
			return getOntologyURI();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("ontology_id") != null) this.setId(entity.getInt("ontology_id"));
		else if( entity.getInt("Ontology_id") != null) this.setId(entity.getInt("Ontology_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("ontology_identifier") != null) this.setIdentifier(entity.getString("ontology_identifier"));
		else if( entity.getString("Ontology_Identifier") != null) this.setIdentifier(entity.getString("Ontology_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("ontology_name") != null) this.setName(entity.getString("ontology_name"));
		else if( entity.getString("Ontology_Name") != null) this.setName(entity.getString("Ontology_Name"));
		//set OntologyAccession
		// query formal name, else lowercase name
		if(entity.getString("ontologyaccession") != null) this.setOntologyAccession(entity.getString("ontologyaccession"));
		else if(entity.getString("ontologyAccession") != null) this.setOntologyAccession(entity.getString("ontologyAccession"));
		else if(strict) this.setOntologyAccession(entity.getString("ontologyaccession")); // setting null is not an option due to function overloading
		if( entity.getString("ontology_ontologyaccession") != null) this.setOntologyAccession(entity.getString("ontology_ontologyaccession"));
		else if( entity.getString("Ontology_ontologyAccession") != null) this.setOntologyAccession(entity.getString("Ontology_ontologyAccession"));
		//set OntologyURI
		// query formal name, else lowercase name
		if(entity.getString("ontologyuri") != null) this.setOntologyURI(entity.getString("ontologyuri"));
		else if(entity.getString("ontologyURI") != null) this.setOntologyURI(entity.getString("ontologyURI"));
		else if(strict) this.setOntologyURI(entity.getString("ontologyuri")); // setting null is not an option due to function overloading
		if( entity.getString("ontology_ontologyuri") != null) this.setOntologyURI(entity.getString("ontology_ontologyuri"));
		else if( entity.getString("Ontology_ontologyURI") != null) this.setOntologyURI(entity.getString("Ontology_ontologyURI"));
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("Ontology(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("ontologyAccession='" + getOntologyAccession()+"' ");	
		sb.append("ontologyURI='" + getOntologyURI()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new OntologyMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		if("id".equalsIgnoreCase(attributeName)) {
			this.setId((Integer) value); 
			return;
		}
		if("Identifier".equalsIgnoreCase(attributeName)) {
			this.setIdentifier((String) value); 
			return;
		}
		if("Name".equalsIgnoreCase(attributeName)) {
			this.setName((String) value); 
			return;
		}
		if("ontologyAccession".equalsIgnoreCase(attributeName)) {
			this.setOntologyAccession((String) value); 
			return;
		}
		if("ontologyURI".equalsIgnoreCase(attributeName)) {
			this.setOntologyURI((String) value); 
			return;
		}
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		Ontology other = (Ontology) obj;
		if (identifier == null)
		{
			if (other.identifier != null) return false;
		}
		else if (!identifier.equals(other.identifier)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ((identifier == null) ? 0 : identifier.hashCode());
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new OntologyMetaData();
	}
}
