
/* File:        org.molgenis.omx/model/ObservableFeature.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;


/**
 * ObservableFeature: 
				ObservableFeature defines anything that can be observed.
				<p/>
				In other words, ObservableFeature are the questions asked, e.g.
				'What
				is Height?', 'What is Systolic blood pressure?', or 'Has blue
				eyes?'.
				<p/>
				Some questions may be repeated for multiple characteristics. For
				example 'What is [MarkerAllele] observed?' can be applied to all
				elements of a MarkerSet, and 'What is [medicin codes] uses' can be
				applied to a set of Medicine codes. This can be specified using the
				measuredCharacteristic field.
				<p/>
				The identifier of ObservableFeature is globally unique. It is
				recommended that each ObservableFeature is named according to a
				well-defined ontology term or database accession.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "ObservableFeature"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class ObservableFeature extends org.molgenis.omx.observ.Characteristic implements org.molgenis.data.Entity
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "ObservableFeature";
    
	// fieldname constants
	public final static String UNIT = "unit";
	public final static String DEFINITIONS = "definitions";
	public final static String DATATYPE = "dataType";
	public final static String TEMPORAL = "temporal";
	public final static String MINRANGE = "minRange";
	public final static String MAXRANGE = "maxRange";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//(Optional) Reference to the well-defined measurement unit used to observe this feature       (if feature is that concrete). E.g. mmHg[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="unit")  
	
				

	private org.molgenis.omx.observ.target.OntologyTerm unit = null;

	//The concept that is being measured in a specific way.[type=mref]

	@javax.persistence.OrderColumn 	
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="definitions", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="ObservableFeature_definitions", 
			joinColumns=@javax.persistence.JoinColumn(name="ObservableFeature"), inverseJoinColumns=@javax.persistence.JoinColumn(name="definitions"))
	
				

	private java.util.List<org.molgenis.omx.observ.target.OntologyTerm> definitions = new java.util.ArrayList<org.molgenis.omx.observ.target.OntologyTerm>();

	//(Optional) Reference to the technical data type. E.g. 'int'[type=enum]

	@javax.persistence.Column(name="dataType", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="dataType")
	
				

	@javax.validation.constraints.NotNull
	private String dataType =  "string";
	@javax.persistence.Transient
	private String dataType_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> dataType_options;
	
	static {
		dataType_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		dataType_options.add(new org.molgenis.util.ValueLabel("bool","bool"));
		dataType_options.add(new org.molgenis.util.ValueLabel("categorical","categorical"));
		dataType_options.add(new org.molgenis.util.ValueLabel("date","date"));
		dataType_options.add(new org.molgenis.util.ValueLabel("datetime","datetime"));
		dataType_options.add(new org.molgenis.util.ValueLabel("decimal","decimal"));
		dataType_options.add(new org.molgenis.util.ValueLabel("email","email"));
		dataType_options.add(new org.molgenis.util.ValueLabel("enum","enum"));
		dataType_options.add(new org.molgenis.util.ValueLabel("file","file"));
		dataType_options.add(new org.molgenis.util.ValueLabel("html","html"));
		dataType_options.add(new org.molgenis.util.ValueLabel("hyperlink","hyperlink"));
		dataType_options.add(new org.molgenis.util.ValueLabel("image","image"));
		dataType_options.add(new org.molgenis.util.ValueLabel("int","int"));
		dataType_options.add(new org.molgenis.util.ValueLabel("long","long"));
		dataType_options.add(new org.molgenis.util.ValueLabel("mref","mref"));
		dataType_options.add(new org.molgenis.util.ValueLabel("string","string"));
		dataType_options.add(new org.molgenis.util.ValueLabel("text","text"));
		dataType_options.add(new org.molgenis.util.ValueLabel("xref","xref"));
	}

	//Whether this feature is time dependent and can have different values when measured       on different times (e.g. weight, temporal=true) or generally only measured once (e.g. birth date,       temporal=false)[type=bool]

	@javax.persistence.Column(name="temporal", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="temporal")
	
				

	@javax.validation.constraints.NotNull
	private Boolean temporal =  false;

	//for numeric values this is used to set the 'min' value of the slider user interface[type=long]

	@javax.persistence.Column(name="minRange")
	@javax.xml.bind.annotation.XmlElement(name="minRange")
	
				

	private Long minRange =  null;

	//for numeric values this is used to set the 'max' value of the slider user interface[type=long]

	@javax.persistence.Column(name="maxRange")
	@javax.xml.bind.annotation.XmlElement(name="maxRange")
	
				

	private Long maxRange =  null;

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public ObservableFeature()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the (Optional) Reference to the well-defined measurement unit used to observe this feature       (if feature is that concrete). E.g. mmHg.
	 * @return unit.
	 */
	public org.molgenis.omx.observ.target.OntologyTerm getUnit()
	{
		return this.unit;
	}	
	
	/**
	 * Set the (Optional) Reference to the well-defined measurement unit used to observe this feature       (if feature is that concrete). E.g. mmHg.
	 * @param unit
	 */
	public void setUnit( org.molgenis.omx.observ.target.OntologyTerm unit)
	{
		
		this.unit = unit;
	}

	

	/**
	 * Get the The concept that is being measured in a specific way..
	 * @return definitions.
	 */
	public java.util.List<org.molgenis.omx.observ.target.OntologyTerm> getDefinitions()
	{
		return this.definitions;
	}	
	
	/**
	 * Set the The concept that is being measured in a specific way..
	 * @param definitions
	 */
	public void setDefinitions( java.util.List<org.molgenis.omx.observ.target.OntologyTerm> definitions)
	{
		
		this.definitions = definitions;
	}

	

	/**
	 * Get the (Optional) Reference to the technical data type. E.g. 'int'.
	 * @return dataType.
	 */
	public String getDataType()
	{
		return this.dataType;
	}	
	
	/**
	 * Set the (Optional) Reference to the technical data type. E.g. 'int'.
	 * @param dataType
	 */
	public void setDataType( String dataType)
	{
		
		this.dataType = dataType;
	}

	
	/**
	 * Get tha label for enum DataType.
	 */
	public String getDataTypeLabel()
	{
		return this.dataType_label;
	}
	/**
	 * DataType is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getDataTypeOptions()
	{
		return dataType_options;
	}	
	

	/**
	 * Get the Whether this feature is time dependent and can have different values when measured       on different times (e.g. weight, temporal=true) or generally only measured once (e.g. birth date,       temporal=false).
	 * @return temporal.
	 */
	public Boolean getTemporal()
	{
		return this.temporal;
	}	
	
	/**
	 * Set the Whether this feature is time dependent and can have different values when measured       on different times (e.g. weight, temporal=true) or generally only measured once (e.g. birth date,       temporal=false).
	 * @param temporal
	 */
	public void setTemporal( Boolean temporal)
	{
		
		this.temporal = temporal;
	}

	

	/**
	 * Get the for numeric values this is used to set the 'min' value of the slider user interface.
	 * @return minRange.
	 */
	public Long getMinRange()
	{
		return this.minRange;
	}	
	
	/**
	 * Set the for numeric values this is used to set the 'min' value of the slider user interface.
	 * @param minRange
	 */
	public void setMinRange( Long minRange)
	{
		
		this.minRange = minRange;
	}

	

	/**
	 * Get the for numeric values this is used to set the 'max' value of the slider user interface.
	 * @return maxRange.
	 */
	public Long getMaxRange()
	{
		return this.maxRange;
	}	
	
	/**
	 * Set the for numeric values this is used to set the 'max' value of the slider user interface.
	 * @param maxRange
	 */
	public void setMaxRange( Long maxRange)
	{
		
		this.maxRange = maxRange;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("unit"))
			return getUnit();
		if (name.equals("definitions"))
			return getDefinitions();
		if (name.equals("datatype"))
			return getDataType();
		if(name.equals("datatype_label"))
			return getDataTypeLabel();			
		if (name.equals("temporal"))
			return getTemporal();
		if (name.equals("minrange"))
			return getMinRange();
		if (name.equals("maxrange"))
			return getMaxRange();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("observablefeature_id") != null) this.setId(entity.getInt("observablefeature_id"));
		else if( entity.getInt("ObservableFeature_id") != null) this.setId(entity.getInt("ObservableFeature_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature_identifier") != null) this.setIdentifier(entity.getString("observablefeature_identifier"));
		else if( entity.getString("ObservableFeature_Identifier") != null) this.setIdentifier(entity.getString("ObservableFeature_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature_name") != null) this.setName(entity.getString("observablefeature_name"));
		else if( entity.getString("ObservableFeature_Name") != null) this.setName(entity.getString("ObservableFeature_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature___type") != null) this.set__Type(entity.getString("observablefeature___type"));
		else if( entity.getString("ObservableFeature___Type") != null) this.set__Type(entity.getString("ObservableFeature___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature_description") != null) this.setDescription(entity.getString("observablefeature_description"));
		else if( entity.getString("ObservableFeature_description") != null) this.setDescription(entity.getString("ObservableFeature_description"));
		//set Unit
		// query formal name, else lowercase name
		if( entity.get("unit") != null) { 
			this.setUnit((org.molgenis.omx.observ.target.OntologyTerm)entity.get("unit"));				
		}
		else if( entity.get("unit") != null) { 
			this.setUnit((org.molgenis.omx.observ.target.OntologyTerm)entity.get("unit"));				
		}
		else if( entity.get("ObservableFeature_unit") != null) { 
			this.setUnit((org.molgenis.omx.observ.target.OntologyTerm)entity.get("ObservableFeature_unit"));				
		}
		else if( entity.get("observablefeature_unit") != null) { 
			this.setUnit((org.molgenis.omx.observ.target.OntologyTerm)entity.get("ObservableFeature_unit"));				
		}
		//set Definitions
		if( entity.get("definitions") != null || entity.get("definitions") != null ) 
		{
			Object mrefs = entity.get("definitions");
			if(mrefs == null) mrefs = entity.get("definitions");
			if(entity.get("observablefeature_definitions")!= null) mrefs = entity.get("observablefeature_definitions");
			else if(entity.get("ObservableFeature_definitions")!= null) mrefs = entity.get("ObservableFeature_definitions");									
			this.setDefinitions((java.util.List<org.molgenis.omx.observ.target.OntologyTerm>) mrefs );
		}				
		//set DataType
		// query formal name, else lowercase name
		if(entity.getString("datatype") != null) this.setDataType(entity.getString("datatype"));
		else if(entity.getString("dataType") != null) this.setDataType(entity.getString("dataType"));
		else if(strict) this.setDataType(entity.getString("datatype")); // setting null is not an option due to function overloading
		if( entity.getString("observablefeature_datatype") != null) this.setDataType(entity.getString("observablefeature_datatype"));
		else if( entity.getString("ObservableFeature_dataType") != null) this.setDataType(entity.getString("ObservableFeature_dataType"));
		//set Temporal
		// query formal name, else lowercase name
		if(entity.getBoolean("temporal") != null) this.setTemporal(entity.getBoolean("temporal"));
		else if(entity.getBoolean("temporal") != null) this.setTemporal(entity.getBoolean("temporal"));
		else if(strict) this.setTemporal(entity.getBoolean("temporal")); // setting null is not an option due to function overloading
		if( entity.getBoolean("observablefeature_temporal") != null) this.setTemporal(entity.getBoolean("observablefeature_temporal"));
		else if( entity.getBoolean("ObservableFeature_temporal") != null) this.setTemporal(entity.getBoolean("ObservableFeature_temporal"));
		//set MinRange
		// query formal name, else lowercase name
		if(entity.getLong("minrange") != null) this.setMinRange(entity.getLong("minrange"));
		else if(entity.getLong("minRange") != null) this.setMinRange(entity.getLong("minRange"));
		else if(strict) this.setMinRange(entity.getLong("minrange")); // setting null is not an option due to function overloading
		if( entity.getLong("observablefeature_minrange") != null) this.setMinRange(entity.getLong("observablefeature_minrange"));
		else if( entity.getLong("ObservableFeature_minRange") != null) this.setMinRange(entity.getLong("ObservableFeature_minRange"));
		//set MaxRange
		// query formal name, else lowercase name
		if(entity.getLong("maxrange") != null) this.setMaxRange(entity.getLong("maxrange"));
		else if(entity.getLong("maxRange") != null) this.setMaxRange(entity.getLong("maxRange"));
		else if(strict) this.setMaxRange(entity.getLong("maxrange")); // setting null is not an option due to function overloading
		if( entity.getLong("observablefeature_maxrange") != null) this.setMaxRange(entity.getLong("observablefeature_maxrange"));
		else if( entity.getLong("ObservableFeature_maxRange") != null) this.setMaxRange(entity.getLong("ObservableFeature_maxRange"));
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("ObservableFeature(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("unit='" + getUnit()+"' ");	
		sb.append("definitions='" + getDefinitions()+"' ");	
		sb.append("dataType='" + getDataType()+"' ");	
		sb.append("temporal='" + getTemporal()+"' ");	
		sb.append("minRange='" + getMinRange()+"' ");	
		sb.append("maxRange='" + getMaxRange()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	
	//7
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="features"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.observ.Protocol> featuresProtocolCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getFeaturesProtocolCollection()
	{
		if(featuresProtocolCollection == null) featuresProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>(); 
        return featuresProtocolCollection;
	}


    public void setFeaturesProtocolCollection(java.util.Collection<org.molgenis.omx.observ.Protocol> collection)
    {
		if(featuresProtocolCollection == null) featuresProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>();
    	featuresProtocolCollection.addAll(collection);
    }	
	//7
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="requiredFeatures"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.observ.Protocol> requiredFeaturesProtocolCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getRequiredFeaturesProtocolCollection()
	{
		if(requiredFeaturesProtocolCollection == null) requiredFeaturesProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>(); 
        return requiredFeaturesProtocolCollection;
	}


    public void setRequiredFeaturesProtocolCollection(java.util.Collection<org.molgenis.omx.observ.Protocol> collection)
    {
		if(requiredFeaturesProtocolCollection == null) requiredFeaturesProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>();
    	requiredFeaturesProtocolCollection.addAll(collection);
    }	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new ObservableFeatureMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		if("id".equalsIgnoreCase(attributeName)) {
			this.setId((Integer) value); 
			return;
		}
		if("Identifier".equalsIgnoreCase(attributeName)) {
			this.setIdentifier((String) value); 
			return;
		}
		if("Name".equalsIgnoreCase(attributeName)) {
			this.setName((String) value); 
			return;
		}
		if("__Type".equalsIgnoreCase(attributeName)) {
			this.set__Type((String) value); 
			return;
		}
		if("description".equalsIgnoreCase(attributeName)) {
			this.setDescription((String) value); 
			return;
		}
		if("unit".equalsIgnoreCase(attributeName)) {
			this.setUnit((org.molgenis.omx.observ.target.OntologyTerm) value); 
			return;
		}
		if("definitions".equalsIgnoreCase(attributeName)) {
			this.setDefinitions((List<org.molgenis.omx.observ.target.OntologyTerm>) value); 
			return;
		}
		if("dataType".equalsIgnoreCase(attributeName)) {
			this.setDataType((String) value); 
			return;
		}
		if("temporal".equalsIgnoreCase(attributeName)) {
			this.setTemporal((Boolean) value); 
			return;
		}
		if("minRange".equalsIgnoreCase(attributeName)) {
			this.setMinRange((Long) value); 
			return;
		}
		if("maxRange".equalsIgnoreCase(attributeName)) {
			this.setMaxRange((Long) value); 
			return;
		}
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new ObservableFeatureMetaData();
	}
}
