/* File:        org.molgenis.omx/model/JDBCDatabase
 * Copyright:   Inventory 2000-2014, GBIC 2002-2014, all rights reserved
 * Date:        November 21, 2014
 * 
 * generator:   org.molgenis.generators.db.JDBCMetaDatabaseGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis;

import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Vector;

import org.molgenis.MolgenisFieldTypes;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Field;
import org.molgenis.model.MolgenisModelException;

/**
 * This class is an in memory representation of the contents of your *_db.xml file
 * Utility of this class is to allow for dynamic querying and/or user interfacing
 * for example within a query tool or a security module.
 */
public class JDBCMetaDatabase extends Model
{
	private static final long serialVersionUID = 1L;
	
	public JDBCMetaDatabase()
	{
		super("org.molgenis.omx");
		try
		{
			//Autoid
			Entity autoid_entity = new Entity("Autoid",this.getDatabase());
			autoid_entity.setSystem(true);
			autoid_entity.setAbstract(true);
			autoid_entity.setDescription("This interface assigns an automatic 'id'.\n\t\t\t");
			autoid_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field autoid_id_field = new Field(autoid_entity, "id", MolgenisFieldTypes.getType("int"));
			autoid_id_field.setAuto(true);
			autoid_id_field.setDescription("automatically generated internal id, only for internal use.");
			autoid_id_field.setNillable(false);
			autoid_entity.addField(autoid_id_field);
			autoid_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Identifiable
			Entity identifiable_entity = new Entity("Identifiable",this.getDatabase());
			identifiable_entity.setSystem(true);
			identifiable_entity.setAbstract(true);
			identifiable_entity.setImplements(new String[]{"Autoid"});
			identifiable_entity.setDescription("This interface assigns an automatic 'id', globally\n\t\t\t\tunique identifier\n\t\t\t\t'identifier' field, and possibly not unique 'name'\n\t\t\t\tto all entities that implement it.\n\t\t\t");
			identifiable_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field identifiable_identifier_field = new Field(identifiable_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			identifiable_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			identifiable_identifier_field.setNillable(false);
			identifiable_entity.addField(identifiable_identifier_field);
			Field identifiable_name_field = new Field(identifiable_entity, "Name", MolgenisFieldTypes.getType("string"));
			identifiable_name_field.setDescription("human readible name, not necessary unique.");
			identifiable_name_field.setNillable(false);
			identifiable_entity.addField(identifiable_name_field);
			Field identifiable_id_field = new Field(identifiable_entity, "id", MolgenisFieldTypes.getType("int"));
			identifiable_id_field.setAuto(true);
			identifiable_id_field.setDescription("automatically generated internal id, only for internal use.");
			identifiable_id_field.setNillable(false);
			identifiable_entity.addField(identifiable_id_field);
			identifiable_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			identifiable_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			
			//MolgenisEntity
			Entity molgenisEntity_entity = new Entity("MolgenisEntity",this.getDatabase());
			molgenisEntity_entity.setSystem(true);
			molgenisEntity_entity.setAbstract(false);
			molgenisEntity_entity.setImplements(new String[]{"Autoid"});
			molgenisEntity_entity.setDescription("Referenceable catalog of entity names, menus, forms and\n\t\t\t\tplugins.\n\t\t\t");
			molgenisEntity_entity.setXrefLabels(Arrays.asList(new String[]{"className"}));
			Field molgenisEntity_name_field = new Field(molgenisEntity_entity, "name", MolgenisFieldTypes.getType("string"));
			molgenisEntity_name_field.setDescription("Name of the entity");
			molgenisEntity_name_field.setNillable(false);
			molgenisEntity_entity.addField(molgenisEntity_name_field);
			Field molgenisEntity_type__field = new Field(molgenisEntity_entity, "type_", MolgenisFieldTypes.getType("string"));
			molgenisEntity_type__field.setDescription("Type of the entity");
			molgenisEntity_type__field.setNillable(false);
			molgenisEntity_entity.addField(molgenisEntity_type__field);
			Field molgenisEntity_className_field = new Field(molgenisEntity_entity, "className", MolgenisFieldTypes.getType("string"));
			molgenisEntity_className_field.setDescription("Full name of the entity");
			molgenisEntity_className_field.setNillable(false);
			molgenisEntity_entity.addField(molgenisEntity_className_field);
			Field molgenisEntity_id_field = new Field(molgenisEntity_entity, "id", MolgenisFieldTypes.getType("int"));
			molgenisEntity_id_field.setAuto(true);
			molgenisEntity_id_field.setDescription("automatically generated internal id, only for internal use.");
			molgenisEntity_id_field.setNillable(false);
			molgenisEntity_entity.addField(molgenisEntity_id_field);
			molgenisEntity_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			molgenisEntity_entity.addKey(Arrays.asList(new String[]{"className"}),false,"");
			molgenisEntity_entity.addKey(Arrays.asList(new String[]{"name","type_"}),false,"");
			
			//RuntimeProperty
			Entity runtimeProperty_entity = new Entity("RuntimeProperty",this.getDatabase());
			runtimeProperty_entity.setSystem(false);
			runtimeProperty_entity.setAbstract(false);
			runtimeProperty_entity.setImplements(new String[]{"Identifiable"});
			runtimeProperty_entity.setDescription("");
			runtimeProperty_entity.setXrefLabels(Arrays.asList(new String[]{"Name"}));
			Field runtimeProperty_value_field = new Field(runtimeProperty_entity, "Value", MolgenisFieldTypes.getType("text"));
			runtimeProperty_value_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_value_field);
			Field runtimeProperty_identifier_field = new Field(runtimeProperty_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			runtimeProperty_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			runtimeProperty_identifier_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_identifier_field);
			Field runtimeProperty_name_field = new Field(runtimeProperty_entity, "Name", MolgenisFieldTypes.getType("string"));
			runtimeProperty_name_field.setDescription("human readible name, not necessary unique.");
			runtimeProperty_name_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_name_field);
			Field runtimeProperty_id_field = new Field(runtimeProperty_entity, "id", MolgenisFieldTypes.getType("int"));
			runtimeProperty_id_field.setAuto(true);
			runtimeProperty_id_field.setDescription("automatically generated internal id, only for internal use.");
			runtimeProperty_id_field.setNillable(false);
			runtimeProperty_entity.addField(runtimeProperty_id_field);
			runtimeProperty_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			runtimeProperty_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			runtimeProperty_entity.addKey(Arrays.asList(new String[]{"Name"}),false,"");
			
			//FreemarkerTemplate
			Entity freemarkerTemplate_entity = new Entity("FreemarkerTemplate",this.getDatabase());
			freemarkerTemplate_entity.setSystem(false);
			freemarkerTemplate_entity.setAbstract(false);
			freemarkerTemplate_entity.setImplements(new String[]{"Autoid"});
			freemarkerTemplate_entity.setDescription("");
			freemarkerTemplate_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field freemarkerTemplate_name_field = new Field(freemarkerTemplate_entity, "Name", MolgenisFieldTypes.getType("string"));
			freemarkerTemplate_name_field.setDescription("Name of the entity");
			freemarkerTemplate_name_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_name_field);
			Field freemarkerTemplate_value_field = new Field(freemarkerTemplate_entity, "Value", MolgenisFieldTypes.getType("script"));
			freemarkerTemplate_value_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_value_field);
			Field freemarkerTemplate_id_field = new Field(freemarkerTemplate_entity, "id", MolgenisFieldTypes.getType("int"));
			freemarkerTemplate_id_field.setAuto(true);
			freemarkerTemplate_id_field.setDescription("automatically generated internal id, only for internal use.");
			freemarkerTemplate_id_field.setNillable(false);
			freemarkerTemplate_entity.addField(freemarkerTemplate_id_field);
			freemarkerTemplate_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			freemarkerTemplate_entity.addKey(Arrays.asList(new String[]{"Name"}),false,"");
			
			//Characteristic
			Entity characteristic_entity = new Entity("Characteristic",this.getDatabase());
			characteristic_entity.setSystem(false);
			characteristic_entity.setAbstract(false);
			characteristic_entity.setImplements(new String[]{"Identifiable"});
			characteristic_entity.setDescription(" Characteristics are yes-no statements about things in\n\t\t\t\tthe world. These can be used as part of an observation, as parameter\n\t\t\t\tof ObservableFeature ('measuredCharacteristic'). For example: 'What\n\t\t\t\tis allele of [Marker]', here the [Marker] is a characteristic. Also,\n\t\t\t\tCharacteristics can be used as target of observation. Typical\n\t\t\t\texamples are 'Individual' or 'Panel'. But also 'Marker' can be an\n\t\t\t\tTarget when asked the question 'QTL p-value for [phenotype]': here\n\t\t\t\tboth target and feature are characteristic, for example 'leave\n\t\t\t\tcount'\n\t\t\t\t(phenotype characteristic) and 'PVV4' (marker characteristic).\n\t\t\t");
			characteristic_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field characteristic_description_field = new Field(characteristic_entity, "description", MolgenisFieldTypes.getType("text"));
			characteristic_description_field.setDescription("(Optional) Rudimentary meta data about the observable feature. Use of ontology       terms references to establish unambigious descriptions is recommended");
			characteristic_description_field.setNillable(true);
			characteristic_entity.addField(characteristic_description_field);
			Field characteristic_identifier_field = new Field(characteristic_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			characteristic_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			characteristic_identifier_field.setNillable(false);
			characteristic_entity.addField(characteristic_identifier_field);
			Field characteristic_name_field = new Field(characteristic_entity, "Name", MolgenisFieldTypes.getType("string"));
			characteristic_name_field.setDescription("human readible name, not necessary unique.");
			characteristic_name_field.setNillable(false);
			characteristic_entity.addField(characteristic_name_field);
			Field characteristic_id_field = new Field(characteristic_entity, "id", MolgenisFieldTypes.getType("int"));
			characteristic_id_field.setAuto(true);
			characteristic_id_field.setDescription("automatically generated internal id, only for internal use.");
			characteristic_id_field.setNillable(false);
			characteristic_entity.addField(characteristic_id_field);
			characteristic_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			characteristic_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			
			//ObservationTarget
			Entity observationTarget_entity = new Entity("ObservationTarget",this.getDatabase());
			observationTarget_entity.setSystem(false);
			observationTarget_entity.setAbstract(false);
			observationTarget_entity.setParents(new String[]{"Characteristic"});
			observationTarget_entity.setDescription(" ObservationTarget defines subjects of observation, such\n\t\t\t\tas Individual, Panel, Sample, etc. For instance: 'target 1' IS A\n\t\t\t\t'Individual'.\n\t\t\t");
			observationTarget_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field observationTarget_id_field = new Field(observationTarget_entity, "id", MolgenisFieldTypes.getType("int"));
			observationTarget_id_field.setAuto(true);
			observationTarget_id_field.setDescription("automatically generated internal id, only for internal use.");
			observationTarget_id_field.setNillable(false);
			observationTarget_entity.addField(observationTarget_id_field);
			observationTarget_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Individual
			Entity individual_entity = new Entity("Individual",this.getDatabase());
			individual_entity.setSystem(false);
			individual_entity.setAbstract(false);
			individual_entity.setParents(new String[]{"ObservationTarget"});
			individual_entity.setDescription(" The Individuals class defines the subjects that are\n\t\t\t\tused\n\t\t\t\tas observation target. The Individual class maps to\n\t\t\t\tXGAP:Individual\n\t\t\t\tand PaGE:Individual. Groups of individuals can be\n\t\t\t\tdefined via\n\t\t\t\tPanel.\n\t\t\t");
			individual_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field individual_mother_field = new Field(individual_entity, "Mother", MolgenisFieldTypes.getType("xref"));
			individual_mother_field.setDescription("Refers to the mother of the individual.");
			individual_mother_field.setNillable(true);
			individual_mother_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			individual_entity.addField(individual_mother_field);
			Field individual_father_field = new Field(individual_entity, "Father", MolgenisFieldTypes.getType("xref"));
			individual_father_field.setDescription("Refers to the father of the individual.");
			individual_father_field.setNillable(true);
			individual_father_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			individual_entity.addField(individual_father_field);
			Field individual_id_field = new Field(individual_entity, "id", MolgenisFieldTypes.getType("int"));
			individual_id_field.setAuto(true);
			individual_id_field.setDescription("automatically generated internal id, only for internal use.");
			individual_id_field.setNillable(false);
			individual_entity.addField(individual_id_field);
			individual_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Ontology
			Entity ontology_entity = new Entity("Ontology",this.getDatabase());
			ontology_entity.setSystem(false);
			ontology_entity.setAbstract(false);
			ontology_entity.setImplements(new String[]{"Identifiable"});
			ontology_entity.setDescription(" Ontology defines a reference to an ontology or\n\t\t\t\tcontrolled vocabulary from which well-defined and stable (ontology)\n\t\t\t\tterms can be obtained. Each Ontology should have a unique identifer,\n\t\t\t\tfor instance: Gene Ontology, Mammalian Phenotype, Human Phenotype\n\t\t\t\tOntology, Unified Medical Language System, Medical Subject Headings,\n\t\t\t\tetc. Also a abbreviation is required, for instance: GO, MP, HPO,\n\t\t\t\tUMLS, MeSH, etc. Use of existing ontologies/vocabularies is\n\t\t\t\trecommended to harmonize phenotypic feature and value descriptions.\n\t\t\t\tBut one can also create a 'local' Ontology. The Ontology class maps\n\t\t\t\tto FuGE::Ontology, MAGE-TAB::TermSourceREF.\n\t\t\t");
			ontology_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field ontology_ontologyAccession_field = new Field(ontology_entity, "ontologyAccession", MolgenisFieldTypes.getType("string"));
			ontology_ontologyAccession_field.setDescription("A accession that uniquely identifies the ontology (typically an acronym). E.g. GO, MeSH, HPO.");
			ontology_ontologyAccession_field.setNillable(true);
			ontology_entity.addField(ontology_ontologyAccession_field);
			Field ontology_ontologyURI_field = new Field(ontology_entity, "ontologyURI", MolgenisFieldTypes.getType("hyperlink"));
			ontology_ontologyURI_field.setDescription("(Optional) A URI that references the location of the ontology.");
			ontology_ontologyURI_field.setNillable(true);
			ontology_entity.addField(ontology_ontologyURI_field);
			Field ontology_identifier_field = new Field(ontology_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			ontology_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			ontology_identifier_field.setNillable(false);
			ontology_entity.addField(ontology_identifier_field);
			Field ontology_name_field = new Field(ontology_entity, "Name", MolgenisFieldTypes.getType("string"));
			ontology_name_field.setDescription("human readible name, not necessary unique.");
			ontology_name_field.setNillable(false);
			ontology_entity.addField(ontology_name_field);
			Field ontology_id_field = new Field(ontology_entity, "id", MolgenisFieldTypes.getType("int"));
			ontology_id_field.setAuto(true);
			ontology_id_field.setDescription("automatically generated internal id, only for internal use.");
			ontology_id_field.setNillable(false);
			ontology_entity.addField(ontology_id_field);
			ontology_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			ontology_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			
			//Species
			Entity species_entity = new Entity("Species",this.getDatabase());
			species_entity.setSystem(false);
			species_entity.setAbstract(false);
			species_entity.setParents(new String[]{"OntologyTerm"});
			species_entity.setDescription("Ontology terms for species. E.g. Arabidopsis thaliana.\n\t\t\t\tDISCUSSION: should we avoid subclasses of OntologyTerm and instead\n\t\t\t\tmake a 'tag' filter on terms so we can make pulldowns context\n\t\t\t\tdependent (e.g. to only show particular subqueries of ontologies).\n\t\t\t");
			species_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field species_id_field = new Field(species_entity, "id", MolgenisFieldTypes.getType("int"));
			species_id_field.setAuto(true);
			species_id_field.setDescription("automatically generated internal id, only for internal use.");
			species_id_field.setNillable(false);
			species_entity.addField(species_id_field);
			species_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//OntologyTerm
			Entity ontologyTerm_entity = new Entity("OntologyTerm",this.getDatabase());
			ontologyTerm_entity.setSystem(false);
			ontologyTerm_entity.setAbstract(false);
			ontologyTerm_entity.setParents(new String[]{"Characteristic"});
			ontologyTerm_entity.setDescription("\n\t\t\t\tOntologyTerm defines a single entry (term) from an\n\t\t\t\tontology or a controlled vocabulary (defined by Ontology). The\n\t\t\t\tidentifier is the ontology term is unique. E.g. 'NCI:Antigen Gene'.\n\t\t\t\tOther data entities can reference to this OntologyTerm to harmonize\n\t\t\t\tnaming of concepts. If no suitable ontology term exists then one can\n\t\t\t\tdefine new terms locally (in which case there is no formal accession\n\t\t\t\tfor the term limiting its use for cross-Investigation queries).\n\t\t\t");
			ontologyTerm_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field ontologyTerm_ontology_field = new Field(ontologyTerm_entity, "ontology", MolgenisFieldTypes.getType("xref"));
			ontologyTerm_ontology_field.setDescription("(Optional) The source ontology or controlled vocabulary list that ontology terms have been obtained from.");
			ontologyTerm_ontology_field.setNillable(true);
			ontologyTerm_ontology_field.setXRefVariables("Ontology", "id",Arrays.asList(new String[]{"Identifier"}));
			ontologyTerm_entity.addField(ontologyTerm_ontology_field);
			Field ontologyTerm_termAccession_field = new Field(ontologyTerm_entity, "termAccession", MolgenisFieldTypes.getType("string"));
			ontologyTerm_termAccession_field.setDescription("(Optional) The accession number assigned to the ontology term in its source ontology. If empty it is assumed to be a locally defined term.");
			ontologyTerm_termAccession_field.setNillable(true);
			ontologyTerm_entity.addField(ontologyTerm_termAccession_field);
			Field ontologyTerm_definition_field = new Field(ontologyTerm_entity, "definition", MolgenisFieldTypes.getType("string"));
			ontologyTerm_definition_field.setDescription("(Optional) The definition of the term.");
			ontologyTerm_definition_field.setNillable(true);
			ontologyTerm_entity.addField(ontologyTerm_definition_field);
			Field ontologyTerm_id_field = new Field(ontologyTerm_entity, "id", MolgenisFieldTypes.getType("int"));
			ontologyTerm_id_field.setAuto(true);
			ontologyTerm_id_field.setDescription("automatically generated internal id, only for internal use.");
			ontologyTerm_id_field.setNillable(false);
			ontologyTerm_entity.addField(ontologyTerm_id_field);
			ontologyTerm_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			ontologyTerm_entity.addKey(Arrays.asList(new String[]{"ontology","termAccession"}),false,"");
			
			//Accession
			Entity accession_entity = new Entity("Accession",this.getDatabase());
			accession_entity.setSystem(false);
			accession_entity.setAbstract(false);
			accession_entity.setParents(new String[]{"OntologyTerm"});
			accession_entity.setDescription("\n\t\t\t\tAn external identifier for an annotation. For example:\n\t\t\t\tname='R13H8.1', ontology='ensembl' or name='WBgene00000912',\n\t\t\t\tontology='wormbase'.\n\t\t\t");
			accession_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field accession_id_field = new Field(accession_entity, "id", MolgenisFieldTypes.getType("int"));
			accession_id_field.setAuto(true);
			accession_id_field.setDescription("automatically generated internal id, only for internal use.");
			accession_id_field.setNillable(false);
			accession_entity.addField(accession_id_field);
			accession_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ContactInterface
			Entity contactInterface_entity = new Entity("ContactInterface",this.getDatabase());
			contactInterface_entity.setSystem(false);
			contactInterface_entity.setAbstract(true);
			contactInterface_entity.setDescription(" A contact is either a person or an organization. Copied\n\t\t\t\tfrom FuGE::Contact.\n\t\t\t");
			Field contactInterface_address_field = new Field(contactInterface_entity, "Address", MolgenisFieldTypes.getType("text"));
			contactInterface_address_field.setDescription("The address of the Contact.");
			contactInterface_address_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_address_field);
			Field contactInterface_phone_field = new Field(contactInterface_entity, "Phone", MolgenisFieldTypes.getType("string"));
			contactInterface_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			contactInterface_phone_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_phone_field);
			Field contactInterface_email_field = new Field(contactInterface_entity, "Email", MolgenisFieldTypes.getType("string"));
			contactInterface_email_field.setDescription("The email address of the Contact.");
			contactInterface_email_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_email_field);
			Field contactInterface_fax_field = new Field(contactInterface_entity, "Fax", MolgenisFieldTypes.getType("string"));
			contactInterface_fax_field.setDescription("The fax number of the Contact.");
			contactInterface_fax_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_fax_field);
			Field contactInterface_tollFreePhone_field = new Field(contactInterface_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			contactInterface_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			contactInterface_tollFreePhone_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_tollFreePhone_field);
			Field contactInterface_city_field = new Field(contactInterface_entity, "City", MolgenisFieldTypes.getType("string"));
			contactInterface_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			contactInterface_city_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_city_field);
			Field contactInterface_country_field = new Field(contactInterface_entity, "Country", MolgenisFieldTypes.getType("string"));
			contactInterface_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			contactInterface_country_field.setNillable(true);
			contactInterface_entity.addField(contactInterface_country_field);
			
			//Institute
			Entity institute_entity = new Entity("Institute",this.getDatabase());
			institute_entity.setSystem(false);
			institute_entity.setAbstract(false);
			institute_entity.setImplements(new String[]{"ContactInterface"});
			institute_entity.setParents(new String[]{"Characteristic"});
			institute_entity.setDescription(" A contact is either a person or an organization. Copied\n\t\t\t\tfrom FuGE::Contact.\n\t\t\t");
			institute_entity.setXrefLabels(Arrays.asList(new String[]{"Name"}));
			Field institute_name_field = new Field(institute_entity, "Name", MolgenisFieldTypes.getType("string"));
			institute_name_field.setNillable(false);
			institute_entity.addField(institute_name_field);
			Field institute_id_field = new Field(institute_entity, "id", MolgenisFieldTypes.getType("int"));
			institute_id_field.setAuto(true);
			institute_id_field.setDescription("automatically generated internal id, only for internal use.");
			institute_id_field.setNillable(false);
			institute_entity.addField(institute_id_field);
			Field institute_address_field = new Field(institute_entity, "Address", MolgenisFieldTypes.getType("text"));
			institute_address_field.setDescription("The address of the Contact.");
			institute_address_field.setNillable(true);
			institute_entity.addField(institute_address_field);
			Field institute_phone_field = new Field(institute_entity, "Phone", MolgenisFieldTypes.getType("string"));
			institute_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			institute_phone_field.setNillable(true);
			institute_entity.addField(institute_phone_field);
			Field institute_email_field = new Field(institute_entity, "Email", MolgenisFieldTypes.getType("string"));
			institute_email_field.setDescription("The email address of the Contact.");
			institute_email_field.setNillable(true);
			institute_entity.addField(institute_email_field);
			Field institute_fax_field = new Field(institute_entity, "Fax", MolgenisFieldTypes.getType("string"));
			institute_fax_field.setDescription("The fax number of the Contact.");
			institute_fax_field.setNillable(true);
			institute_entity.addField(institute_fax_field);
			Field institute_tollFreePhone_field = new Field(institute_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			institute_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			institute_tollFreePhone_field.setNillable(true);
			institute_entity.addField(institute_tollFreePhone_field);
			Field institute_city_field = new Field(institute_entity, "City", MolgenisFieldTypes.getType("string"));
			institute_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			institute_city_field.setNillable(true);
			institute_entity.addField(institute_city_field);
			Field institute_country_field = new Field(institute_entity, "Country", MolgenisFieldTypes.getType("string"));
			institute_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			institute_country_field.setNillable(true);
			institute_entity.addField(institute_country_field);
			institute_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			institute_entity.addKey(Arrays.asList(new String[]{"Name"}),false,"");
			
			//PersonRole
			Entity personRole_entity = new Entity("PersonRole",this.getDatabase());
			personRole_entity.setSystem(false);
			personRole_entity.setAbstract(false);
			personRole_entity.setParents(new String[]{"OntologyTerm"});
			personRole_entity.setDescription("Seperate type of ontologyTerm to administrate roles.\n\t\t\t");
			personRole_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field personRole_id_field = new Field(personRole_entity, "id", MolgenisFieldTypes.getType("int"));
			personRole_id_field.setAuto(true);
			personRole_id_field.setDescription("automatically generated internal id, only for internal use.");
			personRole_id_field.setNillable(false);
			personRole_entity.addField(personRole_id_field);
			personRole_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ObservableFeature
			Entity observableFeature_entity = new Entity("ObservableFeature",this.getDatabase());
			observableFeature_entity.setSystem(false);
			observableFeature_entity.setAbstract(false);
			observableFeature_entity.setParents(new String[]{"Characteristic"});
			observableFeature_entity.setDescription("\n\t\t\t\tObservableFeature defines anything that can be observed.\n\t\t\t\t<p/>\n\t\t\t\tIn other words, ObservableFeature are the questions asked, e.g.\n\t\t\t\t'What\n\t\t\t\tis Height?', 'What is Systolic blood pressure?', or 'Has blue\n\t\t\t\teyes?'.\n\t\t\t\t<p/>\n\t\t\t\tSome questions may be repeated for multiple characteristics. For\n\t\t\t\texample 'What is [MarkerAllele] observed?' can be applied to all\n\t\t\t\telements of a MarkerSet, and 'What is [medicin codes] uses' can be\n\t\t\t\tapplied to a set of Medicine codes. This can be specified using the\n\t\t\t\tmeasuredCharacteristic field.\n\t\t\t\t<p/>\n\t\t\t\tThe identifier of ObservableFeature is globally unique. It is\n\t\t\t\trecommended that each ObservableFeature is named according to a\n\t\t\t\twell-defined ontology term or database accession.\n\t\t\t");
			observableFeature_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field observableFeature_unit_field = new Field(observableFeature_entity, "unit", MolgenisFieldTypes.getType("xref"));
			observableFeature_unit_field.setDescription("(Optional) Reference to the well-defined measurement unit used to observe this feature       (if feature is that concrete). E.g. mmHg");
			observableFeature_unit_field.setNillable(true);
			observableFeature_unit_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			observableFeature_entity.addField(observableFeature_unit_field);
			Field observableFeature_definitions_field = new Field(observableFeature_entity, "definitions", MolgenisFieldTypes.getType("mref"));
			observableFeature_definitions_field.setDescription("The concept that is being measured in a specific way.");
			observableFeature_definitions_field.setNillable(true);
			observableFeature_definitions_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			observableFeature_entity.addField(observableFeature_definitions_field);
			Field observableFeature_dataType_field = new Field(observableFeature_entity, "dataType", MolgenisFieldTypes.getType("enum"));
			Vector<String> observableFeature_dataType_field_enumoptions = new Vector<String>();
			observableFeature_dataType_field_enumoptions.add("bool");
			observableFeature_dataType_field_enumoptions.add("categorical");
			observableFeature_dataType_field_enumoptions.add("date");
			observableFeature_dataType_field_enumoptions.add("datetime");
			observableFeature_dataType_field_enumoptions.add("decimal");
			observableFeature_dataType_field_enumoptions.add("email");
			observableFeature_dataType_field_enumoptions.add("enum");
			observableFeature_dataType_field_enumoptions.add("file");
			observableFeature_dataType_field_enumoptions.add("html");
			observableFeature_dataType_field_enumoptions.add("hyperlink");
			observableFeature_dataType_field_enumoptions.add("image");
			observableFeature_dataType_field_enumoptions.add("int");
			observableFeature_dataType_field_enumoptions.add("long");
			observableFeature_dataType_field_enumoptions.add("mref");
			observableFeature_dataType_field_enumoptions.add("string");
			observableFeature_dataType_field_enumoptions.add("text");
			observableFeature_dataType_field_enumoptions.add("xref");
			observableFeature_dataType_field.setEnumOptions(observableFeature_dataType_field_enumoptions);
			observableFeature_dataType_field.setDevaultValue("string");
			observableFeature_dataType_field.setDescription("(Optional) Reference to the technical data type. E.g. 'int'");
			observableFeature_dataType_field.setNillable(false);
			observableFeature_entity.addField(observableFeature_dataType_field);
			Field observableFeature_temporal_field = new Field(observableFeature_entity, "temporal", MolgenisFieldTypes.getType("bool"));
			observableFeature_temporal_field.setDevaultValue("false");
			observableFeature_temporal_field.setDescription("Whether this feature is time dependent and can have different values when measured       on different times (e.g. weight, temporal=true) or generally only measured once (e.g. birth date,       temporal=false)");
			observableFeature_temporal_field.setNillable(false);
			observableFeature_entity.addField(observableFeature_temporal_field);
			Field observableFeature_minRange_field = new Field(observableFeature_entity, "minRange", MolgenisFieldTypes.getType("long"));
			observableFeature_minRange_field.setDescription("for numeric values this is used to set the 'min' value of the slider user interface");
			observableFeature_minRange_field.setNillable(true);
			observableFeature_entity.addField(observableFeature_minRange_field);
			Field observableFeature_maxRange_field = new Field(observableFeature_entity, "maxRange", MolgenisFieldTypes.getType("long"));
			observableFeature_maxRange_field.setDescription("for numeric values this is used to set the 'max' value of the slider user interface");
			observableFeature_maxRange_field.setNillable(true);
			observableFeature_entity.addField(observableFeature_maxRange_field);
			Field observableFeature_id_field = new Field(observableFeature_entity, "id", MolgenisFieldTypes.getType("int"));
			observableFeature_id_field.setAuto(true);
			observableFeature_id_field.setDescription("automatically generated internal id, only for internal use.");
			observableFeature_id_field.setNillable(false);
			observableFeature_entity.addField(observableFeature_id_field);
			observableFeature_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Category
			Entity category_entity = new Entity("Category",this.getDatabase());
			category_entity.setSystem(false);
			category_entity.setAbstract(false);
			category_entity.setParents(new String[]{"Characteristic"});
			category_entity.setDescription("Category is partOf ObservableFeature to define\n\t\t\t\tcategories for an\n\t\t\t\tObservableFeature, such as the categorical answer\n\t\t\t\tcodes that are often used in Questionaires.\n\t\t\t\tFor example the ObservableFeature 'sex' has {code_string = 1,\n\t\t\t\tlabel=male} and {code_string\n\t\t\t\t= 2, label=female}. Category can be\n\t\t\t\tlinked to well-defined ontology terms via the\n\t\t\t\tontologyReference.\n\t\t\t\tCategory extends ObservationElement such that it\n\t\t\t\tcan be referenced by\n\t\t\t\tObservedValue.value.\n\t\t\t\tThe Category class maps to METABASE::Category\n\t\t\t");
			category_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field category_observableFeature_field = new Field(category_entity, "observableFeature", MolgenisFieldTypes.getType("xref"));
			category_observableFeature_field.setDescription("The Measurement these permitted values are part of.");
			category_observableFeature_field.setNillable(false);
			category_observableFeature_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			category_entity.addField(category_observableFeature_field);
			Field category_valueCode_field = new Field(category_entity, "valueCode", MolgenisFieldTypes.getType("string"));
			category_valueCode_field.setDescription("The value used to store this category in ObservedValue. For example '1', '2'.");
			category_valueCode_field.setNillable(true);
			category_entity.addField(category_valueCode_field);
			Field category_definition_field = new Field(category_entity, "definition", MolgenisFieldTypes.getType("xref"));
			category_definition_field.setDescription("The category that is being measured in a specific way.");
			category_definition_field.setNillable(true);
			category_definition_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			category_entity.addField(category_definition_field);
			Field category_isMissing_field = new Field(category_entity, "isMissing", MolgenisFieldTypes.getType("bool"));
			category_isMissing_field.setDevaultValue("false");
			category_isMissing_field.setDescription("whether this value should be treated as missing value.");
			category_isMissing_field.setNillable(false);
			category_entity.addField(category_isMissing_field);
			Field category_id_field = new Field(category_entity, "id", MolgenisFieldTypes.getType("int"));
			category_id_field.setAuto(true);
			category_id_field.setDescription("automatically generated internal id, only for internal use.");
			category_id_field.setNillable(false);
			category_entity.addField(category_id_field);
			category_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//Protocol
			Entity protocol_entity = new Entity("Protocol",this.getDatabase());
			protocol_entity.setSystem(false);
			protocol_entity.setAbstract(false);
			protocol_entity.setParents(new String[]{"Characteristic"});
			protocol_entity.setDescription("\n\t\t\t\tThe Protocol class defines parameterizable descriptions\n\t\t\t\tof\n\t\t\t\t(analysis)methods. Examples of protocols are: Questionaires, SOPs,\n\t\t\t\tAssay platforms, Statistical analyses, etc.\n\t\t\t\tEach protocol has a\n\t\t\t\tunique identifier.\n\t\t\t\tProtocol has an association to OntologyTerm to\n\t\t\t\trepresent the type of protocol.\n\t\t\t");
			protocol_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field protocol_protocolType_field = new Field(protocol_entity, "ProtocolType", MolgenisFieldTypes.getType("xref"));
			protocol_protocolType_field.setDescription("classification of protocol");
			protocol_protocolType_field.setNillable(true);
			protocol_protocolType_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			protocol_entity.addField(protocol_protocolType_field);
			Field protocol_subprotocols_field = new Field(protocol_entity, "subprotocols", MolgenisFieldTypes.getType("mref"));
			protocol_subprotocols_field.setDescription("Subprotocols of this protocol");
			protocol_subprotocols_field.setNillable(true);
			protocol_subprotocols_field.setXRefVariables("Protocol", "id",Arrays.asList(new String[]{"Identifier"}));
			protocol_entity.addField(protocol_subprotocols_field);
			Field protocol_features_field = new Field(protocol_entity, "Features", MolgenisFieldTypes.getType("mref"));
			protocol_features_field.setDescription("parameters (in/out) that are used or produced by this protocol.");
			protocol_features_field.setNillable(true);
			protocol_features_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			protocol_entity.addField(protocol_features_field);
			Field protocol_requiredFeatures_field = new Field(protocol_entity, "RequiredFeatures", MolgenisFieldTypes.getType("mref"));
			protocol_requiredFeatures_field.setDescription("..........");
			protocol_requiredFeatures_field.setNillable(true);
			protocol_requiredFeatures_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			protocol_entity.addField(protocol_requiredFeatures_field);
			Field protocol_root_field = new Field(protocol_entity, "root", MolgenisFieldTypes.getType("bool"));
			protocol_root_field.setDevaultValue("false");
			protocol_root_field.setDescription("Indicator whether this protocol defines a workflow (e.g is the first protocol of a workflow).");
			protocol_root_field.setNillable(false);
			protocol_entity.addField(protocol_root_field);
			Field protocol_active_field = new Field(protocol_entity, "active", MolgenisFieldTypes.getType("bool"));
			protocol_active_field.setDevaultValue("true");
			protocol_active_field.setDescription("whether this protocol is considered active/inactive");
			protocol_active_field.setNillable(false);
			protocol_entity.addField(protocol_active_field);
			Field protocol_id_field = new Field(protocol_entity, "id", MolgenisFieldTypes.getType("int"));
			protocol_id_field.setAuto(true);
			protocol_id_field.setDescription("automatically generated internal id, only for internal use.");
			protocol_id_field.setNillable(false);
			protocol_entity.addField(protocol_id_field);
			protocol_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DataSet
			Entity dataSet_entity = new Entity("DataSet",this.getDatabase());
			dataSet_entity.setSystem(false);
			dataSet_entity.setAbstract(false);
			dataSet_entity.setParents(new String[]{"Characteristic"});
			dataSet_entity.setDescription("Container for one or more observations that are measured\n\t\t\t\tusing the same protocol and by the same performer(s). The data set\n\t\t\t\tmay be a file (having the same identifier) but in most cases it is a\n\t\t\t\tdata table consisting of rows (Observation).\n\t\t\t\tThis entity replaces\n\t\t\t\tProtocolApplication.\n\t\t\t");
			dataSet_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field dataSet_protocolUsed_field = new Field(dataSet_entity, "ProtocolUsed", MolgenisFieldTypes.getType("xref"));
			dataSet_protocolUsed_field.setDescription("Reference to the protocol that is being used (if available)");
			dataSet_protocolUsed_field.setNillable(false);
			dataSet_protocolUsed_field.setXRefVariables("Protocol", "id",Arrays.asList(new String[]{"Identifier"}));
			dataSet_entity.addField(dataSet_protocolUsed_field);
			Field dataSet_startTime_field = new Field(dataSet_entity, "startTime", MolgenisFieldTypes.getType("datetime"));
			dataSet_startTime_field.setAuto(true);
			dataSet_startTime_field.setDescription("time when the protocol started.");
			dataSet_startTime_field.setNillable(false);
			dataSet_entity.addField(dataSet_startTime_field);
			Field dataSet_endTime_field = new Field(dataSet_entity, "endTime", MolgenisFieldTypes.getType("datetime"));
			dataSet_endTime_field.setAuto(true);
			dataSet_endTime_field.setDescription("(Optional) time when the protocol ended.");
			dataSet_endTime_field.setNillable(true);
			dataSet_entity.addField(dataSet_endTime_field);
			Field dataSet_id_field = new Field(dataSet_entity, "id", MolgenisFieldTypes.getType("int"));
			dataSet_id_field.setAuto(true);
			dataSet_id_field.setDescription("automatically generated internal id, only for internal use.");
			dataSet_id_field.setNillable(false);
			dataSet_entity.addField(dataSet_id_field);
			dataSet_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ObservationSet
			Entity observationSet_entity = new Entity("ObservationSet",this.getDatabase());
			observationSet_entity.setSystem(false);
			observationSet_entity.setAbstract(false);
			observationSet_entity.setImplements(new String[]{"Autoid"});
			observationSet_entity.setDescription("In practice: Observation is one row within a DataSet.\n\t\t\t");
			observationSet_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field observationSet_identifier_field = new Field(observationSet_entity, "Identifier", MolgenisFieldTypes.getType("string"));
			observationSet_identifier_field.setDescription("user supplied or automatically assigned (using a decorator) unique and short identifier, e.g. MA1234");
			observationSet_identifier_field.setNillable(false);
			observationSet_entity.addField(observationSet_identifier_field);
			Field observationSet_partOfDataSet_field = new Field(observationSet_entity, "partOfDataSet", MolgenisFieldTypes.getType("xref"));
			observationSet_partOfDataSet_field.setDescription("DataSet this ValueSet is part of.");
			observationSet_partOfDataSet_field.setNillable(false);
			observationSet_partOfDataSet_field.setXRefVariables("DataSet", "id",Arrays.asList(new String[]{"Identifier"}));
			observationSet_entity.addField(observationSet_partOfDataSet_field);
			Field observationSet_time_field = new Field(observationSet_entity, "Time", MolgenisFieldTypes.getType("datetime"));
			observationSet_time_field.setDescription("Time of this observationSet");
			observationSet_time_field.setNillable(true);
			observationSet_entity.addField(observationSet_time_field);
			Field observationSet_id_field = new Field(observationSet_entity, "id", MolgenisFieldTypes.getType("int"));
			observationSet_id_field.setAuto(true);
			observationSet_id_field.setDescription("automatically generated internal id, only for internal use.");
			observationSet_id_field.setNillable(false);
			observationSet_entity.addField(observationSet_id_field);
			observationSet_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			observationSet_entity.addKey(Arrays.asList(new String[]{"Identifier"}),false,"");
			observationSet_entity.addKey(Arrays.asList(new String[]{"partOfDataSet","Time"}),false,"");
			
			//Panel
			Entity panel_entity = new Entity("Panel",this.getDatabase());
			panel_entity.setSystem(false);
			panel_entity.setAbstract(false);
			panel_entity.setParents(new String[]{"ObservationTarget"});
			panel_entity.setDescription("The Panel class defines groups of individuals based on\n\t\t\t\tcohort design, case/controls, families, etc. For instance:\n\t\t\t\t'LifeLines\n\t\t\t\tcohort', 'middle aged man', 'recombinant mouse inbred Line\n\t\t\t\tdba x b6'\n\t\t\t\tor 'Smith family'. A Panel can act as a single\n\t\t\t\tObservationTarget.\n\t\t\t\tFor example: average height (Measurement) in the\n\t\t\t\tLifeLines cohort\n\t\t\t\t(Panel) is 174cm (ObservedValue). The Panel class\n\t\t\t\tmaps to XGAP:Strain and PaGE:Panel\n\t\t\t\tclasses. In METABASE this is\n\t\t\t\tassumed there is one panel per study.\n\t\t\t");
			panel_entity.setXrefLabels(Arrays.asList(new String[]{"Identifier"}));
			Field panel_panelType_field = new Field(panel_entity, "PanelType", MolgenisFieldTypes.getType("xref"));
			panel_panelType_field.setDescription("Indicate the type of Panel (example: Sample panel, AssayedPanel, Natural=wild type, Parental=parents of a cross, F1=First generation of cross, RCC=Recombinant congenic, CSS=chromosome substitution)");
			panel_panelType_field.setNillable(true);
			panel_panelType_field.setXRefVariables("OntologyTerm", "id",Arrays.asList(new String[]{"Identifier"}));
			panel_entity.addField(panel_panelType_field);
			Field panel_numberOfIndividuals_field = new Field(panel_entity, "NumberOfIndividuals", MolgenisFieldTypes.getType("int"));
			panel_numberOfIndividuals_field.setNillable(false);
			panel_entity.addField(panel_numberOfIndividuals_field);
			Field panel_species_field = new Field(panel_entity, "Species", MolgenisFieldTypes.getType("xref"));
			panel_species_field.setDescription("The species this panel is an instance of/part of/extracted from.");
			panel_species_field.setNillable(true);
			panel_species_field.setXRefVariables("Species", "id",Arrays.asList(new String[]{"Identifier"}));
			panel_entity.addField(panel_species_field);
			Field panel_individuals_field = new Field(panel_entity, "Individuals", MolgenisFieldTypes.getType("mref"));
			panel_individuals_field.setDescription("The list of individuals in this panel");
			panel_individuals_field.setNillable(true);
			panel_individuals_field.setXRefVariables("Individual", "id",Arrays.asList(new String[]{"Identifier"}));
			panel_entity.addField(panel_individuals_field);
			Field panel_id_field = new Field(panel_entity, "id", MolgenisFieldTypes.getType("int"));
			panel_id_field.setAuto(true);
			panel_id_field.setDescription("automatically generated internal id, only for internal use.");
			panel_id_field.setNillable(false);
			panel_entity.addField(panel_id_field);
			panel_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//PanelSource
			Entity panelSource_entity = new Entity("PanelSource",this.getDatabase());
			panelSource_entity.setSystem(false);
			panelSource_entity.setAbstract(false);
			panelSource_entity.setImplements(new String[]{"Autoid"});
			panelSource_entity.setDescription("PanelSources is partOf Panel to define how panels are\n\t\t\t\trelated panels, founder panels,\n\t\t\t\tsuch as overlap,\n\t\t\t\tselection criteria,\n\t\t\t\tgetting assayed panel from a\n\t\t\t\tsample panel, etc.\n\t\t\t");
			panelSource_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field panelSource_currentPanel_field = new Field(panelSource_entity, "CurrentPanel", MolgenisFieldTypes.getType("xref"));
			panelSource_currentPanel_field.setDescription("Panel for which these sources are defined.");
			panelSource_currentPanel_field.setNillable(false);
			panelSource_currentPanel_field.setXRefVariables("Panel", "id",Arrays.asList(new String[]{"Identifier"}));
			panelSource_entity.addField(panelSource_currentPanel_field);
			Field panelSource_sourcePanel_field = new Field(panelSource_entity, "SourcePanel", MolgenisFieldTypes.getType("xref"));
			panelSource_sourcePanel_field.setDescription("Source that contributed individuals to current panel");
			panelSource_sourcePanel_field.setNillable(false);
			panelSource_sourcePanel_field.setXRefVariables("Panel", "id",Arrays.asList(new String[]{"Identifier"}));
			panelSource_entity.addField(panelSource_sourcePanel_field);
			Field panelSource_numberOfIndividuals_field = new Field(panelSource_entity, "NumberOfIndividuals", MolgenisFieldTypes.getType("int"));
			panelSource_numberOfIndividuals_field.setDescription("Number of individuals lifted over from this source");
			panelSource_numberOfIndividuals_field.setNillable(true);
			panelSource_entity.addField(panelSource_numberOfIndividuals_field);
			Field panelSource_selectionCriteria_field = new Field(panelSource_entity, "SelectionCriteria", MolgenisFieldTypes.getType("text"));
			panelSource_selectionCriteria_field.setDescription("Inclusion/exclusion criteria used to select these individuals from source into current panel");
			panelSource_selectionCriteria_field.setNillable(false);
			panelSource_entity.addField(panelSource_selectionCriteria_field);
			Field panelSource_id_field = new Field(panelSource_entity, "id", MolgenisFieldTypes.getType("int"));
			panelSource_id_field.setAuto(true);
			panelSource_id_field.setDescription("automatically generated internal id, only for internal use.");
			panelSource_id_field.setNillable(false);
			panelSource_entity.addField(panelSource_id_field);
			panelSource_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//PersonInterface
			Entity personInterface_entity = new Entity("PersonInterface",this.getDatabase());
			personInterface_entity.setSystem(false);
			personInterface_entity.setAbstract(true);
			personInterface_entity.setDescription(" A contact is either a person or an organization. Copied\n\t\t\t\tfrom FuGE::Contact.\n\t\t\t");
			Field personInterface_address_field = new Field(personInterface_entity, "Address", MolgenisFieldTypes.getType("text"));
			personInterface_address_field.setDescription("The address of the Contact.");
			personInterface_address_field.setNillable(true);
			personInterface_entity.addField(personInterface_address_field);
			Field personInterface_phone_field = new Field(personInterface_entity, "Phone", MolgenisFieldTypes.getType("string"));
			personInterface_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			personInterface_phone_field.setNillable(true);
			personInterface_entity.addField(personInterface_phone_field);
			Field personInterface_email_field = new Field(personInterface_entity, "Email", MolgenisFieldTypes.getType("string"));
			personInterface_email_field.setDescription("The email address of the Contact.");
			personInterface_email_field.setNillable(true);
			personInterface_entity.addField(personInterface_email_field);
			Field personInterface_fax_field = new Field(personInterface_entity, "Fax", MolgenisFieldTypes.getType("string"));
			personInterface_fax_field.setDescription("The fax number of the Contact.");
			personInterface_fax_field.setNillable(true);
			personInterface_entity.addField(personInterface_fax_field);
			Field personInterface_tollFreePhone_field = new Field(personInterface_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			personInterface_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			personInterface_tollFreePhone_field.setNillable(true);
			personInterface_entity.addField(personInterface_tollFreePhone_field);
			Field personInterface_city_field = new Field(personInterface_entity, "City", MolgenisFieldTypes.getType("string"));
			personInterface_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			personInterface_city_field.setNillable(true);
			personInterface_entity.addField(personInterface_city_field);
			Field personInterface_country_field = new Field(personInterface_entity, "Country", MolgenisFieldTypes.getType("string"));
			personInterface_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			personInterface_country_field.setNillable(true);
			personInterface_entity.addField(personInterface_country_field);
			Field personInterface_firstName_field = new Field(personInterface_entity, "FirstName", MolgenisFieldTypes.getType("string"));
			personInterface_firstName_field.setNillable(true);
			personInterface_entity.addField(personInterface_firstName_field);
			Field personInterface_midInitials_field = new Field(personInterface_entity, "MidInitials", MolgenisFieldTypes.getType("string"));
			personInterface_midInitials_field.setNillable(true);
			personInterface_entity.addField(personInterface_midInitials_field);
			Field personInterface_lastName_field = new Field(personInterface_entity, "LastName", MolgenisFieldTypes.getType("string"));
			personInterface_lastName_field.setNillable(true);
			personInterface_entity.addField(personInterface_lastName_field);
			Field personInterface_title_field = new Field(personInterface_entity, "Title", MolgenisFieldTypes.getType("string"));
			personInterface_title_field.setDescription("An academic title, e.g. Prof.dr, PhD");
			personInterface_title_field.setNillable(true);
			personInterface_entity.addField(personInterface_title_field);
			Field personInterface_affiliation_field = new Field(personInterface_entity, "Affiliation", MolgenisFieldTypes.getType("xref"));
			personInterface_affiliation_field.setNillable(true);
			personInterface_affiliation_field.setXRefVariables("Institute", "id",Arrays.asList(new String[]{"Name"}));
			personInterface_entity.addField(personInterface_affiliation_field);
			Field personInterface_department_field = new Field(personInterface_entity, "Department", MolgenisFieldTypes.getType("string"));
			personInterface_department_field.setDescription("Added from the old definition of MolgenisUser. Department of this contact.");
			personInterface_department_field.setNillable(true);
			personInterface_entity.addField(personInterface_department_field);
			Field personInterface_roles_field = new Field(personInterface_entity, "Roles", MolgenisFieldTypes.getType("xref"));
			personInterface_roles_field.setDescription("Indicate role of the contact, e.g. lab worker or PI. Changed from mref to xref in oct 2011.");
			personInterface_roles_field.setNillable(true);
			personInterface_roles_field.setXRefVariables("PersonRole", "id",Arrays.asList(new String[]{"Identifier"}));
			personInterface_entity.addField(personInterface_roles_field);
			
			//Person
			Entity person_entity = new Entity("Person",this.getDatabase());
			person_entity.setSystem(false);
			person_entity.setAbstract(false);
			person_entity.setImplements(new String[]{"PersonInterface"});
			person_entity.setParents(new String[]{"Characteristic"});
			person_entity.setDescription("\n\t\t\t\tPerson represents one or more people involved with an Investigation.\n\t\t\t\tThis may include authors on a paper, lab personnel or PIs. Person\n\t\t\t\thas last name, firstname, mid initial, address, contact and email. A\n\t\t\t\tPerson role is included to represent how a Person is involved with\n\t\t\t\tan investigation. For submission to repository purposes an allowed\n\t\t\t\tvalue is 'submitter' and the term is present in the MGED Ontology,\n\t\t\t\tan alternative use could represent job title. An Example from\n\t\t\t\tArrayExpress is E-MTAB-506\n\t\t\t\t<a href=\"ftp://ftp.ebi.ac.uk/pub/databases/microarray/data/experiment/TABM/E-TABM-506/E-TABM-506.idf.txt\">\n\t\t\t\t\tftp://ftp.ebi.ac.uk/pub/databases/microarray/data/experiment/TABM/E-TABM-506/E-TABM-506.idf.txt.\n\t\t\t\t</a>\n\t\t\t\t.\n\t\t\t\t<br/>\n\t\t\t\tThe FUGE equivalent to Person is FuGE::Person.\n\t\t\t");
			person_entity.setXrefLabels(Arrays.asList(new String[]{"Name"}));
			Field person_id_field = new Field(person_entity, "id", MolgenisFieldTypes.getType("int"));
			person_id_field.setAuto(true);
			person_id_field.setDescription("automatically generated internal id, only for internal use.");
			person_id_field.setNillable(false);
			person_entity.addField(person_id_field);
			Field person_address_field = new Field(person_entity, "Address", MolgenisFieldTypes.getType("text"));
			person_address_field.setDescription("The address of the Contact.");
			person_address_field.setNillable(true);
			person_entity.addField(person_address_field);
			Field person_phone_field = new Field(person_entity, "Phone", MolgenisFieldTypes.getType("string"));
			person_phone_field.setDescription("The telephone number of the Contact including the suitable area codes.");
			person_phone_field.setNillable(true);
			person_entity.addField(person_phone_field);
			Field person_email_field = new Field(person_entity, "Email", MolgenisFieldTypes.getType("string"));
			person_email_field.setDescription("The email address of the Contact.");
			person_email_field.setNillable(true);
			person_entity.addField(person_email_field);
			Field person_fax_field = new Field(person_entity, "Fax", MolgenisFieldTypes.getType("string"));
			person_fax_field.setDescription("The fax number of the Contact.");
			person_fax_field.setNillable(true);
			person_entity.addField(person_fax_field);
			Field person_tollFreePhone_field = new Field(person_entity, "tollFreePhone", MolgenisFieldTypes.getType("string"));
			person_tollFreePhone_field.setDescription("A toll free phone number for the Contact, including suitable area codes.");
			person_tollFreePhone_field.setNillable(true);
			person_entity.addField(person_tollFreePhone_field);
			Field person_city_field = new Field(person_entity, "City", MolgenisFieldTypes.getType("string"));
			person_city_field.setDescription("Added from the old definition of MolgenisUser. City of this contact.");
			person_city_field.setNillable(true);
			person_entity.addField(person_city_field);
			Field person_country_field = new Field(person_entity, "Country", MolgenisFieldTypes.getType("string"));
			person_country_field.setDescription("Added from the old definition of MolgenisUser. Country of this contact.");
			person_country_field.setNillable(true);
			person_entity.addField(person_country_field);
			Field person_firstName_field = new Field(person_entity, "FirstName", MolgenisFieldTypes.getType("string"));
			person_firstName_field.setNillable(true);
			person_entity.addField(person_firstName_field);
			Field person_midInitials_field = new Field(person_entity, "MidInitials", MolgenisFieldTypes.getType("string"));
			person_midInitials_field.setNillable(true);
			person_entity.addField(person_midInitials_field);
			Field person_lastName_field = new Field(person_entity, "LastName", MolgenisFieldTypes.getType("string"));
			person_lastName_field.setNillable(true);
			person_entity.addField(person_lastName_field);
			Field person_title_field = new Field(person_entity, "Title", MolgenisFieldTypes.getType("string"));
			person_title_field.setDescription("An academic title, e.g. Prof.dr, PhD");
			person_title_field.setNillable(true);
			person_entity.addField(person_title_field);
			Field person_affiliation_field = new Field(person_entity, "Affiliation", MolgenisFieldTypes.getType("xref"));
			person_affiliation_field.setNillable(true);
			person_affiliation_field.setXRefVariables("Institute", "id",Arrays.asList(new String[]{"Name"}));
			person_entity.addField(person_affiliation_field);
			Field person_department_field = new Field(person_entity, "Department", MolgenisFieldTypes.getType("string"));
			person_department_field.setDescription("Added from the old definition of MolgenisUser. Department of this contact.");
			person_department_field.setNillable(true);
			person_entity.addField(person_department_field);
			Field person_roles_field = new Field(person_entity, "Roles", MolgenisFieldTypes.getType("xref"));
			person_roles_field.setDescription("Indicate role of the contact, e.g. lab worker or PI. Changed from mref to xref in oct 2011.");
			person_roles_field.setNillable(true);
			person_roles_field.setXRefVariables("PersonRole", "id",Arrays.asList(new String[]{"Identifier"}));
			person_entity.addField(person_roles_field);
			person_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			person_entity.addKey(Arrays.asList(new String[]{"Email"}),false,"");
			
			//Value
			Entity value_entity = new Entity("Value",this.getDatabase());
			value_entity.setSystem(false);
			value_entity.setAbstract(false);
			value_entity.setImplements(new String[]{"Autoid"});
			value_entity.setDescription("");
			value_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field value_id_field = new Field(value_entity, "id", MolgenisFieldTypes.getType("int"));
			value_id_field.setAuto(true);
			value_id_field.setDescription("automatically generated internal id, only for internal use.");
			value_id_field.setNillable(false);
			value_entity.addField(value_id_field);
			value_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//BoolValue
			Entity boolValue_entity = new Entity("BoolValue",this.getDatabase());
			boolValue_entity.setSystem(false);
			boolValue_entity.setAbstract(false);
			boolValue_entity.setParents(new String[]{"Value"});
			boolValue_entity.setDescription("");
			boolValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field boolValue_value_field = new Field(boolValue_entity, "Value", MolgenisFieldTypes.getType("bool"));
			boolValue_value_field.setNillable(false);
			boolValue_entity.addField(boolValue_value_field);
			Field boolValue_id_field = new Field(boolValue_entity, "id", MolgenisFieldTypes.getType("int"));
			boolValue_id_field.setAuto(true);
			boolValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			boolValue_id_field.setNillable(false);
			boolValue_entity.addField(boolValue_id_field);
			boolValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//CategoricalValue
			Entity categoricalValue_entity = new Entity("CategoricalValue",this.getDatabase());
			categoricalValue_entity.setSystem(false);
			categoricalValue_entity.setAbstract(false);
			categoricalValue_entity.setParents(new String[]{"Value"});
			categoricalValue_entity.setDescription("");
			categoricalValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field categoricalValue_value_field = new Field(categoricalValue_entity, "Value", MolgenisFieldTypes.getType("xref"));
			categoricalValue_value_field.setNillable(false);
			categoricalValue_value_field.setXRefVariables("Category", "id",Arrays.asList(new String[]{"Identifier"}));
			categoricalValue_entity.addField(categoricalValue_value_field);
			Field categoricalValue_id_field = new Field(categoricalValue_entity, "id", MolgenisFieldTypes.getType("int"));
			categoricalValue_id_field.setAuto(true);
			categoricalValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			categoricalValue_id_field.setNillable(false);
			categoricalValue_entity.addField(categoricalValue_id_field);
			categoricalValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DateValue
			Entity dateValue_entity = new Entity("DateValue",this.getDatabase());
			dateValue_entity.setSystem(false);
			dateValue_entity.setAbstract(false);
			dateValue_entity.setParents(new String[]{"Value"});
			dateValue_entity.setDescription("");
			dateValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field dateValue_value_field = new Field(dateValue_entity, "Value", MolgenisFieldTypes.getType("date"));
			dateValue_value_field.setNillable(false);
			dateValue_entity.addField(dateValue_value_field);
			Field dateValue_id_field = new Field(dateValue_entity, "id", MolgenisFieldTypes.getType("int"));
			dateValue_id_field.setAuto(true);
			dateValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			dateValue_id_field.setNillable(false);
			dateValue_entity.addField(dateValue_id_field);
			dateValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DateTimeValue
			Entity dateTimeValue_entity = new Entity("DateTimeValue",this.getDatabase());
			dateTimeValue_entity.setSystem(false);
			dateTimeValue_entity.setAbstract(false);
			dateTimeValue_entity.setParents(new String[]{"Value"});
			dateTimeValue_entity.setDescription("");
			dateTimeValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field dateTimeValue_value_field = new Field(dateTimeValue_entity, "Value", MolgenisFieldTypes.getType("datetime"));
			dateTimeValue_value_field.setNillable(false);
			dateTimeValue_entity.addField(dateTimeValue_value_field);
			Field dateTimeValue_id_field = new Field(dateTimeValue_entity, "id", MolgenisFieldTypes.getType("int"));
			dateTimeValue_id_field.setAuto(true);
			dateTimeValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			dateTimeValue_id_field.setNillable(false);
			dateTimeValue_entity.addField(dateTimeValue_id_field);
			dateTimeValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//DecimalValue
			Entity decimalValue_entity = new Entity("DecimalValue",this.getDatabase());
			decimalValue_entity.setSystem(false);
			decimalValue_entity.setAbstract(false);
			decimalValue_entity.setParents(new String[]{"Value"});
			decimalValue_entity.setDescription("");
			decimalValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field decimalValue_value_field = new Field(decimalValue_entity, "Value", MolgenisFieldTypes.getType("decimal"));
			decimalValue_value_field.setNillable(false);
			decimalValue_entity.addField(decimalValue_value_field);
			Field decimalValue_id_field = new Field(decimalValue_entity, "id", MolgenisFieldTypes.getType("int"));
			decimalValue_id_field.setAuto(true);
			decimalValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			decimalValue_id_field.setNillable(false);
			decimalValue_entity.addField(decimalValue_id_field);
			decimalValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//EmailValue
			Entity emailValue_entity = new Entity("EmailValue",this.getDatabase());
			emailValue_entity.setSystem(false);
			emailValue_entity.setAbstract(false);
			emailValue_entity.setParents(new String[]{"Value"});
			emailValue_entity.setDescription("");
			emailValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field emailValue_value_field = new Field(emailValue_entity, "Value", MolgenisFieldTypes.getType("email"));
			emailValue_value_field.setNillable(false);
			emailValue_entity.addField(emailValue_value_field);
			Field emailValue_id_field = new Field(emailValue_entity, "id", MolgenisFieldTypes.getType("int"));
			emailValue_id_field.setAuto(true);
			emailValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			emailValue_id_field.setNillable(false);
			emailValue_entity.addField(emailValue_id_field);
			emailValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//HtmlValue
			Entity htmlValue_entity = new Entity("HtmlValue",this.getDatabase());
			htmlValue_entity.setSystem(false);
			htmlValue_entity.setAbstract(false);
			htmlValue_entity.setParents(new String[]{"Value"});
			htmlValue_entity.setDescription("");
			htmlValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field htmlValue_value_field = new Field(htmlValue_entity, "Value", MolgenisFieldTypes.getType("text"));
			htmlValue_value_field.setNillable(false);
			htmlValue_entity.addField(htmlValue_value_field);
			Field htmlValue_id_field = new Field(htmlValue_entity, "id", MolgenisFieldTypes.getType("int"));
			htmlValue_id_field.setAuto(true);
			htmlValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			htmlValue_id_field.setNillable(false);
			htmlValue_entity.addField(htmlValue_id_field);
			htmlValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//HyperlinkValue
			Entity hyperlinkValue_entity = new Entity("HyperlinkValue",this.getDatabase());
			hyperlinkValue_entity.setSystem(false);
			hyperlinkValue_entity.setAbstract(false);
			hyperlinkValue_entity.setParents(new String[]{"Value"});
			hyperlinkValue_entity.setDescription("");
			hyperlinkValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field hyperlinkValue_value_field = new Field(hyperlinkValue_entity, "Value", MolgenisFieldTypes.getType("hyperlink"));
			hyperlinkValue_value_field.setNillable(false);
			hyperlinkValue_entity.addField(hyperlinkValue_value_field);
			Field hyperlinkValue_id_field = new Field(hyperlinkValue_entity, "id", MolgenisFieldTypes.getType("int"));
			hyperlinkValue_id_field.setAuto(true);
			hyperlinkValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			hyperlinkValue_id_field.setNillable(false);
			hyperlinkValue_entity.addField(hyperlinkValue_id_field);
			hyperlinkValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//IntValue
			Entity intValue_entity = new Entity("IntValue",this.getDatabase());
			intValue_entity.setSystem(false);
			intValue_entity.setAbstract(false);
			intValue_entity.setParents(new String[]{"Value"});
			intValue_entity.setDescription("");
			intValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field intValue_value_field = new Field(intValue_entity, "Value", MolgenisFieldTypes.getType("int"));
			intValue_value_field.setNillable(false);
			intValue_entity.addField(intValue_value_field);
			Field intValue_id_field = new Field(intValue_entity, "id", MolgenisFieldTypes.getType("int"));
			intValue_id_field.setAuto(true);
			intValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			intValue_id_field.setNillable(false);
			intValue_entity.addField(intValue_id_field);
			intValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//LongValue
			Entity longValue_entity = new Entity("LongValue",this.getDatabase());
			longValue_entity.setSystem(false);
			longValue_entity.setAbstract(false);
			longValue_entity.setParents(new String[]{"Value"});
			longValue_entity.setDescription("");
			longValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field longValue_value_field = new Field(longValue_entity, "Value", MolgenisFieldTypes.getType("long"));
			longValue_value_field.setNillable(false);
			longValue_entity.addField(longValue_value_field);
			Field longValue_id_field = new Field(longValue_entity, "id", MolgenisFieldTypes.getType("int"));
			longValue_id_field.setAuto(true);
			longValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			longValue_id_field.setNillable(false);
			longValue_entity.addField(longValue_id_field);
			longValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//MrefValue
			Entity mrefValue_entity = new Entity("MrefValue",this.getDatabase());
			mrefValue_entity.setSystem(false);
			mrefValue_entity.setAbstract(false);
			mrefValue_entity.setParents(new String[]{"Value"});
			mrefValue_entity.setDescription("");
			mrefValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field mrefValue_value_field = new Field(mrefValue_entity, "Value", MolgenisFieldTypes.getType("mref"));
			mrefValue_value_field.setNillable(false);
			mrefValue_value_field.setXRefVariables("Characteristic", "id",Arrays.asList(new String[]{"Identifier"}));
			mrefValue_entity.addField(mrefValue_value_field);
			Field mrefValue_id_field = new Field(mrefValue_entity, "id", MolgenisFieldTypes.getType("int"));
			mrefValue_id_field.setAuto(true);
			mrefValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			mrefValue_id_field.setNillable(false);
			mrefValue_entity.addField(mrefValue_id_field);
			mrefValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//StringValue
			Entity stringValue_entity = new Entity("StringValue",this.getDatabase());
			stringValue_entity.setSystem(false);
			stringValue_entity.setAbstract(false);
			stringValue_entity.setParents(new String[]{"Value"});
			stringValue_entity.setDescription("");
			stringValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field stringValue_value_field = new Field(stringValue_entity, "Value", MolgenisFieldTypes.getType("string"));
			stringValue_value_field.setNillable(false);
			stringValue_entity.addField(stringValue_value_field);
			Field stringValue_id_field = new Field(stringValue_entity, "id", MolgenisFieldTypes.getType("int"));
			stringValue_id_field.setAuto(true);
			stringValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			stringValue_id_field.setNillable(false);
			stringValue_entity.addField(stringValue_id_field);
			stringValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//TextValue
			Entity textValue_entity = new Entity("TextValue",this.getDatabase());
			textValue_entity.setSystem(false);
			textValue_entity.setAbstract(false);
			textValue_entity.setParents(new String[]{"Value"});
			textValue_entity.setDescription("");
			textValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field textValue_value_field = new Field(textValue_entity, "Value", MolgenisFieldTypes.getType("text"));
			textValue_value_field.setNillable(false);
			textValue_entity.addField(textValue_value_field);
			Field textValue_id_field = new Field(textValue_entity, "id", MolgenisFieldTypes.getType("int"));
			textValue_id_field.setAuto(true);
			textValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			textValue_id_field.setNillable(false);
			textValue_entity.addField(textValue_id_field);
			textValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//XrefValue
			Entity xrefValue_entity = new Entity("XrefValue",this.getDatabase());
			xrefValue_entity.setSystem(false);
			xrefValue_entity.setAbstract(false);
			xrefValue_entity.setParents(new String[]{"Value"});
			xrefValue_entity.setDescription("");
			xrefValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field xrefValue_value_field = new Field(xrefValue_entity, "Value", MolgenisFieldTypes.getType("xref"));
			xrefValue_value_field.setNillable(false);
			xrefValue_value_field.setXRefVariables("Characteristic", "id",Arrays.asList(new String[]{"Identifier"}));
			xrefValue_entity.addField(xrefValue_value_field);
			Field xrefValue_id_field = new Field(xrefValue_entity, "id", MolgenisFieldTypes.getType("int"));
			xrefValue_id_field.setAuto(true);
			xrefValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			xrefValue_id_field.setNillable(false);
			xrefValue_entity.addField(xrefValue_id_field);
			xrefValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
			//ObservedValue
			Entity observedValue_entity = new Entity("ObservedValue",this.getDatabase());
			observedValue_entity.setSystem(false);
			observedValue_entity.setAbstract(false);
			observedValue_entity.setImplements(new String[]{"Autoid"});
			observedValue_entity.setDescription("\n\t\t\t\tGeneric storage of values as part of one observation\n\t\t\t\tevent. Values are atomatic observations,\n\t\t\t\te.g., length (feature) of\n\t\t\t\tindividual 1 (valueset.target) = 179cm (value).\n\t\t\t\tValues can also be\n\t\t\t\tqualified by some characteristic,\n\t\t\t\te.g., QTL p-value (feature) between\n\t\t\t\tphenotype 'leaf count'\n\t\t\t\t(characteristic) and marker 'PVV4'\n\t\t\t\t(valueset.target) = 0.1^10+3 (value).\n\t\t\t");
			observedValue_entity.setXrefLabels(Arrays.asList(new String[]{"id"}));
			Field observedValue_observationSet_field = new Field(observedValue_entity, "ObservationSet", MolgenisFieldTypes.getType("xref"));
			observedValue_observationSet_field.setDescription("Reference to the observation. For example a particular patient visit or the application of a microarray or the calculation of a QTL model");
			observedValue_observationSet_field.setNillable(false);
			observedValue_observationSet_field.setXRefVariables("ObservationSet", "id",Arrays.asList(new String[]{"Identifier"}));
			observedValue_entity.addField(observedValue_observationSet_field);
			Field observedValue_feature_field = new Field(observedValue_entity, "Feature", MolgenisFieldTypes.getType("xref"));
			observedValue_feature_field.setDescription("References the ObservableFeature that this observation was made on. For example 'probe123'.");
			observedValue_feature_field.setNillable(false);
			observedValue_feature_field.setXRefVariables("ObservableFeature", "id",Arrays.asList(new String[]{"Identifier"}));
			observedValue_entity.addField(observedValue_feature_field);
			Field observedValue_value_field = new Field(observedValue_entity, "Value", MolgenisFieldTypes.getType("xref"));
			observedValue_value_field.setDescription("The value observed");
			observedValue_value_field.setNillable(true);
			observedValue_value_field.setXRefVariables("Value", "id",Arrays.asList(new String[]{"id"}));
			observedValue_entity.addField(observedValue_value_field);
			Field observedValue_id_field = new Field(observedValue_entity, "id", MolgenisFieldTypes.getType("int"));
			observedValue_id_field.setAuto(true);
			observedValue_id_field.setDescription("automatically generated internal id, only for internal use.");
			observedValue_id_field.setNillable(false);
			observedValue_entity.addField(observedValue_id_field);
			observedValue_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			
		} catch (MolgenisModelException e)
		{
			throw new RuntimeException(e);
		}
	}
}