
/* File:        org.molgenis.omx/model/Protocol.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.observ;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.Entity;

/**
 * Protocol: 
				The Protocol class defines parameterizable descriptions
				of
				(analysis)methods. Examples of protocols are: Questionaires, SOPs,
				Assay platforms, Statistical analyses, etc.
				Each protocol has a
				unique identifier.
				Protocol has an association to OntologyTerm to
				represent the type of protocol.
			.
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "Protocol"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")
public class Protocol extends org.molgenis.omx.observ.Characteristic implements org.molgenis.data.Entity
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "Protocol";
    
	// fieldname constants
	public final static String PROTOCOLTYPE = "ProtocolType";
	public final static String SUBPROTOCOLS = "subprotocols";
	public final static String FEATURES = "Features";
	public final static String REQUIREDFEATURES = "RequiredFeatures";
	public final static String ROOT = "root";
	public final static String ACTIVE = "active";
	public final static String ID = "id";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//classification of protocol[type=xref]

    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProtocolType")  
	
				

	private org.molgenis.omx.observ.target.OntologyTerm protocolType = null;

	//Subprotocols of this protocol[type=mref]

	@javax.persistence.OrderColumn 	
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="subprotocols", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Protocol_subprotocols", 
			joinColumns=@javax.persistence.JoinColumn(name="Protocol"), inverseJoinColumns=@javax.persistence.JoinColumn(name="subprotocols"))
	
				

	private java.util.List<org.molgenis.omx.observ.Protocol> subprotocols = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>();

	//parameters (in/out) that are used or produced by this protocol.[type=mref]

	@javax.persistence.OrderColumn 	
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Features", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Protocol_Features", 
			joinColumns=@javax.persistence.JoinColumn(name="Protocol"), inverseJoinColumns=@javax.persistence.JoinColumn(name="Features"))
	
				

	private java.util.List<org.molgenis.omx.observ.ObservableFeature> features = new java.util.ArrayList<org.molgenis.omx.observ.ObservableFeature>();

	//..........[type=mref]

	@javax.persistence.OrderColumn 	
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="RequiredFeatures", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Protocol_RequiredFeatures", 
			joinColumns=@javax.persistence.JoinColumn(name="Protocol"), inverseJoinColumns=@javax.persistence.JoinColumn(name="RequiredFeatures"))
	
				

	private java.util.List<org.molgenis.omx.observ.ObservableFeature> requiredFeatures = new java.util.ArrayList<org.molgenis.omx.observ.ObservableFeature>();

	//Indicator whether this protocol defines a workflow (e.g is the first protocol of a workflow).[type=bool]

	@javax.persistence.Column(name="root", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="root")
	
				

	@javax.validation.constraints.NotNull
	private Boolean root =  false;

	//whether this protocol is considered active/inactive[type=bool]

	@javax.persistence.Column(name="active", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="active")
	
				

	@javax.validation.constraints.NotNull
	private Boolean active =  true;

	//automatically generated internal id, only for internal use.[type=int]

	

	//constructors
	public Protocol()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	//getters and setters
	/**
	 * Get the classification of protocol.
	 * @return protocolType.
	 */
	public org.molgenis.omx.observ.target.OntologyTerm getProtocolType()
	{
		return this.protocolType;
	}	
	
	/**
	 * Set the classification of protocol.
	 * @param protocolType
	 */
	public void setProtocolType( org.molgenis.omx.observ.target.OntologyTerm protocolType)
	{
		
		this.protocolType = protocolType;
	}

	

	/**
	 * Get the Subprotocols of this protocol.
	 * @return subprotocols.
	 */
	public java.util.List<org.molgenis.omx.observ.Protocol> getSubprotocols()
	{
		return this.subprotocols;
	}	
	
	/**
	 * Set the Subprotocols of this protocol.
	 * @param subprotocols
	 */
	public void setSubprotocols( java.util.List<org.molgenis.omx.observ.Protocol> subprotocols)
	{
		
		this.subprotocols = subprotocols;
	}

	

	/**
	 * Get the parameters (in/out) that are used or produced by this protocol..
	 * @return features.
	 */
	public java.util.List<org.molgenis.omx.observ.ObservableFeature> getFeatures()
	{
		return this.features;
	}	
	
	/**
	 * Set the parameters (in/out) that are used or produced by this protocol..
	 * @param features
	 */
	public void setFeatures( java.util.List<org.molgenis.omx.observ.ObservableFeature> features)
	{
		
		this.features = features;
	}

	

	/**
	 * Get the ...........
	 * @return requiredFeatures.
	 */
	public java.util.List<org.molgenis.omx.observ.ObservableFeature> getRequiredFeatures()
	{
		return this.requiredFeatures;
	}	
	
	/**
	 * Set the ...........
	 * @param requiredFeatures
	 */
	public void setRequiredFeatures( java.util.List<org.molgenis.omx.observ.ObservableFeature> requiredFeatures)
	{
		
		this.requiredFeatures = requiredFeatures;
	}

	

	/**
	 * Get the Indicator whether this protocol defines a workflow (e.g is the first protocol of a workflow)..
	 * @return root.
	 */
	public Boolean getRoot()
	{
		return this.root;
	}	
	
	/**
	 * Set the Indicator whether this protocol defines a workflow (e.g is the first protocol of a workflow)..
	 * @param root
	 */
	public void setRoot( Boolean root)
	{
		
		this.root = root;
	}

	

	/**
	 * Get the whether this protocol is considered active/inactive.
	 * @return active.
	 */
	public Boolean getActive()
	{
		return this.active;
	}	
	
	/**
	 * Set the whether this protocol is considered active/inactive.
	 * @param active
	 */
	public void setActive( Boolean active)
	{
		
		this.active = active;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();			
		if (name.equals("description"))
			return getDescription();
		if (name.equals("protocoltype"))
			return getProtocolType();
		if (name.equals("subprotocols"))
			return getSubprotocols();
		if (name.equals("features"))
			return getFeatures();
		if (name.equals("requiredfeatures"))
			return getRequiredFeatures();
		if (name.equals("root"))
			return getRoot();
		if (name.equals("active"))
			return getActive();
		return null;
	}	
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("protocol_id") != null) this.setId(entity.getInt("protocol_id"));
		else if( entity.getInt("Protocol_id") != null) this.setId(entity.getInt("Protocol_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("protocol_identifier") != null) this.setIdentifier(entity.getString("protocol_identifier"));
		else if( entity.getString("Protocol_Identifier") != null) this.setIdentifier(entity.getString("Protocol_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("protocol_name") != null) this.setName(entity.getString("protocol_name"));
		else if( entity.getString("Protocol_Name") != null) this.setName(entity.getString("Protocol_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("protocol___type") != null) this.set__Type(entity.getString("protocol___type"));
		else if( entity.getString("Protocol___Type") != null) this.set__Type(entity.getString("Protocol___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("protocol_description") != null) this.setDescription(entity.getString("protocol_description"));
		else if( entity.getString("Protocol_description") != null) this.setDescription(entity.getString("Protocol_description"));
		//set ProtocolType
		// query formal name, else lowercase name
		if( entity.getEntity("ProtocolType", org.molgenis.omx.observ.target.OntologyTerm.class) != null) { 
			this.setProtocolType(entity.getEntity("ProtocolType", org.molgenis.omx.observ.target.OntologyTerm.class));				
		}
		else if( entity.getEntity("protocoltype", org.molgenis.omx.observ.target.OntologyTerm.class) != null) { 
			this.setProtocolType(entity.getEntity("protocoltype", org.molgenis.omx.observ.target.OntologyTerm.class));				
		}
		else if( entity.getEntity("Protocol_ProtocolType", org.molgenis.omx.observ.target.OntologyTerm.class) != null) { 
			this.setProtocolType(entity.getEntity("Protocol_ProtocolType", org.molgenis.omx.observ.target.OntologyTerm.class));				
		}
		else if( entity.getEntity("protocol_protocoltype", org.molgenis.omx.observ.target.OntologyTerm.class) != null) { 
			this.setProtocolType(entity.getEntity("Protocol_ProtocolType", org.molgenis.omx.observ.target.OntologyTerm.class));				
		}
		//set Subprotocols
		if( entity.getEntities("subprotocols", org.molgenis.omx.observ.Protocol.class) != null || entity.getEntities("subprotocols", org.molgenis.omx.observ.Protocol.class) != null ) 
		{
			java.lang.Iterable<org.molgenis.omx.observ.Protocol> mrefs = entity.getEntities("subprotocols", org.molgenis.omx.observ.Protocol.class);
			if(mrefs == null) mrefs = entity.getEntities("subprotocols", org.molgenis.omx.observ.Protocol.class);
			if(entity.getEntities("protocol_subprotocols", org.molgenis.omx.observ.Protocol.class)!= null) mrefs = entity.getEntities("protocol_subprotocols", org.molgenis.omx.observ.Protocol.class);
			else if(entity.getEntities("Protocol_subprotocols", org.molgenis.omx.observ.Protocol.class)!= null) mrefs = entity.getEntities("Protocol_subprotocols", org.molgenis.omx.observ.Protocol.class);									
			this.setSubprotocols(mrefs != null ? com.google.common.collect.Lists.newArrayList(mrefs) : null);
		}				
		//set Features
		if( entity.getEntities("Features", org.molgenis.omx.observ.ObservableFeature.class) != null || entity.getEntities("features", org.molgenis.omx.observ.ObservableFeature.class) != null ) 
		{
			java.lang.Iterable<org.molgenis.omx.observ.ObservableFeature> mrefs = entity.getEntities("Features", org.molgenis.omx.observ.ObservableFeature.class);
			if(mrefs == null) mrefs = entity.getEntities("features", org.molgenis.omx.observ.ObservableFeature.class);
			if(entity.getEntities("protocol_features", org.molgenis.omx.observ.ObservableFeature.class)!= null) mrefs = entity.getEntities("protocol_features", org.molgenis.omx.observ.ObservableFeature.class);
			else if(entity.getEntities("Protocol_Features", org.molgenis.omx.observ.ObservableFeature.class)!= null) mrefs = entity.getEntities("Protocol_Features", org.molgenis.omx.observ.ObservableFeature.class);									
			this.setFeatures(mrefs != null ? com.google.common.collect.Lists.newArrayList(mrefs) : null);
		}				
		//set RequiredFeatures
		if( entity.getEntities("RequiredFeatures", org.molgenis.omx.observ.ObservableFeature.class) != null || entity.getEntities("requiredfeatures", org.molgenis.omx.observ.ObservableFeature.class) != null ) 
		{
			java.lang.Iterable<org.molgenis.omx.observ.ObservableFeature> mrefs = entity.getEntities("RequiredFeatures", org.molgenis.omx.observ.ObservableFeature.class);
			if(mrefs == null) mrefs = entity.getEntities("requiredfeatures", org.molgenis.omx.observ.ObservableFeature.class);
			if(entity.getEntities("protocol_requiredfeatures", org.molgenis.omx.observ.ObservableFeature.class)!= null) mrefs = entity.getEntities("protocol_requiredfeatures", org.molgenis.omx.observ.ObservableFeature.class);
			else if(entity.getEntities("Protocol_RequiredFeatures", org.molgenis.omx.observ.ObservableFeature.class)!= null) mrefs = entity.getEntities("Protocol_RequiredFeatures", org.molgenis.omx.observ.ObservableFeature.class);									
			this.setRequiredFeatures(mrefs != null ? com.google.common.collect.Lists.newArrayList(mrefs) : null);
		}				
		//set Root
		// query formal name, else lowercase name
		if(entity.getBoolean("root") != null) this.setRoot(entity.getBoolean("root"));
		else if(entity.getBoolean("root") != null) this.setRoot(entity.getBoolean("root"));
		else if(strict) this.setRoot(entity.getBoolean("root")); // setting null is not an option due to function overloading
		if( entity.getBoolean("protocol_root") != null) this.setRoot(entity.getBoolean("protocol_root"));
		else if( entity.getBoolean("Protocol_root") != null) this.setRoot(entity.getBoolean("Protocol_root"));
		//set Active
		// query formal name, else lowercase name
		if(entity.getBoolean("active") != null) this.setActive(entity.getBoolean("active"));
		else if(entity.getBoolean("active") != null) this.setActive(entity.getBoolean("active"));
		else if(strict) this.setActive(entity.getBoolean("active")); // setting null is not an option due to function overloading
		if( entity.getBoolean("protocol_active") != null) this.setActive(entity.getBoolean("protocol_active"));
		else if( entity.getBoolean("Protocol_active") != null) this.setActive(entity.getBoolean("Protocol_active"));
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("Protocol(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("name='" + getName()+"' ");	
		sb.append("__Type='" + get__Type()+"' ");	
		sb.append("description='" + getDescription()+"' ");	
		sb.append("protocolType='" + getProtocolType()+"' ");	
		sb.append("subprotocols='" + getSubprotocols()+"' ");	
		sb.append("features='" + getFeatures()+"' ");	
		sb.append("requiredFeatures='" + getRequiredFeatures()+"' ");	
		sb.append("root='" + getRoot()+"' ");	
		sb.append("active='" + getActive()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public Integer getIdValue()
	{
		return getId();
	}		
	
	//6
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="subprotocols"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.observ.Protocol> subprotocolsProtocolCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.observ.Protocol> getSubprotocolsProtocolCollection()
	{
		if(subprotocolsProtocolCollection == null) subprotocolsProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>(); 
        return subprotocolsProtocolCollection;
	}


    public void setSubprotocolsProtocolCollection(java.util.Collection<org.molgenis.omx.observ.Protocol> collection)
    {
		if(subprotocolsProtocolCollection == null) subprotocolsProtocolCollection = new java.util.ArrayList<org.molgenis.omx.observ.Protocol>();
    	subprotocolsProtocolCollection.addAll(collection);
    }	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new ProtocolMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}
	
	@Override
	public java.util.List<String> getLabelAttributeNames()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		if("id".equalsIgnoreCase(attributeName)) {
			this.setId((Integer)value); 
			return;
		}
		if("Identifier".equalsIgnoreCase(attributeName)) {
			this.setIdentifier((String)value); 
			return;
		}
		if("Name".equalsIgnoreCase(attributeName)) {
			this.setName((String)value); 
			return;
		}
		if("__Type".equalsIgnoreCase(attributeName)) {
			this.set__Type((String)value); 
			return;
		}
		if("description".equalsIgnoreCase(attributeName)) {
			this.setDescription((String)value); 
			return;
		}
		if("ProtocolType".equalsIgnoreCase(attributeName)) {
			org.molgenis.omx.observ.target.OntologyTerm e = new org.molgenis.omx.observ.target.OntologyTerm();
			e.set((Entity)value);
			this.setProtocolType(e); 
			return;
		}
		if("subprotocols".equalsIgnoreCase(attributeName)) {
			this.setSubprotocols((List<org.molgenis.omx.observ.Protocol>)value); 
			return;
		}
		if("Features".equalsIgnoreCase(attributeName)) {
			this.setFeatures((List<org.molgenis.omx.observ.ObservableFeature>)value); 
			return;
		}
		if("RequiredFeatures".equalsIgnoreCase(attributeName)) {
			this.setRequiredFeatures((List<org.molgenis.omx.observ.ObservableFeature>)value); 
			return;
		}
		if("root".equalsIgnoreCase(attributeName)) {
			this.setRoot((Boolean)value); 
			return;
		}
		if("active".equalsIgnoreCase(attributeName)) {
			this.setActive((Boolean)value); 
			return;
		}
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new ProtocolMetaData();
	}
}
