
/* File:        org.molgenis.omx/model/Gene.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

/**
 * Gene:  Trait annotations specific for genes..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Gene"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.xgap.db.GeneEntityListener.class})
public class Gene extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.omx.xgap.Locus
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String CHROMOSOME = "Chromosome";
	public final static String CHROMOSOME_IDENTIFIER = "Chromosome_Identifier";
	public final static String CM = "cM";
	public final static String BPSTART = "bpStart";
	public final static String BPEND = "bpEnd";
	public final static String SEQ = "Seq";
	public final static String SYMBOL = "Symbol";
	public final static String ORIENTATION = "Orientation";
	public final static String CONTROL = "Control";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(Gene.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Gene> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Gene.class);
	}
	
	/**
	 * Shorthand for db.find(Gene.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Gene> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Gene.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Gene findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Gene> q = db.query(Gene.class);
		q = q.eq(Gene.ID, id);
		java.util.List<Gene> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Gene findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Gene> q = db.query(Gene.class);
		q = q.eq(Gene.IDENTIFIER, identifier);
		java.util.List<Gene> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//Reference to the chromosome this     position belongs to.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Chromosome")   	
	
				

	private org.molgenis.omx.xgap.Chromosome chromosome = null;
	@javax.persistence.Transient
	private Integer chromosome_id = null;	
	@javax.persistence.Transient
	private String chromosome_Identifier = null;						

	//genetic map position in centi morgan (cM).[type=decimal]
	@javax.persistence.Column(name="cM")
	@javax.xml.bind.annotation.XmlElement(name="cM")
	
				

	private Double cM =  null;

	//numeric basepair postion (5') on the chromosome[type=long]
	@javax.persistence.Column(name="bpStart")
	@javax.xml.bind.annotation.XmlElement(name="bpStart")
	
				

	private Long bpStart =  null;

	//numeric basepair postion (3') on the chromosome[type=long]
	@javax.persistence.Column(name="bpEnd")
	@javax.xml.bind.annotation.XmlElement(name="bpEnd")
	
				

	private Long bpEnd =  null;

	//The FASTA text representation of the sequence.[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="Seq")
	
				

	private String seq =  null;

	//Main symbol this gene is known by (not necessarily unique, in constrast to 'name')[type=string]
	@javax.persistence.Column(name="Symbol", length=255)
	@javax.xml.bind.annotation.XmlElement(name="symbol")
	
				

	private String symbol =  null;

	//Orientation of the gene on the genome (F=forward, R=reverse)[type=enum]
	@javax.persistence.Column(name="Orientation")
	@javax.xml.bind.annotation.XmlElement(name="orientation")
	
				

	private String orientation =  null;
	@javax.persistence.Transient
	private String orientation_label = null;
	@javax.persistence.Transient
	private static final java.util.List<org.molgenis.util.ValueLabel> orientation_options;
	
	static {
		orientation_options = new java.util.ArrayList<org.molgenis.util.ValueLabel>();
		orientation_options.add(new org.molgenis.util.ValueLabel("F","F"));
		orientation_options.add(new org.molgenis.util.ValueLabel("R","R"));
	}

	//Indicating whether this is a 'housekeeping' gene that can be used as control.[type=bool]
	@javax.persistence.Column(name="Control")
	@javax.xml.bind.annotation.XmlElement(name="control")
	
				

	private Boolean control =  null;

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public Gene()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public Gene(Gene copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the Reference to the chromosome this     position belongs to..
	 * @return chromosome.
	 */
	public org.molgenis.omx.xgap.Chromosome getChromosome()
	{
		return this.chromosome;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Chromosome getChromosome(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Reference to the chromosome this     position belongs to..
	 * @param chromosome
	 */
	public void setChromosome( org.molgenis.omx.xgap.Chromosome chromosome)
	{
		
		this.chromosome = chromosome;
	}

	
	
	/**
	 * Set foreign key for field chromosome.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setChromosome_Id(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}	

	public void setChromosome(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}
	
	public Integer getChromosome_Id()
	{
		
		if(chromosome != null) 
		{
			return chromosome.getId();
		}
		else
		{
			return chromosome_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Chromosome to Chromosome.Id.
	 */
	public String getChromosome_Identifier()
	{		
		//FIXME should we auto-load based on getChromosome()?	
		if(chromosome != null) {
			return chromosome.getIdentifier();
		} else {
			return chromosome_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Chromosome to <a href="Chromosome.html#Id">Chromosome.Id</a>.
	 * Implies setChromosome(null) until save
	 */
	public void setChromosome_Identifier(String chromosome_Identifier)
	{
		this.chromosome_Identifier = chromosome_Identifier;
	}		
	 
	

	/**
	 * Get the genetic map position in centi morgan (cM)..
	 * @return cM.
	 */
	public Double getCM()
	{
		return this.cM;
	}
	
	@Deprecated
	public Double getCM(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the genetic map position in centi morgan (cM)..
	 * @param cM
	 */
	public void setCM( Double cM)
	{
		
		this.cM = cM;
	}

	

	/**
	 * Get the numeric basepair postion (5') on the chromosome.
	 * @return bpStart.
	 */
	public Long getBpStart()
	{
		return this.bpStart;
	}
	
	@Deprecated
	public Long getBpStart(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (5') on the chromosome.
	 * @param bpStart
	 */
	public void setBpStart( Long bpStart)
	{
		
		this.bpStart = bpStart;
	}

	

	/**
	 * Get the numeric basepair postion (3') on the chromosome.
	 * @return bpEnd.
	 */
	public Long getBpEnd()
	{
		return this.bpEnd;
	}
	
	@Deprecated
	public Long getBpEnd(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (3') on the chromosome.
	 * @param bpEnd
	 */
	public void setBpEnd( Long bpEnd)
	{
		
		this.bpEnd = bpEnd;
	}

	

	/**
	 * Get the The FASTA text representation of the sequence..
	 * @return seq.
	 */
	public String getSeq()
	{
		return this.seq;
	}
	
	@Deprecated
	public String getSeq(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The FASTA text representation of the sequence..
	 * @param seq
	 */
	public void setSeq( String seq)
	{
		
		this.seq = seq;
	}

	

	/**
	 * Get the Main symbol this gene is known by (not necessarily unique, in constrast to 'name').
	 * @return symbol.
	 */
	public String getSymbol()
	{
		return this.symbol;
	}
	
	@Deprecated
	public String getSymbol(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Main symbol this gene is known by (not necessarily unique, in constrast to 'name').
	 * @param symbol
	 */
	public void setSymbol( String symbol)
	{
		
		this.symbol = symbol;
	}

	

	/**
	 * Get the Orientation of the gene on the genome (F=forward, R=reverse).
	 * @return orientation.
	 */
	public String getOrientation()
	{
		return this.orientation;
	}
	
	@Deprecated
	public String getOrientation(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Orientation of the gene on the genome (F=forward, R=reverse).
	 * @param orientation
	 */
	public void setOrientation( String orientation)
	{
		
		this.orientation = orientation;
	}

	
	/**
	 * Get tha label for enum Orientation.
	 */
	public String getOrientationLabel()
	{
		return this.orientation_label;
	}
	/**
	 * Orientation is enum. This method returns all available enum options.
	 */
	public java.util.List<org.molgenis.util.ValueLabel> getOrientationOptions()
	{
		return orientation_options;
	}	
	

	/**
	 * Get the Indicating whether this is a 'housekeeping' gene that can be used as control..
	 * @return control.
	 */
	public Boolean getControl()
	{
		return this.control;
	}
	
	@Deprecated
	public Boolean getControl(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Indicating whether this is a 'housekeeping' gene that can be used as control..
	 * @param control
	 */
	public void setControl( Boolean control)
	{
		
		this.control = control;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if(name.equals("chromosome_id"))
			return getChromosome_Id();
		if(name.equals("chromosome_identifier"))
			return getChromosome_Identifier();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		if (name.equals("orientation"))
			return getOrientation();
		if(name.equals("orientation_label"))
			return getOrientationLabel();
		if (name.equals("control"))
			return getControl();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("gene_id") != null) this.setId(entity.getInt("gene_id"));
		else if( entity.getInt("Gene_id") != null) this.setId(entity.getInt("Gene_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("gene_identifier") != null) this.setIdentifier(entity.getString("gene_identifier"));
		else if( entity.getString("Gene_Identifier") != null) this.setIdentifier(entity.getString("Gene_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("gene_name") != null) this.setName(entity.getString("gene_name"));
		else if( entity.getString("Gene_Name") != null) this.setName(entity.getString("Gene_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("gene___type") != null) this.set__Type(entity.getString("gene___type"));
		else if( entity.getString("Gene___Type") != null) this.set__Type(entity.getString("Gene___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("gene_description") != null) this.setDescription(entity.getString("gene_description"));
		else if( entity.getString("Gene_description") != null) this.setDescription(entity.getString("Gene_description"));
		//set Chromosome
		// query formal name, else lowercase name
		if(entity.getInt("Chromosome_id") != null) this.setChromosome(entity.getInt("Chromosome_id"));
		else if(entity.getInt("chromosome_id") != null) this.setChromosome(entity.getInt("chromosome_id"));
		else if(strict) this.setChromosome(entity.getInt("Chromosome_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Gene_Chromosome_id") != null) this.setChromosome(entity.getInt("Gene_Chromosome_id"));
		else if( entity.getInt("gene_chromosome_id") != null) this.setChromosome(entity.getInt("gene_chromosome_id"));
		//alias of xref
		if( entity.get("Chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome")); 
			}
		}
		else if( entity.get("chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome"));
			}
		}
		if( entity.get("Gene_Chromosome") != null)
			this.setChromosome_Id(entity.getInt("Gene_Chromosome"));			
		else if( entity.get("gene_chromosome") != null)
			this.setChromosome_Id(entity.getInt("gene_chromosome"));
			
		if( entity.get("Gene.Chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Gene.Chromosome_id"));
		else if( entity.get("gene.chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("gene.chromosome_id"));	
		//set label for field Chromosome
		if(entity.get("Chromosome_Identifier") != null) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier"));
		else if(entity.get("chromosome_identifier") != null) this.setChromosome_Identifier(entity.getString("chromosome_identifier"));
		else if(strict) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Gene_Chromosome_Identifier") != null ) this.setChromosome_Identifier(entity.getString("Gene_Chromosome_Identifier"));		
		else if( entity.get("gene_chromosome_identifier") != null ) this.setChromosome_Identifier(entity.getString("gene_chromosome_identifier"));
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("gene_cm") != null) this.setCM(entity.getDouble("gene_cm"));
		else if( entity.getDouble("Gene_cM") != null) this.setCM(entity.getDouble("Gene_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("gene_bpstart") != null) this.setBpStart(entity.getLong("gene_bpstart"));
		else if( entity.getLong("Gene_bpStart") != null) this.setBpStart(entity.getLong("Gene_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("gene_bpend") != null) this.setBpEnd(entity.getLong("gene_bpend"));
		else if( entity.getLong("Gene_bpEnd") != null) this.setBpEnd(entity.getLong("Gene_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("gene_seq") != null) this.setSeq(entity.getString("gene_seq"));
		else if( entity.getString("Gene_Seq") != null) this.setSeq(entity.getString("Gene_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("gene_symbol") != null) this.setSymbol(entity.getString("gene_symbol"));
		else if( entity.getString("Gene_Symbol") != null) this.setSymbol(entity.getString("Gene_Symbol"));
		//set Orientation
		// query formal name, else lowercase name
		if(entity.getString("orientation") != null) this.setOrientation(entity.getString("orientation"));
		else if(entity.getString("Orientation") != null) this.setOrientation(entity.getString("Orientation"));
		else if(strict) this.setOrientation(entity.getString("orientation")); // setting null is not an option due to function overloading
		if( entity.getString("gene_orientation") != null) this.setOrientation(entity.getString("gene_orientation"));
		else if( entity.getString("Gene_Orientation") != null) this.setOrientation(entity.getString("Gene_Orientation"));
		//set Control
		// query formal name, else lowercase name
		if(entity.getBoolean("control") != null) this.setControl(entity.getBoolean("control"));
		else if(entity.getBoolean("Control") != null) this.setControl(entity.getBoolean("Control"));
		else if(strict) this.setControl(entity.getBoolean("control")); // setting null is not an option due to function overloading
		if( entity.getBoolean("gene_control") != null) this.setControl(entity.getBoolean("gene_control"));
		else if( entity.getBoolean("Gene_Control") != null) this.setControl(entity.getBoolean("Gene_Control"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Gene(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " chromosome_id='" + getChromosome_Id()+"' ";	
		result+= " chromosome_identifier='" + getChromosome_Identifier()+"' ";
		result+= "cM='" + getCM()+"' ";	
		result+= "bpStart='" + getBpStart()+"' ";	
		result+= "bpEnd='" + getBpEnd()+"' ";	
		result+= "seq='" + getSeq()+"' ";	
		result+= "symbol='" + getSymbol()+"' ";	
		result+= "orientation='" + getOrientation()+"' ";	
		result+= "control='" + getControl()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Gene.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("Chromosome_id");
		}
		fields.add("Chromosome_Identifier");
		{
			fields.add("cM");
		}
		{
			fields.add("bpStart");
		}
		{
			fields.add("bpEnd");
		}
		{
			fields.add("Seq");
		}
		{
			fields.add("Symbol");
		}
		{
			fields.add("Orientation");
		}
		{
			fields.add("Control");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "chromosome" +sep
		+ "cM" +sep
		+ "bpStart" +sep
		+ "bpEnd" +sep
		+ "seq" +sep
		+ "symbol" +sep
		+ "orientation" +sep
		+ "control" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("chromosome")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getChromosome();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCM();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpStart();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpEnd();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSeq();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSymbol();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getOrientation();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getControl();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Gene create(org.molgenis.data.Entity entity) throws Exception
	{
		Gene e = new Gene();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
