
/* File:        org.molgenis.omx/model/Marker.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

/**
 * Marker:  Trait annotations specific for markers..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Marker"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.xgap.db.MarkerEntityListener.class})
public class Marker extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.omx.xgap.Locus
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String CHROMOSOME = "Chromosome";
	public final static String CHROMOSOME_IDENTIFIER = "Chromosome_Identifier";
	public final static String CM = "cM";
	public final static String BPSTART = "bpStart";
	public final static String BPEND = "bpEnd";
	public final static String SEQ = "Seq";
	public final static String SYMBOL = "Symbol";
	public final static String REPORTSFOR = "ReportsFor";
	public final static String REPORTSFOR_IDENTIFIER = "ReportsFor_Identifier";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(Marker.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Marker> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Marker.class);
	}
	
	/**
	 * Shorthand for db.find(Marker.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Marker> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Marker.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Marker findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Marker> q = db.query(Marker.class);
		q = q.eq(Marker.ID, id);
		java.util.List<Marker> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Marker findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Marker> q = db.query(Marker.class);
		q = q.eq(Marker.IDENTIFIER, identifier);
		java.util.List<Marker> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//Reference to the chromosome this     position belongs to.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Chromosome")   	
	
				

	private org.molgenis.omx.xgap.Chromosome chromosome = null;
	@javax.persistence.Transient
	private Integer chromosome_id = null;	
	@javax.persistence.Transient
	private String chromosome_Identifier = null;						

	//genetic map position in centi morgan (cM).[type=decimal]
	@javax.persistence.Column(name="cM")
	@javax.xml.bind.annotation.XmlElement(name="cM")
	
				

	private Double cM =  null;

	//numeric basepair postion (5') on the chromosome[type=long]
	@javax.persistence.Column(name="bpStart")
	@javax.xml.bind.annotation.XmlElement(name="bpStart")
	
				

	private Long bpStart =  null;

	//numeric basepair postion (3') on the chromosome[type=long]
	@javax.persistence.Column(name="bpEnd")
	@javax.xml.bind.annotation.XmlElement(name="bpEnd")
	
				

	private Long bpEnd =  null;

	//The FASTA text representation of the sequence.[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="Seq")
	
				

	private String seq =  null;

	//todo[type=string]
	@javax.persistence.Column(name="Symbol", length=255)
	@javax.xml.bind.annotation.XmlElement(name="symbol")
	
				

	private String symbol =  null;

	//The marker (or a subclass like 'SNP') this marker (or a subclass like 'SNP') reports for.[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ReportsFor", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="Marker_ReportsFor", 
			joinColumns=@javax.persistence.JoinColumn(name="Marker"), inverseJoinColumns=@javax.persistence.JoinColumn(name="ReportsFor"))
	
				

	private java.util.List<org.molgenis.omx.xgap.Marker> reportsFor = new java.util.ArrayList<org.molgenis.omx.xgap.Marker>();
	@javax.persistence.Transient
	private java.util.List<Integer> reportsFor_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> reportsFor_Identifier = new java.util.ArrayList<String>();

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public Marker()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public Marker(Marker copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the Reference to the chromosome this     position belongs to..
	 * @return chromosome.
	 */
	public org.molgenis.omx.xgap.Chromosome getChromosome()
	{
		return this.chromosome;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Chromosome getChromosome(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Reference to the chromosome this     position belongs to..
	 * @param chromosome
	 */
	public void setChromosome( org.molgenis.omx.xgap.Chromosome chromosome)
	{
		
		this.chromosome = chromosome;
	}

	
	
	/**
	 * Set foreign key for field chromosome.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setChromosome_Id(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}	

	public void setChromosome(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}
	
	public Integer getChromosome_Id()
	{
		
		if(chromosome != null) 
		{
			return chromosome.getId();
		}
		else
		{
			return chromosome_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Chromosome to Chromosome.Id.
	 */
	public String getChromosome_Identifier()
	{		
		//FIXME should we auto-load based on getChromosome()?	
		if(chromosome != null) {
			return chromosome.getIdentifier();
		} else {
			return chromosome_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Chromosome to <a href="Chromosome.html#Id">Chromosome.Id</a>.
	 * Implies setChromosome(null) until save
	 */
	public void setChromosome_Identifier(String chromosome_Identifier)
	{
		this.chromosome_Identifier = chromosome_Identifier;
	}		
	 
	

	/**
	 * Get the genetic map position in centi morgan (cM)..
	 * @return cM.
	 */
	public Double getCM()
	{
		return this.cM;
	}
	
	@Deprecated
	public Double getCM(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the genetic map position in centi morgan (cM)..
	 * @param cM
	 */
	public void setCM( Double cM)
	{
		
		this.cM = cM;
	}

	

	/**
	 * Get the numeric basepair postion (5') on the chromosome.
	 * @return bpStart.
	 */
	public Long getBpStart()
	{
		return this.bpStart;
	}
	
	@Deprecated
	public Long getBpStart(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (5') on the chromosome.
	 * @param bpStart
	 */
	public void setBpStart( Long bpStart)
	{
		
		this.bpStart = bpStart;
	}

	

	/**
	 * Get the numeric basepair postion (3') on the chromosome.
	 * @return bpEnd.
	 */
	public Long getBpEnd()
	{
		return this.bpEnd;
	}
	
	@Deprecated
	public Long getBpEnd(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (3') on the chromosome.
	 * @param bpEnd
	 */
	public void setBpEnd( Long bpEnd)
	{
		
		this.bpEnd = bpEnd;
	}

	

	/**
	 * Get the The FASTA text representation of the sequence..
	 * @return seq.
	 */
	public String getSeq()
	{
		return this.seq;
	}
	
	@Deprecated
	public String getSeq(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The FASTA text representation of the sequence..
	 * @param seq
	 */
	public void setSeq( String seq)
	{
		
		this.seq = seq;
	}

	

	/**
	 * Get the todo.
	 * @return symbol.
	 */
	public String getSymbol()
	{
		return this.symbol;
	}
	
	@Deprecated
	public String getSymbol(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the todo.
	 * @param symbol
	 */
	public void setSymbol( String symbol)
	{
		
		this.symbol = symbol;
	}

	

	/**
	 * Get the The marker (or a subclass like 'SNP') this marker (or a subclass like 'SNP') reports for..
	 * @return reportsFor.
	 */
	public java.util.List<org.molgenis.omx.xgap.Marker> getReportsFor()
	{
		return this.reportsFor;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.xgap.Marker> getReportsFor(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The marker (or a subclass like 'SNP') this marker (or a subclass like 'SNP') reports for..
	 * @param reportsFor
	 */
	public void setReportsFor( java.util.List<org.molgenis.omx.xgap.Marker> reportsFor)
	{
		
		this.reportsFor = reportsFor;
	}

	
	public void setReportsFor_Id(Integer ... reportsFor)
	{
		this.setReportsFor_Id(java.util.Arrays.asList(reportsFor));
	}	
	
	public void setReportsFor(org.molgenis.omx.xgap.Marker ... reportsFor)
	{
		this.setReportsFor(java.util.Arrays.asList(reportsFor));
	}	
	
	/**
	 * Set foreign key for field reportsFor.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setReportsFor_Id(java.util.List<Integer> reportsFor_id)
	{
		this.reportsFor_id = reportsFor_id;
	}	
	
	public java.util.List<Integer> getReportsFor_Id()
	{
		if(reportsFor != null && !reportsFor.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < reportsFor.size(); i++)
				result.add(reportsFor.get(i).getId());
			return result;
		} else {
			if(reportsFor_id == null) {
				reportsFor_id = new java.util.ArrayList<Integer>();
			}		
			return reportsFor_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference ReportsFor to <a href="Marker.html#Id">Marker.Id</a>.
	 */
	public java.util.List<String> getReportsFor_Identifier()
	{
		if(this.reportsFor != null && !this.reportsFor.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.reportsFor.size());
			for(org.molgenis.omx.xgap.Marker o: reportsFor) result.add(o.getIdentifier());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return reportsFor_Identifier;
		}
	}
	
	/**
	 * Update the foreign key ReportsFor
	 * This sets reportsFor to null until next database transaction.
	 */
	public void setReportsFor_Identifier(java.util.List<String> reportsFor_Identifier)
	{
		this.reportsFor_Identifier = reportsFor_Identifier;
	}		
	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if(name.equals("chromosome_id"))
			return getChromosome_Id();
		if(name.equals("chromosome_identifier"))
			return getChromosome_Identifier();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		if (name.equals("reportsfor"))
			return getReportsFor();
		if(name.equals("reportsfor_id"))
			return getReportsFor_Id();
		if(name.equals("reportsfor_identifier"))
			return getReportsFor_Identifier();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("marker_id") != null) this.setId(entity.getInt("marker_id"));
		else if( entity.getInt("Marker_id") != null) this.setId(entity.getInt("Marker_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("marker_identifier") != null) this.setIdentifier(entity.getString("marker_identifier"));
		else if( entity.getString("Marker_Identifier") != null) this.setIdentifier(entity.getString("Marker_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("marker_name") != null) this.setName(entity.getString("marker_name"));
		else if( entity.getString("Marker_Name") != null) this.setName(entity.getString("Marker_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("marker___type") != null) this.set__Type(entity.getString("marker___type"));
		else if( entity.getString("Marker___Type") != null) this.set__Type(entity.getString("Marker___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("marker_description") != null) this.setDescription(entity.getString("marker_description"));
		else if( entity.getString("Marker_description") != null) this.setDescription(entity.getString("Marker_description"));
		//set Chromosome
		// query formal name, else lowercase name
		if(entity.getInt("Chromosome_id") != null) this.setChromosome(entity.getInt("Chromosome_id"));
		else if(entity.getInt("chromosome_id") != null) this.setChromosome(entity.getInt("chromosome_id"));
		else if(strict) this.setChromosome(entity.getInt("Chromosome_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Marker_Chromosome_id") != null) this.setChromosome(entity.getInt("Marker_Chromosome_id"));
		else if( entity.getInt("marker_chromosome_id") != null) this.setChromosome(entity.getInt("marker_chromosome_id"));
		//alias of xref
		if( entity.get("Chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome")); 
			}
		}
		else if( entity.get("chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome"));
			}
		}
		if( entity.get("Marker_Chromosome") != null)
			this.setChromosome_Id(entity.getInt("Marker_Chromosome"));			
		else if( entity.get("marker_chromosome") != null)
			this.setChromosome_Id(entity.getInt("marker_chromosome"));
			
		if( entity.get("Marker.Chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Marker.Chromosome_id"));
		else if( entity.get("marker.chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("marker.chromosome_id"));	
		//set label for field Chromosome
		if(entity.get("Chromosome_Identifier") != null) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier"));
		else if(entity.get("chromosome_identifier") != null) this.setChromosome_Identifier(entity.getString("chromosome_identifier"));
		else if(strict) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Marker_Chromosome_Identifier") != null ) this.setChromosome_Identifier(entity.getString("Marker_Chromosome_Identifier"));		
		else if( entity.get("marker_chromosome_identifier") != null ) this.setChromosome_Identifier(entity.getString("marker_chromosome_identifier"));
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("marker_cm") != null) this.setCM(entity.getDouble("marker_cm"));
		else if( entity.getDouble("Marker_cM") != null) this.setCM(entity.getDouble("Marker_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("marker_bpstart") != null) this.setBpStart(entity.getLong("marker_bpstart"));
		else if( entity.getLong("Marker_bpStart") != null) this.setBpStart(entity.getLong("Marker_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("marker_bpend") != null) this.setBpEnd(entity.getLong("marker_bpend"));
		else if( entity.getLong("Marker_bpEnd") != null) this.setBpEnd(entity.getLong("Marker_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("marker_seq") != null) this.setSeq(entity.getString("marker_seq"));
		else if( entity.getString("Marker_Seq") != null) this.setSeq(entity.getString("Marker_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("marker_symbol") != null) this.setSymbol(entity.getString("marker_symbol"));
		else if( entity.getString("Marker_Symbol") != null) this.setSymbol(entity.getString("Marker_Symbol"));
		//set ReportsFor
		if( entity.get("ReportsFor") != null || entity.get("Marker_ReportsFor") != null || entity.get("reportsfor") != null || entity.get("marker_reportsfor") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = entity.getList("ReportsFor");
			if(mrefs == null) mrefs = entity.getList("reportsfor");
			if(entity.get("marker_reportsfor")!= null) mrefs = entity.getList("marker_reportsfor");
			else if(entity.get("Marker_ReportsFor")!= null) mrefs = entity.getList("Marker_ReportsFor");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setReportsFor_Id( values );
		}
		//set labels Identifier for mref field ReportsFor	
		if( entity.get("ReportsFor_Identifier") != null || entity.get("Marker_ReportsFor_Identifier")!= null || entity.get("reportsfor_identifier") != null || entity.get("marker_reportsfor_identifier") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = entity.getList("ReportsFor_Identifier");
			if(mrefs == null) mrefs = entity.getList("reportsfor_identifier");
			if(entity.get("Marker_ReportsFor_Identifier")!= null) mrefs = entity.getList("Marker_ReportsFor_Identifier");
			else if(entity.get("marker_reportsfor_identifier")!= null) mrefs = entity.getList("marker_reportsfor_identifier");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setReportsFor_Identifier( values );			
		}	
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Marker(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " chromosome_id='" + getChromosome_Id()+"' ";	
		result+= " chromosome_identifier='" + getChromosome_Identifier()+"' ";
		result+= "cM='" + getCM()+"' ";	
		result+= "bpStart='" + getBpStart()+"' ";	
		result+= "bpEnd='" + getBpEnd()+"' ";	
		result+= "seq='" + getSeq()+"' ";	
		result+= "symbol='" + getSymbol()+"' ";	
		result+= " reportsFor_id='" + getReportsFor_Id()+"' ";	
		result+= " reportsFor_identifier='" + getReportsFor_Identifier()+"' ";
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Marker.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("Chromosome_id");
		}
		fields.add("Chromosome_Identifier");
		{
			fields.add("cM");
		}
		{
			fields.add("bpStart");
		}
		{
			fields.add("bpEnd");
		}
		{
			fields.add("Seq");
		}
		{
			fields.add("Symbol");
		}
		{
			fields.add("ReportsFor_id");
		}
		fields.add("ReportsFor_Identifier");
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "chromosome" +sep
		+ "cM" +sep
		+ "bpStart" +sep
		+ "bpEnd" +sep
		+ "seq" +sep
		+ "symbol" +sep
		+ "reportsFor" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("chromosome")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("reportsFor")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getChromosome();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCM();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpStart();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpEnd();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSeq();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSymbol();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getReportsFor();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Marker create(org.molgenis.data.Entity entity) throws Exception
	{
		Marker e = new Marker();
		e.set(entity);
		return e;
	}
	
	//3
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY, mappedBy="reportsFor"/*, cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    private java.util.Collection<org.molgenis.omx.xgap.Marker> reportsForMarkerCollection;

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.xgap.Marker> getReportsForMarkerCollection()
	{
		if(reportsForMarkerCollection == null) reportsForMarkerCollection = new java.util.ArrayList<org.molgenis.omx.xgap.Marker>(); 
        return reportsForMarkerCollection;
	}

	@javax.xml.bind.annotation.XmlTransient
	public java.util.Collection<org.molgenis.omx.xgap.Marker> getReportsForMarkerCollection(org.molgenis.framework.db.Database db)
	{
        return getReportsForMarkerCollection();
	}

    public void setReportsForMarkerCollection(java.util.Collection<org.molgenis.omx.xgap.Marker> collection)
    {
		if(reportsForMarkerCollection == null) reportsForMarkerCollection = new java.util.ArrayList<org.molgenis.omx.xgap.Marker>();
    	reportsForMarkerCollection.addAll(collection);
    }	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
