
/* File:        org.molgenis.omx/model/Protein.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

/**
 * Protein:  Trait annotations specific for proteins..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Protein"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.xgap.db.ProteinEntityListener.class})
public class Protein extends org.molgenis.omx.observ.ObservationTarget 
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String GENE = "Gene";
	public final static String GENE_IDENTIFIER = "Gene_Identifier";
	public final static String TRANSCRIPT = "Transcript";
	public final static String TRANSCRIPT_IDENTIFIER = "Transcript_Identifier";
	public final static String AMINOSEQUENCE = "AminoSequence";
	public final static String MASS = "Mass";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(Protein.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Protein> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Protein.class);
	}
	
	/**
	 * Shorthand for db.find(Protein.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Protein> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Protein.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Protein findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Protein> q = db.query(Protein.class);
		q = q.eq(Protein.ID, id);
		java.util.List<Protein> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Protein findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Protein> q = db.query(Protein.class);
		q = q.eq(Protein.IDENTIFIER, identifier);
		java.util.List<Protein> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//The gene that produces this protein[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Gene")   	
	
				

	private org.molgenis.omx.xgap.Gene gene = null;
	@javax.persistence.Transient
	private Integer gene_id = null;	
	@javax.persistence.Transient
	private String gene_Identifier = null;						

	//The transcript variant that produces this protein[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Transcript")   	
	
				

	private org.molgenis.omx.xgap.Transcript transcript = null;
	@javax.persistence.Transient
	private Integer transcript_id = null;	
	@javax.persistence.Transient
	private String transcript_Identifier = null;						

	//The aminoacid sequence.[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="AminoSequence")
	
				

	private String aminoSequence =  null;

	//The mass of this metabolite[type=decimal]
	@javax.persistence.Column(name="Mass")
	@javax.xml.bind.annotation.XmlElement(name="mass")
	
				

	private Double mass =  null;

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public Protein()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public Protein(Protein copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the The gene that produces this protein.
	 * @return gene.
	 */
	public org.molgenis.omx.xgap.Gene getGene()
	{
		return this.gene;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Gene getGene(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The gene that produces this protein.
	 * @param gene
	 */
	public void setGene( org.molgenis.omx.xgap.Gene gene)
	{
		
		this.gene = gene;
	}

	
	
	/**
	 * Set foreign key for field gene.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setGene_Id(Integer gene_id)
	{
		this.gene_id = gene_id;
	}	

	public void setGene(Integer gene_id)
	{
		this.gene_id = gene_id;
	}
	
	public Integer getGene_Id()
	{
		
		if(gene != null) 
		{
			return gene.getId();
		}
		else
		{
			return gene_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Gene to Gene.Id.
	 */
	public String getGene_Identifier()
	{		
		//FIXME should we auto-load based on getGene()?	
		if(gene != null) {
			return gene.getIdentifier();
		} else {
			return gene_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Gene to <a href="Gene.html#Id">Gene.Id</a>.
	 * Implies setGene(null) until save
	 */
	public void setGene_Identifier(String gene_Identifier)
	{
		this.gene_Identifier = gene_Identifier;
	}		
	 
	

	/**
	 * Get the The transcript variant that produces this protein.
	 * @return transcript.
	 */
	public org.molgenis.omx.xgap.Transcript getTranscript()
	{
		return this.transcript;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Transcript getTranscript(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The transcript variant that produces this protein.
	 * @param transcript
	 */
	public void setTranscript( org.molgenis.omx.xgap.Transcript transcript)
	{
		
		this.transcript = transcript;
	}

	
	
	/**
	 * Set foreign key for field transcript.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setTranscript_Id(Integer transcript_id)
	{
		this.transcript_id = transcript_id;
	}	

	public void setTranscript(Integer transcript_id)
	{
		this.transcript_id = transcript_id;
	}
	
	public Integer getTranscript_Id()
	{
		
		if(transcript != null) 
		{
			return transcript.getId();
		}
		else
		{
			return transcript_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Transcript to Transcript.Id.
	 */
	public String getTranscript_Identifier()
	{		
		//FIXME should we auto-load based on getTranscript()?	
		if(transcript != null) {
			return transcript.getIdentifier();
		} else {
			return transcript_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Transcript to <a href="Transcript.html#Id">Transcript.Id</a>.
	 * Implies setTranscript(null) until save
	 */
	public void setTranscript_Identifier(String transcript_Identifier)
	{
		this.transcript_Identifier = transcript_Identifier;
	}		
	 
	

	/**
	 * Get the The aminoacid sequence..
	 * @return aminoSequence.
	 */
	public String getAminoSequence()
	{
		return this.aminoSequence;
	}
	
	@Deprecated
	public String getAminoSequence(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The aminoacid sequence..
	 * @param aminoSequence
	 */
	public void setAminoSequence( String aminoSequence)
	{
		
		this.aminoSequence = aminoSequence;
	}

	

	/**
	 * Get the The mass of this metabolite.
	 * @return mass.
	 */
	public Double getMass()
	{
		return this.mass;
	}
	
	@Deprecated
	public Double getMass(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The mass of this metabolite.
	 * @param mass
	 */
	public void setMass( Double mass)
	{
		
		this.mass = mass;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("gene"))
			return getGene();
		if(name.equals("gene_id"))
			return getGene_Id();
		if(name.equals("gene_identifier"))
			return getGene_Identifier();
		if (name.equals("transcript"))
			return getTranscript();
		if(name.equals("transcript_id"))
			return getTranscript_Id();
		if(name.equals("transcript_identifier"))
			return getTranscript_Identifier();
		if (name.equals("aminosequence"))
			return getAminoSequence();
		if (name.equals("mass"))
			return getMass();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("protein_id") != null) this.setId(entity.getInt("protein_id"));
		else if( entity.getInt("Protein_id") != null) this.setId(entity.getInt("Protein_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("protein_identifier") != null) this.setIdentifier(entity.getString("protein_identifier"));
		else if( entity.getString("Protein_Identifier") != null) this.setIdentifier(entity.getString("Protein_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("protein_name") != null) this.setName(entity.getString("protein_name"));
		else if( entity.getString("Protein_Name") != null) this.setName(entity.getString("Protein_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("protein___type") != null) this.set__Type(entity.getString("protein___type"));
		else if( entity.getString("Protein___Type") != null) this.set__Type(entity.getString("Protein___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("protein_description") != null) this.setDescription(entity.getString("protein_description"));
		else if( entity.getString("Protein_description") != null) this.setDescription(entity.getString("Protein_description"));
		//set Gene
		// query formal name, else lowercase name
		if(entity.getInt("Gene_id") != null) this.setGene(entity.getInt("Gene_id"));
		else if(entity.getInt("gene_id") != null) this.setGene(entity.getInt("gene_id"));
		else if(strict) this.setGene(entity.getInt("Gene_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Protein_Gene_id") != null) this.setGene(entity.getInt("Protein_Gene_id"));
		else if( entity.getInt("protein_gene_id") != null) this.setGene(entity.getInt("protein_gene_id"));
		//alias of xref
		if( entity.get("Gene") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Gene").toString())) {
				org.molgenis.omx.xgap.Gene instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Gene"), org.molgenis.omx.xgap.Gene.class);
				this.setGene(instance);				
			} else {
				this.setGene_Id(entity.getInt("Gene")); 
			}
		}
		else if( entity.get("gene") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("gene").toString())) {
				org.molgenis.omx.xgap.Gene instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("gene"), org.molgenis.omx.xgap.Gene.class);
				this.setGene(instance);				
			} else {
				this.setGene_Id(entity.getInt("Gene"));
			}
		}
		if( entity.get("Protein_Gene") != null)
			this.setGene_Id(entity.getInt("Protein_Gene"));			
		else if( entity.get("protein_gene") != null)
			this.setGene_Id(entity.getInt("protein_gene"));
			
		if( entity.get("Protein.Gene") != null) 
			this.setGene((org.molgenis.omx.xgap.Gene)entity.get("Protein.Gene_id"));
		else if( entity.get("protein.gene") != null) 
			this.setGene((org.molgenis.omx.xgap.Gene)entity.get("protein.gene_id"));	
		//set label for field Gene
		if(entity.get("Gene_Identifier") != null) this.setGene_Identifier(entity.getString("Gene_Identifier"));
		else if(entity.get("gene_identifier") != null) this.setGene_Identifier(entity.getString("gene_identifier"));
		else if(strict) this.setGene_Identifier(entity.getString("Gene_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Protein_Gene_Identifier") != null ) this.setGene_Identifier(entity.getString("Protein_Gene_Identifier"));		
		else if( entity.get("protein_gene_identifier") != null ) this.setGene_Identifier(entity.getString("protein_gene_identifier"));
		//set Transcript
		// query formal name, else lowercase name
		if(entity.getInt("Transcript_id") != null) this.setTranscript(entity.getInt("Transcript_id"));
		else if(entity.getInt("transcript_id") != null) this.setTranscript(entity.getInt("transcript_id"));
		else if(strict) this.setTranscript(entity.getInt("Transcript_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Protein_Transcript_id") != null) this.setTranscript(entity.getInt("Protein_Transcript_id"));
		else if( entity.getInt("protein_transcript_id") != null) this.setTranscript(entity.getInt("protein_transcript_id"));
		//alias of xref
		if( entity.get("Transcript") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Transcript").toString())) {
				org.molgenis.omx.xgap.Transcript instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Transcript"), org.molgenis.omx.xgap.Transcript.class);
				this.setTranscript(instance);				
			} else {
				this.setTranscript_Id(entity.getInt("Transcript")); 
			}
		}
		else if( entity.get("transcript") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("transcript").toString())) {
				org.molgenis.omx.xgap.Transcript instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("transcript"), org.molgenis.omx.xgap.Transcript.class);
				this.setTranscript(instance);				
			} else {
				this.setTranscript_Id(entity.getInt("Transcript"));
			}
		}
		if( entity.get("Protein_Transcript") != null)
			this.setTranscript_Id(entity.getInt("Protein_Transcript"));			
		else if( entity.get("protein_transcript") != null)
			this.setTranscript_Id(entity.getInt("protein_transcript"));
			
		if( entity.get("Protein.Transcript") != null) 
			this.setTranscript((org.molgenis.omx.xgap.Transcript)entity.get("Protein.Transcript_id"));
		else if( entity.get("protein.transcript") != null) 
			this.setTranscript((org.molgenis.omx.xgap.Transcript)entity.get("protein.transcript_id"));	
		//set label for field Transcript
		if(entity.get("Transcript_Identifier") != null) this.setTranscript_Identifier(entity.getString("Transcript_Identifier"));
		else if(entity.get("transcript_identifier") != null) this.setTranscript_Identifier(entity.getString("transcript_identifier"));
		else if(strict) this.setTranscript_Identifier(entity.getString("Transcript_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Protein_Transcript_Identifier") != null ) this.setTranscript_Identifier(entity.getString("Protein_Transcript_Identifier"));		
		else if( entity.get("protein_transcript_identifier") != null ) this.setTranscript_Identifier(entity.getString("protein_transcript_identifier"));
		//set AminoSequence
		// query formal name, else lowercase name
		if(entity.getString("aminosequence") != null) this.setAminoSequence(entity.getString("aminosequence"));
		else if(entity.getString("AminoSequence") != null) this.setAminoSequence(entity.getString("AminoSequence"));
		else if(strict) this.setAminoSequence(entity.getString("aminosequence")); // setting null is not an option due to function overloading
		if( entity.getString("protein_aminosequence") != null) this.setAminoSequence(entity.getString("protein_aminosequence"));
		else if( entity.getString("Protein_AminoSequence") != null) this.setAminoSequence(entity.getString("Protein_AminoSequence"));
		//set Mass
		// query formal name, else lowercase name
		if(entity.getDouble("mass") != null) this.setMass(entity.getDouble("mass"));
		else if(entity.getDouble("Mass") != null) this.setMass(entity.getDouble("Mass"));
		else if(strict) this.setMass(entity.getDouble("mass")); // setting null is not an option due to function overloading
		if( entity.getDouble("protein_mass") != null) this.setMass(entity.getDouble("protein_mass"));
		else if( entity.getDouble("Protein_Mass") != null) this.setMass(entity.getDouble("Protein_Mass"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Protein(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " gene_id='" + getGene_Id()+"' ";	
		result+= " gene_identifier='" + getGene_Identifier()+"' ";
		result+= " transcript_id='" + getTranscript_Id()+"' ";	
		result+= " transcript_identifier='" + getTranscript_Identifier()+"' ";
		result+= "aminoSequence='" + getAminoSequence()+"' ";	
		result+= "mass='" + getMass()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Protein.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("Gene_id");
		}
		fields.add("Gene_Identifier");
		{
			fields.add("Transcript_id");
		}
		fields.add("Transcript_Identifier");
		{
			fields.add("AminoSequence");
		}
		{
			fields.add("Mass");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "gene" +sep
		+ "transcript" +sep
		+ "aminoSequence" +sep
		+ "mass" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("gene")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("transcript")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getGene();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getTranscript();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getAminoSequence();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getMass();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Protein create(org.molgenis.data.Entity entity) throws Exception
	{
		Protein e = new Protein();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
