
/* File:        org.molgenis.omx/model/SNP.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

/**
 * SNP: A SNP is a special kind of Marker, but can also be seen as a phenotype to map against in some cases. A single-nucleotide polymorphism is a DNA sequence variation occurring when a single nucleotide in the genome (or other shared sequence) differs between members of a biological species or paired chromosomes in an individual..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "SNP"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.xgap.db.SNPEntityListener.class})
public class SNP extends org.molgenis.omx.xgap.Marker 
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String STATUS = "Status";
	public final static String POLYMORPHISM = "Polymorphism";
	public final static String POLYMORPHISM_IDENTIFIER = "Polymorphism_Identifier";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(SNP.class).
	 */
	public static org.molgenis.framework.db.Query<? extends SNP> query(org.molgenis.framework.db.Database db)
	{
		return db.query(SNP.class);
	}
	
	/**
	 * Shorthand for db.find(SNP.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends SNP> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(SNP.class, rules);
	}	
	
	/**
	 * 
	 */
	public static SNP findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<SNP> q = db.query(SNP.class);
		q = q.eq(SNP.ID, id);
		java.util.List<SNP> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static SNP findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<SNP> q = db.query(SNP.class);
		q = q.eq(SNP.IDENTIFIER, identifier);
		java.util.List<SNP> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//The status of this SNP, eg 'confirmed'.[type=string]
	@javax.persistence.Column(name="Status", length=255)
	@javax.xml.bind.annotation.XmlElement(name="status")
	
				

	private String status =  null;

	//The polymorphism that belongs to this SNP.[type=mref]
    @javax.persistence.ManyToMany(fetch=javax.persistence.FetchType.LAZY /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Polymorphism", insertable=true, updatable=true, nullable=true)
	@javax.persistence.JoinTable(name="SNP_Polymorphism", 
			joinColumns=@javax.persistence.JoinColumn(name="SNP"), inverseJoinColumns=@javax.persistence.JoinColumn(name="Polymorphism"))
	
				

	private java.util.List<org.molgenis.omx.xgap.Polymorphism> polymorphism = new java.util.ArrayList<org.molgenis.omx.xgap.Polymorphism>();
	@javax.persistence.Transient
	private java.util.List<Integer> polymorphism_id = new java.util.ArrayList<Integer>();		
	@javax.persistence.Transient
	private java.util.List<String> polymorphism_Identifier = new java.util.ArrayList<String>();

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public SNP()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public SNP(SNP copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the The status of this SNP, eg 'confirmed'..
	 * @return status.
	 */
	public String getStatus()
	{
		return this.status;
	}
	
	@Deprecated
	public String getStatus(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The status of this SNP, eg 'confirmed'..
	 * @param status
	 */
	public void setStatus( String status)
	{
		
		this.status = status;
	}

	

	/**
	 * Get the The polymorphism that belongs to this SNP..
	 * @return polymorphism.
	 */
	public java.util.List<org.molgenis.omx.xgap.Polymorphism> getPolymorphism()
	{
		return this.polymorphism;
	}
	
	@Deprecated
	public java.util.List<org.molgenis.omx.xgap.Polymorphism> getPolymorphism(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The polymorphism that belongs to this SNP..
	 * @param polymorphism
	 */
	public void setPolymorphism( java.util.List<org.molgenis.omx.xgap.Polymorphism> polymorphism)
	{
		
		this.polymorphism = polymorphism;
	}

	
	public void setPolymorphism_Id(Integer ... polymorphism)
	{
		this.setPolymorphism_Id(java.util.Arrays.asList(polymorphism));
	}	
	
	public void setPolymorphism(org.molgenis.omx.xgap.Polymorphism ... polymorphism)
	{
		this.setPolymorphism(java.util.Arrays.asList(polymorphism));
	}	
	
	/**
	 * Set foreign key for field polymorphism.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setPolymorphism_Id(java.util.List<Integer> polymorphism_id)
	{
		this.polymorphism_id = polymorphism_id;
	}	
	
	public java.util.List<Integer> getPolymorphism_Id()
	{
		if(polymorphism != null && !polymorphism.isEmpty()) {
			java.util.List<Integer> result = new java.util.ArrayList<Integer>();
			for (int i = 0; i < polymorphism.size(); i++)
				result.add(polymorphism.get(i).getId());
			return result;
		} else {
			if(polymorphism_id == null) {
				polymorphism_id = new java.util.ArrayList<Integer>();
			}		
			return polymorphism_id;
		}
	}	
	
	/**
	 * Get a pretty label for cross reference Polymorphism to <a href="Polymorphism.html#Id">Polymorphism.Id</a>.
	 */
	public java.util.List<String> getPolymorphism_Identifier()
	{
		if(this.polymorphism != null && !this.polymorphism.isEmpty())
		{
			java.util.List<String> result = new java.util.ArrayList<String>(this.polymorphism.size());
			for(org.molgenis.omx.xgap.Polymorphism o: polymorphism) result.add(o.getIdentifier());
			return java.util.Collections.unmodifiableList(result);
		}	
		else
		{	
			return polymorphism_Identifier;
		}
	}
	
	/**
	 * Update the foreign key Polymorphism
	 * This sets polymorphism to null until next database transaction.
	 */
	public void setPolymorphism_Identifier(java.util.List<String> polymorphism_Identifier)
	{
		this.polymorphism_Identifier = polymorphism_Identifier;
	}		
	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if(name.equals("chromosome_id"))
			return getChromosome_Id();
		if(name.equals("chromosome_identifier"))
			return getChromosome_Identifier();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		if (name.equals("reportsfor"))
			return getReportsFor();
		if(name.equals("reportsfor_id"))
			return getReportsFor_Id();
		if(name.equals("reportsfor_identifier"))
			return getReportsFor_Identifier();
		if (name.equals("status"))
			return getStatus();
		if (name.equals("polymorphism"))
			return getPolymorphism();
		if(name.equals("polymorphism_id"))
			return getPolymorphism_Id();
		if(name.equals("polymorphism_identifier"))
			return getPolymorphism_Identifier();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("snp_id") != null) this.setId(entity.getInt("snp_id"));
		else if( entity.getInt("SNP_id") != null) this.setId(entity.getInt("SNP_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("snp_identifier") != null) this.setIdentifier(entity.getString("snp_identifier"));
		else if( entity.getString("SNP_Identifier") != null) this.setIdentifier(entity.getString("SNP_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("snp_name") != null) this.setName(entity.getString("snp_name"));
		else if( entity.getString("SNP_Name") != null) this.setName(entity.getString("SNP_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("snp___type") != null) this.set__Type(entity.getString("snp___type"));
		else if( entity.getString("SNP___Type") != null) this.set__Type(entity.getString("SNP___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("snp_description") != null) this.setDescription(entity.getString("snp_description"));
		else if( entity.getString("SNP_description") != null) this.setDescription(entity.getString("SNP_description"));
		//set Chromosome
		// query formal name, else lowercase name
		if(entity.getInt("Chromosome_id") != null) this.setChromosome(entity.getInt("Chromosome_id"));
		else if(entity.getInt("chromosome_id") != null) this.setChromosome(entity.getInt("chromosome_id"));
		else if(strict) this.setChromosome(entity.getInt("Chromosome_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("SNP_Chromosome_id") != null) this.setChromosome(entity.getInt("SNP_Chromosome_id"));
		else if( entity.getInt("snp_chromosome_id") != null) this.setChromosome(entity.getInt("snp_chromosome_id"));
		//alias of xref
		if( entity.get("Chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome")); 
			}
		}
		else if( entity.get("chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome"));
			}
		}
		if( entity.get("SNP_Chromosome") != null)
			this.setChromosome_Id(entity.getInt("SNP_Chromosome"));			
		else if( entity.get("snp_chromosome") != null)
			this.setChromosome_Id(entity.getInt("snp_chromosome"));
			
		if( entity.get("SNP.Chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("SNP.Chromosome_id"));
		else if( entity.get("snp.chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("snp.chromosome_id"));	
		//set label for field Chromosome
		if(entity.get("Chromosome_Identifier") != null) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier"));
		else if(entity.get("chromosome_identifier") != null) this.setChromosome_Identifier(entity.getString("chromosome_identifier"));
		else if(strict) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("SNP_Chromosome_Identifier") != null ) this.setChromosome_Identifier(entity.getString("SNP_Chromosome_Identifier"));		
		else if( entity.get("snp_chromosome_identifier") != null ) this.setChromosome_Identifier(entity.getString("snp_chromosome_identifier"));
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("snp_cm") != null) this.setCM(entity.getDouble("snp_cm"));
		else if( entity.getDouble("SNP_cM") != null) this.setCM(entity.getDouble("SNP_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("snp_bpstart") != null) this.setBpStart(entity.getLong("snp_bpstart"));
		else if( entity.getLong("SNP_bpStart") != null) this.setBpStart(entity.getLong("SNP_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("snp_bpend") != null) this.setBpEnd(entity.getLong("snp_bpend"));
		else if( entity.getLong("SNP_bpEnd") != null) this.setBpEnd(entity.getLong("SNP_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("snp_seq") != null) this.setSeq(entity.getString("snp_seq"));
		else if( entity.getString("SNP_Seq") != null) this.setSeq(entity.getString("SNP_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("snp_symbol") != null) this.setSymbol(entity.getString("snp_symbol"));
		else if( entity.getString("SNP_Symbol") != null) this.setSymbol(entity.getString("SNP_Symbol"));
		//set ReportsFor
		if( entity.get("ReportsFor") != null || entity.get("SNP_ReportsFor") != null || entity.get("reportsfor") != null || entity.get("snp_reportsfor") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = entity.getList("ReportsFor");
			if(mrefs == null) mrefs = entity.getList("reportsfor");
			if(entity.get("snp_reportsfor")!= null) mrefs = entity.getList("snp_reportsfor");
			else if(entity.get("SNP_ReportsFor")!= null) mrefs = entity.getList("SNP_ReportsFor");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setReportsFor_Id( values );
		}
		//set labels Identifier for mref field ReportsFor	
		if( entity.get("ReportsFor_Identifier") != null || entity.get("SNP_ReportsFor_Identifier")!= null || entity.get("reportsfor_identifier") != null || entity.get("snp_reportsfor_identifier") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = entity.getList("ReportsFor_Identifier");
			if(mrefs == null) mrefs = entity.getList("reportsfor_identifier");
			if(entity.get("SNP_ReportsFor_Identifier")!= null) mrefs = entity.getList("SNP_ReportsFor_Identifier");
			else if(entity.get("snp_reportsfor_identifier")!= null) mrefs = entity.getList("snp_reportsfor_identifier");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setReportsFor_Identifier( values );			
		}	
		//set Status
		// query formal name, else lowercase name
		if(entity.getString("status") != null) this.setStatus(entity.getString("status"));
		else if(entity.getString("Status") != null) this.setStatus(entity.getString("Status"));
		else if(strict) this.setStatus(entity.getString("status")); // setting null is not an option due to function overloading
		if( entity.getString("snp_status") != null) this.setStatus(entity.getString("snp_status"));
		else if( entity.getString("SNP_Status") != null) this.setStatus(entity.getString("SNP_Status"));
		//set Polymorphism
		if( entity.get("Polymorphism") != null || entity.get("SNP_Polymorphism") != null || entity.get("polymorphism") != null || entity.get("snp_polymorphism") != null) 
		{
			java.util.List<Integer> values = new java.util.ArrayList<Integer>();
			java.util.List<?> mrefs = entity.getList("Polymorphism");
			if(mrefs == null) mrefs = entity.getList("polymorphism");
			if(entity.get("snp_polymorphism")!= null) mrefs = entity.getList("snp_polymorphism");
			else if(entity.get("SNP_Polymorphism")!= null) mrefs = entity.getList("SNP_Polymorphism");
			if(mrefs != null) for(Object ref: mrefs)
			{
				if(ref instanceof String)
					values.add(Integer.parseInt((String)ref));
				else if(ref instanceof org.molgenis.util.AbstractEntity) 	
					values.add((Integer)((org.molgenis.util.AbstractEntity)ref).getIdValue() );
				else
					values.add((Integer)ref);		
			}											
			this.setPolymorphism_Id( values );
		}
		//set labels Identifier for mref field Polymorphism	
		if( entity.get("Polymorphism_Identifier") != null || entity.get("SNP_Polymorphism_Identifier")!= null || entity.get("polymorphism_identifier") != null || entity.get("snp_polymorphism_identifier") != null) 
		{
			java.util.List<String> values = new java.util.ArrayList<String>();
			java.util.List<?> mrefs = entity.getList("Polymorphism_Identifier");
			if(mrefs == null) mrefs = entity.getList("polymorphism_identifier");
			if(entity.get("SNP_Polymorphism_Identifier")!= null) mrefs = entity.getList("SNP_Polymorphism_Identifier");
			else if(entity.get("snp_polymorphism_identifier")!= null) mrefs = entity.getList("snp_polymorphism_identifier");
			if(mrefs != null) 
				for(Object ref: mrefs)
				{
					String[] refs = ref.toString().split("\\|");
					for(String r : refs) {
						values.add(r);	
					}						
				}							
			this.setPolymorphism_Identifier( values );			
		}	
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "SNP(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " chromosome_id='" + getChromosome_Id()+"' ";	
		result+= " chromosome_identifier='" + getChromosome_Identifier()+"' ";
		result+= "cM='" + getCM()+"' ";	
		result+= "bpStart='" + getBpStart()+"' ";	
		result+= "bpEnd='" + getBpEnd()+"' ";	
		result+= "seq='" + getSeq()+"' ";	
		result+= "symbol='" + getSymbol()+"' ";	
		result+= " reportsFor_id='" + getReportsFor_Id()+"' ";	
		result+= " reportsFor_identifier='" + getReportsFor_Identifier()+"' ";
		result+= "status='" + getStatus()+"' ";	
		result+= " polymorphism_id='" + getPolymorphism_Id()+"' ";	
		result+= " polymorphism_identifier='" + getPolymorphism_Identifier()+"' ";
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of SNP.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("Chromosome_id");
		}
		fields.add("Chromosome_Identifier");
		{
			fields.add("cM");
		}
		{
			fields.add("bpStart");
		}
		{
			fields.add("bpEnd");
		}
		{
			fields.add("Seq");
		}
		{
			fields.add("Symbol");
		}
		{
			fields.add("ReportsFor_id");
		}
		fields.add("ReportsFor_Identifier");
		{
			fields.add("Status");
		}
		{
			fields.add("Polymorphism_id");
		}
		fields.add("Polymorphism_Identifier");
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "chromosome" +sep
		+ "cM" +sep
		+ "bpStart" +sep
		+ "bpEnd" +sep
		+ "seq" +sep
		+ "symbol" +sep
		+ "reportsFor" +sep
		+ "status" +sep
		+ "polymorphism" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("chromosome")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("reportsFor")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("polymorphism")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getChromosome();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCM();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpStart();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpEnd();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSeq();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSymbol();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getReportsFor();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getStatus();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getPolymorphism();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public SNP create(org.molgenis.data.Entity entity) throws Exception
	{
		SNP e = new SNP();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
