
/* File:        org.molgenis.omx/model/Marker_ReportsFor.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Marker;
import org.molgenis.omx.xgap.Marker_ReportsFor;


/**
 * Reads Marker_ReportsFor from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class Marker_ReportsForEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(Marker_ReportsForEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'reportsFor' (maps marker.Identifier -> marker.id)			
	final Map<String,Integer> reportsForKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'marker' (maps marker.Identifier -> marker.id)			
	final Map<String,Integer> markerKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Marker_ReportsFor from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Marker_ReportsFor> marker_ReportsForsMissingRefs = new ArrayList<Marker_ReportsFor>();
	
		//cache for objects to be imported from file (in batch)
		final List<Marker_ReportsFor> marker_ReportsForList = new ArrayList<Marker_ReportsFor>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Marker_ReportsFor object = new Marker_ReportsFor();
			object.set(entity, false);				
			marker_ReportsForList.add(object);		
			
			//add to db when batch size is reached
			if(marker_ReportsForList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				marker_ReportsForsMissingRefs.addAll(resolveForeignKeys(db, marker_ReportsForList));
				marker_ReportsForList.removeAll(marker_ReportsForsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'ReportsFor,Marker' defined in xref_label
				db.update(marker_ReportsForList,dbAction, "ReportsFor", "Marker");
				
				//clear for next batch						
				marker_ReportsForList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!marker_ReportsForList.isEmpty())
		{
			total.set(total.get() + marker_ReportsForList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			marker_ReportsForsMissingRefs.addAll(resolveForeignKeys(db, marker_ReportsForList));
			marker_ReportsForList.removeAll(marker_ReportsForsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'ReportsFor,Marker' defined in xref_label
			db.update(marker_ReportsForList,dbAction, "ReportsFor", "Marker");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Marker_ReportsFor> marker_ReportsFors = new ArrayList<Marker_ReportsFor>(marker_ReportsForsMissingRefs);

		int iterationCount = 0;

		do
		{
			marker_ReportsForsMissingRefs = resolveForeignKeys(db, marker_ReportsForsMissingRefs);
			
			LinkedHashSet<Marker_ReportsFor> differenceSet = new LinkedHashSet<Marker_ReportsFor>();
			Sets.symmetricDifference(new LinkedHashSet<Marker_ReportsFor>(marker_ReportsFors), new LinkedHashSet<Marker_ReportsFor>(marker_ReportsForsMissingRefs)).copyInto(differenceSet);
			List<Marker_ReportsFor> resolvablemarker_ReportsFors = new ArrayList<Marker_ReportsFor>(differenceSet);
			
			marker_ReportsFors.removeAll(resolvablemarker_ReportsFors);
			
			db.update(resolvablemarker_ReportsFors,dbAction, "ReportsFor", "Marker");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Marker_ReportsFor blaat : marker_ReportsForsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'marker_ReportsFor' entity failed:"
								+ "This is probably caused by a(n) 'marker_ReportsFor' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (marker_ReportsForsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " marker_ReportsFor from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param marker_ReportsForList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Marker_ReportsFor> resolveForeignKeys(Database db, List<Marker_ReportsFor> marker_ReportsForList) throws Exception
	{
		//keep a list of Marker_ReportsFor instances that miss a reference which might be resolvable later
		List<Marker_ReportsFor> marker_ReportsForsMissingRefs = new ArrayList<Marker_ReportsFor>();
	
		//resolve xref 'reportsFor' from marker.Identifier -> marker.id
		for(Marker_ReportsFor o: marker_ReportsForList) 
		{
			if(o.getReportsFor_Identifier() != null) 
				reportsForKeymap.put(o.getReportsFor_Identifier(), null);
		}
		
		if(reportsForKeymap.size() > 0) 
		{
			List<Marker> reportsForList = db.query(Marker.class).in("Identifier",new ArrayList<Object>(reportsForKeymap.keySet())).find();
			for(Marker xref :  reportsForList)
			{
				reportsForKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'marker' from marker.Identifier -> marker.id
		for(Marker_ReportsFor o: marker_ReportsForList) 
		{
			if(o.getMarker_Identifier() != null) 
				markerKeymap.put(o.getMarker_Identifier(), null);
		}
		
		if(markerKeymap.size() > 0) 
		{
			List<Marker> markerList = db.query(Marker.class).in("Identifier",new ArrayList<Object>(markerKeymap.keySet())).find();
			for(Marker xref :  markerList)
			{
				markerKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Marker_ReportsFor o:  marker_ReportsForList)
		{
			while(true){
				//update xref ReportsFor
				if(o.getReportsFor_Identifier() != null) 
				{
					String key = o.getReportsFor_Identifier();
					if(reportsForKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Marker_ReportsFor' objects failed: cannot find Marker for reportsFor_Identifier='"+o.getReportsFor_Identifier()+"'");
					}
					o.setReportsFor_Id(reportsForKeymap.get(key));
				}
				//update xref Marker
				if(o.getMarker_Identifier() != null) 
				{
					String key = o.getMarker_Identifier();
					if(markerKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Marker_ReportsFor' objects failed: cannot find Marker for marker_Identifier='"+o.getMarker_Identifier()+"'");
					}
					o.setMarker_Id(markerKeymap.get(key));
				}
				break;
			}
		}
		
		reportsForKeymap.clear();
		markerKeymap.clear();
		
		return marker_ReportsForsMissingRefs;
	}
}

