
/* File:        org.molgenis.omx/model/NMRBin.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.NMRBin;


/**
 * Reads NMRBin from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class NMRBinEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(NMRBinEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports NMRBin from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<NMRBin> nMRBinsMissingRefs = new ArrayList<NMRBin>();
	
		//cache for objects to be imported from file (in batch)
		final List<NMRBin> nMRBinList = new ArrayList<NMRBin>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			NMRBin object = new NMRBin();
			object.set(entity, false);				
			nMRBinList.add(object);		
			
			//add to db when batch size is reached
			if(nMRBinList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				nMRBinsMissingRefs.addAll(resolveForeignKeys(db, nMRBinList));
				nMRBinList.removeAll(nMRBinsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(nMRBinList,dbAction, "Identifier");
				
				//clear for next batch						
				nMRBinList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!nMRBinList.isEmpty())
		{
			total.set(total.get() + nMRBinList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			nMRBinsMissingRefs.addAll(resolveForeignKeys(db, nMRBinList));
			nMRBinList.removeAll(nMRBinsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(nMRBinList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<NMRBin> nMRBins = new ArrayList<NMRBin>(nMRBinsMissingRefs);

		int iterationCount = 0;

		do
		{
			nMRBinsMissingRefs = resolveForeignKeys(db, nMRBinsMissingRefs);
			
			LinkedHashSet<NMRBin> differenceSet = new LinkedHashSet<NMRBin>();
			Sets.symmetricDifference(new LinkedHashSet<NMRBin>(nMRBins), new LinkedHashSet<NMRBin>(nMRBinsMissingRefs)).copyInto(differenceSet);
			List<NMRBin> resolvablenMRBins = new ArrayList<NMRBin>(differenceSet);
			
			nMRBins.removeAll(resolvablenMRBins);
			
			db.update(resolvablenMRBins,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(NMRBin blaat : nMRBinsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'nMRBin' entity failed:"
								+ "This is probably caused by a(n) 'nMRBin' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (nMRBinsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " nMRBin from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param nMRBinList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<NMRBin> resolveForeignKeys(Database db, List<NMRBin> nMRBinList) throws Exception
	{
		//keep a list of NMRBin instances that miss a reference which might be resolvable later
		List<NMRBin> nMRBinsMissingRefs = new ArrayList<NMRBin>();
	
		//update objects with foreign key values
		for(NMRBin o:  nMRBinList)
		{
			while(true){
				break;
			}
		}
		
		
		return nMRBinsMissingRefs;
	}
}

