
/* File:        org.molgenis.omx/model/PairedSample.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.Individual;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.xgap.PairedSample;


/**
 * Reads PairedSample from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class PairedSampleEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(PairedSampleEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'subject1' (maps individual.Identifier -> individual.id)			
	final Map<String,Integer> subject1Keymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'label1' (maps ontologyTerm.Identifier -> ontologyTerm.id)			
	final Map<String,Integer> label1Keymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'subject2' (maps individual.Identifier -> individual.id)			
	final Map<String,Integer> subject2Keymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'label2' (maps ontologyTerm.Identifier -> ontologyTerm.id)			
	final Map<String,Integer> label2Keymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports PairedSample from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<PairedSample> pairedSamplesMissingRefs = new ArrayList<PairedSample>();
	
		//cache for objects to be imported from file (in batch)
		final List<PairedSample> pairedSampleList = new ArrayList<PairedSample>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			PairedSample object = new PairedSample();
			object.set(entity, false);				
			pairedSampleList.add(object);		
			
			//add to db when batch size is reached
			if(pairedSampleList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				pairedSamplesMissingRefs.addAll(resolveForeignKeys(db, pairedSampleList));
				pairedSampleList.removeAll(pairedSamplesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(pairedSampleList,dbAction, "Identifier");
				
				//clear for next batch						
				pairedSampleList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!pairedSampleList.isEmpty())
		{
			total.set(total.get() + pairedSampleList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			pairedSamplesMissingRefs.addAll(resolveForeignKeys(db, pairedSampleList));
			pairedSampleList.removeAll(pairedSamplesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(pairedSampleList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<PairedSample> pairedSamples = new ArrayList<PairedSample>(pairedSamplesMissingRefs);

		int iterationCount = 0;

		do
		{
			pairedSamplesMissingRefs = resolveForeignKeys(db, pairedSamplesMissingRefs);
			
			LinkedHashSet<PairedSample> differenceSet = new LinkedHashSet<PairedSample>();
			Sets.symmetricDifference(new LinkedHashSet<PairedSample>(pairedSamples), new LinkedHashSet<PairedSample>(pairedSamplesMissingRefs)).copyInto(differenceSet);
			List<PairedSample> resolvablepairedSamples = new ArrayList<PairedSample>(differenceSet);
			
			pairedSamples.removeAll(resolvablepairedSamples);
			
			db.update(resolvablepairedSamples,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(PairedSample blaat : pairedSamplesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'pairedSample' entity failed:"
								+ "This is probably caused by a(n) 'pairedSample' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (pairedSamplesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " pairedSample from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param pairedSampleList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<PairedSample> resolveForeignKeys(Database db, List<PairedSample> pairedSampleList) throws Exception
	{
		//keep a list of PairedSample instances that miss a reference which might be resolvable later
		List<PairedSample> pairedSamplesMissingRefs = new ArrayList<PairedSample>();
	
		//resolve xref 'subject1' from individual.Identifier -> individual.id
		for(PairedSample o: pairedSampleList) 
		{
			if(o.getSubject1_Identifier() != null) 
				subject1Keymap.put(o.getSubject1_Identifier(), null);
		}
		
		if(subject1Keymap.size() > 0) 
		{
			List<Individual> subject1List = db.query(Individual.class).in("Identifier",new ArrayList<Object>(subject1Keymap.keySet())).find();
			for(Individual xref :  subject1List)
			{
				subject1Keymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'label1' from ontologyTerm.Identifier -> ontologyTerm.id
		for(PairedSample o: pairedSampleList) 
		{
			if(o.getLabel1_Identifier() != null) 
				label1Keymap.put(o.getLabel1_Identifier(), null);
		}
		
		if(label1Keymap.size() > 0) 
		{
			List<OntologyTerm> label1List = db.query(OntologyTerm.class).in("Identifier",new ArrayList<Object>(label1Keymap.keySet())).find();
			for(OntologyTerm xref :  label1List)
			{
				label1Keymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'subject2' from individual.Identifier -> individual.id
		for(PairedSample o: pairedSampleList) 
		{
			if(o.getSubject2_Identifier() != null) 
				subject2Keymap.put(o.getSubject2_Identifier(), null);
		}
		
		if(subject2Keymap.size() > 0) 
		{
			List<Individual> subject2List = db.query(Individual.class).in("Identifier",new ArrayList<Object>(subject2Keymap.keySet())).find();
			for(Individual xref :  subject2List)
			{
				subject2Keymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'label2' from ontologyTerm.Identifier -> ontologyTerm.id
		for(PairedSample o: pairedSampleList) 
		{
			if(o.getLabel2_Identifier() != null) 
				label2Keymap.put(o.getLabel2_Identifier(), null);
		}
		
		if(label2Keymap.size() > 0) 
		{
			List<OntologyTerm> label2List = db.query(OntologyTerm.class).in("Identifier",new ArrayList<Object>(label2Keymap.keySet())).find();
			for(OntologyTerm xref :  label2List)
			{
				label2Keymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(PairedSample o:  pairedSampleList)
		{
			while(true){
				//update xref Subject1
				if(o.getSubject1_Identifier() != null) 
				{
					String key = o.getSubject1_Identifier();
					if(subject1Keymap.get(key) == null)
					{
						throw new Exception("Import of 'PairedSample' objects failed: cannot find Individual for subject1_Identifier='"+o.getSubject1_Identifier()+"'");
					}
					o.setSubject1_Id(subject1Keymap.get(key));
				}
				//update xref Label1
				if(o.getLabel1_Identifier() != null) 
				{
					String key = o.getLabel1_Identifier();
					if(label1Keymap.get(key) == null)
					{
						throw new Exception("Import of 'PairedSample' objects failed: cannot find OntologyTerm for label1_Identifier='"+o.getLabel1_Identifier()+"'");
					}
					o.setLabel1_Id(label1Keymap.get(key));
				}
				//update xref Subject2
				if(o.getSubject2_Identifier() != null) 
				{
					String key = o.getSubject2_Identifier();
					if(subject2Keymap.get(key) == null)
					{
						throw new Exception("Import of 'PairedSample' objects failed: cannot find Individual for subject2_Identifier='"+o.getSubject2_Identifier()+"'");
					}
					o.setSubject2_Id(subject2Keymap.get(key));
				}
				//update xref Label2
				if(o.getLabel2_Identifier() != null) 
				{
					String key = o.getLabel2_Identifier();
					if(label2Keymap.get(key) == null)
					{
						throw new Exception("Import of 'PairedSample' objects failed: cannot find OntologyTerm for label2_Identifier='"+o.getLabel2_Identifier()+"'");
					}
					o.setLabel2_Id(label2Keymap.get(key));
				}
				break;
			}
		}
		
		subject1Keymap.clear();
		label1Keymap.clear();
		subject2Keymap.clear();
		label2Keymap.clear();
		
		return pairedSamplesMissingRefs;
	}
}

