/* File:        org.molgenis.omx/model/ProbeSet.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class ProbeSetJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.xgap.ProbeSet>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ProbeSetJpaMapper.class);

	public ProbeSetJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT ProbeSet.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", ProbeSet.Chromosome"
			+", ProbeSet.cM"
			+", ProbeSet.bpStart"
			+", ProbeSet.bpEnd"
			+", ProbeSet.Seq"
			+", ProbeSet.Symbol"
			//parent is SimpleTree(name='Chromosome')
			+", xref_Chromosome.Identifier AS Chromosome_Identifier"
			+" FROM ProbeSet "
			+" INNER JOIN ObservationTarget ON (ProbeSet.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (ProbeSet.id = Characteristic.id)"

			
			//label for Chromosome=Identifier
//path==Chromosome. type==xref.
//path==Chromosome_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Chromosome " 
			+" ON xref_Chromosome.id = ProbeSet.Chromosome"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.xgap.ProbeSet entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Chromosome' is known in the databse
			if(entity.getChromosome() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getChromosome().getIdValue() == null)
					new org.molgenis.omx.xgap.db.ChromosomeJpaMapper(getDatabase()).create(entity.getChromosome());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getChromosome()) && entity.getChromosome().getIdValue() != null)
					entity.setChromosome(getEntityManager().getReference(org.molgenis.omx.xgap.Chromosome.class, entity.getChromosome().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getChromosome_Id() != null) {
					entity.setChromosome((org.molgenis.omx.xgap.Chromosome)getEntityManager().find(org.molgenis.omx.xgap.Chromosome.class, entity.getChromosome_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.xgap.ProbeSet probeSet) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				probeSet = getEntityManager().getReference(org.molgenis.omx.xgap.ProbeSet.class, probeSet.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The probeSet with id " + probeSet.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(probeSet);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.xgap.ProbeSet probeSet) throws org.molgenis.framework.db.DatabaseException {
		try {







			//7
			org.molgenis.omx.xgap.Chromosome chromosomeNew = probeSet.getChromosome();

			if (chromosomeNew == null) { //object is reference by xref		
                            if(probeSet.getChromosome_Id() != null) {
                                probeSet.setChromosome((org.molgenis.omx.xgap.Chromosome)getEntityManager().find(org.molgenis.omx.xgap.Chromosome.class, probeSet.getChromosome_Id()));
                            }
			}





			if(!getEntityManager().contains(probeSet)) {
				probeSet = getEntityManager().merge(probeSet);
			}
			

		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.xgap.ProbeSet> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.xgap.ProbeSet probeSet : entities) 
			{
				create(probeSet);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.xgap.ProbeSet> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.xgap.ProbeSet probeSet : entities) 
			{
				edit(probeSet);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.xgap.ProbeSet> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.xgap.ProbeSet probeSet : entities) 
			{
				destroy(probeSet);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("ProbeSet_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("ProbeSet_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("ProbeSet_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("ProbeSet___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("ProbeSet_description".equalsIgnoreCase(fieldName)) return "description";
		if("Chromosome".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("ProbeSet_Chromosome".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("cM".equalsIgnoreCase(fieldName)) return "cM";
		if("ProbeSet_cM".equalsIgnoreCase(fieldName)) return "cM";
		if("bpStart".equalsIgnoreCase(fieldName)) return "bpStart";
		if("ProbeSet_bpStart".equalsIgnoreCase(fieldName)) return "bpStart";
		if("bpEnd".equalsIgnoreCase(fieldName)) return "bpEnd";
		if("ProbeSet_bpEnd".equalsIgnoreCase(fieldName)) return "bpEnd";
		if("Seq".equalsIgnoreCase(fieldName)) return "Seq";
		if("ProbeSet_Seq".equalsIgnoreCase(fieldName)) return "Seq";
		if("Symbol".equalsIgnoreCase(fieldName)) return "Symbol";
		if("ProbeSet_Symbol".equalsIgnoreCase(fieldName)) return "Symbol";
		if("Chromosome_id".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("ProbeSet_Chromosome_id".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("Chromosome_Identifier".equalsIgnoreCase(fieldName)) return "Chromosome.Identifier";	
		if("ProbeSet_Chromosome_Identifier".equalsIgnoreCase(fieldName)) return "Chromosome.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.xgap.ProbeSet> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.xgap.ProbeSet>(size);
	}			

	@Override
	public org.molgenis.omx.xgap.ProbeSet create()
	{
		return new org.molgenis.omx.xgap.ProbeSet();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.xgap.ProbeSet> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'chromosome' to chromosome.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> chromosomeRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.xgap.ProbeSet object: entities)
		{
			//create xref/mref rule filtering Chromosome on the label Identifier
			if(object.getChromosome_Id() == null && object.getChromosome_Identifier() != null)
			{
				Object label = object.getChromosome_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!chromosomeRules.containsKey(label))
					{
						chromosomeRules.put(""+label, xrefFilter);
						chromosomeRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'chromosome' to chromosome.id using Identifier)
		final java.util.Map<String,Integer> chromosome_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(chromosomeRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Chromosome> chromosomeList = null;
			try
			{
				chromosomeList = getDatabase().find(org.molgenis.omx.xgap.Chromosome.class, chromosomeRules.values().toArray(new org.molgenis.framework.db.QueryRule[chromosomeRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Chromosome xref :  chromosomeList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				chromosome_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.xgap.ProbeSet object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getChromosome_Id() == null )
			{
					String key = "";
					if(object.getChromosome_Identifier() != null)
						key += 	object.getChromosome_Identifier();
					
					if(!"".equals(key) && chromosome_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Chromosome_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setChromosome_Id(chromosome_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "probeSet.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("chromosome".equalsIgnoreCase(fieldName) || "probeSet.chromosome".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("cM".equalsIgnoreCase(fieldName) || "probeSet.cM".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.DecimalField();
			if("bpStart".equalsIgnoreCase(fieldName) || "probeSet.bpStart".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.LongField();
			if("bpEnd".equalsIgnoreCase(fieldName) || "probeSet.bpEnd".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.LongField();
			if("seq".equalsIgnoreCase(fieldName) || "probeSet.seq".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("symbol".equalsIgnoreCase(fieldName) || "probeSet.symbol".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.xgap.ProbeSet> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.xgap.ProbeSet> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
