/* File:        org.molgenis.omx/model/Protein.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class ProteinJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.xgap.Protein>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ProteinJpaMapper.class);

	public ProteinJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Protein.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Protein.Gene"
			+", Protein.Transcript"
			+", Protein.AminoSequence"
			+", Protein.Mass"
			//parent is SimpleTree(name='Gene')
			+", xref_Gene.Identifier AS Gene_Identifier"
			//parent is SimpleTree(name='Transcript')
			+", xref_Transcript.Identifier AS Transcript_Identifier"
			+" FROM Protein "
			+" INNER JOIN ObservationTarget ON (Protein.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Protein.id = Characteristic.id)"

			
			//label for Gene=Identifier
//path==Gene. type==xref.
//path==Gene_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Gene " 
			+" ON xref_Gene.id = Protein.Gene"
			
			//label for Transcript=Identifier
//path==Transcript. type==xref.
//path==Transcript_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Transcript " 
			+" ON xref_Transcript.id = Protein.Transcript"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.xgap.Protein entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Gene' is known in the databse
			if(entity.getGene() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getGene().getIdValue() == null)
					new org.molgenis.omx.xgap.db.GeneJpaMapper(getDatabase()).create(entity.getGene());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getGene()) && entity.getGene().getIdValue() != null)
					entity.setGene(getEntityManager().getReference(org.molgenis.omx.xgap.Gene.class, entity.getGene().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getGene_Id() != null) {
					entity.setGene((org.molgenis.omx.xgap.Gene)getEntityManager().find(org.molgenis.omx.xgap.Gene.class, entity.getGene_Id()));
				}
			}
			//check if the object refered by 'Transcript' is known in the databse
			if(entity.getTranscript() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getTranscript().getIdValue() == null)
					new org.molgenis.omx.xgap.db.TranscriptJpaMapper(getDatabase()).create(entity.getTranscript());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getTranscript()) && entity.getTranscript().getIdValue() != null)
					entity.setTranscript(getEntityManager().getReference(org.molgenis.omx.xgap.Transcript.class, entity.getTranscript().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getTranscript_Id() != null) {
					entity.setTranscript((org.molgenis.omx.xgap.Transcript)getEntityManager().find(org.molgenis.omx.xgap.Transcript.class, entity.getTranscript_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.xgap.Protein protein) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				protein = getEntityManager().getReference(org.molgenis.omx.xgap.Protein.class, protein.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The protein with id " + protein.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(protein);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.xgap.Protein protein) throws org.molgenis.framework.db.DatabaseException {
		try {







			//3
			org.molgenis.omx.xgap.Gene geneNew = protein.getGene();

			if (geneNew == null) { //object is reference by xref		
                            if(protein.getGene_Id() != null) {
                                protein.setGene((org.molgenis.omx.xgap.Gene)getEntityManager().find(org.molgenis.omx.xgap.Gene.class, protein.getGene_Id()));
                            }
			}


			//1
			org.molgenis.omx.xgap.Transcript transcriptNew = protein.getTranscript();

			if (transcriptNew == null) { //object is reference by xref		
                            if(protein.getTranscript_Id() != null) {
                                protein.setTranscript((org.molgenis.omx.xgap.Transcript)getEntityManager().find(org.molgenis.omx.xgap.Transcript.class, protein.getTranscript_Id()));
                            }
			}


			if(!getEntityManager().contains(protein)) {
				protein = getEntityManager().merge(protein);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.xgap.Protein> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.xgap.Protein protein : entities) 
			{
				create(protein);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.xgap.Protein> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.xgap.Protein protein : entities) 
			{
				edit(protein);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.xgap.Protein> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.xgap.Protein protein : entities) 
			{
				destroy(protein);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Protein_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Protein_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Protein_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Protein___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Protein_description".equalsIgnoreCase(fieldName)) return "description";
		if("Gene".equalsIgnoreCase(fieldName)) return "Gene";
		if("Protein_Gene".equalsIgnoreCase(fieldName)) return "Gene";
		if("Transcript".equalsIgnoreCase(fieldName)) return "Transcript";
		if("Protein_Transcript".equalsIgnoreCase(fieldName)) return "Transcript";
		if("AminoSequence".equalsIgnoreCase(fieldName)) return "AminoSequence";
		if("Protein_AminoSequence".equalsIgnoreCase(fieldName)) return "AminoSequence";
		if("Mass".equalsIgnoreCase(fieldName)) return "Mass";
		if("Protein_Mass".equalsIgnoreCase(fieldName)) return "Mass";
		if("Gene_id".equalsIgnoreCase(fieldName)) return "Gene";
		if("Protein_Gene_id".equalsIgnoreCase(fieldName)) return "Gene";
		if("Gene_Identifier".equalsIgnoreCase(fieldName)) return "Gene.Identifier";	
		if("Protein_Gene_Identifier".equalsIgnoreCase(fieldName)) return "Gene.Identifier";
		if("Transcript_id".equalsIgnoreCase(fieldName)) return "Transcript";
		if("Protein_Transcript_id".equalsIgnoreCase(fieldName)) return "Transcript";
		if("Transcript_Identifier".equalsIgnoreCase(fieldName)) return "Transcript.Identifier";	
		if("Protein_Transcript_Identifier".equalsIgnoreCase(fieldName)) return "Transcript.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.xgap.Protein> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.xgap.Protein>(size);
	}			

	@Override
	public org.molgenis.omx.xgap.Protein create()
	{
		return new org.molgenis.omx.xgap.Protein();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.xgap.Protein> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'gene' to gene.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> geneRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'transcript' to transcript.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> transcriptRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.xgap.Protein object: entities)
		{
			//create xref/mref rule filtering Gene on the label Identifier
			if(object.getGene_Id() == null && object.getGene_Identifier() != null)
			{
				Object label = object.getGene_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!geneRules.containsKey(label))
					{
						geneRules.put(""+label, xrefFilter);
						geneRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Transcript on the label Identifier
			if(object.getTranscript_Id() == null && object.getTranscript_Identifier() != null)
			{
				Object label = object.getTranscript_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!transcriptRules.containsKey(label))
					{
						transcriptRules.put(""+label, xrefFilter);
						transcriptRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'gene' to gene.id using Identifier)
		final java.util.Map<String,Integer> gene_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(geneRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Gene> geneList = null;
			try
			{
				geneList = getDatabase().find(org.molgenis.omx.xgap.Gene.class, geneRules.values().toArray(new org.molgenis.framework.db.QueryRule[geneRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Gene xref :  geneList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				gene_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'transcript' to transcript.id using Identifier)
		final java.util.Map<String,Integer> transcript_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(transcriptRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Transcript> transcriptList = null;
			try
			{
				transcriptList = getDatabase().find(org.molgenis.omx.xgap.Transcript.class, transcriptRules.values().toArray(new org.molgenis.framework.db.QueryRule[transcriptRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Transcript xref :  transcriptList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				transcript_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.xgap.Protein object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getGene_Id() == null )
			{
					String key = "";
					if(object.getGene_Identifier() != null)
						key += 	object.getGene_Identifier();
					
					if(!"".equals(key) && gene_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Gene_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setGene_Id(gene_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getTranscript_Id() == null )
			{
					String key = "";
					if(object.getTranscript_Identifier() != null)
						key += 	object.getTranscript_Identifier();
					
					if(!"".equals(key) && transcript_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Transcript_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setTranscript_Id(transcript_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "protein.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("gene".equalsIgnoreCase(fieldName) || "protein.gene".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("transcript".equalsIgnoreCase(fieldName) || "protein.transcript".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("aminoSequence".equalsIgnoreCase(fieldName) || "protein.aminoSequence".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("mass".equalsIgnoreCase(fieldName) || "protein.mass".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.DecimalField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.xgap.Protein> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.xgap.Protein> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
