
/* File:        org.molgenis.omx/model/SNP_Polymorphism.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Polymorphism;
import org.molgenis.omx.xgap.SNP;
import org.molgenis.omx.xgap.SNP_Polymorphism;


/**
 * Reads SNP_Polymorphism from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class SNP_PolymorphismEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(SNP_PolymorphismEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'polymorphism' (maps polymorphism.Identifier -> polymorphism.id)			
	final Map<String,Integer> polymorphismKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'sNP' (maps sNP.Identifier -> sNP.id)			
	final Map<String,Integer> sNPKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports SNP_Polymorphism from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<SNP_Polymorphism> sNP_PolymorphismsMissingRefs = new ArrayList<SNP_Polymorphism>();
	
		//cache for objects to be imported from file (in batch)
		final List<SNP_Polymorphism> sNP_PolymorphismList = new ArrayList<SNP_Polymorphism>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			SNP_Polymorphism object = new SNP_Polymorphism();
			object.set(entity, false);				
			sNP_PolymorphismList.add(object);		
			
			//add to db when batch size is reached
			if(sNP_PolymorphismList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				sNP_PolymorphismsMissingRefs.addAll(resolveForeignKeys(db, sNP_PolymorphismList));
				sNP_PolymorphismList.removeAll(sNP_PolymorphismsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Polymorphism,SNP' defined in xref_label
				db.update(sNP_PolymorphismList,dbAction, "Polymorphism", "SNP");
				
				//clear for next batch						
				sNP_PolymorphismList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!sNP_PolymorphismList.isEmpty())
		{
			total.set(total.get() + sNP_PolymorphismList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			sNP_PolymorphismsMissingRefs.addAll(resolveForeignKeys(db, sNP_PolymorphismList));
			sNP_PolymorphismList.removeAll(sNP_PolymorphismsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Polymorphism,SNP' defined in xref_label
			db.update(sNP_PolymorphismList,dbAction, "Polymorphism", "SNP");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<SNP_Polymorphism> sNP_Polymorphisms = new ArrayList<SNP_Polymorphism>(sNP_PolymorphismsMissingRefs);

		int iterationCount = 0;

		do
		{
			sNP_PolymorphismsMissingRefs = resolveForeignKeys(db, sNP_PolymorphismsMissingRefs);
			
			LinkedHashSet<SNP_Polymorphism> differenceSet = new LinkedHashSet<SNP_Polymorphism>();
			Sets.symmetricDifference(new LinkedHashSet<SNP_Polymorphism>(sNP_Polymorphisms), new LinkedHashSet<SNP_Polymorphism>(sNP_PolymorphismsMissingRefs)).copyInto(differenceSet);
			List<SNP_Polymorphism> resolvablesNP_Polymorphisms = new ArrayList<SNP_Polymorphism>(differenceSet);
			
			sNP_Polymorphisms.removeAll(resolvablesNP_Polymorphisms);
			
			db.update(resolvablesNP_Polymorphisms,dbAction, "Polymorphism", "SNP");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(SNP_Polymorphism blaat : sNP_PolymorphismsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'sNP_Polymorphism' entity failed:"
								+ "This is probably caused by a(n) 'sNP_Polymorphism' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (sNP_PolymorphismsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " sNP_Polymorphism from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param sNP_PolymorphismList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<SNP_Polymorphism> resolveForeignKeys(Database db, List<SNP_Polymorphism> sNP_PolymorphismList) throws Exception
	{
		//keep a list of SNP_Polymorphism instances that miss a reference which might be resolvable later
		List<SNP_Polymorphism> sNP_PolymorphismsMissingRefs = new ArrayList<SNP_Polymorphism>();
	
		//resolve xref 'polymorphism' from polymorphism.Identifier -> polymorphism.id
		for(SNP_Polymorphism o: sNP_PolymorphismList) 
		{
			if(o.getPolymorphism_Identifier() != null) 
				polymorphismKeymap.put(o.getPolymorphism_Identifier(), null);
		}
		
		if(polymorphismKeymap.size() > 0) 
		{
			List<Polymorphism> polymorphismList = db.query(Polymorphism.class).in("Identifier",new ArrayList<Object>(polymorphismKeymap.keySet())).find();
			for(Polymorphism xref :  polymorphismList)
			{
				polymorphismKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'sNP' from sNP.Identifier -> sNP.id
		for(SNP_Polymorphism o: sNP_PolymorphismList) 
		{
			if(o.getSNP_Identifier() != null) 
				sNPKeymap.put(o.getSNP_Identifier(), null);
		}
		
		if(sNPKeymap.size() > 0) 
		{
			List<SNP> sNPList = db.query(SNP.class).in("Identifier",new ArrayList<Object>(sNPKeymap.keySet())).find();
			for(SNP xref :  sNPList)
			{
				sNPKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(SNP_Polymorphism o:  sNP_PolymorphismList)
		{
			while(true){
				//update xref Polymorphism
				if(o.getPolymorphism_Identifier() != null) 
				{
					String key = o.getPolymorphism_Identifier();
					if(polymorphismKeymap.get(key) == null)
					{
						throw new Exception("Import of 'SNP_Polymorphism' objects failed: cannot find Polymorphism for polymorphism_Identifier='"+o.getPolymorphism_Identifier()+"'");
					}
					o.setPolymorphism_Id(polymorphismKeymap.get(key));
				}
				//update xref SNP
				if(o.getSNP_Identifier() != null) 
				{
					String key = o.getSNP_Identifier();
					if(sNPKeymap.get(key) == null)
					{
						throw new Exception("Import of 'SNP_Polymorphism' objects failed: cannot find SNP for sNP_Identifier='"+o.getSNP_Identifier()+"'");
					}
					o.setSNP_Id(sNPKeymap.get(key));
				}
				break;
			}
		}
		
		polymorphismKeymap.clear();
		sNPKeymap.clear();
		
		return sNP_PolymorphismsMissingRefs;
	}
}

