
/* File:        org.molgenis.omx/model/Sample.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.Individual;
import org.molgenis.omx.observ.target.OntologyTerm;
import org.molgenis.omx.xgap.Sample;


/**
 * Reads Sample from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class SampleEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(SampleEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'individual' (maps individual.Identifier -> individual.id)			
	final Map<String,Integer> individualKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'tissue' (maps ontologyTerm.Identifier -> ontologyTerm.id)			
	final Map<String,Integer> tissueKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Sample from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Sample> samplesMissingRefs = new ArrayList<Sample>();
	
		//cache for objects to be imported from file (in batch)
		final List<Sample> sampleList = new ArrayList<Sample>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Sample object = new Sample();
			object.set(entity, false);				
			sampleList.add(object);		
			
			//add to db when batch size is reached
			if(sampleList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				samplesMissingRefs.addAll(resolveForeignKeys(db, sampleList));
				sampleList.removeAll(samplesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(sampleList,dbAction, "Identifier");
				
				//clear for next batch						
				sampleList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!sampleList.isEmpty())
		{
			total.set(total.get() + sampleList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			samplesMissingRefs.addAll(resolveForeignKeys(db, sampleList));
			sampleList.removeAll(samplesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(sampleList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Sample> samples = new ArrayList<Sample>(samplesMissingRefs);

		int iterationCount = 0;

		do
		{
			samplesMissingRefs = resolveForeignKeys(db, samplesMissingRefs);
			
			LinkedHashSet<Sample> differenceSet = new LinkedHashSet<Sample>();
			Sets.symmetricDifference(new LinkedHashSet<Sample>(samples), new LinkedHashSet<Sample>(samplesMissingRefs)).copyInto(differenceSet);
			List<Sample> resolvablesamples = new ArrayList<Sample>(differenceSet);
			
			samples.removeAll(resolvablesamples);
			
			db.update(resolvablesamples,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Sample blaat : samplesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'sample' entity failed:"
								+ "This is probably caused by a(n) 'sample' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (samplesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " sample from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param sampleList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Sample> resolveForeignKeys(Database db, List<Sample> sampleList) throws Exception
	{
		//keep a list of Sample instances that miss a reference which might be resolvable later
		List<Sample> samplesMissingRefs = new ArrayList<Sample>();
	
		//resolve xref 'individual' from individual.Identifier -> individual.id
		for(Sample o: sampleList) 
		{
			if(o.getIndividual_Identifier() != null) 
				individualKeymap.put(o.getIndividual_Identifier(), null);
		}
		
		if(individualKeymap.size() > 0) 
		{
			List<Individual> individualList = db.query(Individual.class).in("Identifier",new ArrayList<Object>(individualKeymap.keySet())).find();
			for(Individual xref :  individualList)
			{
				individualKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'tissue' from ontologyTerm.Identifier -> ontologyTerm.id
		for(Sample o: sampleList) 
		{
			if(o.getTissue_Identifier() != null) 
				tissueKeymap.put(o.getTissue_Identifier(), null);
		}
		
		if(tissueKeymap.size() > 0) 
		{
			List<OntologyTerm> tissueList = db.query(OntologyTerm.class).in("Identifier",new ArrayList<Object>(tissueKeymap.keySet())).find();
			for(OntologyTerm xref :  tissueList)
			{
				tissueKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Sample o:  sampleList)
		{
			while(true){
				//update xref Individual
				if(o.getIndividual_Identifier() != null) 
				{
					String key = o.getIndividual_Identifier();
					if(individualKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Sample' objects failed: cannot find Individual for individual_Identifier='"+o.getIndividual_Identifier()+"'");
					}
					o.setIndividual_Id(individualKeymap.get(key));
				}
				//update xref Tissue
				if(o.getTissue_Identifier() != null) 
				{
					String key = o.getTissue_Identifier();
					if(tissueKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Sample' objects failed: cannot find OntologyTerm for tissue_Identifier='"+o.getTissue_Identifier()+"'");
					}
					o.setTissue_Id(tissueKeymap.get(key));
				}
				break;
			}
		}
		
		individualKeymap.clear();
		tissueKeymap.clear();
		
		return samplesMissingRefs;
	}
}

