/* File:        org.molgenis.omx/model/Transcript.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class TranscriptJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.xgap.Transcript>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(TranscriptJpaMapper.class);

	public TranscriptJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Transcript.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Transcript.Gene"
			//parent is SimpleTree(name='Gene')
			+", xref_Gene.Identifier AS Gene_Identifier"
			+" FROM Transcript "
			+" INNER JOIN ObservationTarget ON (Transcript.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Transcript.id = Characteristic.id)"

			
			//label for Gene=Identifier
//path==Gene. type==xref.
//path==Gene_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Gene " 
			+" ON xref_Gene.id = Transcript.Gene"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.xgap.Transcript entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Gene' is known in the databse
			if(entity.getGene() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getGene().getIdValue() == null)
					new org.molgenis.omx.xgap.db.GeneJpaMapper(getDatabase()).create(entity.getGene());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getGene()) && entity.getGene().getIdValue() != null)
					entity.setGene(getEntityManager().getReference(org.molgenis.omx.xgap.Gene.class, entity.getGene().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getGene_Id() != null) {
					entity.setGene((org.molgenis.omx.xgap.Gene)getEntityManager().find(org.molgenis.omx.xgap.Gene.class, entity.getGene_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.xgap.Transcript transcript) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				transcript = getEntityManager().getReference(org.molgenis.omx.xgap.Transcript.class, transcript.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The transcript with id " + transcript.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(transcript);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.xgap.Transcript transcript) throws org.molgenis.framework.db.DatabaseException {
		try {







			//3
			org.molgenis.omx.xgap.Gene geneNew = transcript.getGene();

			if (geneNew == null) { //object is reference by xref		
                            if(transcript.getGene_Id() != null) {
                                transcript.setGene((org.molgenis.omx.xgap.Gene)getEntityManager().find(org.molgenis.omx.xgap.Gene.class, transcript.getGene_Id()));
                            }
			}
			if(!getEntityManager().contains(transcript)) {
				transcript = getEntityManager().merge(transcript);
			}
			

		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.xgap.Transcript> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.xgap.Transcript transcript : entities) 
			{
				create(transcript);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.xgap.Transcript> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.xgap.Transcript transcript : entities) 
			{
				edit(transcript);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.xgap.Transcript> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.xgap.Transcript transcript : entities) 
			{
				destroy(transcript);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Transcript_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Transcript_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Transcript_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Transcript___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Transcript_description".equalsIgnoreCase(fieldName)) return "description";
		if("Gene".equalsIgnoreCase(fieldName)) return "Gene";
		if("Transcript_Gene".equalsIgnoreCase(fieldName)) return "Gene";
		if("Gene_id".equalsIgnoreCase(fieldName)) return "Gene";
		if("Transcript_Gene_id".equalsIgnoreCase(fieldName)) return "Gene";
		if("Gene_Identifier".equalsIgnoreCase(fieldName)) return "Gene.Identifier";	
		if("Transcript_Gene_Identifier".equalsIgnoreCase(fieldName)) return "Gene.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.xgap.Transcript> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.xgap.Transcript>(size);
	}			

	@Override
	public org.molgenis.omx.xgap.Transcript create()
	{
		return new org.molgenis.omx.xgap.Transcript();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.xgap.Transcript> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'gene' to gene.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> geneRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.xgap.Transcript object: entities)
		{
			//create xref/mref rule filtering Gene on the label Identifier
			if(object.getGene_Id() == null && object.getGene_Identifier() != null)
			{
				Object label = object.getGene_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!geneRules.containsKey(label))
					{
						geneRules.put(""+label, xrefFilter);
						geneRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'gene' to gene.id using Identifier)
		final java.util.Map<String,Integer> gene_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(geneRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Gene> geneList = null;
			try
			{
				geneList = getDatabase().find(org.molgenis.omx.xgap.Gene.class, geneRules.values().toArray(new org.molgenis.framework.db.QueryRule[geneRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Gene xref :  geneList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				gene_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.xgap.Transcript object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getGene_Id() == null )
			{
					String key = "";
					if(object.getGene_Identifier() != null)
						key += 	object.getGene_Identifier();
					
					if(!"".equals(key) && gene_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Gene_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setGene_Id(gene_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "transcript.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("gene".equalsIgnoreCase(fieldName) || "transcript.gene".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.xgap.Transcript> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.xgap.Transcript> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
