/* File:        org.molgenis.omx/model/Variant.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class VariantJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.xgap.Variant>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(VariantJpaMapper.class);

	public VariantJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Variant.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Variant.Description"
			+", Variant.Chromosome"
			+", Variant.cM"
			+", Variant.bpStart"
			+", Variant.bpEnd"
			+", Variant.Seq"
			+", Variant.Symbol"
			+", Variant.MutationPosition"
			+", Variant.CdnaPosition"
			+", Variant.AaPosition"
			+", Variant.VariantLength"
			+", Variant.Event"
			+", Variant.NtChange"
			+", Variant.Codonchange"
			+", Variant.CdnaNotation"
			+", Variant.GdnaNotation"
			+", Variant.AaNotation"
			+", Variant.Exon"
			+", Variant.Consequence"
			+", Variant.Inheritance"
			+", Variant.ReportedSNP"
			+", Variant.EffectOnSplicing"
			+", Variant.Pathogenicity"
			+", Variant.Gene"
			+", Variant.IdMutation"
			+", Variant.DetailsForMutation"
			+", Variant.Track"
			//parent is SimpleTree(name='Chromosome')
			+", xref_Chromosome.Identifier AS Chromosome_Identifier"
			//parent is SimpleTree(name='Track')
			+", xref_Track.Identifier AS Track_Identifier"
			+" FROM Variant "
			+" INNER JOIN ObservationTarget ON (Variant.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Variant.id = Characteristic.id)"

			
			//label for Chromosome=Identifier
//path==Chromosome. type==xref.
//path==Chromosome_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Chromosome " 
			+" ON xref_Chromosome.id = Variant.Chromosome"
			
			//label for Track=Identifier
//path==Track. type==xref.
//path==Track_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Track " 
			+" ON xref_Track.id = Variant.Track"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.xgap.Variant entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Chromosome' is known in the databse
			if(entity.getChromosome() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getChromosome().getIdValue() == null)
					new org.molgenis.omx.xgap.db.ChromosomeJpaMapper(getDatabase()).create(entity.getChromosome());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getChromosome()) && entity.getChromosome().getIdValue() != null)
					entity.setChromosome(getEntityManager().getReference(org.molgenis.omx.xgap.Chromosome.class, entity.getChromosome().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getChromosome_Id() != null) {
					entity.setChromosome((org.molgenis.omx.xgap.Chromosome)getEntityManager().find(org.molgenis.omx.xgap.Chromosome.class, entity.getChromosome_Id()));
				}
			}
			//check if the object refered by 'Track' is known in the databse
			if(entity.getTrack() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getTrack().getIdValue() == null)
					new org.molgenis.omx.xgap.db.TrackJpaMapper(getDatabase()).create(entity.getTrack());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getTrack()) && entity.getTrack().getIdValue() != null)
					entity.setTrack(getEntityManager().getReference(org.molgenis.omx.xgap.Track.class, entity.getTrack().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getTrack_Id() != null) {
					entity.setTrack((org.molgenis.omx.xgap.Track)getEntityManager().find(org.molgenis.omx.xgap.Track.class, entity.getTrack_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.xgap.Variant variant) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				variant = getEntityManager().getReference(org.molgenis.omx.xgap.Variant.class, variant.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The variant with id " + variant.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(variant);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.xgap.Variant variant) throws org.molgenis.framework.db.DatabaseException {
		try {







			//7
			org.molgenis.omx.xgap.Chromosome chromosomeNew = variant.getChromosome();

			if (chromosomeNew == null) { //object is reference by xref		
                            if(variant.getChromosome_Id() != null) {
                                variant.setChromosome((org.molgenis.omx.xgap.Chromosome)getEntityManager().find(org.molgenis.omx.xgap.Chromosome.class, variant.getChromosome_Id()));
                            }
			}


























			//1
			org.molgenis.omx.xgap.Track trackNew = variant.getTrack();

			if (trackNew == null) { //object is reference by xref		
                            if(variant.getTrack_Id() != null) {
                                variant.setTrack((org.molgenis.omx.xgap.Track)getEntityManager().find(org.molgenis.omx.xgap.Track.class, variant.getTrack_Id()));
                            }
			}
			if(!getEntityManager().contains(variant)) {
				variant = getEntityManager().merge(variant);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.xgap.Variant> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.xgap.Variant variant : entities) 
			{
				create(variant);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.xgap.Variant> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.xgap.Variant variant : entities) 
			{
				edit(variant);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.xgap.Variant> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.xgap.Variant variant : entities) 
			{
				destroy(variant);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Variant_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Variant_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Variant_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Variant___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Description".equalsIgnoreCase(fieldName)) return "Description";
		if("Variant_Description".equalsIgnoreCase(fieldName)) return "Description";
		if("Chromosome".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("Variant_Chromosome".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("cM".equalsIgnoreCase(fieldName)) return "cM";
		if("Variant_cM".equalsIgnoreCase(fieldName)) return "cM";
		if("bpStart".equalsIgnoreCase(fieldName)) return "bpStart";
		if("Variant_bpStart".equalsIgnoreCase(fieldName)) return "bpStart";
		if("bpEnd".equalsIgnoreCase(fieldName)) return "bpEnd";
		if("Variant_bpEnd".equalsIgnoreCase(fieldName)) return "bpEnd";
		if("Seq".equalsIgnoreCase(fieldName)) return "Seq";
		if("Variant_Seq".equalsIgnoreCase(fieldName)) return "Seq";
		if("Symbol".equalsIgnoreCase(fieldName)) return "Symbol";
		if("Variant_Symbol".equalsIgnoreCase(fieldName)) return "Symbol";
		if("MutationPosition".equalsIgnoreCase(fieldName)) return "MutationPosition";
		if("Variant_MutationPosition".equalsIgnoreCase(fieldName)) return "MutationPosition";
		if("CdnaPosition".equalsIgnoreCase(fieldName)) return "CdnaPosition";
		if("Variant_CdnaPosition".equalsIgnoreCase(fieldName)) return "CdnaPosition";
		if("AaPosition".equalsIgnoreCase(fieldName)) return "AaPosition";
		if("Variant_AaPosition".equalsIgnoreCase(fieldName)) return "AaPosition";
		if("VariantLength".equalsIgnoreCase(fieldName)) return "VariantLength";
		if("Variant_VariantLength".equalsIgnoreCase(fieldName)) return "VariantLength";
		if("Event".equalsIgnoreCase(fieldName)) return "Event";
		if("Variant_Event".equalsIgnoreCase(fieldName)) return "Event";
		if("NtChange".equalsIgnoreCase(fieldName)) return "NtChange";
		if("Variant_NtChange".equalsIgnoreCase(fieldName)) return "NtChange";
		if("Codonchange".equalsIgnoreCase(fieldName)) return "Codonchange";
		if("Variant_Codonchange".equalsIgnoreCase(fieldName)) return "Codonchange";
		if("CdnaNotation".equalsIgnoreCase(fieldName)) return "CdnaNotation";
		if("Variant_CdnaNotation".equalsIgnoreCase(fieldName)) return "CdnaNotation";
		if("GdnaNotation".equalsIgnoreCase(fieldName)) return "GdnaNotation";
		if("Variant_GdnaNotation".equalsIgnoreCase(fieldName)) return "GdnaNotation";
		if("AaNotation".equalsIgnoreCase(fieldName)) return "AaNotation";
		if("Variant_AaNotation".equalsIgnoreCase(fieldName)) return "AaNotation";
		if("Exon".equalsIgnoreCase(fieldName)) return "Exon";
		if("Variant_Exon".equalsIgnoreCase(fieldName)) return "Exon";
		if("Consequence".equalsIgnoreCase(fieldName)) return "Consequence";
		if("Variant_Consequence".equalsIgnoreCase(fieldName)) return "Consequence";
		if("Inheritance".equalsIgnoreCase(fieldName)) return "Inheritance";
		if("Variant_Inheritance".equalsIgnoreCase(fieldName)) return "Inheritance";
		if("ReportedSNP".equalsIgnoreCase(fieldName)) return "ReportedSNP";
		if("Variant_ReportedSNP".equalsIgnoreCase(fieldName)) return "ReportedSNP";
		if("EffectOnSplicing".equalsIgnoreCase(fieldName)) return "EffectOnSplicing";
		if("Variant_EffectOnSplicing".equalsIgnoreCase(fieldName)) return "EffectOnSplicing";
		if("Pathogenicity".equalsIgnoreCase(fieldName)) return "Pathogenicity";
		if("Variant_Pathogenicity".equalsIgnoreCase(fieldName)) return "Pathogenicity";
		if("Gene".equalsIgnoreCase(fieldName)) return "Gene";
		if("Variant_Gene".equalsIgnoreCase(fieldName)) return "Gene";
		if("IdMutation".equalsIgnoreCase(fieldName)) return "IdMutation";
		if("Variant_IdMutation".equalsIgnoreCase(fieldName)) return "IdMutation";
		if("DetailsForMutation".equalsIgnoreCase(fieldName)) return "DetailsForMutation";
		if("Variant_DetailsForMutation".equalsIgnoreCase(fieldName)) return "DetailsForMutation";
		if("Track".equalsIgnoreCase(fieldName)) return "Track";
		if("Variant_Track".equalsIgnoreCase(fieldName)) return "Track";
		if("Chromosome_id".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("Variant_Chromosome_id".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("Chromosome_Identifier".equalsIgnoreCase(fieldName)) return "Chromosome.Identifier";	
		if("Variant_Chromosome_Identifier".equalsIgnoreCase(fieldName)) return "Chromosome.Identifier";
		if("Track_id".equalsIgnoreCase(fieldName)) return "Track";
		if("Variant_Track_id".equalsIgnoreCase(fieldName)) return "Track";
		if("Track_Identifier".equalsIgnoreCase(fieldName)) return "Track.Identifier";	
		if("Variant_Track_Identifier".equalsIgnoreCase(fieldName)) return "Track.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.xgap.Variant> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.xgap.Variant>(size);
	}			

	@Override
	public org.molgenis.omx.xgap.Variant create()
	{
		return new org.molgenis.omx.xgap.Variant();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.xgap.Variant> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'chromosome' to chromosome.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> chromosomeRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'track' to track.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> trackRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.xgap.Variant object: entities)
		{
			//create xref/mref rule filtering Chromosome on the label Identifier
			if(object.getChromosome_Id() == null && object.getChromosome_Identifier() != null)
			{
				Object label = object.getChromosome_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!chromosomeRules.containsKey(label))
					{
						chromosomeRules.put(""+label, xrefFilter);
						chromosomeRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Track on the label Identifier
			if(object.getTrack_Id() == null && object.getTrack_Identifier() != null)
			{
				Object label = object.getTrack_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!trackRules.containsKey(label))
					{
						trackRules.put(""+label, xrefFilter);
						trackRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'chromosome' to chromosome.id using Identifier)
		final java.util.Map<String,Integer> chromosome_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(chromosomeRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Chromosome> chromosomeList = null;
			try
			{
				chromosomeList = getDatabase().find(org.molgenis.omx.xgap.Chromosome.class, chromosomeRules.values().toArray(new org.molgenis.framework.db.QueryRule[chromosomeRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Chromosome xref :  chromosomeList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				chromosome_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'track' to track.id using Identifier)
		final java.util.Map<String,Integer> track_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(trackRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Track> trackList = null;
			try
			{
				trackList = getDatabase().find(org.molgenis.omx.xgap.Track.class, trackRules.values().toArray(new org.molgenis.framework.db.QueryRule[trackRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Track xref :  trackList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				track_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.xgap.Variant object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getChromosome_Id() == null )
			{
					String key = "";
					if(object.getChromosome_Identifier() != null)
						key += 	object.getChromosome_Identifier();
					
					if(!"".equals(key) && chromosome_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Chromosome_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setChromosome_Id(chromosome_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getTrack_Id() == null )
			{
					String key = "";
					if(object.getTrack_Identifier() != null)
						key += 	object.getTrack_Identifier();
					
					if(!"".equals(key) && track_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Track_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setTrack_Id(track_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "variant.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "variant.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("chromosome".equalsIgnoreCase(fieldName) || "variant.chromosome".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("cM".equalsIgnoreCase(fieldName) || "variant.cM".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.DecimalField();
			if("bpStart".equalsIgnoreCase(fieldName) || "variant.bpStart".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.LongField();
			if("bpEnd".equalsIgnoreCase(fieldName) || "variant.bpEnd".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.LongField();
			if("seq".equalsIgnoreCase(fieldName) || "variant.seq".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("symbol".equalsIgnoreCase(fieldName) || "variant.symbol".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("mutationPosition".equalsIgnoreCase(fieldName) || "variant.mutationPosition".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("cdnaPosition".equalsIgnoreCase(fieldName) || "variant.cdnaPosition".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("aaPosition".equalsIgnoreCase(fieldName) || "variant.aaPosition".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("variantLength".equalsIgnoreCase(fieldName) || "variant.variantLength".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("event".equalsIgnoreCase(fieldName) || "variant.event".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("ntChange".equalsIgnoreCase(fieldName) || "variant.ntChange".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("codonchange".equalsIgnoreCase(fieldName) || "variant.codonchange".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("cdnaNotation".equalsIgnoreCase(fieldName) || "variant.cdnaNotation".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("gdnaNotation".equalsIgnoreCase(fieldName) || "variant.gdnaNotation".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("aaNotation".equalsIgnoreCase(fieldName) || "variant.aaNotation".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("exon".equalsIgnoreCase(fieldName) || "variant.exon".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("consequence".equalsIgnoreCase(fieldName) || "variant.consequence".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("inheritance".equalsIgnoreCase(fieldName) || "variant.inheritance".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("reportedSNP".equalsIgnoreCase(fieldName) || "variant.reportedSNP".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
			if("effectOnSplicing".equalsIgnoreCase(fieldName) || "variant.effectOnSplicing".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
			if("pathogenicity".equalsIgnoreCase(fieldName) || "variant.pathogenicity".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("gene".equalsIgnoreCase(fieldName) || "variant.gene".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("idMutation".equalsIgnoreCase(fieldName) || "variant.idMutation".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("detailsForMutation".equalsIgnoreCase(fieldName) || "variant.detailsForMutation".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.HyperlinkField();
			if("track".equalsIgnoreCase(fieldName) || "variant.track".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.xgap.Variant> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.xgap.Variant> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
