package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.DerivedTrait;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class DerivedTraitService
{
	private static final Logger logger = Logger.getLogger(DerivedTraitService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DERIVEDTRAIT')")
	public DerivedTrait create(DerivedTrait derivedTrait) throws DatabaseException
	{
		logger.debug("creating DerivedTrait");
		db.add(derivedTrait);
		return derivedTrait;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DERIVEDTRAIT')")
	public DerivedTrait read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving DerivedTrait");
		return db.findById(DerivedTrait.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DERIVEDTRAIT')")
	public void update(DerivedTrait derivedTrait) throws DatabaseException
	{
		logger.debug("updating DerivedTrait");
		db.update(derivedTrait);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_DERIVEDTRAIT')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting DerivedTrait");
		DerivedTrait derivedTrait = db.findById(DerivedTrait.class, id);
		return db.remove(derivedTrait) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DERIVEDTRAIT')")
	public Iterable<DerivedTrait> readAll() throws DatabaseException
	{
		logger.debug("retrieving all DerivedTrait instances");
		return db.find(DerivedTrait.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DERIVEDTRAIT')")
	public EntityPager<DerivedTrait> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all DerivedTrait instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(DerivedTrait.class, queryRules.toArray(new QueryRule[0]));
		List<DerivedTrait> derivedTraitCollection = db.find(DerivedTrait.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<DerivedTrait>(start, num, count, derivedTraitCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_DERIVEDTRAIT')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("DerivedTrait");
	}
}