package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Gene;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class GeneService
{
	private static final Logger logger = Logger.getLogger(GeneService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_GENE')")
	public Gene create(Gene gene) throws DatabaseException
	{
		logger.debug("creating Gene");
		db.add(gene);
		return gene;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_GENE')")
	public Gene read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Gene");
		return db.findById(Gene.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_GENE')")
	public void update(Gene gene) throws DatabaseException
	{
		logger.debug("updating Gene");
		db.update(gene);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_GENE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Gene");
		Gene gene = db.findById(Gene.class, id);
		return db.remove(gene) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_GENE')")
	public Iterable<Gene> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Gene instances");
		return db.find(Gene.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_GENE')")
	public EntityPager<Gene> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Gene instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Gene.class, queryRules.toArray(new QueryRule[0]));
		List<Gene> geneCollection = db.find(Gene.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Gene>(start, num, count, geneCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_GENE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Gene");
	}
}