package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Marker;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MarkerService
{
	private static final Logger logger = Logger.getLogger(MarkerService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MARKER')")
	public Marker create(Marker marker) throws DatabaseException
	{
		logger.debug("creating Marker");
		db.add(marker);
		return marker;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MARKER')")
	public Marker read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Marker");
		return db.findById(Marker.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MARKER')")
	public void update(Marker marker) throws DatabaseException
	{
		logger.debug("updating Marker");
		db.update(marker);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MARKER')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Marker");
		Marker marker = db.findById(Marker.class, id);
		return db.remove(marker) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MARKER')")
	public Iterable<Marker> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Marker instances");
		return db.find(Marker.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MARKER')")
	public EntityPager<Marker> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Marker instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Marker.class, queryRules.toArray(new QueryRule[0]));
		List<Marker> markerCollection = db.find(Marker.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Marker>(start, num, count, markerCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MARKER')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Marker");
	}
}