package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.NMRBin;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class NMRBinService
{
	private static final Logger logger = Logger.getLogger(NMRBinService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_NMRBIN')")
	public NMRBin create(NMRBin nMRBin) throws DatabaseException
	{
		logger.debug("creating NMRBin");
		db.add(nMRBin);
		return nMRBin;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_NMRBIN')")
	public NMRBin read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving NMRBin");
		return db.findById(NMRBin.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_NMRBIN')")
	public void update(NMRBin nMRBin) throws DatabaseException
	{
		logger.debug("updating NMRBin");
		db.update(nMRBin);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_NMRBIN')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting NMRBin");
		NMRBin nMRBin = db.findById(NMRBin.class, id);
		return db.remove(nMRBin) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_NMRBIN')")
	public Iterable<NMRBin> readAll() throws DatabaseException
	{
		logger.debug("retrieving all NMRBin instances");
		return db.find(NMRBin.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_NMRBIN')")
	public EntityPager<NMRBin> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all NMRBin instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(NMRBin.class, queryRules.toArray(new QueryRule[0]));
		List<NMRBin> nMRBinCollection = db.find(NMRBin.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<NMRBin>(start, num, count, nMRBinCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_NMRBIN')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("NMRBin");
	}
}