package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.patient.Patient;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PatientService
{
	private static final Logger logger = Logger.getLogger(PatientService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PATIENT')")
	public Patient create(Patient patient) throws DatabaseException
	{
		logger.debug("creating Patient");
		db.add(patient);
		return patient;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PATIENT')")
	public Patient read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Patient");
		return db.findById(Patient.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PATIENT')")
	public void update(Patient patient) throws DatabaseException
	{
		logger.debug("updating Patient");
		db.update(patient);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PATIENT')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Patient");
		Patient patient = db.findById(Patient.class, id);
		return db.remove(patient) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PATIENT')")
	public Iterable<Patient> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Patient instances");
		return db.find(Patient.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PATIENT')")
	public EntityPager<Patient> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Patient instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Patient.class, queryRules.toArray(new QueryRule[0]));
		List<Patient> patientCollection = db.find(Patient.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Patient>(start, num, count, patientCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PATIENT')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Patient");
	}
}