package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Protein;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ProteinService
{
	private static final Logger logger = Logger.getLogger(ProteinService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROTEIN')")
	public Protein create(Protein protein) throws DatabaseException
	{
		logger.debug("creating Protein");
		db.add(protein);
		return protein;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROTEIN')")
	public Protein read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Protein");
		return db.findById(Protein.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROTEIN')")
	public void update(Protein protein) throws DatabaseException
	{
		logger.debug("updating Protein");
		db.update(protein);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_PROTEIN')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Protein");
		Protein protein = db.findById(Protein.class, id);
		return db.remove(protein) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROTEIN')")
	public Iterable<Protein> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Protein instances");
		return db.find(Protein.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROTEIN')")
	public EntityPager<Protein> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Protein instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Protein.class, queryRules.toArray(new QueryRule[0]));
		List<Protein> proteinCollection = db.find(Protein.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Protein>(start, num, count, proteinCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_PROTEIN')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Protein");
	}
}