package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Track;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class TrackService
{
	private static final Logger logger = Logger.getLogger(TrackService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TRACK')")
	public Track create(Track track) throws DatabaseException
	{
		logger.debug("creating Track");
		db.add(track);
		return track;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TRACK')")
	public Track read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Track");
		return db.findById(Track.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TRACK')")
	public void update(Track track) throws DatabaseException
	{
		logger.debug("updating Track");
		db.update(track);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TRACK')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Track");
		Track track = db.findById(Track.class, id);
		return db.remove(track) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TRACK')")
	public Iterable<Track> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Track instances");
		return db.find(Track.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TRACK')")
	public EntityPager<Track> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Track instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Track.class, queryRules.toArray(new QueryRule[0]));
		List<Track> trackCollection = db.find(Track.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Track>(start, num, count, trackCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TRACK')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Track");
	}
}