package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Transcript;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class TranscriptService
{
	private static final Logger logger = Logger.getLogger(TranscriptService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TRANSCRIPT')")
	public Transcript create(Transcript transcript) throws DatabaseException
	{
		logger.debug("creating Transcript");
		db.add(transcript);
		return transcript;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TRANSCRIPT')")
	public Transcript read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Transcript");
		return db.findById(Transcript.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TRANSCRIPT')")
	public void update(Transcript transcript) throws DatabaseException
	{
		logger.debug("updating Transcript");
		db.update(transcript);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_TRANSCRIPT')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Transcript");
		Transcript transcript = db.findById(Transcript.class, id);
		return db.remove(transcript) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TRANSCRIPT')")
	public Iterable<Transcript> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Transcript instances");
		return db.find(Transcript.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TRANSCRIPT')")
	public EntityPager<Transcript> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Transcript instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Transcript.class, queryRules.toArray(new QueryRule[0]));
		List<Transcript> transcriptCollection = db.find(Transcript.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Transcript>(start, num, count, transcriptCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_TRANSCRIPT')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Transcript");
	}
}