
/* File:        org.molgenis.omx/model/Patient.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.patient.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.observ.target.Individual;
import org.molgenis.omx.xgap.Variant;
import org.molgenis.omx.patient.Patient;


/**
 * Reads Patient from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class PatientEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(PatientEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'mother' (maps individual.Identifier -> individual.id)			
	final Map<String,Integer> motherKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'father' (maps individual.Identifier -> individual.id)			
	final Map<String,Integer> fatherKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'allele1' (maps variant.Identifier -> variant.id)			
	final Map<String,Integer> allele1Keymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'allele2' (maps variant.Identifier -> variant.id)			
	final Map<String,Integer> allele2Keymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Patient from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Patient> patientsMissingRefs = new ArrayList<Patient>();
	
		//cache for objects to be imported from file (in batch)
		final List<Patient> patientList = new ArrayList<Patient>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Patient object = new Patient();
			object.set(entity, false);				
			patientList.add(object);		
			
			//add to db when batch size is reached
			if(patientList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				patientsMissingRefs.addAll(resolveForeignKeys(db, patientList));
				patientList.removeAll(patientsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(patientList,dbAction, "Identifier");
				
				//clear for next batch						
				patientList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!patientList.isEmpty())
		{
			total.set(total.get() + patientList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			patientsMissingRefs.addAll(resolveForeignKeys(db, patientList));
			patientList.removeAll(patientsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(patientList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Patient> patients = new ArrayList<Patient>(patientsMissingRefs);

		int iterationCount = 0;

		do
		{
			patientsMissingRefs = resolveForeignKeys(db, patientsMissingRefs);
			
			LinkedHashSet<Patient> differenceSet = new LinkedHashSet<Patient>();
			Sets.symmetricDifference(new LinkedHashSet<Patient>(patients), new LinkedHashSet<Patient>(patientsMissingRefs)).copyInto(differenceSet);
			List<Patient> resolvablepatients = new ArrayList<Patient>(differenceSet);
			
			patients.removeAll(resolvablepatients);
			
			db.update(resolvablepatients,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Patient blaat : patientsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'patient' entity failed:"
								+ "This is probably caused by a(n) 'patient' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (patientsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " patient from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param patientList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Patient> resolveForeignKeys(Database db, List<Patient> patientList) throws Exception
	{
		//keep a list of Patient instances that miss a reference which might be resolvable later
		List<Patient> patientsMissingRefs = new ArrayList<Patient>();
	
		//resolve xref 'mother' from individual.Identifier -> individual.id
		for(Patient o: patientList) 
		{
			if(o.getMother_Identifier() != null) 
				motherKeymap.put(o.getMother_Identifier(), null);
		}
		
		if(motherKeymap.size() > 0) 
		{
			List<Individual> motherList = db.query(Individual.class).in("Identifier",new ArrayList<Object>(motherKeymap.keySet())).find();
			for(Individual xref :  motherList)
			{
				motherKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'father' from individual.Identifier -> individual.id
		for(Patient o: patientList) 
		{
			if(o.getFather_Identifier() != null) 
				fatherKeymap.put(o.getFather_Identifier(), null);
		}
		
		if(fatherKeymap.size() > 0) 
		{
			List<Individual> fatherList = db.query(Individual.class).in("Identifier",new ArrayList<Object>(fatherKeymap.keySet())).find();
			for(Individual xref :  fatherList)
			{
				fatherKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'allele1' from variant.Identifier -> variant.id
		for(Patient o: patientList) 
		{
			if(o.getAllele1_Identifier() != null) 
				allele1Keymap.put(o.getAllele1_Identifier(), null);
		}
		
		if(allele1Keymap.size() > 0) 
		{
			List<Variant> allele1List = db.query(Variant.class).in("Identifier",new ArrayList<Object>(allele1Keymap.keySet())).find();
			for(Variant xref :  allele1List)
			{
				allele1Keymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'allele2' from variant.Identifier -> variant.id
		for(Patient o: patientList) 
		{
			if(o.getAllele2_Identifier() != null) 
				allele2Keymap.put(o.getAllele2_Identifier(), null);
		}
		
		if(allele2Keymap.size() > 0) 
		{
			List<Variant> allele2List = db.query(Variant.class).in("Identifier",new ArrayList<Object>(allele2Keymap.keySet())).find();
			for(Variant xref :  allele2List)
			{
				allele2Keymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Patient o:  patientList)
		{
			while(true){
				//update xref Mother
				if(o.getMother_Identifier() != null) 
				{
					String key = o.getMother_Identifier();
					if(motherKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Patient' objects failed: cannot find Individual for mother_Identifier='"+o.getMother_Identifier()+"'");
					}
					o.setMother_Id(motherKeymap.get(key));
				}
				//update xref Father
				if(o.getFather_Identifier() != null) 
				{
					String key = o.getFather_Identifier();
					if(fatherKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Patient' objects failed: cannot find Individual for father_Identifier='"+o.getFather_Identifier()+"'");
					}
					o.setFather_Id(fatherKeymap.get(key));
				}
				//update xref Allele1
				if(o.getAllele1_Identifier() != null) 
				{
					String key = o.getAllele1_Identifier();
					if(allele1Keymap.get(key) == null)
					{
						throw new Exception("Import of 'Patient' objects failed: cannot find Variant for allele1_Identifier='"+o.getAllele1_Identifier()+"'");
					}
					o.setAllele1_Id(allele1Keymap.get(key));
				}
				//update xref Allele2
				if(o.getAllele2_Identifier() != null) 
				{
					String key = o.getAllele2_Identifier();
					if(allele2Keymap.get(key) == null)
					{
						throw new Exception("Import of 'Patient' objects failed: cannot find Variant for allele2_Identifier='"+o.getAllele2_Identifier()+"'");
					}
					o.setAllele2_Id(allele2Keymap.get(key));
				}
				break;
			}
		}
		
		motherKeymap.clear();
		fatherKeymap.clear();
		allele1Keymap.clear();
		allele2Keymap.clear();
		
		return patientsMissingRefs;
	}
}

