/* File:        org.molgenis.omx/model/Patient.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.patient.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class PatientJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.patient.Patient>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PatientJpaMapper.class);

	public PatientJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Patient.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Individual.Mother"
			+", Individual.Father"
			+", Patient.Allele1"
			+", Patient.Allele2"
			+", Patient.Pheno"
			+", Patient.PubMedID"
			+", Patient.Reference"
			//parent is SimpleTree(name='Mother')
			+", xref_Mother.Identifier AS Mother_Identifier"
			//parent is SimpleTree(name='Father')
			+", xref_Father.Identifier AS Father_Identifier"
			//parent is SimpleTree(name='Allele1')
			+", xref_Allele1.Identifier AS Allele1_Identifier"
			//parent is SimpleTree(name='Allele2')
			+", xref_Allele2.Identifier AS Allele2_Identifier"
			+" FROM Patient "
			+" INNER JOIN Individual ON (Patient.id = Individual.id)"
			+" INNER JOIN ObservationTarget ON (Patient.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Patient.id = Characteristic.id)"

			
			//label for Mother=Identifier
//path==Mother. type==xref.
//path==Mother_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Mother " 
			+" ON xref_Mother.id = Individual.Mother"
			
			//label for Father=Identifier
//path==Father. type==xref.
//path==Father_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Father " 
			+" ON xref_Father.id = Individual.Father"
			
			//label for Allele1=Identifier
//path==Allele1. type==xref.
//path==Allele1_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Allele1 " 
			+" ON xref_Allele1.id = Patient.Allele1"
			
			//label for Allele2=Identifier
//path==Allele2. type==xref.
//path==Allele2_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Allele2 " 
			+" ON xref_Allele2.id = Patient.Allele2"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.patient.Patient entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Mother' is known in the databse
			if(entity.getMother() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getMother().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.IndividualJpaMapper(getDatabase()).create(entity.getMother());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getMother()) && entity.getMother().getIdValue() != null)
					entity.setMother(getEntityManager().getReference(org.molgenis.omx.observ.target.Individual.class, entity.getMother().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getMother_Id() != null) {
					entity.setMother((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, entity.getMother_Id()));
				}
			}
			//check if the object refered by 'Father' is known in the databse
			if(entity.getFather() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getFather().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.IndividualJpaMapper(getDatabase()).create(entity.getFather());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getFather()) && entity.getFather().getIdValue() != null)
					entity.setFather(getEntityManager().getReference(org.molgenis.omx.observ.target.Individual.class, entity.getFather().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getFather_Id() != null) {
					entity.setFather((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, entity.getFather_Id()));
				}
			}
			//check if the object refered by 'Allele1' is known in the databse
			if(entity.getAllele1() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getAllele1().getIdValue() == null)
					new org.molgenis.omx.xgap.db.VariantJpaMapper(getDatabase()).create(entity.getAllele1());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getAllele1()) && entity.getAllele1().getIdValue() != null)
					entity.setAllele1(getEntityManager().getReference(org.molgenis.omx.xgap.Variant.class, entity.getAllele1().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getAllele1_Id() != null) {
					entity.setAllele1((org.molgenis.omx.xgap.Variant)getEntityManager().find(org.molgenis.omx.xgap.Variant.class, entity.getAllele1_Id()));
				}
			}
			//check if the object refered by 'Allele2' is known in the databse
			if(entity.getAllele2() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getAllele2().getIdValue() == null)
					new org.molgenis.omx.xgap.db.VariantJpaMapper(getDatabase()).create(entity.getAllele2());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getAllele2()) && entity.getAllele2().getIdValue() != null)
					entity.setAllele2(getEntityManager().getReference(org.molgenis.omx.xgap.Variant.class, entity.getAllele2().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getAllele2_Id() != null) {
					entity.setAllele2((org.molgenis.omx.xgap.Variant)getEntityManager().find(org.molgenis.omx.xgap.Variant.class, entity.getAllele2_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.patient.Patient patient) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				patient = getEntityManager().getReference(org.molgenis.omx.patient.Patient.class, patient.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The patient with id " + patient.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(patient);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.patient.Patient patient) throws org.molgenis.framework.db.DatabaseException {
		try {







			//6
			org.molgenis.omx.observ.target.Individual motherNew = patient.getMother();

			if (motherNew == null) { //object is reference by xref		
                            if(patient.getMother_Id() != null) {
                                patient.setMother((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, patient.getMother_Id()));
                            }
			}


			//6
			org.molgenis.omx.observ.target.Individual fatherNew = patient.getFather();

			if (fatherNew == null) { //object is reference by xref		
                            if(patient.getFather_Id() != null) {
                                patient.setFather((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, patient.getFather_Id()));
                            }
			}


			//2
			org.molgenis.omx.xgap.Variant allele1New = patient.getAllele1();

			if (allele1New == null) { //object is reference by xref		
                            if(patient.getAllele1_Id() != null) {
                                patient.setAllele1((org.molgenis.omx.xgap.Variant)getEntityManager().find(org.molgenis.omx.xgap.Variant.class, patient.getAllele1_Id()));
                            }
			}


			//2
			org.molgenis.omx.xgap.Variant allele2New = patient.getAllele2();

			if (allele2New == null) { //object is reference by xref		
                            if(patient.getAllele2_Id() != null) {
                                patient.setAllele2((org.molgenis.omx.xgap.Variant)getEntityManager().find(org.molgenis.omx.xgap.Variant.class, patient.getAllele2_Id()));
                            }
			}



			if(!getEntityManager().contains(patient)) {
				patient = getEntityManager().merge(patient);
			}
			




		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.patient.Patient> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.patient.Patient patient : entities) 
			{
				create(patient);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.patient.Patient> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.patient.Patient patient : entities) 
			{
				edit(patient);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.patient.Patient> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.patient.Patient patient : entities) 
			{
				destroy(patient);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Patient_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Patient_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Patient_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Patient___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Patient_description".equalsIgnoreCase(fieldName)) return "description";
		if("Mother".equalsIgnoreCase(fieldName)) return "Mother";
		if("Patient_Mother".equalsIgnoreCase(fieldName)) return "Mother";
		if("Father".equalsIgnoreCase(fieldName)) return "Father";
		if("Patient_Father".equalsIgnoreCase(fieldName)) return "Father";
		if("Allele1".equalsIgnoreCase(fieldName)) return "Allele1";
		if("Patient_Allele1".equalsIgnoreCase(fieldName)) return "Allele1";
		if("Allele2".equalsIgnoreCase(fieldName)) return "Allele2";
		if("Patient_Allele2".equalsIgnoreCase(fieldName)) return "Allele2";
		if("Pheno".equalsIgnoreCase(fieldName)) return "Pheno";
		if("Patient_Pheno".equalsIgnoreCase(fieldName)) return "Pheno";
		if("PubMedID".equalsIgnoreCase(fieldName)) return "PubMedID";
		if("Patient_PubMedID".equalsIgnoreCase(fieldName)) return "PubMedID";
		if("Reference".equalsIgnoreCase(fieldName)) return "Reference";
		if("Patient_Reference".equalsIgnoreCase(fieldName)) return "Reference";
		if("Mother_id".equalsIgnoreCase(fieldName)) return "Mother";
		if("Patient_Mother_id".equalsIgnoreCase(fieldName)) return "Mother";
		if("Mother_Identifier".equalsIgnoreCase(fieldName)) return "Mother.Identifier";	
		if("Patient_Mother_Identifier".equalsIgnoreCase(fieldName)) return "Mother.Identifier";
		if("Father_id".equalsIgnoreCase(fieldName)) return "Father";
		if("Patient_Father_id".equalsIgnoreCase(fieldName)) return "Father";
		if("Father_Identifier".equalsIgnoreCase(fieldName)) return "Father.Identifier";	
		if("Patient_Father_Identifier".equalsIgnoreCase(fieldName)) return "Father.Identifier";
		if("Allele1_id".equalsIgnoreCase(fieldName)) return "Allele1";
		if("Patient_Allele1_id".equalsIgnoreCase(fieldName)) return "Allele1";
		if("Allele1_Identifier".equalsIgnoreCase(fieldName)) return "Allele1.Identifier";	
		if("Patient_Allele1_Identifier".equalsIgnoreCase(fieldName)) return "Allele1.Identifier";
		if("Allele2_id".equalsIgnoreCase(fieldName)) return "Allele2";
		if("Patient_Allele2_id".equalsIgnoreCase(fieldName)) return "Allele2";
		if("Allele2_Identifier".equalsIgnoreCase(fieldName)) return "Allele2.Identifier";	
		if("Patient_Allele2_Identifier".equalsIgnoreCase(fieldName)) return "Allele2.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.patient.Patient> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.patient.Patient>(size);
	}			

	@Override
	public org.molgenis.omx.patient.Patient create()
	{
		return new org.molgenis.omx.patient.Patient();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.patient.Patient> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'mother' to individual.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> motherRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'father' to individual.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> fatherRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'allele1' to variant.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> allele1Rules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'allele2' to variant.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> allele2Rules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.patient.Patient object: entities)
		{
			//create xref/mref rule filtering Individual on the label Identifier
			if(object.getMother_Id() == null && object.getMother_Identifier() != null)
			{
				Object label = object.getMother_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!motherRules.containsKey(label))
					{
						motherRules.put(""+label, xrefFilter);
						motherRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Individual on the label Identifier
			if(object.getFather_Id() == null && object.getFather_Identifier() != null)
			{
				Object label = object.getFather_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!fatherRules.containsKey(label))
					{
						fatherRules.put(""+label, xrefFilter);
						fatherRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Variant on the label Identifier
			if(object.getAllele1_Id() == null && object.getAllele1_Identifier() != null)
			{
				Object label = object.getAllele1_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!allele1Rules.containsKey(label))
					{
						allele1Rules.put(""+label, xrefFilter);
						allele1Rules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Variant on the label Identifier
			if(object.getAllele2_Id() == null && object.getAllele2_Identifier() != null)
			{
				Object label = object.getAllele2_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!allele2Rules.containsKey(label))
					{
						allele2Rules.put(""+label, xrefFilter);
						allele2Rules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'mother' to individual.id using Identifier)
		final java.util.Map<String,Integer> mother_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(motherRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.Individual> motherList = null;
			try
			{
				motherList = getDatabase().find(org.molgenis.omx.observ.target.Individual.class, motherRules.values().toArray(new org.molgenis.framework.db.QueryRule[motherRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.Individual xref :  motherList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				mother_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'father' to individual.id using Identifier)
		final java.util.Map<String,Integer> father_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(fatherRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.Individual> fatherList = null;
			try
			{
				fatherList = getDatabase().find(org.molgenis.omx.observ.target.Individual.class, fatherRules.values().toArray(new org.molgenis.framework.db.QueryRule[fatherRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.Individual xref :  fatherList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				father_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'allele1' to variant.id using Identifier)
		final java.util.Map<String,Integer> allele1_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(allele1Rules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Variant> allele1List = null;
			try
			{
				allele1List = getDatabase().find(org.molgenis.omx.xgap.Variant.class, allele1Rules.values().toArray(new org.molgenis.framework.db.QueryRule[allele1Rules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Variant xref :  allele1List)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				allele1_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'allele2' to variant.id using Identifier)
		final java.util.Map<String,Integer> allele2_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(allele2Rules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Variant> allele2List = null;
			try
			{
				allele2List = getDatabase().find(org.molgenis.omx.xgap.Variant.class, allele2Rules.values().toArray(new org.molgenis.framework.db.QueryRule[allele2Rules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Variant xref :  allele2List)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				allele2_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.patient.Patient object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getMother_Id() == null )
			{
					String key = "";
					if(object.getMother_Identifier() != null)
						key += 	object.getMother_Identifier();
					
					if(!"".equals(key) && mother_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Mother_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setMother_Id(mother_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getFather_Id() == null )
			{
					String key = "";
					if(object.getFather_Identifier() != null)
						key += 	object.getFather_Identifier();
					
					if(!"".equals(key) && father_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Father_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setFather_Id(father_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getAllele1_Id() == null )
			{
					String key = "";
					if(object.getAllele1_Identifier() != null)
						key += 	object.getAllele1_Identifier();
					
					if(!"".equals(key) && allele1_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Allele1_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setAllele1_Id(allele1_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getAllele2_Id() == null )
			{
					String key = "";
					if(object.getAllele2_Identifier() != null)
						key += 	object.getAllele2_Identifier();
					
					if(!"".equals(key) && allele2_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Allele2_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setAllele2_Id(allele2_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "patient.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("mother".equalsIgnoreCase(fieldName) || "individual.mother".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("father".equalsIgnoreCase(fieldName) || "individual.father".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("allele1".equalsIgnoreCase(fieldName) || "patient.allele1".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("allele2".equalsIgnoreCase(fieldName) || "patient.allele2".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("pheno".equalsIgnoreCase(fieldName) || "patient.pheno".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("pubMedID".equalsIgnoreCase(fieldName) || "patient.pubMedID".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("reference".equalsIgnoreCase(fieldName) || "patient.reference".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.patient.Patient> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.patient.Patient> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
