
/* File:        org.molgenis.omx/model/Probe.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

/**
 * Probe:  A piece of sequence that reports for the expression of
				a gene, typically spotted onto a microarray..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Probe"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.xgap.db.ProbeEntityListener.class})
public class Probe extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.omx.xgap.Locus
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String CHROMOSOME = "Chromosome";
	public final static String CHROMOSOME_IDENTIFIER = "Chromosome_Identifier";
	public final static String CM = "cM";
	public final static String BPSTART = "bpStart";
	public final static String BPEND = "bpEnd";
	public final static String SEQ = "Seq";
	public final static String SYMBOL = "Symbol";
	public final static String MISMATCH = "Mismatch";
	public final static String PROBESET = "ProbeSet";
	public final static String PROBESET_IDENTIFIER = "ProbeSet_Identifier";
	public final static String REPORTSFOR = "ReportsFor";
	public final static String REPORTSFOR_IDENTIFIER = "ReportsFor_Identifier";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(Probe.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Probe> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Probe.class);
	}
	
	/**
	 * Shorthand for db.find(Probe.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Probe> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Probe.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Probe findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Probe> q = db.query(Probe.class);
		q = q.eq(Probe.ID, id);
		java.util.List<Probe> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Probe findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Probe> q = db.query(Probe.class);
		q = q.eq(Probe.IDENTIFIER, identifier);
		java.util.List<Probe> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//Reference to the chromosome this     position belongs to.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Chromosome")   	
	
				

	private org.molgenis.omx.xgap.Chromosome chromosome = null;
	@javax.persistence.Transient
	private Integer chromosome_id = null;	
	@javax.persistence.Transient
	private String chromosome_Identifier = null;						

	//genetic map position in centi morgan (cM).[type=decimal]
	@javax.persistence.Column(name="cM")
	@javax.xml.bind.annotation.XmlElement(name="cM")
	
				

	private Double cM =  null;

	//numeric basepair postion (5') on the chromosome[type=long]
	@javax.persistence.Column(name="bpStart")
	@javax.xml.bind.annotation.XmlElement(name="bpStart")
	
				

	private Long bpStart =  null;

	//numeric basepair postion (3') on the chromosome[type=long]
	@javax.persistence.Column(name="bpEnd")
	@javax.xml.bind.annotation.XmlElement(name="bpEnd")
	
				

	private Long bpEnd =  null;

	//The FASTA text representation of the sequence.[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="Seq")
	
				

	private String seq =  null;

	//todo[type=string]
	@javax.persistence.Column(name="Symbol", length=255)
	@javax.xml.bind.annotation.XmlElement(name="symbol")
	
				

	private String symbol =  null;

	//Indicating whether the probe is a match[type=bool]
	@javax.persistence.Column(name="Mismatch", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="mismatch")
	
				

	@javax.validation.constraints.NotNull
	private Boolean mismatch =  false;

	//Optional: probeset this probe belongs to (e.g., in Affymetrix assays).[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ProbeSet")   	
	
				

	private org.molgenis.omx.xgap.ProbeSet probeSet = null;
	@javax.persistence.Transient
	private Integer probeSet_id = null;	
	@javax.persistence.Transient
	private String probeSet_Identifier = null;						

	//The gene this probe reports for.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="ReportsFor")   	
	
				

	private org.molgenis.omx.xgap.Gene reportsFor = null;
	@javax.persistence.Transient
	private Integer reportsFor_id = null;	
	@javax.persistence.Transient
	private String reportsFor_Identifier = null;						

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public Probe()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public Probe(Probe copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the Reference to the chromosome this     position belongs to..
	 * @return chromosome.
	 */
	public org.molgenis.omx.xgap.Chromosome getChromosome()
	{
		return this.chromosome;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Chromosome getChromosome(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Reference to the chromosome this     position belongs to..
	 * @param chromosome
	 */
	public void setChromosome( org.molgenis.omx.xgap.Chromosome chromosome)
	{
		
		this.chromosome = chromosome;
	}

	
	
	/**
	 * Set foreign key for field chromosome.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setChromosome_Id(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}	

	public void setChromosome(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}
	
	public Integer getChromosome_Id()
	{
		
		if(chromosome != null) 
		{
			return chromosome.getId();
		}
		else
		{
			return chromosome_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Chromosome to Chromosome.Id.
	 */
	public String getChromosome_Identifier()
	{		
		//FIXME should we auto-load based on getChromosome()?	
		if(chromosome != null) {
			return chromosome.getIdentifier();
		} else {
			return chromosome_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Chromosome to <a href="Chromosome.html#Id">Chromosome.Id</a>.
	 * Implies setChromosome(null) until save
	 */
	public void setChromosome_Identifier(String chromosome_Identifier)
	{
		this.chromosome_Identifier = chromosome_Identifier;
	}		
	 
	

	/**
	 * Get the genetic map position in centi morgan (cM)..
	 * @return cM.
	 */
	public Double getCM()
	{
		return this.cM;
	}
	
	@Deprecated
	public Double getCM(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the genetic map position in centi morgan (cM)..
	 * @param cM
	 */
	public void setCM( Double cM)
	{
		
		this.cM = cM;
	}

	

	/**
	 * Get the numeric basepair postion (5') on the chromosome.
	 * @return bpStart.
	 */
	public Long getBpStart()
	{
		return this.bpStart;
	}
	
	@Deprecated
	public Long getBpStart(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (5') on the chromosome.
	 * @param bpStart
	 */
	public void setBpStart( Long bpStart)
	{
		
		this.bpStart = bpStart;
	}

	

	/**
	 * Get the numeric basepair postion (3') on the chromosome.
	 * @return bpEnd.
	 */
	public Long getBpEnd()
	{
		return this.bpEnd;
	}
	
	@Deprecated
	public Long getBpEnd(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (3') on the chromosome.
	 * @param bpEnd
	 */
	public void setBpEnd( Long bpEnd)
	{
		
		this.bpEnd = bpEnd;
	}

	

	/**
	 * Get the The FASTA text representation of the sequence..
	 * @return seq.
	 */
	public String getSeq()
	{
		return this.seq;
	}
	
	@Deprecated
	public String getSeq(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The FASTA text representation of the sequence..
	 * @param seq
	 */
	public void setSeq( String seq)
	{
		
		this.seq = seq;
	}

	

	/**
	 * Get the todo.
	 * @return symbol.
	 */
	public String getSymbol()
	{
		return this.symbol;
	}
	
	@Deprecated
	public String getSymbol(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the todo.
	 * @param symbol
	 */
	public void setSymbol( String symbol)
	{
		
		this.symbol = symbol;
	}

	

	/**
	 * Get the Indicating whether the probe is a match.
	 * @return mismatch.
	 */
	public Boolean getMismatch()
	{
		return this.mismatch;
	}
	
	@Deprecated
	public Boolean getMismatch(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Indicating whether the probe is a match.
	 * @param mismatch
	 */
	public void setMismatch( Boolean mismatch)
	{
		
		this.mismatch = mismatch;
	}

	

	/**
	 * Get the Optional: probeset this probe belongs to (e.g., in Affymetrix assays)..
	 * @return probeSet.
	 */
	public org.molgenis.omx.xgap.ProbeSet getProbeSet()
	{
		return this.probeSet;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.ProbeSet getProbeSet(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Optional: probeset this probe belongs to (e.g., in Affymetrix assays)..
	 * @param probeSet
	 */
	public void setProbeSet( org.molgenis.omx.xgap.ProbeSet probeSet)
	{
		
		this.probeSet = probeSet;
	}

	
	
	/**
	 * Set foreign key for field probeSet.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setProbeSet_Id(Integer probeSet_id)
	{
		this.probeSet_id = probeSet_id;
	}	

	public void setProbeSet(Integer probeSet_id)
	{
		this.probeSet_id = probeSet_id;
	}
	
	public Integer getProbeSet_Id()
	{
		
		if(probeSet != null) 
		{
			return probeSet.getId();
		}
		else
		{
			return probeSet_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference ProbeSet to ProbeSet.Id.
	 */
	public String getProbeSet_Identifier()
	{		
		//FIXME should we auto-load based on getProbeSet()?	
		if(probeSet != null) {
			return probeSet.getIdentifier();
		} else {
			return probeSet_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ProbeSet to <a href="ProbeSet.html#Id">ProbeSet.Id</a>.
	 * Implies setProbeSet(null) until save
	 */
	public void setProbeSet_Identifier(String probeSet_Identifier)
	{
		this.probeSet_Identifier = probeSet_Identifier;
	}		
	 
	

	/**
	 * Get the The gene this probe reports for..
	 * @return reportsFor.
	 */
	public org.molgenis.omx.xgap.Gene getReportsFor()
	{
		return this.reportsFor;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Gene getReportsFor(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The gene this probe reports for..
	 * @param reportsFor
	 */
	public void setReportsFor( org.molgenis.omx.xgap.Gene reportsFor)
	{
		
		this.reportsFor = reportsFor;
	}

	
	
	/**
	 * Set foreign key for field reportsFor.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setReportsFor_Id(Integer reportsFor_id)
	{
		this.reportsFor_id = reportsFor_id;
	}	

	public void setReportsFor(Integer reportsFor_id)
	{
		this.reportsFor_id = reportsFor_id;
	}
	
	public Integer getReportsFor_Id()
	{
		
		if(reportsFor != null) 
		{
			return reportsFor.getId();
		}
		else
		{
			return reportsFor_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference ReportsFor to Gene.Id.
	 */
	public String getReportsFor_Identifier()
	{		
		//FIXME should we auto-load based on getReportsFor()?	
		if(reportsFor != null) {
			return reportsFor.getIdentifier();
		} else {
			return reportsFor_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference ReportsFor to <a href="Gene.html#Id">Gene.Id</a>.
	 * Implies setReportsFor(null) until save
	 */
	public void setReportsFor_Identifier(String reportsFor_Identifier)
	{
		this.reportsFor_Identifier = reportsFor_Identifier;
	}		
	 
	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if(name.equals("chromosome_id"))
			return getChromosome_Id();
		if(name.equals("chromosome_identifier"))
			return getChromosome_Identifier();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		if (name.equals("mismatch"))
			return getMismatch();
		if (name.equals("probeset"))
			return getProbeSet();
		if(name.equals("probeset_id"))
			return getProbeSet_Id();
		if(name.equals("probeset_identifier"))
			return getProbeSet_Identifier();
		if (name.equals("reportsfor"))
			return getReportsFor();
		if(name.equals("reportsfor_id"))
			return getReportsFor_Id();
		if(name.equals("reportsfor_identifier"))
			return getReportsFor_Identifier();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
		if(this.getMismatch() == null) throw new org.molgenis.framework.db.DatabaseException("required field mismatch is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("probe_id") != null) this.setId(entity.getInt("probe_id"));
		else if( entity.getInt("Probe_id") != null) this.setId(entity.getInt("Probe_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("probe_identifier") != null) this.setIdentifier(entity.getString("probe_identifier"));
		else if( entity.getString("Probe_Identifier") != null) this.setIdentifier(entity.getString("Probe_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("probe_name") != null) this.setName(entity.getString("probe_name"));
		else if( entity.getString("Probe_Name") != null) this.setName(entity.getString("Probe_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("probe___type") != null) this.set__Type(entity.getString("probe___type"));
		else if( entity.getString("Probe___Type") != null) this.set__Type(entity.getString("Probe___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("probe_description") != null) this.setDescription(entity.getString("probe_description"));
		else if( entity.getString("Probe_description") != null) this.setDescription(entity.getString("Probe_description"));
		//set Chromosome
		// query formal name, else lowercase name
		if(entity.getInt("Chromosome_id") != null) this.setChromosome(entity.getInt("Chromosome_id"));
		else if(entity.getInt("chromosome_id") != null) this.setChromosome(entity.getInt("chromosome_id"));
		else if(strict) this.setChromosome(entity.getInt("Chromosome_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Probe_Chromosome_id") != null) this.setChromosome(entity.getInt("Probe_Chromosome_id"));
		else if( entity.getInt("probe_chromosome_id") != null) this.setChromosome(entity.getInt("probe_chromosome_id"));
		//alias of xref
		if( entity.get("Chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome")); 
			}
		}
		else if( entity.get("chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome"));
			}
		}
		if( entity.get("Probe_Chromosome") != null)
			this.setChromosome_Id(entity.getInt("Probe_Chromosome"));			
		else if( entity.get("probe_chromosome") != null)
			this.setChromosome_Id(entity.getInt("probe_chromosome"));
			
		if( entity.get("Probe.Chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Probe.Chromosome_id"));
		else if( entity.get("probe.chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("probe.chromosome_id"));	
		//set label for field Chromosome
		if(entity.get("Chromosome_Identifier") != null) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier"));
		else if(entity.get("chromosome_identifier") != null) this.setChromosome_Identifier(entity.getString("chromosome_identifier"));
		else if(strict) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Probe_Chromosome_Identifier") != null ) this.setChromosome_Identifier(entity.getString("Probe_Chromosome_Identifier"));		
		else if( entity.get("probe_chromosome_identifier") != null ) this.setChromosome_Identifier(entity.getString("probe_chromosome_identifier"));
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("probe_cm") != null) this.setCM(entity.getDouble("probe_cm"));
		else if( entity.getDouble("Probe_cM") != null) this.setCM(entity.getDouble("Probe_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("probe_bpstart") != null) this.setBpStart(entity.getLong("probe_bpstart"));
		else if( entity.getLong("Probe_bpStart") != null) this.setBpStart(entity.getLong("Probe_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("probe_bpend") != null) this.setBpEnd(entity.getLong("probe_bpend"));
		else if( entity.getLong("Probe_bpEnd") != null) this.setBpEnd(entity.getLong("Probe_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("probe_seq") != null) this.setSeq(entity.getString("probe_seq"));
		else if( entity.getString("Probe_Seq") != null) this.setSeq(entity.getString("Probe_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("probe_symbol") != null) this.setSymbol(entity.getString("probe_symbol"));
		else if( entity.getString("Probe_Symbol") != null) this.setSymbol(entity.getString("Probe_Symbol"));
		//set Mismatch
		// query formal name, else lowercase name
		if(entity.getBoolean("mismatch") != null) this.setMismatch(entity.getBoolean("mismatch"));
		else if(entity.getBoolean("Mismatch") != null) this.setMismatch(entity.getBoolean("Mismatch"));
		else if(strict) this.setMismatch(entity.getBoolean("mismatch")); // setting null is not an option due to function overloading
		if( entity.getBoolean("probe_mismatch") != null) this.setMismatch(entity.getBoolean("probe_mismatch"));
		else if( entity.getBoolean("Probe_Mismatch") != null) this.setMismatch(entity.getBoolean("Probe_Mismatch"));
		//set ProbeSet
		// query formal name, else lowercase name
		if(entity.getInt("ProbeSet_id") != null) this.setProbeSet(entity.getInt("ProbeSet_id"));
		else if(entity.getInt("probeset_id") != null) this.setProbeSet(entity.getInt("probeset_id"));
		else if(strict) this.setProbeSet(entity.getInt("ProbeSet_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Probe_ProbeSet_id") != null) this.setProbeSet(entity.getInt("Probe_ProbeSet_id"));
		else if( entity.getInt("probe_probeset_id") != null) this.setProbeSet(entity.getInt("probe_probeset_id"));
		//alias of xref
		if( entity.get("ProbeSet") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("ProbeSet").toString())) {
				org.molgenis.omx.xgap.ProbeSet instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("ProbeSet"), org.molgenis.omx.xgap.ProbeSet.class);
				this.setProbeSet(instance);				
			} else {
				this.setProbeSet_Id(entity.getInt("ProbeSet")); 
			}
		}
		else if( entity.get("probeset") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("probeset").toString())) {
				org.molgenis.omx.xgap.ProbeSet instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("probeset"), org.molgenis.omx.xgap.ProbeSet.class);
				this.setProbeSet(instance);				
			} else {
				this.setProbeSet_Id(entity.getInt("ProbeSet"));
			}
		}
		if( entity.get("Probe_ProbeSet") != null)
			this.setProbeSet_Id(entity.getInt("Probe_ProbeSet"));			
		else if( entity.get("probe_probeset") != null)
			this.setProbeSet_Id(entity.getInt("probe_probeset"));
			
		if( entity.get("Probe.ProbeSet") != null) 
			this.setProbeSet((org.molgenis.omx.xgap.ProbeSet)entity.get("Probe.ProbeSet_id"));
		else if( entity.get("probe.probeset") != null) 
			this.setProbeSet((org.molgenis.omx.xgap.ProbeSet)entity.get("probe.probeset_id"));	
		//set label for field ProbeSet
		if(entity.get("ProbeSet_Identifier") != null) this.setProbeSet_Identifier(entity.getString("ProbeSet_Identifier"));
		else if(entity.get("probeset_identifier") != null) this.setProbeSet_Identifier(entity.getString("probeset_identifier"));
		else if(strict) this.setProbeSet_Identifier(entity.getString("ProbeSet_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Probe_ProbeSet_Identifier") != null ) this.setProbeSet_Identifier(entity.getString("Probe_ProbeSet_Identifier"));		
		else if( entity.get("probe_probeset_identifier") != null ) this.setProbeSet_Identifier(entity.getString("probe_probeset_identifier"));
		//set ReportsFor
		// query formal name, else lowercase name
		if(entity.getInt("ReportsFor_id") != null) this.setReportsFor(entity.getInt("ReportsFor_id"));
		else if(entity.getInt("reportsfor_id") != null) this.setReportsFor(entity.getInt("reportsfor_id"));
		else if(strict) this.setReportsFor(entity.getInt("ReportsFor_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Probe_ReportsFor_id") != null) this.setReportsFor(entity.getInt("Probe_ReportsFor_id"));
		else if( entity.getInt("probe_reportsfor_id") != null) this.setReportsFor(entity.getInt("probe_reportsfor_id"));
		//alias of xref
		if( entity.get("ReportsFor") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("ReportsFor").toString())) {
				org.molgenis.omx.xgap.Gene instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("ReportsFor"), org.molgenis.omx.xgap.Gene.class);
				this.setReportsFor(instance);				
			} else {
				this.setReportsFor_Id(entity.getInt("ReportsFor")); 
			}
		}
		else if( entity.get("reportsfor") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("reportsfor").toString())) {
				org.molgenis.omx.xgap.Gene instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("reportsfor"), org.molgenis.omx.xgap.Gene.class);
				this.setReportsFor(instance);				
			} else {
				this.setReportsFor_Id(entity.getInt("ReportsFor"));
			}
		}
		if( entity.get("Probe_ReportsFor") != null)
			this.setReportsFor_Id(entity.getInt("Probe_ReportsFor"));			
		else if( entity.get("probe_reportsfor") != null)
			this.setReportsFor_Id(entity.getInt("probe_reportsfor"));
			
		if( entity.get("Probe.ReportsFor") != null) 
			this.setReportsFor((org.molgenis.omx.xgap.Gene)entity.get("Probe.ReportsFor_id"));
		else if( entity.get("probe.reportsfor") != null) 
			this.setReportsFor((org.molgenis.omx.xgap.Gene)entity.get("probe.reportsfor_id"));	
		//set label for field ReportsFor
		if(entity.get("ReportsFor_Identifier") != null) this.setReportsFor_Identifier(entity.getString("ReportsFor_Identifier"));
		else if(entity.get("reportsfor_identifier") != null) this.setReportsFor_Identifier(entity.getString("reportsfor_identifier"));
		else if(strict) this.setReportsFor_Identifier(entity.getString("ReportsFor_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Probe_ReportsFor_Identifier") != null ) this.setReportsFor_Identifier(entity.getString("Probe_ReportsFor_Identifier"));		
		else if( entity.get("probe_reportsfor_identifier") != null ) this.setReportsFor_Identifier(entity.getString("probe_reportsfor_identifier"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Probe(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " chromosome_id='" + getChromosome_Id()+"' ";	
		result+= " chromosome_identifier='" + getChromosome_Identifier()+"' ";
		result+= "cM='" + getCM()+"' ";	
		result+= "bpStart='" + getBpStart()+"' ";	
		result+= "bpEnd='" + getBpEnd()+"' ";	
		result+= "seq='" + getSeq()+"' ";	
		result+= "symbol='" + getSymbol()+"' ";	
		result+= "mismatch='" + getMismatch()+"' ";	
		result+= " probeSet_id='" + getProbeSet_Id()+"' ";	
		result+= " probeSet_identifier='" + getProbeSet_Identifier()+"' ";
		result+= " reportsFor_id='" + getReportsFor_Id()+"' ";	
		result+= " reportsFor_identifier='" + getReportsFor_Identifier()+"' ";
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Probe.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("Chromosome_id");
		}
		fields.add("Chromosome_Identifier");
		{
			fields.add("cM");
		}
		{
			fields.add("bpStart");
		}
		{
			fields.add("bpEnd");
		}
		{
			fields.add("Seq");
		}
		{
			fields.add("Symbol");
		}
		{
			fields.add("Mismatch");
		}
		{
			fields.add("ProbeSet_id");
		}
		fields.add("ProbeSet_Identifier");
		{
			fields.add("ReportsFor_id");
		}
		fields.add("ReportsFor_Identifier");
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "chromosome" +sep
		+ "cM" +sep
		+ "bpStart" +sep
		+ "bpEnd" +sep
		+ "seq" +sep
		+ "symbol" +sep
		+ "mismatch" +sep
		+ "probeSet" +sep
		+ "reportsFor" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("chromosome")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("probeSet")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("reportsFor")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getChromosome();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCM();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpStart();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpEnd();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSeq();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSymbol();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getMismatch();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getProbeSet();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getReportsFor();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Probe create(org.molgenis.data.Entity entity) throws Exception
	{
		Probe e = new Probe();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
