
/* File:        org.molgenis.omx/model/ProbeSet.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

/**
 * ProbeSet:  A set of Probes. E.g. an Affymetrix probeset has multiple
				probes. It implements locus because sometimes you want to give the complete set of probes a range,
				for example: indicating that this set of probes spans basepair 0 through 10.000.000 on chromosome 3.
				The same information could arguably also be queried from the probes themselves, but if you have 40k probes,
				retrieving the same information from only ProbeSet (if annotated so) would be much faster..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "ProbeSet"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.xgap.db.ProbeSetEntityListener.class})
public class ProbeSet extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.omx.xgap.Locus
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String CHROMOSOME = "Chromosome";
	public final static String CHROMOSOME_IDENTIFIER = "Chromosome_Identifier";
	public final static String CM = "cM";
	public final static String BPSTART = "bpStart";
	public final static String BPEND = "bpEnd";
	public final static String SEQ = "Seq";
	public final static String SYMBOL = "Symbol";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(ProbeSet.class).
	 */
	public static org.molgenis.framework.db.Query<? extends ProbeSet> query(org.molgenis.framework.db.Database db)
	{
		return db.query(ProbeSet.class);
	}
	
	/**
	 * Shorthand for db.find(ProbeSet.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends ProbeSet> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(ProbeSet.class, rules);
	}	
	
	/**
	 * 
	 */
	public static ProbeSet findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<ProbeSet> q = db.query(ProbeSet.class);
		q = q.eq(ProbeSet.ID, id);
		java.util.List<ProbeSet> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static ProbeSet findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<ProbeSet> q = db.query(ProbeSet.class);
		q = q.eq(ProbeSet.IDENTIFIER, identifier);
		java.util.List<ProbeSet> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//Reference to the chromosome this     position belongs to.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Chromosome")   	
	
				

	private org.molgenis.omx.xgap.Chromosome chromosome = null;
	@javax.persistence.Transient
	private Integer chromosome_id = null;	
	@javax.persistence.Transient
	private String chromosome_Identifier = null;						

	//genetic map position in centi morgan (cM).[type=decimal]
	@javax.persistence.Column(name="cM")
	@javax.xml.bind.annotation.XmlElement(name="cM")
	
				

	private Double cM =  null;

	//numeric basepair postion (5') on the chromosome[type=long]
	@javax.persistence.Column(name="bpStart")
	@javax.xml.bind.annotation.XmlElement(name="bpStart")
	
				

	private Long bpStart =  null;

	//numeric basepair postion (3') on the chromosome[type=long]
	@javax.persistence.Column(name="bpEnd")
	@javax.xml.bind.annotation.XmlElement(name="bpEnd")
	
				

	private Long bpEnd =  null;

	//The FASTA text representation of the sequence.[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="Seq")
	
				

	private String seq =  null;

	//todo[type=string]
	@javax.persistence.Column(name="Symbol", length=255)
	@javax.xml.bind.annotation.XmlElement(name="symbol")
	
				

	private String symbol =  null;

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public ProbeSet()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public ProbeSet(ProbeSet copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the Reference to the chromosome this     position belongs to..
	 * @return chromosome.
	 */
	public org.molgenis.omx.xgap.Chromosome getChromosome()
	{
		return this.chromosome;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Chromosome getChromosome(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Reference to the chromosome this     position belongs to..
	 * @param chromosome
	 */
	public void setChromosome( org.molgenis.omx.xgap.Chromosome chromosome)
	{
		
		this.chromosome = chromosome;
	}

	
	
	/**
	 * Set foreign key for field chromosome.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setChromosome_Id(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}	

	public void setChromosome(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}
	
	public Integer getChromosome_Id()
	{
		
		if(chromosome != null) 
		{
			return chromosome.getId();
		}
		else
		{
			return chromosome_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Chromosome to Chromosome.Id.
	 */
	public String getChromosome_Identifier()
	{		
		//FIXME should we auto-load based on getChromosome()?	
		if(chromosome != null) {
			return chromosome.getIdentifier();
		} else {
			return chromosome_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Chromosome to <a href="Chromosome.html#Id">Chromosome.Id</a>.
	 * Implies setChromosome(null) until save
	 */
	public void setChromosome_Identifier(String chromosome_Identifier)
	{
		this.chromosome_Identifier = chromosome_Identifier;
	}		
	 
	

	/**
	 * Get the genetic map position in centi morgan (cM)..
	 * @return cM.
	 */
	public Double getCM()
	{
		return this.cM;
	}
	
	@Deprecated
	public Double getCM(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the genetic map position in centi morgan (cM)..
	 * @param cM
	 */
	public void setCM( Double cM)
	{
		
		this.cM = cM;
	}

	

	/**
	 * Get the numeric basepair postion (5') on the chromosome.
	 * @return bpStart.
	 */
	public Long getBpStart()
	{
		return this.bpStart;
	}
	
	@Deprecated
	public Long getBpStart(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (5') on the chromosome.
	 * @param bpStart
	 */
	public void setBpStart( Long bpStart)
	{
		
		this.bpStart = bpStart;
	}

	

	/**
	 * Get the numeric basepair postion (3') on the chromosome.
	 * @return bpEnd.
	 */
	public Long getBpEnd()
	{
		return this.bpEnd;
	}
	
	@Deprecated
	public Long getBpEnd(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (3') on the chromosome.
	 * @param bpEnd
	 */
	public void setBpEnd( Long bpEnd)
	{
		
		this.bpEnd = bpEnd;
	}

	

	/**
	 * Get the The FASTA text representation of the sequence..
	 * @return seq.
	 */
	public String getSeq()
	{
		return this.seq;
	}
	
	@Deprecated
	public String getSeq(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The FASTA text representation of the sequence..
	 * @param seq
	 */
	public void setSeq( String seq)
	{
		
		this.seq = seq;
	}

	

	/**
	 * Get the todo.
	 * @return symbol.
	 */
	public String getSymbol()
	{
		return this.symbol;
	}
	
	@Deprecated
	public String getSymbol(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the todo.
	 * @param symbol
	 */
	public void setSymbol( String symbol)
	{
		
		this.symbol = symbol;
	}

	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if(name.equals("chromosome_id"))
			return getChromosome_Id();
		if(name.equals("chromosome_identifier"))
			return getChromosome_Identifier();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("probeset_id") != null) this.setId(entity.getInt("probeset_id"));
		else if( entity.getInt("ProbeSet_id") != null) this.setId(entity.getInt("ProbeSet_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("probeset_identifier") != null) this.setIdentifier(entity.getString("probeset_identifier"));
		else if( entity.getString("ProbeSet_Identifier") != null) this.setIdentifier(entity.getString("ProbeSet_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("probeset_name") != null) this.setName(entity.getString("probeset_name"));
		else if( entity.getString("ProbeSet_Name") != null) this.setName(entity.getString("ProbeSet_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("probeset___type") != null) this.set__Type(entity.getString("probeset___type"));
		else if( entity.getString("ProbeSet___Type") != null) this.set__Type(entity.getString("ProbeSet___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("probeset_description") != null) this.setDescription(entity.getString("probeset_description"));
		else if( entity.getString("ProbeSet_description") != null) this.setDescription(entity.getString("ProbeSet_description"));
		//set Chromosome
		// query formal name, else lowercase name
		if(entity.getInt("Chromosome_id") != null) this.setChromosome(entity.getInt("Chromosome_id"));
		else if(entity.getInt("chromosome_id") != null) this.setChromosome(entity.getInt("chromosome_id"));
		else if(strict) this.setChromosome(entity.getInt("Chromosome_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("ProbeSet_Chromosome_id") != null) this.setChromosome(entity.getInt("ProbeSet_Chromosome_id"));
		else if( entity.getInt("probeset_chromosome_id") != null) this.setChromosome(entity.getInt("probeset_chromosome_id"));
		//alias of xref
		if( entity.get("Chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome")); 
			}
		}
		else if( entity.get("chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome"));
			}
		}
		if( entity.get("ProbeSet_Chromosome") != null)
			this.setChromosome_Id(entity.getInt("ProbeSet_Chromosome"));			
		else if( entity.get("probeset_chromosome") != null)
			this.setChromosome_Id(entity.getInt("probeset_chromosome"));
			
		if( entity.get("ProbeSet.Chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("ProbeSet.Chromosome_id"));
		else if( entity.get("probeset.chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("probeset.chromosome_id"));	
		//set label for field Chromosome
		if(entity.get("Chromosome_Identifier") != null) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier"));
		else if(entity.get("chromosome_identifier") != null) this.setChromosome_Identifier(entity.getString("chromosome_identifier"));
		else if(strict) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("ProbeSet_Chromosome_Identifier") != null ) this.setChromosome_Identifier(entity.getString("ProbeSet_Chromosome_Identifier"));		
		else if( entity.get("probeset_chromosome_identifier") != null ) this.setChromosome_Identifier(entity.getString("probeset_chromosome_identifier"));
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("probeset_cm") != null) this.setCM(entity.getDouble("probeset_cm"));
		else if( entity.getDouble("ProbeSet_cM") != null) this.setCM(entity.getDouble("ProbeSet_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("probeset_bpstart") != null) this.setBpStart(entity.getLong("probeset_bpstart"));
		else if( entity.getLong("ProbeSet_bpStart") != null) this.setBpStart(entity.getLong("ProbeSet_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("probeset_bpend") != null) this.setBpEnd(entity.getLong("probeset_bpend"));
		else if( entity.getLong("ProbeSet_bpEnd") != null) this.setBpEnd(entity.getLong("ProbeSet_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("probeset_seq") != null) this.setSeq(entity.getString("probeset_seq"));
		else if( entity.getString("ProbeSet_Seq") != null) this.setSeq(entity.getString("ProbeSet_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("probeset_symbol") != null) this.setSymbol(entity.getString("probeset_symbol"));
		else if( entity.getString("ProbeSet_Symbol") != null) this.setSymbol(entity.getString("ProbeSet_Symbol"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "ProbeSet(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " chromosome_id='" + getChromosome_Id()+"' ";	
		result+= " chromosome_identifier='" + getChromosome_Identifier()+"' ";
		result+= "cM='" + getCM()+"' ";	
		result+= "bpStart='" + getBpStart()+"' ";	
		result+= "bpEnd='" + getBpEnd()+"' ";	
		result+= "seq='" + getSeq()+"' ";	
		result+= "symbol='" + getSymbol()+"'";	
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of ProbeSet.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("description");
		}
		{
			fields.add("Chromosome_id");
		}
		fields.add("Chromosome_Identifier");
		{
			fields.add("cM");
		}
		{
			fields.add("bpStart");
		}
		{
			fields.add("bpEnd");
		}
		{
			fields.add("Seq");
		}
		{
			fields.add("Symbol");
		}
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "chromosome" +sep
		+ "cM" +sep
		+ "bpStart" +sep
		+ "bpEnd" +sep
		+ "seq" +sep
		+ "symbol" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("chromosome")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getChromosome();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCM();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpStart();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpEnd();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSeq();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSymbol();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public ProbeSet create(org.molgenis.data.Entity entity) throws Exception
	{
		ProbeSet e = new ProbeSet();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
