
/* File:        org.molgenis.omx/model/Variant.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.omx.xgap;

/**
 * Variant: A SNP is a special kind of Marker, but can also be seen as a phenotype to map against in some cases. A single-nucleotide polymorphism is a DNA sequence variation occurring when a single nucleotide in the genome (or other shared sequence) differs between members of a biological species or paired chromosomes in an individual..
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
//@org.hibernate.search.annotations.Indexed
@javax.persistence.Table(name = "Variant"
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
//@EntityListeners({org.molgenis.omx.xgap.db.VariantEntityListener.class})
public class Variant extends org.molgenis.omx.observ.ObservationTarget implements org.molgenis.omx.xgap.Locus
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
	// fieldname constants
	public final static String CHROMOSOME = "Chromosome";
	public final static String CHROMOSOME_IDENTIFIER = "Chromosome_Identifier";
	public final static String CM = "cM";
	public final static String BPSTART = "bpStart";
	public final static String BPEND = "bpEnd";
	public final static String SEQ = "Seq";
	public final static String SYMBOL = "Symbol";
	public final static String MUTATIONPOSITION = "MutationPosition";
	public final static String CDNAPOSITION = "CdnaPosition";
	public final static String AAPOSITION = "AaPosition";
	public final static String VARIANTLENGTH = "VariantLength";
	public final static String EVENT = "Event";
	public final static String DESCRIPTION = "Description";
	public final static String NTCHANGE = "NtChange";
	public final static String CODONCHANGE = "Codonchange";
	public final static String CDNANOTATION = "CdnaNotation";
	public final static String GDNANOTATION = "GdnaNotation";
	public final static String AANOTATION = "AaNotation";
	public final static String EXON = "Exon";
	public final static String CONSEQUENCE = "Consequence";
	public final static String INHERITANCE = "Inheritance";
	public final static String REPORTEDSNP = "ReportedSNP";
	public final static String EFFECTONSPLICING = "EffectOnSplicing";
	public final static String PATHOGENICITY = "Pathogenicity";
	public final static String GENE = "Gene";
	public final static String IDMUTATION = "IdMutation";
	public final static String DETAILSFORMUTATION = "DetailsForMutation";
	public final static String TRACK = "Track";
	public final static String TRACK_IDENTIFIER = "Track_Identifier";
	public final static String ID = "id";
	
	//static methods
	/**
	 * Shorthand for db.query(Variant.class).
	 */
	public static org.molgenis.framework.db.Query<? extends Variant> query(org.molgenis.framework.db.Database db)
	{
		return db.query(Variant.class);
	}
	
	/**
	 * Shorthand for db.find(Variant.class, org.molgenis.framework.db.QueryRule ... rules).
	 */
	public static java.util.List<? extends Variant> find(org.molgenis.framework.db.Database db, org.molgenis.framework.db.QueryRule ... rules) throws org.molgenis.framework.db.DatabaseException
	{
		return db.find(Variant.class, rules);
	}	
	
	/**
	 * 
	 */
	public static Variant findById(org.molgenis.framework.db.Database db, Integer id) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Variant> q = db.query(Variant.class);
		q = q.eq(Variant.ID, id);
		java.util.List<Variant> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	/**
	 * 
	 */
	public static Variant findByIdentifier(org.molgenis.framework.db.Database db, String identifier) throws org.molgenis.framework.db.DatabaseException
	{
		org.molgenis.framework.db.Query<Variant> q = db.query(Variant.class);
		q = q.eq(Variant.IDENTIFIER, identifier);
		java.util.List<Variant> result = q.find();
		if(result.size()>0) return result.get(0);
		else return null;
	}

	
	// member variables (including setters.getters for interface)

	//Reference to the chromosome this     position belongs to.[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Chromosome")   	
	
				

	private org.molgenis.omx.xgap.Chromosome chromosome = null;
	@javax.persistence.Transient
	private Integer chromosome_id = null;	
	@javax.persistence.Transient
	private String chromosome_Identifier = null;						

	//genetic map position in centi morgan (cM).[type=decimal]
	@javax.persistence.Column(name="cM")
	@javax.xml.bind.annotation.XmlElement(name="cM")
	
				

	private Double cM =  null;

	//numeric basepair postion (5') on the chromosome[type=long]
	@javax.persistence.Column(name="bpStart")
	@javax.xml.bind.annotation.XmlElement(name="bpStart")
	
				

	private Long bpStart =  null;

	//numeric basepair postion (3') on the chromosome[type=long]
	@javax.persistence.Column(name="bpEnd")
	@javax.xml.bind.annotation.XmlElement(name="bpEnd")
	
				

	private Long bpEnd =  null;

	//The FASTA text representation of the sequence.[type=text]
	@javax.persistence.Lob
	@javax.persistence.Column(name="Seq")
	
				

	private String seq =  null;

	//todo[type=string]
	@javax.persistence.Column(name="Symbol", length=255)
	@javax.xml.bind.annotation.XmlElement(name="symbol")
	
				

	private String symbol =  null;

	//MutationPosition[type=int]
	@javax.persistence.Column(name="MutationPosition")
	@javax.xml.bind.annotation.XmlElement(name="mutationPosition")
	
				

	private Integer mutationPosition =  null;

	//CdnaPosition[type=int]
	@javax.persistence.Column(name="CdnaPosition")
	@javax.xml.bind.annotation.XmlElement(name="cdnaPosition")
	
				

	private Integer cdnaPosition =  null;

	//AaPosition[type=int]
	@javax.persistence.Column(name="AaPosition")
	@javax.xml.bind.annotation.XmlElement(name="aaPosition")
	
				

	private Integer aaPosition =  null;

	//VariantLength[type=int]
	@javax.persistence.Column(name="VariantLength")
	@javax.xml.bind.annotation.XmlElement(name="variantLength")
	
				

	private Integer variantLength =  null;

	//Event[type=string]
	@javax.persistence.Column(name="Event", length=255)
	@javax.xml.bind.annotation.XmlElement(name="event")
	
				

	private String event =  null;

	//Description[type=string]
	@javax.persistence.Column(name="Description", length=255)
	@javax.xml.bind.annotation.XmlElement(name="description")
	
				

	private String description =  null;

	//NtChange[type=string]
	@javax.persistence.Column(name="NtChange", length=255)
	@javax.xml.bind.annotation.XmlElement(name="ntChange")
	
				

	private String ntChange =  null;

	//Codonchange[type=string]
	@javax.persistence.Column(name="Codonchange", length=255)
	@javax.xml.bind.annotation.XmlElement(name="codonchange")
	
				

	private String codonchange =  null;

	//CdnaNotation[type=string]
	@javax.persistence.Column(name="CdnaNotation", length=255)
	@javax.xml.bind.annotation.XmlElement(name="cdnaNotation")
	
				

	private String cdnaNotation =  null;

	//GdnaNotation[type=string]
	@javax.persistence.Column(name="GdnaNotation", length=255)
	@javax.xml.bind.annotation.XmlElement(name="gdnaNotation")
	
				

	private String gdnaNotation =  null;

	//AaNotation[type=string]
	@javax.persistence.Column(name="AaNotation", length=255)
	@javax.xml.bind.annotation.XmlElement(name="aaNotation")
	
				

	private String aaNotation =  null;

	//Exon[type=string]
	@javax.persistence.Column(name="Exon", length=255)
	@javax.xml.bind.annotation.XmlElement(name="exon")
	
				

	private String exon =  null;

	//Consequence[type=string]
	@javax.persistence.Column(name="Consequence", length=255)
	@javax.xml.bind.annotation.XmlElement(name="consequence")
	
				

	private String consequence =  null;

	//Inheritance[type=string]
	@javax.persistence.Column(name="Inheritance", length=255)
	@javax.xml.bind.annotation.XmlElement(name="inheritance")
	
				

	private String inheritance =  null;

	//ReportedSNP[type=bool]
	@javax.persistence.Column(name="ReportedSNP")
	@javax.xml.bind.annotation.XmlElement(name="reportedSNP")
	
				

	private Boolean reportedSNP =  null;

	//EffectOnSplicing[type=bool]
	@javax.persistence.Column(name="EffectOnSplicing")
	@javax.xml.bind.annotation.XmlElement(name="effectOnSplicing")
	
				

	private Boolean effectOnSplicing =  null;

	//Pathogenicity[type=string]
	@javax.persistence.Column(name="Pathogenicity", length=255)
	@javax.xml.bind.annotation.XmlElement(name="pathogenicity")
	
				

	private String pathogenicity =  null;

	//Gene[type=string]
	@javax.persistence.Column(name="Gene", length=255)
	@javax.xml.bind.annotation.XmlElement(name="gene")
	
				

	private String gene =  null;

	//IdMutation[type=int]
	@javax.persistence.Column(name="IdMutation")
	@javax.xml.bind.annotation.XmlElement(name="idMutation")
	
				

	private Integer idMutation =  null;

	//DetailsForMutation[type=hyperlink]
	@javax.persistence.Column(name="DetailsForMutation")
	@javax.xml.bind.annotation.XmlElement(name="detailsForMutation")
	
				

	private String detailsForMutation =  null;

	//Track[type=xref]
    @javax.persistence.ManyToOne(fetch=javax.persistence.FetchType.EAGER /*cascade={javax.persistence.CascadeType.MERGE, javax.persistence.CascadeType.PERSIST, javax.persistence.CascadeType.REFRESH}*/)
    @javax.persistence.JoinColumn(name="Track", nullable=false)   	
	
				

	@javax.validation.constraints.NotNull
	private org.molgenis.omx.xgap.Track track = null;
	@javax.persistence.Transient
	private Integer track_id = null;	
	@javax.persistence.Transient
	private String track_Identifier = null;						

	//automatically generated internal id, only for internal use.[type=int]
	

	//constructors
	public Variant()
	{
		//set the type for a new instance
		set__Type(this.getClass().getSimpleName());
	}
	
	/** copy constructor */
	public Variant(Variant copyMe) throws Exception
	{	
		for(String f : this.getFields())
		{
			this.set(f, copyMe.get(f));
		}	
	}
	
	//getters and setters
	/**
	 * Get the Reference to the chromosome this     position belongs to..
	 * @return chromosome.
	 */
	public org.molgenis.omx.xgap.Chromosome getChromosome()
	{
		return this.chromosome;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Chromosome getChromosome(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Reference to the chromosome this     position belongs to..
	 * @param chromosome
	 */
	public void setChromosome( org.molgenis.omx.xgap.Chromosome chromosome)
	{
		
		this.chromosome = chromosome;
	}

	
	
	/**
	 * Set foreign key for field chromosome.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setChromosome_Id(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}	

	public void setChromosome(Integer chromosome_id)
	{
		this.chromosome_id = chromosome_id;
	}
	
	public Integer getChromosome_Id()
	{
		
		if(chromosome != null) 
		{
			return chromosome.getId();
		}
		else
		{
			return chromosome_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Chromosome to Chromosome.Id.
	 */
	public String getChromosome_Identifier()
	{		
		//FIXME should we auto-load based on getChromosome()?	
		if(chromosome != null) {
			return chromosome.getIdentifier();
		} else {
			return chromosome_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Chromosome to <a href="Chromosome.html#Id">Chromosome.Id</a>.
	 * Implies setChromosome(null) until save
	 */
	public void setChromosome_Identifier(String chromosome_Identifier)
	{
		this.chromosome_Identifier = chromosome_Identifier;
	}		
	 
	

	/**
	 * Get the genetic map position in centi morgan (cM)..
	 * @return cM.
	 */
	public Double getCM()
	{
		return this.cM;
	}
	
	@Deprecated
	public Double getCM(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the genetic map position in centi morgan (cM)..
	 * @param cM
	 */
	public void setCM( Double cM)
	{
		
		this.cM = cM;
	}

	

	/**
	 * Get the numeric basepair postion (5') on the chromosome.
	 * @return bpStart.
	 */
	public Long getBpStart()
	{
		return this.bpStart;
	}
	
	@Deprecated
	public Long getBpStart(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (5') on the chromosome.
	 * @param bpStart
	 */
	public void setBpStart( Long bpStart)
	{
		
		this.bpStart = bpStart;
	}

	

	/**
	 * Get the numeric basepair postion (3') on the chromosome.
	 * @return bpEnd.
	 */
	public Long getBpEnd()
	{
		return this.bpEnd;
	}
	
	@Deprecated
	public Long getBpEnd(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the numeric basepair postion (3') on the chromosome.
	 * @param bpEnd
	 */
	public void setBpEnd( Long bpEnd)
	{
		
		this.bpEnd = bpEnd;
	}

	

	/**
	 * Get the The FASTA text representation of the sequence..
	 * @return seq.
	 */
	public String getSeq()
	{
		return this.seq;
	}
	
	@Deprecated
	public String getSeq(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the The FASTA text representation of the sequence..
	 * @param seq
	 */
	public void setSeq( String seq)
	{
		
		this.seq = seq;
	}

	

	/**
	 * Get the todo.
	 * @return symbol.
	 */
	public String getSymbol()
	{
		return this.symbol;
	}
	
	@Deprecated
	public String getSymbol(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the todo.
	 * @param symbol
	 */
	public void setSymbol( String symbol)
	{
		
		this.symbol = symbol;
	}

	

	/**
	 * Get the MutationPosition.
	 * @return mutationPosition.
	 */
	public Integer getMutationPosition()
	{
		return this.mutationPosition;
	}
	
	@Deprecated
	public Integer getMutationPosition(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the MutationPosition.
	 * @param mutationPosition
	 */
	public void setMutationPosition( Integer mutationPosition)
	{
		
		this.mutationPosition = mutationPosition;
	}

	

	/**
	 * Get the CdnaPosition.
	 * @return cdnaPosition.
	 */
	public Integer getCdnaPosition()
	{
		return this.cdnaPosition;
	}
	
	@Deprecated
	public Integer getCdnaPosition(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the CdnaPosition.
	 * @param cdnaPosition
	 */
	public void setCdnaPosition( Integer cdnaPosition)
	{
		
		this.cdnaPosition = cdnaPosition;
	}

	

	/**
	 * Get the AaPosition.
	 * @return aaPosition.
	 */
	public Integer getAaPosition()
	{
		return this.aaPosition;
	}
	
	@Deprecated
	public Integer getAaPosition(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the AaPosition.
	 * @param aaPosition
	 */
	public void setAaPosition( Integer aaPosition)
	{
		
		this.aaPosition = aaPosition;
	}

	

	/**
	 * Get the VariantLength.
	 * @return variantLength.
	 */
	public Integer getVariantLength()
	{
		return this.variantLength;
	}
	
	@Deprecated
	public Integer getVariantLength(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the VariantLength.
	 * @param variantLength
	 */
	public void setVariantLength( Integer variantLength)
	{
		
		this.variantLength = variantLength;
	}

	

	/**
	 * Get the Event.
	 * @return event.
	 */
	public String getEvent()
	{
		return this.event;
	}
	
	@Deprecated
	public String getEvent(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Event.
	 * @param event
	 */
	public void setEvent( String event)
	{
		
		this.event = event;
	}

	

	/**
	 * Get the Description.
	 * @return description.
	 */
	public String getDescription()
	{
		return this.description;
	}
	
	@Deprecated
	public String getDescription(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Description.
	 * @param description
	 */
	public void setDescription( String description)
	{
				//2222hack to solve problem with variable hidden in supertype
				super.setDescription(description);
		
		this.description = description;
	}

	

	/**
	 * Get the NtChange.
	 * @return ntChange.
	 */
	public String getNtChange()
	{
		return this.ntChange;
	}
	
	@Deprecated
	public String getNtChange(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the NtChange.
	 * @param ntChange
	 */
	public void setNtChange( String ntChange)
	{
		
		this.ntChange = ntChange;
	}

	

	/**
	 * Get the Codonchange.
	 * @return codonchange.
	 */
	public String getCodonchange()
	{
		return this.codonchange;
	}
	
	@Deprecated
	public String getCodonchange(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Codonchange.
	 * @param codonchange
	 */
	public void setCodonchange( String codonchange)
	{
		
		this.codonchange = codonchange;
	}

	

	/**
	 * Get the CdnaNotation.
	 * @return cdnaNotation.
	 */
	public String getCdnaNotation()
	{
		return this.cdnaNotation;
	}
	
	@Deprecated
	public String getCdnaNotation(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the CdnaNotation.
	 * @param cdnaNotation
	 */
	public void setCdnaNotation( String cdnaNotation)
	{
		
		this.cdnaNotation = cdnaNotation;
	}

	

	/**
	 * Get the GdnaNotation.
	 * @return gdnaNotation.
	 */
	public String getGdnaNotation()
	{
		return this.gdnaNotation;
	}
	
	@Deprecated
	public String getGdnaNotation(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the GdnaNotation.
	 * @param gdnaNotation
	 */
	public void setGdnaNotation( String gdnaNotation)
	{
		
		this.gdnaNotation = gdnaNotation;
	}

	

	/**
	 * Get the AaNotation.
	 * @return aaNotation.
	 */
	public String getAaNotation()
	{
		return this.aaNotation;
	}
	
	@Deprecated
	public String getAaNotation(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the AaNotation.
	 * @param aaNotation
	 */
	public void setAaNotation( String aaNotation)
	{
		
		this.aaNotation = aaNotation;
	}

	

	/**
	 * Get the Exon.
	 * @return exon.
	 */
	public String getExon()
	{
		return this.exon;
	}
	
	@Deprecated
	public String getExon(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Exon.
	 * @param exon
	 */
	public void setExon( String exon)
	{
		
		this.exon = exon;
	}

	

	/**
	 * Get the Consequence.
	 * @return consequence.
	 */
	public String getConsequence()
	{
		return this.consequence;
	}
	
	@Deprecated
	public String getConsequence(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Consequence.
	 * @param consequence
	 */
	public void setConsequence( String consequence)
	{
		
		this.consequence = consequence;
	}

	

	/**
	 * Get the Inheritance.
	 * @return inheritance.
	 */
	public String getInheritance()
	{
		return this.inheritance;
	}
	
	@Deprecated
	public String getInheritance(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Inheritance.
	 * @param inheritance
	 */
	public void setInheritance( String inheritance)
	{
		
		this.inheritance = inheritance;
	}

	

	/**
	 * Get the ReportedSNP.
	 * @return reportedSNP.
	 */
	public Boolean getReportedSNP()
	{
		return this.reportedSNP;
	}
	
	@Deprecated
	public Boolean getReportedSNP(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the ReportedSNP.
	 * @param reportedSNP
	 */
	public void setReportedSNP( Boolean reportedSNP)
	{
		
		this.reportedSNP = reportedSNP;
	}

	

	/**
	 * Get the EffectOnSplicing.
	 * @return effectOnSplicing.
	 */
	public Boolean getEffectOnSplicing()
	{
		return this.effectOnSplicing;
	}
	
	@Deprecated
	public Boolean getEffectOnSplicing(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the EffectOnSplicing.
	 * @param effectOnSplicing
	 */
	public void setEffectOnSplicing( Boolean effectOnSplicing)
	{
		
		this.effectOnSplicing = effectOnSplicing;
	}

	

	/**
	 * Get the Pathogenicity.
	 * @return pathogenicity.
	 */
	public String getPathogenicity()
	{
		return this.pathogenicity;
	}
	
	@Deprecated
	public String getPathogenicity(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Pathogenicity.
	 * @param pathogenicity
	 */
	public void setPathogenicity( String pathogenicity)
	{
		
		this.pathogenicity = pathogenicity;
	}

	

	/**
	 * Get the Gene.
	 * @return gene.
	 */
	public String getGene()
	{
		return this.gene;
	}
	
	@Deprecated
	public String getGene(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Gene.
	 * @param gene
	 */
	public void setGene( String gene)
	{
		
		this.gene = gene;
	}

	

	/**
	 * Get the IdMutation.
	 * @return idMutation.
	 */
	public Integer getIdMutation()
	{
		return this.idMutation;
	}
	
	@Deprecated
	public Integer getIdMutation(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the IdMutation.
	 * @param idMutation
	 */
	public void setIdMutation( Integer idMutation)
	{
		
		this.idMutation = idMutation;
	}

	

	/**
	 * Get the DetailsForMutation.
	 * @return detailsForMutation.
	 */
	public String getDetailsForMutation()
	{
		return this.detailsForMutation;
	}
	
	@Deprecated
	public String getDetailsForMutation(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the DetailsForMutation.
	 * @param detailsForMutation
	 */
	public void setDetailsForMutation( String detailsForMutation)
	{
		
		this.detailsForMutation = detailsForMutation;
	}

	

	/**
	 * Get the Track.
	 * @return track.
	 */
	public org.molgenis.omx.xgap.Track getTrack()
	{
		return this.track;
	}
	
	@Deprecated
	public org.molgenis.omx.xgap.Track getTrack(org.molgenis.framework.db.Database db)
	{
		throw new UnsupportedOperationException();
	}	
	
	/**
	 * Set the Track.
	 * @param track
	 */
	public void setTrack( org.molgenis.omx.xgap.Track track)
	{
		
		this.track = track;
	}

	
	
	/**
	 * Set foreign key for field track.
	 * This will erase any foreign key objects currently set.
	 * FIXME: can we autoload the new object?
	 */
	public void setTrack_Id(Integer track_id)
	{
		this.track_id = track_id;
	}	

	public void setTrack(Integer track_id)
	{
		this.track_id = track_id;
	}
	
	public Integer getTrack_Id()
	{
		
		if(track != null) 
		{
			return track.getId();
		}
		else
		{
			return track_id;
		}
	}	
	 
	/**
	 * Get a pretty label Identifier for cross reference Track to Track.Id.
	 */
	public String getTrack_Identifier()
	{		
		//FIXME should we auto-load based on getTrack()?	
		if(track != null) {
			return track.getIdentifier();
		} else {
			return track_Identifier;
		}
	}		
	
	/**
	 * Set a pretty label for cross reference Track to <a href="Track.html#Id">Track.Id</a>.
	 * Implies setTrack(null) until save
	 */
	public void setTrack_Identifier(String track_Identifier)
	{
		this.track_Identifier = track_Identifier;
	}		
	 
	

	

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("name"))
			return getName();
		if (name.equals("__type"))
			return get__Type();
		if(name.equals("__type_label"))
			return get__TypeLabel();
		if (name.equals("description"))
			return getDescription();
		if (name.equals("chromosome"))
			return getChromosome();
		if(name.equals("chromosome_id"))
			return getChromosome_Id();
		if(name.equals("chromosome_identifier"))
			return getChromosome_Identifier();
		if (name.equals("cm"))
			return getCM();
		if (name.equals("bpstart"))
			return getBpStart();
		if (name.equals("bpend"))
			return getBpEnd();
		if (name.equals("seq"))
			return getSeq();
		if (name.equals("symbol"))
			return getSymbol();
		if (name.equals("mutationposition"))
			return getMutationPosition();
		if (name.equals("cdnaposition"))
			return getCdnaPosition();
		if (name.equals("aaposition"))
			return getAaPosition();
		if (name.equals("variantlength"))
			return getVariantLength();
		if (name.equals("event"))
			return getEvent();
		if (name.equals("ntchange"))
			return getNtChange();
		if (name.equals("codonchange"))
			return getCodonchange();
		if (name.equals("cdnanotation"))
			return getCdnaNotation();
		if (name.equals("gdnanotation"))
			return getGdnaNotation();
		if (name.equals("aanotation"))
			return getAaNotation();
		if (name.equals("exon"))
			return getExon();
		if (name.equals("consequence"))
			return getConsequence();
		if (name.equals("inheritance"))
			return getInheritance();
		if (name.equals("reportedsnp"))
			return getReportedSNP();
		if (name.equals("effectonsplicing"))
			return getEffectOnSplicing();
		if (name.equals("pathogenicity"))
			return getPathogenicity();
		if (name.equals("gene"))
			return getGene();
		if (name.equals("idmutation"))
			return getIdMutation();
		if (name.equals("detailsformutation"))
			return getDetailsForMutation();
		if (name.equals("track"))
			return getTrack();
		if(name.equals("track_id"))
			return getTrack_Id();
		if(name.equals("track_identifier"))
			return getTrack_Identifier();
		return null;
	}	
	
	@Override
	public void validate() throws org.molgenis.framework.db.DatabaseException
	{
		if(this.getId() == null) throw new org.molgenis.framework.db.DatabaseException("required field id is null");
		if(this.getIdentifier() == null) throw new org.molgenis.framework.db.DatabaseException("required field identifier is null");
		if(this.getName() == null) throw new org.molgenis.framework.db.DatabaseException("required field name is null");
		if(this.get__Type() == null) throw new org.molgenis.framework.db.DatabaseException("required field __Type is null");
		if(this.getTrack() == null) throw new org.molgenis.framework.db.DatabaseException("required field track is null");
	}
	
	@Override
	public void set(org.molgenis.data.Entity entity, boolean strict ) throws Exception
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(entity.getInt("id") != null) this.setId(entity.getInt("id"));
		else if(strict) this.setId(entity.getInt("id")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_id") != null) this.setId(entity.getInt("variant_id"));
		else if( entity.getInt("Variant_id") != null) this.setId(entity.getInt("Variant_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("Identifier") != null) this.setIdentifier(entity.getString("Identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("variant_identifier") != null) this.setIdentifier(entity.getString("variant_identifier"));
		else if( entity.getString("Variant_Identifier") != null) this.setIdentifier(entity.getString("Variant_Identifier"));
		//set Name
		// query formal name, else lowercase name
		if(entity.getString("name") != null) this.setName(entity.getString("name"));
		else if(entity.getString("Name") != null) this.setName(entity.getString("Name"));
		else if(strict) this.setName(entity.getString("name")); // setting null is not an option due to function overloading
		if( entity.getString("variant_name") != null) this.setName(entity.getString("variant_name"));
		else if( entity.getString("Variant_Name") != null) this.setName(entity.getString("Variant_Name"));
		//set __Type
		// query formal name, else lowercase name
		if(entity.getString("__type") != null) this.set__Type(entity.getString("__type"));
		else if(entity.getString("__Type") != null) this.set__Type(entity.getString("__Type"));
		else if(strict) this.set__Type(entity.getString("__type")); // setting null is not an option due to function overloading
		if( entity.getString("variant___type") != null) this.set__Type(entity.getString("variant___type"));
		else if( entity.getString("Variant___Type") != null) this.set__Type(entity.getString("Variant___Type"));
		//set Description
		// query formal name, else lowercase name
		if(entity.getString("description") != null) this.setDescription(entity.getString("description"));
		else if(entity.getString("Description") != null) this.setDescription(entity.getString("Description"));
		else if(strict) this.setDescription(entity.getString("description")); // setting null is not an option due to function overloading
		if( entity.getString("variant_description") != null) this.setDescription(entity.getString("variant_description"));
		else if( entity.getString("Variant_Description") != null) this.setDescription(entity.getString("Variant_Description"));
		//set Chromosome
		// query formal name, else lowercase name
		if(entity.getInt("Chromosome_id") != null) this.setChromosome(entity.getInt("Chromosome_id"));
		else if(entity.getInt("chromosome_id") != null) this.setChromosome(entity.getInt("chromosome_id"));
		else if(strict) this.setChromosome(entity.getInt("Chromosome_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Variant_Chromosome_id") != null) this.setChromosome(entity.getInt("Variant_Chromosome_id"));
		else if( entity.getInt("variant_chromosome_id") != null) this.setChromosome(entity.getInt("variant_chromosome_id"));
		//alias of xref
		if( entity.get("Chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome")); 
			}
		}
		else if( entity.get("chromosome") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("chromosome").toString())) {
				org.molgenis.omx.xgap.Chromosome instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("chromosome"), org.molgenis.omx.xgap.Chromosome.class);
				this.setChromosome(instance);				
			} else {
				this.setChromosome_Id(entity.getInt("Chromosome"));
			}
		}
		if( entity.get("Variant_Chromosome") != null)
			this.setChromosome_Id(entity.getInt("Variant_Chromosome"));			
		else if( entity.get("variant_chromosome") != null)
			this.setChromosome_Id(entity.getInt("variant_chromosome"));
			
		if( entity.get("Variant.Chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("Variant.Chromosome_id"));
		else if( entity.get("variant.chromosome") != null) 
			this.setChromosome((org.molgenis.omx.xgap.Chromosome)entity.get("variant.chromosome_id"));	
		//set label for field Chromosome
		if(entity.get("Chromosome_Identifier") != null) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier"));
		else if(entity.get("chromosome_identifier") != null) this.setChromosome_Identifier(entity.getString("chromosome_identifier"));
		else if(strict) this.setChromosome_Identifier(entity.getString("Chromosome_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Variant_Chromosome_Identifier") != null ) this.setChromosome_Identifier(entity.getString("Variant_Chromosome_Identifier"));		
		else if( entity.get("variant_chromosome_identifier") != null ) this.setChromosome_Identifier(entity.getString("variant_chromosome_identifier"));
		//set CM
		// query formal name, else lowercase name
		if(entity.getDouble("cm") != null) this.setCM(entity.getDouble("cm"));
		else if(entity.getDouble("cM") != null) this.setCM(entity.getDouble("cM"));
		else if(strict) this.setCM(entity.getDouble("cm")); // setting null is not an option due to function overloading
		if( entity.getDouble("variant_cm") != null) this.setCM(entity.getDouble("variant_cm"));
		else if( entity.getDouble("Variant_cM") != null) this.setCM(entity.getDouble("Variant_cM"));
		//set BpStart
		// query formal name, else lowercase name
		if(entity.getLong("bpstart") != null) this.setBpStart(entity.getLong("bpstart"));
		else if(entity.getLong("bpStart") != null) this.setBpStart(entity.getLong("bpStart"));
		else if(strict) this.setBpStart(entity.getLong("bpstart")); // setting null is not an option due to function overloading
		if( entity.getLong("variant_bpstart") != null) this.setBpStart(entity.getLong("variant_bpstart"));
		else if( entity.getLong("Variant_bpStart") != null) this.setBpStart(entity.getLong("Variant_bpStart"));
		//set BpEnd
		// query formal name, else lowercase name
		if(entity.getLong("bpend") != null) this.setBpEnd(entity.getLong("bpend"));
		else if(entity.getLong("bpEnd") != null) this.setBpEnd(entity.getLong("bpEnd"));
		else if(strict) this.setBpEnd(entity.getLong("bpend")); // setting null is not an option due to function overloading
		if( entity.getLong("variant_bpend") != null) this.setBpEnd(entity.getLong("variant_bpend"));
		else if( entity.getLong("Variant_bpEnd") != null) this.setBpEnd(entity.getLong("Variant_bpEnd"));
		//set Seq
		// query formal name, else lowercase name
		if(entity.getString("seq") != null) this.setSeq(entity.getString("seq"));
		else if(entity.getString("Seq") != null) this.setSeq(entity.getString("Seq"));
		else if(strict) this.setSeq(entity.getString("seq")); // setting null is not an option due to function overloading
		if( entity.getString("variant_seq") != null) this.setSeq(entity.getString("variant_seq"));
		else if( entity.getString("Variant_Seq") != null) this.setSeq(entity.getString("Variant_Seq"));
		//set Symbol
		// query formal name, else lowercase name
		if(entity.getString("symbol") != null) this.setSymbol(entity.getString("symbol"));
		else if(entity.getString("Symbol") != null) this.setSymbol(entity.getString("Symbol"));
		else if(strict) this.setSymbol(entity.getString("symbol")); // setting null is not an option due to function overloading
		if( entity.getString("variant_symbol") != null) this.setSymbol(entity.getString("variant_symbol"));
		else if( entity.getString("Variant_Symbol") != null) this.setSymbol(entity.getString("Variant_Symbol"));
		//set MutationPosition
		// query formal name, else lowercase name
		if(entity.getInt("mutationposition") != null) this.setMutationPosition(entity.getInt("mutationposition"));
		else if(entity.getInt("MutationPosition") != null) this.setMutationPosition(entity.getInt("MutationPosition"));
		else if(strict) this.setMutationPosition(entity.getInt("mutationposition")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_mutationposition") != null) this.setMutationPosition(entity.getInt("variant_mutationposition"));
		else if( entity.getInt("Variant_MutationPosition") != null) this.setMutationPosition(entity.getInt("Variant_MutationPosition"));
		//set CdnaPosition
		// query formal name, else lowercase name
		if(entity.getInt("cdnaposition") != null) this.setCdnaPosition(entity.getInt("cdnaposition"));
		else if(entity.getInt("CdnaPosition") != null) this.setCdnaPosition(entity.getInt("CdnaPosition"));
		else if(strict) this.setCdnaPosition(entity.getInt("cdnaposition")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_cdnaposition") != null) this.setCdnaPosition(entity.getInt("variant_cdnaposition"));
		else if( entity.getInt("Variant_CdnaPosition") != null) this.setCdnaPosition(entity.getInt("Variant_CdnaPosition"));
		//set AaPosition
		// query formal name, else lowercase name
		if(entity.getInt("aaposition") != null) this.setAaPosition(entity.getInt("aaposition"));
		else if(entity.getInt("AaPosition") != null) this.setAaPosition(entity.getInt("AaPosition"));
		else if(strict) this.setAaPosition(entity.getInt("aaposition")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_aaposition") != null) this.setAaPosition(entity.getInt("variant_aaposition"));
		else if( entity.getInt("Variant_AaPosition") != null) this.setAaPosition(entity.getInt("Variant_AaPosition"));
		//set VariantLength
		// query formal name, else lowercase name
		if(entity.getInt("variantlength") != null) this.setVariantLength(entity.getInt("variantlength"));
		else if(entity.getInt("VariantLength") != null) this.setVariantLength(entity.getInt("VariantLength"));
		else if(strict) this.setVariantLength(entity.getInt("variantlength")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_variantlength") != null) this.setVariantLength(entity.getInt("variant_variantlength"));
		else if( entity.getInt("Variant_VariantLength") != null) this.setVariantLength(entity.getInt("Variant_VariantLength"));
		//set Event
		// query formal name, else lowercase name
		if(entity.getString("event") != null) this.setEvent(entity.getString("event"));
		else if(entity.getString("Event") != null) this.setEvent(entity.getString("Event"));
		else if(strict) this.setEvent(entity.getString("event")); // setting null is not an option due to function overloading
		if( entity.getString("variant_event") != null) this.setEvent(entity.getString("variant_event"));
		else if( entity.getString("Variant_Event") != null) this.setEvent(entity.getString("Variant_Event"));
		//set NtChange
		// query formal name, else lowercase name
		if(entity.getString("ntchange") != null) this.setNtChange(entity.getString("ntchange"));
		else if(entity.getString("NtChange") != null) this.setNtChange(entity.getString("NtChange"));
		else if(strict) this.setNtChange(entity.getString("ntchange")); // setting null is not an option due to function overloading
		if( entity.getString("variant_ntchange") != null) this.setNtChange(entity.getString("variant_ntchange"));
		else if( entity.getString("Variant_NtChange") != null) this.setNtChange(entity.getString("Variant_NtChange"));
		//set Codonchange
		// query formal name, else lowercase name
		if(entity.getString("codonchange") != null) this.setCodonchange(entity.getString("codonchange"));
		else if(entity.getString("Codonchange") != null) this.setCodonchange(entity.getString("Codonchange"));
		else if(strict) this.setCodonchange(entity.getString("codonchange")); // setting null is not an option due to function overloading
		if( entity.getString("variant_codonchange") != null) this.setCodonchange(entity.getString("variant_codonchange"));
		else if( entity.getString("Variant_Codonchange") != null) this.setCodonchange(entity.getString("Variant_Codonchange"));
		//set CdnaNotation
		// query formal name, else lowercase name
		if(entity.getString("cdnanotation") != null) this.setCdnaNotation(entity.getString("cdnanotation"));
		else if(entity.getString("CdnaNotation") != null) this.setCdnaNotation(entity.getString("CdnaNotation"));
		else if(strict) this.setCdnaNotation(entity.getString("cdnanotation")); // setting null is not an option due to function overloading
		if( entity.getString("variant_cdnanotation") != null) this.setCdnaNotation(entity.getString("variant_cdnanotation"));
		else if( entity.getString("Variant_CdnaNotation") != null) this.setCdnaNotation(entity.getString("Variant_CdnaNotation"));
		//set GdnaNotation
		// query formal name, else lowercase name
		if(entity.getString("gdnanotation") != null) this.setGdnaNotation(entity.getString("gdnanotation"));
		else if(entity.getString("GdnaNotation") != null) this.setGdnaNotation(entity.getString("GdnaNotation"));
		else if(strict) this.setGdnaNotation(entity.getString("gdnanotation")); // setting null is not an option due to function overloading
		if( entity.getString("variant_gdnanotation") != null) this.setGdnaNotation(entity.getString("variant_gdnanotation"));
		else if( entity.getString("Variant_GdnaNotation") != null) this.setGdnaNotation(entity.getString("Variant_GdnaNotation"));
		//set AaNotation
		// query formal name, else lowercase name
		if(entity.getString("aanotation") != null) this.setAaNotation(entity.getString("aanotation"));
		else if(entity.getString("AaNotation") != null) this.setAaNotation(entity.getString("AaNotation"));
		else if(strict) this.setAaNotation(entity.getString("aanotation")); // setting null is not an option due to function overloading
		if( entity.getString("variant_aanotation") != null) this.setAaNotation(entity.getString("variant_aanotation"));
		else if( entity.getString("Variant_AaNotation") != null) this.setAaNotation(entity.getString("Variant_AaNotation"));
		//set Exon
		// query formal name, else lowercase name
		if(entity.getString("exon") != null) this.setExon(entity.getString("exon"));
		else if(entity.getString("Exon") != null) this.setExon(entity.getString("Exon"));
		else if(strict) this.setExon(entity.getString("exon")); // setting null is not an option due to function overloading
		if( entity.getString("variant_exon") != null) this.setExon(entity.getString("variant_exon"));
		else if( entity.getString("Variant_Exon") != null) this.setExon(entity.getString("Variant_Exon"));
		//set Consequence
		// query formal name, else lowercase name
		if(entity.getString("consequence") != null) this.setConsequence(entity.getString("consequence"));
		else if(entity.getString("Consequence") != null) this.setConsequence(entity.getString("Consequence"));
		else if(strict) this.setConsequence(entity.getString("consequence")); // setting null is not an option due to function overloading
		if( entity.getString("variant_consequence") != null) this.setConsequence(entity.getString("variant_consequence"));
		else if( entity.getString("Variant_Consequence") != null) this.setConsequence(entity.getString("Variant_Consequence"));
		//set Inheritance
		// query formal name, else lowercase name
		if(entity.getString("inheritance") != null) this.setInheritance(entity.getString("inheritance"));
		else if(entity.getString("Inheritance") != null) this.setInheritance(entity.getString("Inheritance"));
		else if(strict) this.setInheritance(entity.getString("inheritance")); // setting null is not an option due to function overloading
		if( entity.getString("variant_inheritance") != null) this.setInheritance(entity.getString("variant_inheritance"));
		else if( entity.getString("Variant_Inheritance") != null) this.setInheritance(entity.getString("Variant_Inheritance"));
		//set ReportedSNP
		// query formal name, else lowercase name
		if(entity.getBoolean("reportedsnp") != null) this.setReportedSNP(entity.getBoolean("reportedsnp"));
		else if(entity.getBoolean("ReportedSNP") != null) this.setReportedSNP(entity.getBoolean("ReportedSNP"));
		else if(strict) this.setReportedSNP(entity.getBoolean("reportedsnp")); // setting null is not an option due to function overloading
		if( entity.getBoolean("variant_reportedsnp") != null) this.setReportedSNP(entity.getBoolean("variant_reportedsnp"));
		else if( entity.getBoolean("Variant_ReportedSNP") != null) this.setReportedSNP(entity.getBoolean("Variant_ReportedSNP"));
		//set EffectOnSplicing
		// query formal name, else lowercase name
		if(entity.getBoolean("effectonsplicing") != null) this.setEffectOnSplicing(entity.getBoolean("effectonsplicing"));
		else if(entity.getBoolean("EffectOnSplicing") != null) this.setEffectOnSplicing(entity.getBoolean("EffectOnSplicing"));
		else if(strict) this.setEffectOnSplicing(entity.getBoolean("effectonsplicing")); // setting null is not an option due to function overloading
		if( entity.getBoolean("variant_effectonsplicing") != null) this.setEffectOnSplicing(entity.getBoolean("variant_effectonsplicing"));
		else if( entity.getBoolean("Variant_EffectOnSplicing") != null) this.setEffectOnSplicing(entity.getBoolean("Variant_EffectOnSplicing"));
		//set Pathogenicity
		// query formal name, else lowercase name
		if(entity.getString("pathogenicity") != null) this.setPathogenicity(entity.getString("pathogenicity"));
		else if(entity.getString("Pathogenicity") != null) this.setPathogenicity(entity.getString("Pathogenicity"));
		else if(strict) this.setPathogenicity(entity.getString("pathogenicity")); // setting null is not an option due to function overloading
		if( entity.getString("variant_pathogenicity") != null) this.setPathogenicity(entity.getString("variant_pathogenicity"));
		else if( entity.getString("Variant_Pathogenicity") != null) this.setPathogenicity(entity.getString("Variant_Pathogenicity"));
		//set Gene
		// query formal name, else lowercase name
		if(entity.getString("gene") != null) this.setGene(entity.getString("gene"));
		else if(entity.getString("Gene") != null) this.setGene(entity.getString("Gene"));
		else if(strict) this.setGene(entity.getString("gene")); // setting null is not an option due to function overloading
		if( entity.getString("variant_gene") != null) this.setGene(entity.getString("variant_gene"));
		else if( entity.getString("Variant_Gene") != null) this.setGene(entity.getString("Variant_Gene"));
		//set IdMutation
		// query formal name, else lowercase name
		if(entity.getInt("idmutation") != null) this.setIdMutation(entity.getInt("idmutation"));
		else if(entity.getInt("IdMutation") != null) this.setIdMutation(entity.getInt("IdMutation"));
		else if(strict) this.setIdMutation(entity.getInt("idmutation")); // setting null is not an option due to function overloading
		if( entity.getInt("variant_idmutation") != null) this.setIdMutation(entity.getInt("variant_idmutation"));
		else if( entity.getInt("Variant_IdMutation") != null) this.setIdMutation(entity.getInt("Variant_IdMutation"));
		//set DetailsForMutation
		// query formal name, else lowercase name
		if(entity.getString("detailsformutation") != null) this.setDetailsForMutation(entity.getString("detailsformutation"));
		else if(entity.getString("DetailsForMutation") != null) this.setDetailsForMutation(entity.getString("DetailsForMutation"));
		else if(strict) this.setDetailsForMutation(entity.getString("detailsformutation")); // setting null is not an option due to function overloading
		if( entity.getString("variant_detailsformutation") != null) this.setDetailsForMutation(entity.getString("variant_detailsformutation"));
		else if( entity.getString("Variant_DetailsForMutation") != null) this.setDetailsForMutation(entity.getString("Variant_DetailsForMutation"));
		//set Track
		// query formal name, else lowercase name
		if(entity.getInt("Track_id") != null) this.setTrack(entity.getInt("Track_id"));
		else if(entity.getInt("track_id") != null) this.setTrack(entity.getInt("track_id"));
		else if(strict) this.setTrack(entity.getInt("Track_id")); // setting null is not an option due to function overloading
		
		if( entity.getInt("Variant_Track_id") != null) this.setTrack(entity.getInt("Variant_Track_id"));
		else if( entity.getInt("variant_track_id") != null) this.setTrack(entity.getInt("variant_track_id"));
		//alias of xref
		if( entity.get("Track") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("Track").toString())) {
				org.molgenis.omx.xgap.Track instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("Track"), org.molgenis.omx.xgap.Track.class);
				this.setTrack(instance);				
			} else {
				this.setTrack_Id(entity.getInt("Track")); 
			}
		}
		else if( entity.get("track") != null) { 
			if(org.molgenis.util.AbstractEntity.isObjectRepresentation(entity.get("track").toString())) {
				org.molgenis.omx.xgap.Track instance = org.molgenis.util.AbstractEntity.setValuesFromString((String)entity.get("track"), org.molgenis.omx.xgap.Track.class);
				this.setTrack(instance);				
			} else {
				this.setTrack_Id(entity.getInt("Track"));
			}
		}
		if( entity.get("Variant_Track") != null)
			this.setTrack_Id(entity.getInt("Variant_Track"));			
		else if( entity.get("variant_track") != null)
			this.setTrack_Id(entity.getInt("variant_track"));
			
		if( entity.get("Variant.Track") != null) 
			this.setTrack((org.molgenis.omx.xgap.Track)entity.get("Variant.Track_id"));
		else if( entity.get("variant.track") != null) 
			this.setTrack((org.molgenis.omx.xgap.Track)entity.get("variant.track_id"));	
		//set label for field Track
		if(entity.get("Track_Identifier") != null) this.setTrack_Identifier(entity.getString("Track_Identifier"));
		else if(entity.get("track_identifier") != null) this.setTrack_Identifier(entity.getString("track_identifier"));
		else if(strict) this.setTrack_Identifier(entity.getString("Track_Identifier")); // setting null is not an option due to function overloading
		if( entity.get("Variant_Track_Identifier") != null ) this.setTrack_Identifier(entity.getString("Variant_Track_Identifier"));		
		else if( entity.get("variant_track_identifier") != null ) this.setTrack_Identifier(entity.getString("variant_track_identifier"));
	}

	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		String result = "Variant(";
		result+= "id='" + getId()+"' ";	
		result+= "identifier='" + getIdentifier()+"' ";	
		result+= "name='" + getName()+"' ";	
		result+= "__Type='" + get__Type()+"' ";	
		result+= "description='" + getDescription()+"' ";	
		result+= " chromosome_id='" + getChromosome_Id()+"' ";	
		result+= " chromosome_identifier='" + getChromosome_Identifier()+"' ";
		result+= "cM='" + getCM()+"' ";	
		result+= "bpStart='" + getBpStart()+"' ";	
		result+= "bpEnd='" + getBpEnd()+"' ";	
		result+= "seq='" + getSeq()+"' ";	
		result+= "symbol='" + getSymbol()+"' ";	
		result+= "mutationPosition='" + getMutationPosition()+"' ";	
		result+= "cdnaPosition='" + getCdnaPosition()+"' ";	
		result+= "aaPosition='" + getAaPosition()+"' ";	
		result+= "variantLength='" + getVariantLength()+"' ";	
		result+= "event='" + getEvent()+"' ";	
		result+= "ntChange='" + getNtChange()+"' ";	
		result+= "codonchange='" + getCodonchange()+"' ";	
		result+= "cdnaNotation='" + getCdnaNotation()+"' ";	
		result+= "gdnaNotation='" + getGdnaNotation()+"' ";	
		result+= "aaNotation='" + getAaNotation()+"' ";	
		result+= "exon='" + getExon()+"' ";	
		result+= "consequence='" + getConsequence()+"' ";	
		result+= "inheritance='" + getInheritance()+"' ";	
		result+= "reportedSNP='" + getReportedSNP()+"' ";	
		result+= "effectOnSplicing='" + getEffectOnSplicing()+"' ";	
		result+= "pathogenicity='" + getPathogenicity()+"' ";	
		result+= "gene='" + getGene()+"' ";	
		result+= "idMutation='" + getIdMutation()+"' ";	
		result+= "detailsForMutation='" + getDetailsForMutation()+"' ";	
		result+= " track_id='" + getTrack_Id()+"' ";	
		result+= " track_identifier='" + getTrack_Identifier()+"' ";
		result += ");";
		return result;

	}

	/**
	 * Get the names of all public properties of Variant.
	 */
	@Override
	public java.util.Vector<String> getFields(boolean skipAutoIds)
	{
		java.util.Vector<String> fields = new java.util.Vector<String>();
		if(!skipAutoIds)
		{
			fields.add("id");
		}
		{
			fields.add("Identifier");
		}
		{
			fields.add("Name");
		}
		{
			fields.add("__Type");
		}
		{
			fields.add("Description");
		}
		{
			fields.add("Chromosome_id");
		}
		fields.add("Chromosome_Identifier");
		{
			fields.add("cM");
		}
		{
			fields.add("bpStart");
		}
		{
			fields.add("bpEnd");
		}
		{
			fields.add("Seq");
		}
		{
			fields.add("Symbol");
		}
		{
			fields.add("MutationPosition");
		}
		{
			fields.add("CdnaPosition");
		}
		{
			fields.add("AaPosition");
		}
		{
			fields.add("VariantLength");
		}
		{
			fields.add("Event");
		}
		{
			fields.add("NtChange");
		}
		{
			fields.add("Codonchange");
		}
		{
			fields.add("CdnaNotation");
		}
		{
			fields.add("GdnaNotation");
		}
		{
			fields.add("AaNotation");
		}
		{
			fields.add("Exon");
		}
		{
			fields.add("Consequence");
		}
		{
			fields.add("Inheritance");
		}
		{
			fields.add("ReportedSNP");
		}
		{
			fields.add("EffectOnSplicing");
		}
		{
			fields.add("Pathogenicity");
		}
		{
			fields.add("Gene");
		}
		{
			fields.add("IdMutation");
		}
		{
			fields.add("DetailsForMutation");
		}
		{
			fields.add("Track_id");
		}
		fields.add("Track_Identifier");
		return fields;
	}	

	@Override
	public java.util.Vector<String> getFields()
	{
		return getFields(false);
	}

	@Override
	public String getIdField()
	{
		return "id";
	}

	@Override
	public java.util.List<String> getLabelFields()
	{
		java.util.List<String> result = new java.util.ArrayList<String>();
		result.add("Identifier");
		return result;
	}

	@Deprecated
	@Override
	public String getFields(String sep)
	{
		return (""
		+ "id" +sep
		+ "identifier" +sep
		+ "name" +sep
		+ "__Type" +sep
		+ "description" +sep
		+ "chromosome" +sep
		+ "cM" +sep
		+ "bpStart" +sep
		+ "bpEnd" +sep
		+ "seq" +sep
		+ "symbol" +sep
		+ "mutationPosition" +sep
		+ "cdnaPosition" +sep
		+ "aaPosition" +sep
		+ "variantLength" +sep
		+ "event" +sep
		+ "ntChange" +sep
		+ "codonchange" +sep
		+ "cdnaNotation" +sep
		+ "gdnaNotation" +sep
		+ "aaNotation" +sep
		+ "exon" +sep
		+ "consequence" +sep
		+ "inheritance" +sep
		+ "reportedSNP" +sep
		+ "effectOnSplicing" +sep
		+ "pathogenicity" +sep
		+ "gene" +sep
		+ "idMutation" +sep
		+ "detailsForMutation" +sep
		+ "track" 
		);
	}

	@Override
	public Object getIdValue()
	{
		return get(getIdField());
	}		
	
	@Override
    public String getXrefIdFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("chromosome")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("track")) {
            return "id";
        }
        
        return null;
    }	

	@Deprecated
	@Override
	public String getValues(String sep)
	{
		java.io.StringWriter out = new java.io.StringWriter();
		{
			Object valueO = getId();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdentifier();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getName();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = get__Type();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDescription();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getChromosome();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCM();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpStart();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getBpEnd();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSeq();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getSymbol();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getMutationPosition();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCdnaPosition();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getAaPosition();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getVariantLength();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getEvent();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getNtChange();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCodonchange();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getCdnaNotation();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getGdnaNotation();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getAaNotation();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getExon();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getConsequence();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getInheritance();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getReportedSNP();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getEffectOnSplicing();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getPathogenicity();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getGene();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getIdMutation();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getDetailsForMutation();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS+sep);
		}
		{
			Object valueO = getTrack();
			String valueS;
			if (valueO != null)
				valueS = valueO.toString();
			else 
				valueS = "";
			valueS = valueS.replaceAll("\r\n"," ").replaceAll("\n"," ").replaceAll("\r"," ");
			valueS = valueS.replaceAll("\t"," ").replaceAll(sep," ");
			out.write(valueS);
		}
		return out.toString();
	}
	
	@Override
	public Variant create(org.molgenis.data.Entity entity) throws Exception
	{
		Variant e = new Variant();
		e.set(entity);
		return e;
	}
	

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (!super.equals(obj)) return false;
		if (getClass() != obj.getClass()) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		int result = super.hashCode();
		return result;
	}
}
