/* File:        org.molgenis.omx/model/Chromosome.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class ChromosomeJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.xgap.Chromosome>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(ChromosomeJpaMapper.class);

	public ChromosomeJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Chromosome.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Chromosome.orderNr"
			+", Chromosome.isAutosomal"
			+", Chromosome.bpLength"
			+", Chromosome.Species"
			//parent is SimpleTree(name='Species')
			+", xref_Species.Identifier AS Species_Identifier"
			+" FROM Chromosome "
			+" INNER JOIN ObservationTarget ON (Chromosome.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Chromosome.id = Characteristic.id)"

			
			//label for Species=Identifier
//path==Species. type==xref.
//path==Species_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Species " 
			+" ON xref_Species.id = Chromosome.Species"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.xgap.Chromosome entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Species' is known in the databse
			if(entity.getSpecies() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getSpecies().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(getDatabase()).create(entity.getSpecies());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getSpecies()) && entity.getSpecies().getIdValue() != null)
					entity.setSpecies(getEntityManager().getReference(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getSpecies().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getSpecies_Id() != null) {
					entity.setSpecies((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getSpecies_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.xgap.Chromosome chromosome) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				chromosome = getEntityManager().getReference(org.molgenis.omx.xgap.Chromosome.class, chromosome.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The chromosome with id " + chromosome.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(chromosome);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.xgap.Chromosome chromosome) throws org.molgenis.framework.db.DatabaseException {
		try {










			//9
			org.molgenis.omx.observ.target.OntologyTerm speciesNew = chromosome.getSpecies();

			if (speciesNew == null) { //object is reference by xref		
                            if(chromosome.getSpecies_Id() != null) {
                                chromosome.setSpecies((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, chromosome.getSpecies_Id()));
                            }
			}
			if(!getEntityManager().contains(chromosome)) {
				chromosome = getEntityManager().merge(chromosome);
			}
			

		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.xgap.Chromosome> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.xgap.Chromosome chromosome : entities) 
			{
				create(chromosome);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.xgap.Chromosome> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.xgap.Chromosome chromosome : entities) 
			{
				edit(chromosome);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.xgap.Chromosome> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.xgap.Chromosome chromosome : entities) 
			{
				destroy(chromosome);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Chromosome_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Chromosome_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Chromosome_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Chromosome___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Chromosome_description".equalsIgnoreCase(fieldName)) return "description";
		if("orderNr".equalsIgnoreCase(fieldName)) return "orderNr";
		if("Chromosome_orderNr".equalsIgnoreCase(fieldName)) return "orderNr";
		if("isAutosomal".equalsIgnoreCase(fieldName)) return "isAutosomal";
		if("Chromosome_isAutosomal".equalsIgnoreCase(fieldName)) return "isAutosomal";
		if("bpLength".equalsIgnoreCase(fieldName)) return "bpLength";
		if("Chromosome_bpLength".equalsIgnoreCase(fieldName)) return "bpLength";
		if("Species".equalsIgnoreCase(fieldName)) return "Species";
		if("Chromosome_Species".equalsIgnoreCase(fieldName)) return "Species";
		if("Species_id".equalsIgnoreCase(fieldName)) return "Species";
		if("Chromosome_Species_id".equalsIgnoreCase(fieldName)) return "Species";
		if("Species_Identifier".equalsIgnoreCase(fieldName)) return "Species.Identifier";	
		if("Chromosome_Species_Identifier".equalsIgnoreCase(fieldName)) return "Species.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.xgap.Chromosome> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.xgap.Chromosome>(size);
	}			

	@Override
	public org.molgenis.omx.xgap.Chromosome create()
	{
		return new org.molgenis.omx.xgap.Chromosome();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.xgap.Chromosome> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'species' to ontologyTerm.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> speciesRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.xgap.Chromosome object: entities)
		{
			//create xref/mref rule filtering OntologyTerm on the label Identifier
			if(object.getSpecies_Id() == null && object.getSpecies_Identifier() != null)
			{
				Object label = object.getSpecies_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!speciesRules.containsKey(label))
					{
						speciesRules.put(""+label, xrefFilter);
						speciesRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'species' to ontologyTerm.id using Identifier)
		final java.util.Map<String,Integer> species_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(speciesRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.OntologyTerm> speciesList = null;
			try
			{
				speciesList = getDatabase().find(org.molgenis.omx.observ.target.OntologyTerm.class, speciesRules.values().toArray(new org.molgenis.framework.db.QueryRule[speciesRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.OntologyTerm xref :  speciesList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				species_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.xgap.Chromosome object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getSpecies_Id() == null )
			{
					String key = "";
					if(object.getSpecies_Identifier() != null)
						key += 	object.getSpecies_Identifier();
					
					if(!"".equals(key) && species_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Species_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setSpecies_Id(species_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "chromosome.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("orderNr".equalsIgnoreCase(fieldName) || "chromosome.orderNr".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("isAutosomal".equalsIgnoreCase(fieldName) || "chromosome.isAutosomal".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
			if("bpLength".equalsIgnoreCase(fieldName) || "chromosome.bpLength".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("species".equalsIgnoreCase(fieldName) || "chromosome.species".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.xgap.Chromosome> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.xgap.Chromosome> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
