
/* File:        org.molgenis.omx/model/Gene.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Chromosome;
import org.molgenis.omx.xgap.Gene;


/**
 * Reads Gene from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class GeneEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(GeneEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'chromosome' (maps chromosome.Identifier -> chromosome.id)			
	final Map<String,Integer> chromosomeKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Gene from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Gene> genesMissingRefs = new ArrayList<Gene>();
	
		//cache for objects to be imported from file (in batch)
		final List<Gene> geneList = new ArrayList<Gene>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Gene object = new Gene();
			object.set(entity, false);				
			geneList.add(object);		
			
			//add to db when batch size is reached
			if(geneList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				genesMissingRefs.addAll(resolveForeignKeys(db, geneList));
				geneList.removeAll(genesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(geneList,dbAction, "Identifier");
				
				//clear for next batch						
				geneList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!geneList.isEmpty())
		{
			total.set(total.get() + geneList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			genesMissingRefs.addAll(resolveForeignKeys(db, geneList));
			geneList.removeAll(genesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(geneList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Gene> genes = new ArrayList<Gene>(genesMissingRefs);

		int iterationCount = 0;

		do
		{
			genesMissingRefs = resolveForeignKeys(db, genesMissingRefs);
			
			LinkedHashSet<Gene> differenceSet = new LinkedHashSet<Gene>();
			Sets.symmetricDifference(new LinkedHashSet<Gene>(genes), new LinkedHashSet<Gene>(genesMissingRefs)).copyInto(differenceSet);
			List<Gene> resolvablegenes = new ArrayList<Gene>(differenceSet);
			
			genes.removeAll(resolvablegenes);
			
			db.update(resolvablegenes,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Gene blaat : genesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'gene' entity failed:"
								+ "This is probably caused by a(n) 'gene' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (genesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " gene from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param geneList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Gene> resolveForeignKeys(Database db, List<Gene> geneList) throws Exception
	{
		//keep a list of Gene instances that miss a reference which might be resolvable later
		List<Gene> genesMissingRefs = new ArrayList<Gene>();
	
		//resolve xref 'chromosome' from chromosome.Identifier -> chromosome.id
		for(Gene o: geneList) 
		{
			if(o.getChromosome_Identifier() != null) 
				chromosomeKeymap.put(o.getChromosome_Identifier(), null);
		}
		
		if(chromosomeKeymap.size() > 0) 
		{
			List<Chromosome> chromosomeList = db.query(Chromosome.class).in("Identifier",new ArrayList<Object>(chromosomeKeymap.keySet())).find();
			for(Chromosome xref :  chromosomeList)
			{
				chromosomeKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Gene o:  geneList)
		{
			while(true){
				//update xref Chromosome
				if(o.getChromosome_Identifier() != null) 
				{
					String key = o.getChromosome_Identifier();
					if(chromosomeKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Gene' objects failed: cannot find Chromosome for chromosome_Identifier='"+o.getChromosome_Identifier()+"'");
					}
					o.setChromosome_Id(chromosomeKeymap.get(key));
				}
				break;
			}
		}
		
		chromosomeKeymap.clear();
		
		return genesMissingRefs;
	}
}

