
/* File:        org.molgenis.omx/model/Metabolite.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Metabolite;


/**
 * Reads Metabolite from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class MetaboliteEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(MetaboliteEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports Metabolite from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Metabolite> metabolitesMissingRefs = new ArrayList<Metabolite>();
	
		//cache for objects to be imported from file (in batch)
		final List<Metabolite> metaboliteList = new ArrayList<Metabolite>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Metabolite object = new Metabolite();
			object.set(entity, false);				
			metaboliteList.add(object);		
			
			//add to db when batch size is reached
			if(metaboliteList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				metabolitesMissingRefs.addAll(resolveForeignKeys(db, metaboliteList));
				metaboliteList.removeAll(metabolitesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(metaboliteList,dbAction, "Identifier");
				
				//clear for next batch						
				metaboliteList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!metaboliteList.isEmpty())
		{
			total.set(total.get() + metaboliteList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			metabolitesMissingRefs.addAll(resolveForeignKeys(db, metaboliteList));
			metaboliteList.removeAll(metabolitesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(metaboliteList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Metabolite> metabolites = new ArrayList<Metabolite>(metabolitesMissingRefs);

		int iterationCount = 0;

		do
		{
			metabolitesMissingRefs = resolveForeignKeys(db, metabolitesMissingRefs);
			
			LinkedHashSet<Metabolite> differenceSet = new LinkedHashSet<Metabolite>();
			Sets.symmetricDifference(new LinkedHashSet<Metabolite>(metabolites), new LinkedHashSet<Metabolite>(metabolitesMissingRefs)).copyInto(differenceSet);
			List<Metabolite> resolvablemetabolites = new ArrayList<Metabolite>(differenceSet);
			
			metabolites.removeAll(resolvablemetabolites);
			
			db.update(resolvablemetabolites,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Metabolite blaat : metabolitesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'metabolite' entity failed:"
								+ "This is probably caused by a(n) 'metabolite' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (metabolitesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " metabolite from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param metaboliteList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Metabolite> resolveForeignKeys(Database db, List<Metabolite> metaboliteList) throws Exception
	{
		//keep a list of Metabolite instances that miss a reference which might be resolvable later
		List<Metabolite> metabolitesMissingRefs = new ArrayList<Metabolite>();
	
		//update objects with foreign key values
		for(Metabolite o:  metaboliteList)
		{
			while(true){
				break;
			}
		}
		
		
		return metabolitesMissingRefs;
	}
}

