
/* File:        org.molgenis.omx/model/Polymorphism.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Polymorphism;


/**
 * Reads Polymorphism from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class PolymorphismEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(PolymorphismEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports Polymorphism from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Polymorphism> polymorphismsMissingRefs = new ArrayList<Polymorphism>();
	
		//cache for objects to be imported from file (in batch)
		final List<Polymorphism> polymorphismList = new ArrayList<Polymorphism>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Polymorphism object = new Polymorphism();
			object.set(entity, false);				
			polymorphismList.add(object);		
			
			//add to db when batch size is reached
			if(polymorphismList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				polymorphismsMissingRefs.addAll(resolveForeignKeys(db, polymorphismList));
				polymorphismList.removeAll(polymorphismsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(polymorphismList,dbAction, "Identifier");
				
				//clear for next batch						
				polymorphismList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!polymorphismList.isEmpty())
		{
			total.set(total.get() + polymorphismList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			polymorphismsMissingRefs.addAll(resolveForeignKeys(db, polymorphismList));
			polymorphismList.removeAll(polymorphismsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(polymorphismList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Polymorphism> polymorphisms = new ArrayList<Polymorphism>(polymorphismsMissingRefs);

		int iterationCount = 0;

		do
		{
			polymorphismsMissingRefs = resolveForeignKeys(db, polymorphismsMissingRefs);
			
			LinkedHashSet<Polymorphism> differenceSet = new LinkedHashSet<Polymorphism>();
			Sets.symmetricDifference(new LinkedHashSet<Polymorphism>(polymorphisms), new LinkedHashSet<Polymorphism>(polymorphismsMissingRefs)).copyInto(differenceSet);
			List<Polymorphism> resolvablepolymorphisms = new ArrayList<Polymorphism>(differenceSet);
			
			polymorphisms.removeAll(resolvablepolymorphisms);
			
			db.update(resolvablepolymorphisms,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Polymorphism blaat : polymorphismsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'polymorphism' entity failed:"
								+ "This is probably caused by a(n) 'polymorphism' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (polymorphismsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " polymorphism from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param polymorphismList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Polymorphism> resolveForeignKeys(Database db, List<Polymorphism> polymorphismList) throws Exception
	{
		//keep a list of Polymorphism instances that miss a reference which might be resolvable later
		List<Polymorphism> polymorphismsMissingRefs = new ArrayList<Polymorphism>();
	
		//update objects with foreign key values
		for(Polymorphism o:  polymorphismList)
		{
			while(true){
				break;
			}
		}
		
		
		return polymorphismsMissingRefs;
	}
}

