
/* File:        org.molgenis.omx/model/Probe.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Chromosome;
import org.molgenis.omx.xgap.ProbeSet;
import org.molgenis.omx.xgap.Gene;
import org.molgenis.omx.xgap.Probe;


/**
 * Reads Probe from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class ProbeEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(ProbeEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'chromosome' (maps chromosome.Identifier -> chromosome.id)			
	final Map<String,Integer> chromosomeKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'probeSet' (maps probeSet.Identifier -> probeSet.id)			
	final Map<String,Integer> probeSetKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'reportsFor' (maps gene.Identifier -> gene.id)			
	final Map<String,Integer> reportsForKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Probe from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Probe> probesMissingRefs = new ArrayList<Probe>();
	
		//cache for objects to be imported from file (in batch)
		final List<Probe> probeList = new ArrayList<Probe>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Probe object = new Probe();
			object.set(entity, false);				
			probeList.add(object);		
			
			//add to db when batch size is reached
			if(probeList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				probesMissingRefs.addAll(resolveForeignKeys(db, probeList));
				probeList.removeAll(probesMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(probeList,dbAction, "Identifier");
				
				//clear for next batch						
				probeList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!probeList.isEmpty())
		{
			total.set(total.get() + probeList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			probesMissingRefs.addAll(resolveForeignKeys(db, probeList));
			probeList.removeAll(probesMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(probeList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Probe> probes = new ArrayList<Probe>(probesMissingRefs);

		int iterationCount = 0;

		do
		{
			probesMissingRefs = resolveForeignKeys(db, probesMissingRefs);
			
			LinkedHashSet<Probe> differenceSet = new LinkedHashSet<Probe>();
			Sets.symmetricDifference(new LinkedHashSet<Probe>(probes), new LinkedHashSet<Probe>(probesMissingRefs)).copyInto(differenceSet);
			List<Probe> resolvableprobes = new ArrayList<Probe>(differenceSet);
			
			probes.removeAll(resolvableprobes);
			
			db.update(resolvableprobes,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Probe blaat : probesMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'probe' entity failed:"
								+ "This is probably caused by a(n) 'probe' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (probesMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " probe from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param probeList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Probe> resolveForeignKeys(Database db, List<Probe> probeList) throws Exception
	{
		//keep a list of Probe instances that miss a reference which might be resolvable later
		List<Probe> probesMissingRefs = new ArrayList<Probe>();
	
		//resolve xref 'chromosome' from chromosome.Identifier -> chromosome.id
		for(Probe o: probeList) 
		{
			if(o.getChromosome_Identifier() != null) 
				chromosomeKeymap.put(o.getChromosome_Identifier(), null);
		}
		
		if(chromosomeKeymap.size() > 0) 
		{
			List<Chromosome> chromosomeList = db.query(Chromosome.class).in("Identifier",new ArrayList<Object>(chromosomeKeymap.keySet())).find();
			for(Chromosome xref :  chromosomeList)
			{
				chromosomeKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'probeSet' from probeSet.Identifier -> probeSet.id
		for(Probe o: probeList) 
		{
			if(o.getProbeSet_Identifier() != null) 
				probeSetKeymap.put(o.getProbeSet_Identifier(), null);
		}
		
		if(probeSetKeymap.size() > 0) 
		{
			List<ProbeSet> probeSetList = db.query(ProbeSet.class).in("Identifier",new ArrayList<Object>(probeSetKeymap.keySet())).find();
			for(ProbeSet xref :  probeSetList)
			{
				probeSetKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'reportsFor' from gene.Identifier -> gene.id
		for(Probe o: probeList) 
		{
			if(o.getReportsFor_Identifier() != null) 
				reportsForKeymap.put(o.getReportsFor_Identifier(), null);
		}
		
		if(reportsForKeymap.size() > 0) 
		{
			List<Gene> reportsForList = db.query(Gene.class).in("Identifier",new ArrayList<Object>(reportsForKeymap.keySet())).find();
			for(Gene xref :  reportsForList)
			{
				reportsForKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Probe o:  probeList)
		{
			while(true){
				//update xref Chromosome
				if(o.getChromosome_Identifier() != null) 
				{
					String key = o.getChromosome_Identifier();
					if(chromosomeKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Probe' objects failed: cannot find Chromosome for chromosome_Identifier='"+o.getChromosome_Identifier()+"'");
					}
					o.setChromosome_Id(chromosomeKeymap.get(key));
				}
				//update xref ProbeSet
				if(o.getProbeSet_Identifier() != null) 
				{
					String key = o.getProbeSet_Identifier();
					if(probeSetKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Probe' objects failed: cannot find ProbeSet for probeSet_Identifier='"+o.getProbeSet_Identifier()+"'");
					}
					o.setProbeSet_Id(probeSetKeymap.get(key));
				}
				//update xref ReportsFor
				if(o.getReportsFor_Identifier() != null) 
				{
					String key = o.getReportsFor_Identifier();
					if(reportsForKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Probe' objects failed: cannot find Gene for reportsFor_Identifier='"+o.getReportsFor_Identifier()+"'");
					}
					o.setReportsFor_Id(reportsForKeymap.get(key));
				}
				break;
			}
		}
		
		chromosomeKeymap.clear();
		probeSetKeymap.clear();
		reportsForKeymap.clear();
		
		return probesMissingRefs;
	}
}

