
/* File:        org.molgenis.omx/model/ProbeSet.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Chromosome;
import org.molgenis.omx.xgap.ProbeSet;


/**
 * Reads ProbeSet from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class ProbeSetEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(ProbeSetEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'chromosome' (maps chromosome.Identifier -> chromosome.id)			
	final Map<String,Integer> chromosomeKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports ProbeSet from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<ProbeSet> probeSetsMissingRefs = new ArrayList<ProbeSet>();
	
		//cache for objects to be imported from file (in batch)
		final List<ProbeSet> probeSetList = new ArrayList<ProbeSet>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			ProbeSet object = new ProbeSet();
			object.set(entity, false);				
			probeSetList.add(object);		
			
			//add to db when batch size is reached
			if(probeSetList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				probeSetsMissingRefs.addAll(resolveForeignKeys(db, probeSetList));
				probeSetList.removeAll(probeSetsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(probeSetList,dbAction, "Identifier");
				
				//clear for next batch						
				probeSetList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!probeSetList.isEmpty())
		{
			total.set(total.get() + probeSetList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			probeSetsMissingRefs.addAll(resolveForeignKeys(db, probeSetList));
			probeSetList.removeAll(probeSetsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(probeSetList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<ProbeSet> probeSets = new ArrayList<ProbeSet>(probeSetsMissingRefs);

		int iterationCount = 0;

		do
		{
			probeSetsMissingRefs = resolveForeignKeys(db, probeSetsMissingRefs);
			
			LinkedHashSet<ProbeSet> differenceSet = new LinkedHashSet<ProbeSet>();
			Sets.symmetricDifference(new LinkedHashSet<ProbeSet>(probeSets), new LinkedHashSet<ProbeSet>(probeSetsMissingRefs)).copyInto(differenceSet);
			List<ProbeSet> resolvableprobeSets = new ArrayList<ProbeSet>(differenceSet);
			
			probeSets.removeAll(resolvableprobeSets);
			
			db.update(resolvableprobeSets,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(ProbeSet blaat : probeSetsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'probeSet' entity failed:"
								+ "This is probably caused by a(n) 'probeSet' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (probeSetsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " probeSet from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param probeSetList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<ProbeSet> resolveForeignKeys(Database db, List<ProbeSet> probeSetList) throws Exception
	{
		//keep a list of ProbeSet instances that miss a reference which might be resolvable later
		List<ProbeSet> probeSetsMissingRefs = new ArrayList<ProbeSet>();
	
		//resolve xref 'chromosome' from chromosome.Identifier -> chromosome.id
		for(ProbeSet o: probeSetList) 
		{
			if(o.getChromosome_Identifier() != null) 
				chromosomeKeymap.put(o.getChromosome_Identifier(), null);
		}
		
		if(chromosomeKeymap.size() > 0) 
		{
			List<Chromosome> chromosomeList = db.query(Chromosome.class).in("Identifier",new ArrayList<Object>(chromosomeKeymap.keySet())).find();
			for(Chromosome xref :  chromosomeList)
			{
				chromosomeKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(ProbeSet o:  probeSetList)
		{
			while(true){
				//update xref Chromosome
				if(o.getChromosome_Identifier() != null) 
				{
					String key = o.getChromosome_Identifier();
					if(chromosomeKeymap.get(key) == null)
					{
						throw new Exception("Import of 'ProbeSet' objects failed: cannot find Chromosome for chromosome_Identifier='"+o.getChromosome_Identifier()+"'");
					}
					o.setChromosome_Id(chromosomeKeymap.get(key));
				}
				break;
			}
		}
		
		chromosomeKeymap.clear();
		
		return probeSetsMissingRefs;
	}
}

