
/* File:        org.molgenis.omx/model/Protein.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Gene;
import org.molgenis.omx.xgap.Transcript;
import org.molgenis.omx.xgap.Protein;


/**
 * Reads Protein from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class ProteinEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(ProteinEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'gene' (maps gene.Identifier -> gene.id)			
	final Map<String,Integer> geneKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'transcript' (maps transcript.Identifier -> transcript.id)			
	final Map<String,Integer> transcriptKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Protein from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Protein> proteinsMissingRefs = new ArrayList<Protein>();
	
		//cache for objects to be imported from file (in batch)
		final List<Protein> proteinList = new ArrayList<Protein>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Protein object = new Protein();
			object.set(entity, false);				
			proteinList.add(object);		
			
			//add to db when batch size is reached
			if(proteinList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				proteinsMissingRefs.addAll(resolveForeignKeys(db, proteinList));
				proteinList.removeAll(proteinsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(proteinList,dbAction, "Identifier");
				
				//clear for next batch						
				proteinList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!proteinList.isEmpty())
		{
			total.set(total.get() + proteinList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			proteinsMissingRefs.addAll(resolveForeignKeys(db, proteinList));
			proteinList.removeAll(proteinsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(proteinList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Protein> proteins = new ArrayList<Protein>(proteinsMissingRefs);

		int iterationCount = 0;

		do
		{
			proteinsMissingRefs = resolveForeignKeys(db, proteinsMissingRefs);
			
			LinkedHashSet<Protein> differenceSet = new LinkedHashSet<Protein>();
			Sets.symmetricDifference(new LinkedHashSet<Protein>(proteins), new LinkedHashSet<Protein>(proteinsMissingRefs)).copyInto(differenceSet);
			List<Protein> resolvableproteins = new ArrayList<Protein>(differenceSet);
			
			proteins.removeAll(resolvableproteins);
			
			db.update(resolvableproteins,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Protein blaat : proteinsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'protein' entity failed:"
								+ "This is probably caused by a(n) 'protein' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (proteinsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " protein from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param proteinList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Protein> resolveForeignKeys(Database db, List<Protein> proteinList) throws Exception
	{
		//keep a list of Protein instances that miss a reference which might be resolvable later
		List<Protein> proteinsMissingRefs = new ArrayList<Protein>();
	
		//resolve xref 'gene' from gene.Identifier -> gene.id
		for(Protein o: proteinList) 
		{
			if(o.getGene_Identifier() != null) 
				geneKeymap.put(o.getGene_Identifier(), null);
		}
		
		if(geneKeymap.size() > 0) 
		{
			List<Gene> geneList = db.query(Gene.class).in("Identifier",new ArrayList<Object>(geneKeymap.keySet())).find();
			for(Gene xref :  geneList)
			{
				geneKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'transcript' from transcript.Identifier -> transcript.id
		for(Protein o: proteinList) 
		{
			if(o.getTranscript_Identifier() != null) 
				transcriptKeymap.put(o.getTranscript_Identifier(), null);
		}
		
		if(transcriptKeymap.size() > 0) 
		{
			List<Transcript> transcriptList = db.query(Transcript.class).in("Identifier",new ArrayList<Object>(transcriptKeymap.keySet())).find();
			for(Transcript xref :  transcriptList)
			{
				transcriptKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Protein o:  proteinList)
		{
			while(true){
				//update xref Gene
				if(o.getGene_Identifier() != null) 
				{
					String key = o.getGene_Identifier();
					if(geneKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Protein' objects failed: cannot find Gene for gene_Identifier='"+o.getGene_Identifier()+"'");
					}
					o.setGene_Id(geneKeymap.get(key));
				}
				//update xref Transcript
				if(o.getTranscript_Identifier() != null) 
				{
					String key = o.getTranscript_Identifier();
					if(transcriptKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Protein' objects failed: cannot find Transcript for transcript_Identifier='"+o.getTranscript_Identifier()+"'");
					}
					o.setTranscript_Id(transcriptKeymap.get(key));
				}
				break;
			}
		}
		
		geneKeymap.clear();
		transcriptKeymap.clear();
		
		return proteinsMissingRefs;
	}
}

