/* File:        org.molgenis.omx/model/Sample.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class SampleJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.xgap.Sample>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(SampleJpaMapper.class);

	public SampleJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Sample.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Sample.Individual"
			+", Sample.Tissue"
			//parent is SimpleTree(name='Individual')
			+", xref_Individual.Identifier AS Individual_Identifier"
			//parent is SimpleTree(name='Tissue')
			+", xref_Tissue.Identifier AS Tissue_Identifier"
			+" FROM Sample "
			+" INNER JOIN ObservationTarget ON (Sample.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Sample.id = Characteristic.id)"

			
			//label for Individual=Identifier
//path==Individual. type==xref.
//path==Individual_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Individual " 
			+" ON xref_Individual.id = Sample.Individual"
			
			//label for Tissue=Identifier
//path==Tissue. type==xref.
//path==Tissue_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Tissue " 
			+" ON xref_Tissue.id = Sample.Tissue"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.xgap.Sample entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Individual' is known in the databse
			if(entity.getIndividual() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getIndividual().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.IndividualJpaMapper(getDatabase()).create(entity.getIndividual());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getIndividual()) && entity.getIndividual().getIdValue() != null)
					entity.setIndividual(getEntityManager().getReference(org.molgenis.omx.observ.target.Individual.class, entity.getIndividual().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getIndividual_Id() != null) {
					entity.setIndividual((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, entity.getIndividual_Id()));
				}
			}
			//check if the object refered by 'Tissue' is known in the databse
			if(entity.getTissue() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getTissue().getIdValue() == null)
					new org.molgenis.omx.observ.target.db.OntologyTermJpaMapper(getDatabase()).create(entity.getTissue());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getTissue()) && entity.getTissue().getIdValue() != null)
					entity.setTissue(getEntityManager().getReference(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getTissue().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getTissue_Id() != null) {
					entity.setTissue((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, entity.getTissue_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.xgap.Sample sample) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				sample = getEntityManager().getReference(org.molgenis.omx.xgap.Sample.class, sample.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The sample with id " + sample.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(sample);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.xgap.Sample sample) throws org.molgenis.framework.db.DatabaseException {
		try {







			//6
			org.molgenis.omx.observ.target.Individual individualNew = sample.getIndividual();

			if (individualNew == null) { //object is reference by xref		
                            if(sample.getIndividual_Id() != null) {
                                sample.setIndividual((org.molgenis.omx.observ.target.Individual)getEntityManager().find(org.molgenis.omx.observ.target.Individual.class, sample.getIndividual_Id()));
                            }
			}


			//9
			org.molgenis.omx.observ.target.OntologyTerm tissueNew = sample.getTissue();

			if (tissueNew == null) { //object is reference by xref		
                            if(sample.getTissue_Id() != null) {
                                sample.setTissue((org.molgenis.omx.observ.target.OntologyTerm)getEntityManager().find(org.molgenis.omx.observ.target.OntologyTerm.class, sample.getTissue_Id()));
                            }
			}
			if(!getEntityManager().contains(sample)) {
				sample = getEntityManager().merge(sample);
			}
			


		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.xgap.Sample> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.xgap.Sample sample : entities) 
			{
				create(sample);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.xgap.Sample> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.xgap.Sample sample : entities) 
			{
				edit(sample);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.xgap.Sample> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.xgap.Sample sample : entities) 
			{
				destroy(sample);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Sample_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Sample_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Sample_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Sample___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Sample_description".equalsIgnoreCase(fieldName)) return "description";
		if("Individual".equalsIgnoreCase(fieldName)) return "Individual";
		if("Sample_Individual".equalsIgnoreCase(fieldName)) return "Individual";
		if("Tissue".equalsIgnoreCase(fieldName)) return "Tissue";
		if("Sample_Tissue".equalsIgnoreCase(fieldName)) return "Tissue";
		if("Individual_id".equalsIgnoreCase(fieldName)) return "Individual";
		if("Sample_Individual_id".equalsIgnoreCase(fieldName)) return "Individual";
		if("Individual_Identifier".equalsIgnoreCase(fieldName)) return "Individual.Identifier";	
		if("Sample_Individual_Identifier".equalsIgnoreCase(fieldName)) return "Individual.Identifier";
		if("Tissue_id".equalsIgnoreCase(fieldName)) return "Tissue";
		if("Sample_Tissue_id".equalsIgnoreCase(fieldName)) return "Tissue";
		if("Tissue_Identifier".equalsIgnoreCase(fieldName)) return "Tissue.Identifier";	
		if("Sample_Tissue_Identifier".equalsIgnoreCase(fieldName)) return "Tissue.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.xgap.Sample> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.xgap.Sample>(size);
	}			

	@Override
	public org.molgenis.omx.xgap.Sample create()
	{
		return new org.molgenis.omx.xgap.Sample();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.xgap.Sample> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'individual' to individual.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> individualRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'tissue' to ontologyTerm.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> tissueRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.xgap.Sample object: entities)
		{
			//create xref/mref rule filtering Individual on the label Identifier
			if(object.getIndividual_Id() == null && object.getIndividual_Identifier() != null)
			{
				Object label = object.getIndividual_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!individualRules.containsKey(label))
					{
						individualRules.put(""+label, xrefFilter);
						individualRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering OntologyTerm on the label Identifier
			if(object.getTissue_Id() == null && object.getTissue_Identifier() != null)
			{
				Object label = object.getTissue_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!tissueRules.containsKey(label))
					{
						tissueRules.put(""+label, xrefFilter);
						tissueRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'individual' to individual.id using Identifier)
		final java.util.Map<String,Integer> individual_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(individualRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.Individual> individualList = null;
			try
			{
				individualList = getDatabase().find(org.molgenis.omx.observ.target.Individual.class, individualRules.values().toArray(new org.molgenis.framework.db.QueryRule[individualRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.Individual xref :  individualList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				individual_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'tissue' to ontologyTerm.id using Identifier)
		final java.util.Map<String,Integer> tissue_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(tissueRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.observ.target.OntologyTerm> tissueList = null;
			try
			{
				tissueList = getDatabase().find(org.molgenis.omx.observ.target.OntologyTerm.class, tissueRules.values().toArray(new org.molgenis.framework.db.QueryRule[tissueRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.observ.target.OntologyTerm xref :  tissueList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				tissue_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.xgap.Sample object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getIndividual_Id() == null )
			{
					String key = "";
					if(object.getIndividual_Identifier() != null)
						key += 	object.getIndividual_Identifier();
					
					if(!"".equals(key) && individual_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Individual_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setIndividual_Id(individual_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getTissue_Id() == null )
			{
					String key = "";
					if(object.getTissue_Identifier() != null)
						key += 	object.getTissue_Identifier();
					
					if(!"".equals(key) && tissue_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Tissue_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setTissue_Id(tissue_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "sample.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("individual".equalsIgnoreCase(fieldName) || "sample.individual".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("tissue".equalsIgnoreCase(fieldName) || "sample.tissue".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.xgap.Sample> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.xgap.Sample> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
