/* File:        org.molgenis.omx/model/Spot.java
 * Copyright:   GBIC 2000-2,013, all rights reserved
 * Date:        November 22, 2013
 * Template:	JpaMapperGen.java.ftl
 * generator:   org.molgenis.generators.db.JpaMapperGen 4.0.0-testing
 *
 * Jpa Entity Mapper, helper to add, delete and update entities
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

@edu.umd.cs.findbugs.annotations.SuppressWarnings(value = "DLS_DEAD_LOCAL_STORE", justification = "Too much template code required to prevent warnings")
public class SpotJpaMapper extends org.molgenis.framework.db.jpa.AbstractJpaMapper<org.molgenis.omx.xgap.Spot>
{
	private final static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(SpotJpaMapper.class);

	public SpotJpaMapper(org.molgenis.framework.db.Database db) 
	{
		super(db);
	}
	
	@Override
	public String createFindSqlInclRules(org.molgenis.framework.db.QueryRule[] rules) throws org.molgenis.framework.db.DatabaseException
	{
		return "SELECT Spot.id"
			+", Characteristic.Identifier"
			+", Characteristic.Name"
			+", Characteristic.__Type"
			+", Characteristic.description"
			+", Probe.Chromosome"
			+", Probe.cM"
			+", Probe.bpStart"
			+", Probe.bpEnd"
			+", Probe.Seq"
			+", Probe.Symbol"
			+", Probe.Mismatch"
			+", Probe.ProbeSet"
			+", Probe.ReportsFor"
			+", Spot.x"
			+", Spot.y"
			+", Spot.GridX"
			+", Spot.GridY"
			//parent is SimpleTree(name='Chromosome')
			+", xref_Chromosome.Identifier AS Chromosome_Identifier"
			//parent is SimpleTree(name='ProbeSet')
			+", xref_ProbeSet.Identifier AS ProbeSet_Identifier"
			//parent is SimpleTree(name='ReportsFor')
			+", xref_ReportsFor.Identifier AS ReportsFor_Identifier"
			+" FROM Spot "
			+" INNER JOIN Probe ON (Spot.id = Probe.id)"
			+" INNER JOIN ObservationTarget ON (Spot.id = ObservationTarget.id)"
			+" INNER JOIN Characteristic ON (Spot.id = Characteristic.id)"

			
			//label for Chromosome=Identifier
//path==Chromosome. type==xref.
//path==Chromosome_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_Chromosome " 
			+" ON xref_Chromosome.id = Probe.Chromosome"
			
			//label for ProbeSet=Identifier
//path==ProbeSet. type==xref.
//path==ProbeSet_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_ProbeSet " 
			+" ON xref_ProbeSet.id = Probe.ProbeSet"
			
			//label for ReportsFor=Identifier
//path==ReportsFor. type==xref.
//path==ReportsFor_Identifier. type==string.
//in if path.value.type != "xref" && !pathlist?seq_contains(path.getParent().name)
		   	+" LEFT JOIN Characteristic AS xref_ReportsFor " 
			+" ON xref_ReportsFor.id = Probe.ReportsFor"
;
	}	

	/** This method first saves the objects that are being refered to by entity, 
	then the entity itself and 
	finally the objects that refer to this object*/
    public void create(org.molgenis.omx.xgap.Spot entity) throws org.molgenis.framework.db.DatabaseException {
        try {


			//check if the object refered by 'Chromosome' is known in the databse
			if(entity.getChromosome() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getChromosome().getIdValue() == null)
					new org.molgenis.omx.xgap.db.ChromosomeJpaMapper(getDatabase()).create(entity.getChromosome());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getChromosome()) && entity.getChromosome().getIdValue() != null)
					entity.setChromosome(getEntityManager().getReference(org.molgenis.omx.xgap.Chromosome.class, entity.getChromosome().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getChromosome_Id() != null) {
					entity.setChromosome((org.molgenis.omx.xgap.Chromosome)getEntityManager().find(org.molgenis.omx.xgap.Chromosome.class, entity.getChromosome_Id()));
				}
			}
			//check if the object refered by 'ProbeSet' is known in the databse
			if(entity.getProbeSet() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getProbeSet().getIdValue() == null)
					new org.molgenis.omx.xgap.db.ProbeSetJpaMapper(getDatabase()).create(entity.getProbeSet());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getProbeSet()) && entity.getProbeSet().getIdValue() != null)
					entity.setProbeSet(getEntityManager().getReference(org.molgenis.omx.xgap.ProbeSet.class, entity.getProbeSet().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getProbeSet_Id() != null) {
					entity.setProbeSet((org.molgenis.omx.xgap.ProbeSet)getEntityManager().find(org.molgenis.omx.xgap.ProbeSet.class, entity.getProbeSet_Id()));
				}
			}
			//check if the object refered by 'ReportsFor' is known in the databse
			if(entity.getReportsFor() != null)
			{
				//if object has been added as xref, but not yet stored (has no id) -> add the refered object
				if(entity.getReportsFor().getIdValue() == null)
					new org.molgenis.omx.xgap.db.GeneJpaMapper(getDatabase()).create(entity.getReportsFor());
				//if object has id (so is stored) but not in this em -> retrieve proper reference reference
				else if (!getEntityManager().contains(entity.getReportsFor()) && entity.getReportsFor().getIdValue() != null)
					entity.setReportsFor(getEntityManager().getReference(org.molgenis.omx.xgap.Gene.class, entity.getReportsFor().getIdValue()));
			} else { //object is reference by xref	
				if(entity.getReportsFor_Id() != null) {
					entity.setReportsFor((org.molgenis.omx.xgap.Gene)getEntityManager().find(org.molgenis.omx.xgap.Gene.class, entity.getReportsFor_Id()));
				}
			}

			//prevents uncontrolled recursion call of create (stack overflow)
          
          if(entity.getIdValue() != null) {
            entity = getEntityManager().merge(entity);            
          } else {
            getEntityManager().persist(entity);
          }
//inverse association relation

        } catch (Exception ex) {
            try {
				getEntityManager().getTransaction().rollback();
            } catch (Exception re) {
                throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
            }
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
    }

	public void destroy(org.molgenis.omx.xgap.Spot spot) throws org.molgenis.framework.db.DatabaseException {
		try {
			try {
				spot = getEntityManager().getReference(org.molgenis.omx.xgap.Spot.class, spot.getIdValue());
			} catch (javax.persistence.EntityNotFoundException enfe) {
				throw new org.molgenis.framework.db.DatabaseException("The spot with id " + spot.getIdField().toString() + " no longer exists: " + enfe.getMessage());
			}

			getEntityManager().remove(spot);
		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: "+re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}


	public void edit(org.molgenis.omx.xgap.Spot spot) throws org.molgenis.framework.db.DatabaseException {
		try {







			//7
			org.molgenis.omx.xgap.Chromosome chromosomeNew = spot.getChromosome();

			if (chromosomeNew == null) { //object is reference by xref		
                            if(spot.getChromosome_Id() != null) {
                                spot.setChromosome((org.molgenis.omx.xgap.Chromosome)getEntityManager().find(org.molgenis.omx.xgap.Chromosome.class, spot.getChromosome_Id()));
                            }
			}








			//1
			org.molgenis.omx.xgap.ProbeSet probeSetNew = spot.getProbeSet();

			if (probeSetNew == null) { //object is reference by xref		
                            if(spot.getProbeSet_Id() != null) {
                                spot.setProbeSet((org.molgenis.omx.xgap.ProbeSet)getEntityManager().find(org.molgenis.omx.xgap.ProbeSet.class, spot.getProbeSet_Id()));
                            }
			}


			//3
			org.molgenis.omx.xgap.Gene reportsForNew = spot.getReportsFor();

			if (reportsForNew == null) { //object is reference by xref		
                            if(spot.getReportsFor_Id() != null) {
                                spot.setReportsFor((org.molgenis.omx.xgap.Gene)getEntityManager().find(org.molgenis.omx.xgap.Gene.class, spot.getReportsFor_Id()));
                            }
			}




			if(!getEntityManager().contains(spot)) {
				spot = getEntityManager().merge(spot);
			}
			



		} catch (Exception ex) {
			try {
				getEntityManager().getTransaction().rollback();
			} catch (Exception re) {
				throw new org.molgenis.framework.db.DatabaseException("An error occurred attempting to roll back the transaction: " + re.getMessage());
			}
			throw new org.molgenis.framework.db.DatabaseException(ex);
		} 
	}

	@Override
	public int executeAdd(java.util.List<? extends org.molgenis.omx.xgap.Spot> entities) throws org.molgenis.framework.db.DatabaseException
	{	
		int count = 0;
		
		try 
		{
			for (org.molgenis.omx.xgap.Spot spot : entities) 
			{
				create(spot);
				++count;
			}
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}

	@Override
	public int executeUpdate(java.util.List<? extends org.molgenis.omx.xgap.Spot> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;

		try
		{
			for (org.molgenis.omx.xgap.Spot spot : entities) 
			{
				edit(spot);
				++count;
			} 
			return count;
		}
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }		
	}

	@Override
	public int executeRemove(java.util.List<? extends org.molgenis.omx.xgap.Spot> entities) throws org.molgenis.framework.db.DatabaseException
	{
		int count = 0;		
		try 
		{
			for (org.molgenis.omx.xgap.Spot spot : entities) 
			{
				destroy(spot);
				++count;
			}
		} 
		catch (Exception ex) 
		{
            throw new org.molgenis.framework.db.DatabaseException(ex);
        }
		return count;
	}
	
	@Override
	public String getTableFieldName(String fieldName)
	{
		if("id".equalsIgnoreCase(fieldName)) return "id";
		if("Spot_id".equalsIgnoreCase(fieldName)) return "id";
		if("Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Spot_Identifier".equalsIgnoreCase(fieldName)) return "Identifier";
		if("Name".equalsIgnoreCase(fieldName)) return "Name";
		if("Spot_Name".equalsIgnoreCase(fieldName)) return "Name";
		if("__Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("Spot___Type".equalsIgnoreCase(fieldName)) return "__Type";
		if("description".equalsIgnoreCase(fieldName)) return "description";
		if("Spot_description".equalsIgnoreCase(fieldName)) return "description";
		if("Chromosome".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("Spot_Chromosome".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("cM".equalsIgnoreCase(fieldName)) return "cM";
		if("Spot_cM".equalsIgnoreCase(fieldName)) return "cM";
		if("bpStart".equalsIgnoreCase(fieldName)) return "bpStart";
		if("Spot_bpStart".equalsIgnoreCase(fieldName)) return "bpStart";
		if("bpEnd".equalsIgnoreCase(fieldName)) return "bpEnd";
		if("Spot_bpEnd".equalsIgnoreCase(fieldName)) return "bpEnd";
		if("Seq".equalsIgnoreCase(fieldName)) return "Seq";
		if("Spot_Seq".equalsIgnoreCase(fieldName)) return "Seq";
		if("Symbol".equalsIgnoreCase(fieldName)) return "Symbol";
		if("Spot_Symbol".equalsIgnoreCase(fieldName)) return "Symbol";
		if("Mismatch".equalsIgnoreCase(fieldName)) return "Mismatch";
		if("Spot_Mismatch".equalsIgnoreCase(fieldName)) return "Mismatch";
		if("ProbeSet".equalsIgnoreCase(fieldName)) return "ProbeSet";
		if("Spot_ProbeSet".equalsIgnoreCase(fieldName)) return "ProbeSet";
		if("ReportsFor".equalsIgnoreCase(fieldName)) return "ReportsFor";
		if("Spot_ReportsFor".equalsIgnoreCase(fieldName)) return "ReportsFor";
		if("x".equalsIgnoreCase(fieldName)) return "x";
		if("Spot_x".equalsIgnoreCase(fieldName)) return "x";
		if("y".equalsIgnoreCase(fieldName)) return "y";
		if("Spot_y".equalsIgnoreCase(fieldName)) return "y";
		if("GridX".equalsIgnoreCase(fieldName)) return "GridX";
		if("Spot_GridX".equalsIgnoreCase(fieldName)) return "GridX";
		if("GridY".equalsIgnoreCase(fieldName)) return "GridY";
		if("Spot_GridY".equalsIgnoreCase(fieldName)) return "GridY";
		if("Chromosome_id".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("Spot_Chromosome_id".equalsIgnoreCase(fieldName)) return "Chromosome";
		if("Chromosome_Identifier".equalsIgnoreCase(fieldName)) return "Chromosome.Identifier";	
		if("Spot_Chromosome_Identifier".equalsIgnoreCase(fieldName)) return "Chromosome.Identifier";
		if("ProbeSet_id".equalsIgnoreCase(fieldName)) return "ProbeSet";
		if("Spot_ProbeSet_id".equalsIgnoreCase(fieldName)) return "ProbeSet";
		if("ProbeSet_Identifier".equalsIgnoreCase(fieldName)) return "ProbeSet.Identifier";	
		if("Spot_ProbeSet_Identifier".equalsIgnoreCase(fieldName)) return "ProbeSet.Identifier";
		if("ReportsFor_id".equalsIgnoreCase(fieldName)) return "ReportsFor";
		if("Spot_ReportsFor_id".equalsIgnoreCase(fieldName)) return "ReportsFor";
		if("ReportsFor_Identifier".equalsIgnoreCase(fieldName)) return "ReportsFor.Identifier";	
		if("Spot_ReportsFor_Identifier".equalsIgnoreCase(fieldName)) return "ReportsFor.Identifier";
		return fieldName;
	}
	
	/**
	 * Return EMPTY list of given allocated size
	 *
	 * @param i initial capacity of returned EMPTY list
	 * @return an EMPTY list with initial capacity given by size
	 */
	@Override
	public java.util.List<org.molgenis.omx.xgap.Spot> createList(int size)
	{
		return new java.util.ArrayList<org.molgenis.omx.xgap.Spot>(size);
	}			

	@Override
	public org.molgenis.omx.xgap.Spot create()
	{
		return new org.molgenis.omx.xgap.Spot();
	}

	@Override
	//Resolve
	public void resolveForeignKeys(java.util.List<org.molgenis.omx.xgap.Spot> entities)  throws org.molgenis.framework.db.DatabaseException, java.text.ParseException
	{
		//create foreign key map for field 'chromosome' to chromosome.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> chromosomeRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'probeSet' to probeSet.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> probeSetRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create foreign key map for field 'reportsFor' to gene.id using Identifier)	
		//we will use a hash of the values to ensure that entities are only queried once	
		final java.util.Map<String, org.molgenis.framework.db.QueryRule> reportsForRules = new java.util.LinkedHashMap<String, org.molgenis.framework.db.QueryRule>();
		//create all query rules	
		for(org.molgenis.omx.xgap.Spot object: entities)
		{
			//create xref/mref rule filtering Chromosome on the label Identifier
			if(object.getChromosome_Id() == null && object.getChromosome_Identifier() != null)
			{
				Object label = object.getChromosome_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!chromosomeRules.containsKey(label))
					{
						chromosomeRules.put(""+label, xrefFilter);
						chromosomeRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering ProbeSet on the label Identifier
			if(object.getProbeSet_Id() == null && object.getProbeSet_Identifier() != null)
			{
				Object label = object.getProbeSet_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!probeSetRules.containsKey(label))
					{
						probeSetRules.put(""+label, xrefFilter);
						probeSetRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
			//create xref/mref rule filtering Gene on the label Identifier
			if(object.getReportsFor_Id() == null && object.getReportsFor_Identifier() != null)
			{
				Object label = object.getReportsFor_Identifier();
				{
					org.molgenis.framework.db.QueryRule xrefFilter = new org.molgenis.framework.db.QueryRule("Identifier", org.molgenis.framework.db.QueryRule.Operator.EQUALS, label.toString());
					
					if(!reportsForRules.containsKey(label))
					{
						reportsForRules.put(""+label, xrefFilter);
						reportsForRules.put(""+label+"_OR_", new org.molgenis.framework.db.QueryRule(org.molgenis.framework.db.QueryRule.Operator.OR));
					}
				}
			}		
		}

		//resolve foreign key field 'chromosome' to chromosome.id using Identifier)
		final java.util.Map<String,Integer> chromosome_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(chromosomeRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Chromosome> chromosomeList = null;
			try
			{
				chromosomeList = getDatabase().find(org.molgenis.omx.xgap.Chromosome.class, chromosomeRules.values().toArray(new org.molgenis.framework.db.QueryRule[chromosomeRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Chromosome xref :  chromosomeList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				chromosome_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'probeSet' to probeSet.id using Identifier)
		final java.util.Map<String,Integer> probeSet_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(probeSetRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.ProbeSet> probeSetList = null;
			try
			{
				probeSetList = getDatabase().find(org.molgenis.omx.xgap.ProbeSet.class, probeSetRules.values().toArray(new org.molgenis.framework.db.QueryRule[probeSetRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.ProbeSet xref :  probeSetList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				probeSet_Labels_to_IdMap.put(key, xref.getId());
			}
		}
		//resolve foreign key field 'reportsFor' to gene.id using Identifier)
		final java.util.Map<String,Integer> reportsFor_Labels_to_IdMap = new java.util.TreeMap<String,Integer>();
		if(reportsForRules.size() > 0)
		{		
		
			java.util.List<org.molgenis.omx.xgap.Gene> reportsForList = null;
			try
			{
				reportsForList = getDatabase().find(org.molgenis.omx.xgap.Gene.class, reportsForRules.values().toArray(new org.molgenis.framework.db.QueryRule[reportsForRules.values().size()]));
			}
			catch(Exception e)
			{
				// something went wrong while querying for this entities' name field
				// we assume it has no such field, which should have been checked earlier ofcourse
				// regardless, just quit the function now
				throw new org.molgenis.framework.db.DatabaseException(e);
			}
		
			for(org.molgenis.omx.xgap.Gene xref :  reportsForList)
			{
				String key = "";
				key += 	xref.getIdentifier();
				
				reportsFor_Labels_to_IdMap.put(key, xref.getId());
			}
		}

		//update objects with the keys
		for(int i = 0; i < entities.size(); i++)
		{
			org.molgenis.omx.xgap.Spot object = entities.get(i);		
			//update object using label fields Identifier
			if(object.getChromosome_Id() == null )
			{
					String key = "";
					if(object.getChromosome_Identifier() != null)
						key += 	object.getChromosome_Identifier();
					
					if(!"".equals(key) && chromosome_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("Chromosome_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setChromosome_Id(chromosome_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getProbeSet_Id() == null )
			{
					String key = "";
					if(object.getProbeSet_Identifier() != null)
						key += 	object.getProbeSet_Identifier();
					
					if(!"".equals(key) && probeSet_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ProbeSet_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setProbeSet_Id(probeSet_Labels_to_IdMap.get(key));
					}
			}
			//update object using label fields Identifier
			if(object.getReportsFor_Id() == null )
			{
					String key = "";
					if(object.getReportsFor_Identifier() != null)
						key += 	object.getReportsFor_Identifier();
					
					if(!"".equals(key) && reportsFor_Labels_to_IdMap.get(key) == null) 
					{
						throw new org.molgenis.framework.db.DatabaseException("ReportsFor_Identifier cannot be resolved: unknown xref='"+key+"'");
					}
					else
					{
						object.setReportsFor_Id(reportsFor_Labels_to_IdMap.get(key));
					}
			}
						
		}
	}	
	
	@Override
	public org.molgenis.fieldtypes.FieldType getFieldType(String fieldName)
	{
			if("id".equalsIgnoreCase(fieldName) || "spot.id".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("identifier".equalsIgnoreCase(fieldName) || "characteristic.identifier".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("name".equalsIgnoreCase(fieldName) || "characteristic.name".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("__Type".equalsIgnoreCase(fieldName) || "characteristic.__Type".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.EnumField();
			if("description".equalsIgnoreCase(fieldName) || "characteristic.description".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("chromosome".equalsIgnoreCase(fieldName) || "probe.chromosome".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("cM".equalsIgnoreCase(fieldName) || "probe.cM".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.DecimalField();
			if("bpStart".equalsIgnoreCase(fieldName) || "probe.bpStart".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.LongField();
			if("bpEnd".equalsIgnoreCase(fieldName) || "probe.bpEnd".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.LongField();
			if("seq".equalsIgnoreCase(fieldName) || "probe.seq".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.TextField();
			if("symbol".equalsIgnoreCase(fieldName) || "probe.symbol".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.StringField();
			if("mismatch".equalsIgnoreCase(fieldName) || "probe.mismatch".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.BoolField();
			if("probeSet".equalsIgnoreCase(fieldName) || "probe.probeSet".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("reportsFor".equalsIgnoreCase(fieldName) || "probe.reportsFor".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.XrefField();
			if("x".equalsIgnoreCase(fieldName) || "spot.x".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("y".equalsIgnoreCase(fieldName) || "spot.y".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("gridX".equalsIgnoreCase(fieldName) || "spot.gridX".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
			if("gridY".equalsIgnoreCase(fieldName) || "spot.gridY".equalsIgnoreCase(fieldName)) 
				return new org.molgenis.fieldtypes.IntField();
		return null;
	}		
	@Override
	public void prepareFileAttachements(java.util.List<org.molgenis.omx.xgap.Spot> entities, java.io.File baseDir) throws java.io.IOException
	{
	}

	@Override
	public boolean saveFileAttachements(java.util.List<org.molgenis.omx.xgap.Spot> entities, java.io.File baseDir) throws java.io.IOException
	{
		return false;
	}}
