
/* File:        org.molgenis.omx/model/Transcript.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Gene;
import org.molgenis.omx.xgap.Transcript;


/**
 * Reads Transcript from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class TranscriptEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(TranscriptEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'gene' (maps gene.Identifier -> gene.id)			
	final Map<String,Integer> geneKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Transcript from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Transcript> transcriptsMissingRefs = new ArrayList<Transcript>();
	
		//cache for objects to be imported from file (in batch)
		final List<Transcript> transcriptList = new ArrayList<Transcript>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Transcript object = new Transcript();
			object.set(entity, false);				
			transcriptList.add(object);		
			
			//add to db when batch size is reached
			if(transcriptList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				transcriptsMissingRefs.addAll(resolveForeignKeys(db, transcriptList));
				transcriptList.removeAll(transcriptsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(transcriptList,dbAction, "Identifier");
				
				//clear for next batch						
				transcriptList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!transcriptList.isEmpty())
		{
			total.set(total.get() + transcriptList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			transcriptsMissingRefs.addAll(resolveForeignKeys(db, transcriptList));
			transcriptList.removeAll(transcriptsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(transcriptList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Transcript> transcripts = new ArrayList<Transcript>(transcriptsMissingRefs);

		int iterationCount = 0;

		do
		{
			transcriptsMissingRefs = resolveForeignKeys(db, transcriptsMissingRefs);
			
			LinkedHashSet<Transcript> differenceSet = new LinkedHashSet<Transcript>();
			Sets.symmetricDifference(new LinkedHashSet<Transcript>(transcripts), new LinkedHashSet<Transcript>(transcriptsMissingRefs)).copyInto(differenceSet);
			List<Transcript> resolvabletranscripts = new ArrayList<Transcript>(differenceSet);
			
			transcripts.removeAll(resolvabletranscripts);
			
			db.update(resolvabletranscripts,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Transcript blaat : transcriptsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'transcript' entity failed:"
								+ "This is probably caused by a(n) 'transcript' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (transcriptsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " transcript from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param transcriptList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Transcript> resolveForeignKeys(Database db, List<Transcript> transcriptList) throws Exception
	{
		//keep a list of Transcript instances that miss a reference which might be resolvable later
		List<Transcript> transcriptsMissingRefs = new ArrayList<Transcript>();
	
		//resolve xref 'gene' from gene.Identifier -> gene.id
		for(Transcript o: transcriptList) 
		{
			if(o.getGene_Identifier() != null) 
				geneKeymap.put(o.getGene_Identifier(), null);
		}
		
		if(geneKeymap.size() > 0) 
		{
			List<Gene> geneList = db.query(Gene.class).in("Identifier",new ArrayList<Object>(geneKeymap.keySet())).find();
			for(Gene xref :  geneList)
			{
				geneKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Transcript o:  transcriptList)
		{
			while(true){
				//update xref Gene
				if(o.getGene_Identifier() != null) 
				{
					String key = o.getGene_Identifier();
					if(geneKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Transcript' objects failed: cannot find Gene for gene_Identifier='"+o.getGene_Identifier()+"'");
					}
					o.setGene_Id(geneKeymap.get(key));
				}
				break;
			}
		}
		
		geneKeymap.clear();
		
		return transcriptsMissingRefs;
	}
}

