
/* File:        org.molgenis.omx/model/Variant.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.xgap.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.xgap.Chromosome;
import org.molgenis.omx.xgap.Track;
import org.molgenis.omx.xgap.Variant;


/**
 * Reads Variant from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class VariantEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(VariantEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'chromosome' (maps chromosome.Identifier -> chromosome.id)			
	final Map<String,Integer> chromosomeKeymap = new TreeMap<String,Integer>();	
	//foreign key map for xref 'track' (maps track.Identifier -> track.id)			
	final Map<String,Integer> trackKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports Variant from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<Variant> variantsMissingRefs = new ArrayList<Variant>();
	
		//cache for objects to be imported from file (in batch)
		final List<Variant> variantList = new ArrayList<Variant>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			Variant object = new Variant();
			object.set(entity, false);				
			variantList.add(object);		
			
			//add to db when batch size is reached
			if(variantList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				variantsMissingRefs.addAll(resolveForeignKeys(db, variantList));
				variantList.removeAll(variantsMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
				db.update(variantList,dbAction, "Identifier");
				
				//clear for next batch						
				variantList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!variantList.isEmpty())
		{
			total.set(total.get() + variantList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			variantsMissingRefs.addAll(resolveForeignKeys(db, variantList));
			variantList.removeAll(variantsMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'Identifier' defined in xref_label
			db.update(variantList,dbAction, "Identifier");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<Variant> variants = new ArrayList<Variant>(variantsMissingRefs);

		int iterationCount = 0;

		do
		{
			variantsMissingRefs = resolveForeignKeys(db, variantsMissingRefs);
			
			LinkedHashSet<Variant> differenceSet = new LinkedHashSet<Variant>();
			Sets.symmetricDifference(new LinkedHashSet<Variant>(variants), new LinkedHashSet<Variant>(variantsMissingRefs)).copyInto(differenceSet);
			List<Variant> resolvablevariants = new ArrayList<Variant>(differenceSet);
			
			variants.removeAll(resolvablevariants);
			
			db.update(resolvablevariants,dbAction, "Identifier");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(Variant blaat : variantsMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'variant' entity failed:"
								+ "This is probably caused by a(n) 'variant' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (variantsMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " variant from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param variantList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<Variant> resolveForeignKeys(Database db, List<Variant> variantList) throws Exception
	{
		//keep a list of Variant instances that miss a reference which might be resolvable later
		List<Variant> variantsMissingRefs = new ArrayList<Variant>();
	
		//resolve xref 'chromosome' from chromosome.Identifier -> chromosome.id
		for(Variant o: variantList) 
		{
			if(o.getChromosome_Identifier() != null) 
				chromosomeKeymap.put(o.getChromosome_Identifier(), null);
		}
		
		if(chromosomeKeymap.size() > 0) 
		{
			List<Chromosome> chromosomeList = db.query(Chromosome.class).in("Identifier",new ArrayList<Object>(chromosomeKeymap.keySet())).find();
			for(Chromosome xref :  chromosomeList)
			{
				chromosomeKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//resolve xref 'track' from track.Identifier -> track.id
		for(Variant o: variantList) 
		{
			if(o.getTrack_Identifier() != null) 
				trackKeymap.put(o.getTrack_Identifier(), null);
		}
		
		if(trackKeymap.size() > 0) 
		{
			List<Track> trackList = db.query(Track.class).in("Identifier",new ArrayList<Object>(trackKeymap.keySet())).find();
			for(Track xref :  trackList)
			{
				trackKeymap.put(xref.getIdentifier(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(Variant o:  variantList)
		{
			while(true){
				//update xref Chromosome
				if(o.getChromosome_Identifier() != null) 
				{
					String key = o.getChromosome_Identifier();
					if(chromosomeKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Variant' objects failed: cannot find Chromosome for chromosome_Identifier='"+o.getChromosome_Identifier()+"'");
					}
					o.setChromosome_Id(chromosomeKeymap.get(key));
				}
				//update xref Track
				if(o.getTrack_Identifier() != null) 
				{
					String key = o.getTrack_Identifier();
					if(trackKeymap.get(key) == null)
					{
						throw new Exception("Import of 'Variant' objects failed: cannot find Track for track_Identifier='"+o.getTrack_Identifier()+"'");
					}
					o.setTrack_Id(trackKeymap.get(key));
				}
				break;
			}
		}
		
		chromosomeKeymap.clear();
		trackKeymap.clear();
		
		return variantsMissingRefs;
	}
}

