package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.EnvironmentalFactor;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class EnvironmentalFactorService
{
	private static final Logger logger = Logger.getLogger(EnvironmentalFactorService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ENVIRONMENTALFACTOR')")
	public EnvironmentalFactor create(EnvironmentalFactor environmentalFactor) throws DatabaseException
	{
		logger.debug("creating EnvironmentalFactor");
		db.add(environmentalFactor);
		return environmentalFactor;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ENVIRONMENTALFACTOR')")
	public EnvironmentalFactor read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving EnvironmentalFactor");
		return db.findById(EnvironmentalFactor.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ENVIRONMENTALFACTOR')")
	public void update(EnvironmentalFactor environmentalFactor) throws DatabaseException
	{
		logger.debug("updating EnvironmentalFactor");
		db.update(environmentalFactor);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_ENVIRONMENTALFACTOR')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting EnvironmentalFactor");
		EnvironmentalFactor environmentalFactor = db.findById(EnvironmentalFactor.class, id);
		return db.remove(environmentalFactor) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ENVIRONMENTALFACTOR')")
	public Iterable<EnvironmentalFactor> readAll() throws DatabaseException
	{
		logger.debug("retrieving all EnvironmentalFactor instances");
		return db.find(EnvironmentalFactor.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ENVIRONMENTALFACTOR')")
	public EntityPager<EnvironmentalFactor> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all EnvironmentalFactor instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(EnvironmentalFactor.class, queryRules.toArray(new QueryRule[0]));
		List<EnvironmentalFactor> environmentalFactorCollection = db.find(EnvironmentalFactor.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<EnvironmentalFactor>(start, num, count, environmentalFactorCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_ENVIRONMENTALFACTOR')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("EnvironmentalFactor");
	}
}