package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.MassPeak;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MassPeakService
{
	private static final Logger logger = Logger.getLogger(MassPeakService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MASSPEAK')")
	public MassPeak create(MassPeak massPeak) throws DatabaseException
	{
		logger.debug("creating MassPeak");
		db.add(massPeak);
		return massPeak;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MASSPEAK')")
	public MassPeak read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving MassPeak");
		return db.findById(MassPeak.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MASSPEAK')")
	public void update(MassPeak massPeak) throws DatabaseException
	{
		logger.debug("updating MassPeak");
		db.update(massPeak);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_MASSPEAK')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting MassPeak");
		MassPeak massPeak = db.findById(MassPeak.class, id);
		return db.remove(massPeak) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MASSPEAK')")
	public Iterable<MassPeak> readAll() throws DatabaseException
	{
		logger.debug("retrieving all MassPeak instances");
		return db.find(MassPeak.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MASSPEAK')")
	public EntityPager<MassPeak> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all MassPeak instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(MassPeak.class, queryRules.toArray(new QueryRule[0]));
		List<MassPeak> massPeakCollection = db.find(MassPeak.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<MassPeak>(start, num, count, massPeakCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_MASSPEAK')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("MassPeak");
	}
}