package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.xgap.Metabolite;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MetaboliteService
{
	private static final Logger logger = Logger.getLogger(MetaboliteService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_METABOLITE')")
	public Metabolite create(Metabolite metabolite) throws DatabaseException
	{
		logger.debug("creating Metabolite");
		db.add(metabolite);
		return metabolite;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_METABOLITE')")
	public Metabolite read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving Metabolite");
		return db.findById(Metabolite.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_METABOLITE')")
	public void update(Metabolite metabolite) throws DatabaseException
	{
		logger.debug("updating Metabolite");
		db.update(metabolite);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_METABOLITE')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting Metabolite");
		Metabolite metabolite = db.findById(Metabolite.class, id);
		return db.remove(metabolite) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_METABOLITE')")
	public Iterable<Metabolite> readAll() throws DatabaseException
	{
		logger.debug("retrieving all Metabolite instances");
		return db.find(Metabolite.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_METABOLITE')")
	public EntityPager<Metabolite> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all Metabolite instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(Metabolite.class, queryRules.toArray(new QueryRule[0]));
		List<Metabolite> metaboliteCollection = db.find(Metabolite.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<Metabolite>(start, num, count, metaboliteCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_METABOLITE')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("Metabolite");
	}
}